/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.ui.AbstractFilesystemHyperLinkHandler;
import com.ibm.team.filesystem.ui.editor.PartUtil;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.actions.CompareFilesAction;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.StateId;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class FileItemHyperlinkHandler
extends AbstractFilesystemHyperLinkHandler {
    private static final String BEFORE_STATE = "beforeState";
    private static final String AFTER_STATE = "afterState";
    private static final String PATH = "path";

    public boolean handles(URI uri) {
        try {
            Location location = Location.location((URI)uri);
            IItemType type = location.getItemType();
            return type != null && type.equals(IFileItem.ITEM_TYPE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public IStatus open2(URI uri, ContextProvider provider, IProgressMonitor monitor) {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)11);
            Location location = Location.location((URI)uri);
            IVersionableHandle handle = (IVersionableHandle)location.getItemHandle();
            String pathHint = this.getQueryParam(location, PATH);
            String before = this.getQueryParam(location, BEFORE_STATE);
            String after = this.getQueryParam(location, AFTER_STATE);
            if (pathHint == null) {
                pathHint = "";
            }
            UUID beforeId = before != null ? UUID.valueOf((String)before) : null;
            UUID afterId = after != null ? UUID.valueOf((String)after) : null;
            IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)this.extractItem(IWorkspace.ITEM_TYPE, location, (IProgressMonitor)progress.newChild(5));
            IComponentHandle componentHandle = (IComponentHandle)this.extractItem(IComponent.ITEM_TYPE, location, (IProgressMonitor)progress.newChild(5));
            Object namespace = null;
            namespace = workspaceHandle != null && componentHandle != null ? WorkspaceNamespace.create((IWorkspaceHandle)workspaceHandle, (IComponentHandle)componentHandle) : RepositoryNamespace.create((ITeamRepository)FileItemHyperlinkHandler.resolveTeamRepository(location, (IProgressMonitor)progress.newChild(1)));
            if (beforeId == null && afterId == null && handle.hasStateId()) {
                StateId fileState = new StateId(IFileItem.ITEM_TYPE, handle.getItemId(), handle.getStateId());
                FileItemWrapper fileItemWrapper = (FileItemWrapper)((Object)FileItemWrapper.newWrapper(fileState, pathHint, namespace));
                UIContext context = this.getUIContext();
                if (context != null) {
                    PartUtil.openEditor(context, fileItemWrapper);
                }
            } else if (beforeId != null || afterId != null) {
                beforeId = beforeId == null ? StateId.STATE_DELETED : beforeId;
                afterId = afterId == null ? StateId.STATE_DELETED : afterId;
                StateId beforeState = new StateId(IFileItem.ITEM_TYPE, handle.getItemId(), beforeId);
                StateId afterState = new StateId(IFileItem.ITEM_TYPE, handle.getItemId(), afterId);
                FileItemWrapper beforeWrapper = (FileItemWrapper)((Object)FileItemWrapper.newWrapper(beforeState, pathHint, namespace));
                FileItemWrapper afterWrapper = (FileItemWrapper)((Object)FileItemWrapper.newWrapper(afterState, pathHint, namespace));
                UIContext context = this.getUIContext();
                if (context != null) {
                    CompareFilesAction action = new CompareFilesAction();
                    FileItemHyperlinkHandler.runAction(action, afterWrapper, beforeWrapper, context.getPage(), context.getShell());
                }
            }
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private static void runAction(AbstractActionDelegate actionDelegate, final FileItemWrapper left, final FileItemWrapper right, final IWorkbenchPage page, Shell shell) {
        Display display = shell.getDisplay();
        if (!display.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CompareFilesAction.openCompareEditor(page, right, left, Messages.OpenAction_0, Messages.OpenAction_1);
                }
            });
        }
    }

    private UIContext getUIContext() {
        IWorkbenchPage activePage = JFaceUtils.getWorkbenchPage();
        if (activePage != null && activePage.getWorkbenchWindow() != null) {
            IWorkbenchWindow workbenchWindow = activePage.getWorkbenchWindow();
            return UIContext.createPageContext((Display)workbenchWindow.getShell().getDisplay(), (Shell)workbenchWindow.getShell(), (IWorkbenchPage)activePage);
        }
        return null;
    }
}

