/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.ui.FilteringElementSelector;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.wizards.newworkspace.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.SettableSelectionProvider;
import com.ibm.team.scm.client.IReadScopeDescriber;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.IReadScope;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ComponentSelector
extends FilteringElementSelector {
    private ITeamRepository repo;
    private SettableSelectionProvider selectionProvider = new SettableSelectionProvider();
    private IAuditableHandle owner = null;

    public ComponentSelector(ITeamRepository initialRepo, Composite parent, int flags, String initalPattern) {
        super(parent, flags, initalPattern, ComponentSelector.createLabelProvider());
        this.repo = initialRepo;
        this.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSelector.this.selectionProvider.realSetSelection((ISelection)new StructuredSelection(ComponentSelector.this.getSelection()));
            }
        });
    }

    private static FilteringElementSelector.ElementLabelProvider createLabelProvider() {
        return new FilteringElementSelector.ElementLabelProvider(){

            @Override
            public String getText(Object element) {
                Entry entry = (Entry)element;
                IComponent component = entry.component;
                IAuditable owner = entry.owner;
                String ownerName = Messages.ComponentSelector_unknown_owner;
                if (owner instanceof IContributor) {
                    ownerName = ((IContributor)owner).getName();
                } else if (owner instanceof IProcessArea) {
                    ownerName = ((IProcessArea)owner).getName();
                }
                IReadScope visibility = entry.visibility;
                String text = Messages.ComponentSelector_OWNER_VISIBILITY;
                String visibleText = "";
                visibleText = IReadScopeDescriber.FACTORY.shortDescription(visibility);
                if (owner instanceof IProcessArea) {
                    text = Messages.ComponentSelector_OWNER;
                }
                text = NLS.bind((String)text, (Object[])new Object[]{component.getName(), ownerName, visibleText});
                return text;
            }

            @Override
            public ImageDescriptor getImageDescriptor(Object element) {
                Entry entry = (Entry)element;
                if (entry.owner instanceof IContributorHandle) {
                    if (entry.repo.loggedInContributor().sameItemId((IItemHandle)entry.owner)) {
                        return ImagePool.SELF_COMPONENT;
                    }
                    return ImagePool.PRIVATE_COMPONENT;
                }
                if (entry.owner instanceof ITeamArea) {
                    return ImagePool.TEAM_COMPONENT;
                }
                if (entry.owner instanceof IProjectArea) {
                    return ImagePool.PROJECT_COMPONENT;
                }
                return ImagePool.COMPONENT;
            }
        };
    }

    public Entry[] getWrapperSelection() {
        Object[] objects = this.getSelection();
        ArrayList<Entry> result = new ArrayList<Entry>(objects.length);
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null && obj instanceof Entry) {
                result.add((Entry)obj);
            }
            ++n2;
        }
        return result.toArray(new Entry[result.size()]);
    }

    @Override
    protected FilteringElementSelector.SyncJob createSyncJob() {
        return null;
    }

    @Override
    protected FilteringElementSelector.AbstractSearchJob createSearchJob() {
        return new ComponentSearchJob((FilteringElementSelector)this);
    }

    @Override
    protected FilteringElementSelector.AbstractSearchJob createCachedSearchJob(Object[] cachedElements) {
        return null;
    }

    @Override
    protected Object[] getHistoryElements() {
        return new Object[0];
    }

    @Override
    protected boolean canUseCachedResult() {
        return false;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void setSelection(Entry newSelection) {
        Table table = this.getTable();
        if (newSelection == null) {
            table.deselectAll();
            this.selectionProvider.realSetSelection((ISelection)new StructuredSelection());
            return;
        }
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Object data = item.getData();
            if (data != null && data instanceof Entry) {
                Entry entry = (Entry)data;
                if (newSelection.component.sameItemId(entry.component.getItemHandle())) {
                    table.setSelection(item);
                    return;
                }
            }
            ++n2;
        }
    }

    public void setRepository(ITeamRepository repo) {
        this.repo = repo;
    }

    public void filterOwner(IAuditableHandle owner) {
        this.owner = owner;
    }

    private class ComponentSearchJob
    extends FilteringElementSelector.AbstractSearchJob {
        protected ComponentSearchJob(FilteringElementSelector viewer) {
            super(viewer);
        }

        @Override
        protected Object[] getHistoryResult(IProgressMonitor monitor) throws CoreException {
            return new Object[0];
        }

        @Override
        protected FilteringElementSelector.SearchResult getSearchResult(Object[] historyElements, IProgressMonitor monitor) throws CoreException {
            IComponentSearchCriteria componentCriteria = IComponentSearchCriteria.FACTORY.newInstance();
            String searchPattern = ComponentSelector.this.getSearchPattern();
            if (!(searchPattern = searchPattern.trim()).endsWith("*")) {
                searchPattern = String.valueOf(searchPattern) + "*";
            }
            componentCriteria.setPartialNameIgnoreCase(searchPattern);
            componentCriteria.setAlphabetical(true);
            if (ComponentSelector.this.owner != null) {
                componentCriteria.getFilterByOwnerOptional().add(ComponentSelector.this.owner);
            }
            try {
                IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)ComponentSelector.this.repo);
                List componentHandles = wm.findComponents(componentCriteria, Integer.MAX_VALUE, monitor);
                ArrayList<Entry> results = new ArrayList<Entry>();
                if (componentHandles.size() > 0) {
                    ArrayList toFetch = new ArrayList();
                    toFetch.addAll(componentHandles);
                    List componentOwners = wm.findOwnersForComponents(componentHandles, monitor);
                    toFetch.addAll(componentOwners);
                    List componentVisibilities = wm.findReadScopeForComponents(componentHandles, monitor);
                    List completeItems = ComponentSelector.this.repo.itemManager().fetchCompleteItems(toFetch, 0, monitor);
                    List completeComponents = completeItems.subList(0, componentHandles.size());
                    List completeComponentOwners = completeItems.subList(componentHandles.size(), completeItems.size());
                    int i = 0;
                    for (Object item : completeComponents) {
                        IComponent component = (IComponent)item;
                        results.add(new Entry(component, ComponentSelector.this.repo, (IAuditable)completeComponentOwners.get(i), (IReadScope)componentVisibilities.get(i)));
                        ++i;
                    }
                }
                return new FilteringElementSelector.SearchResult(results.toArray(), true);
            }
            catch (TeamRepositoryException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", 4, Messages.ComponentSelector_Search_Exception, (Throwable)e));
            }
            catch (OperationCanceledException e) {
                return new FilteringElementSelector.SearchResult(new Object[0], true);
            }
        }
    }

    public class Entry {
        private IComponent component;
        private IAuditable owner;
        private IReadScope visibility;
        private ITeamRepository repo;

        public Entry(IComponent component, ITeamRepository repo, IAuditable owner, IReadScope visibility) {
            this.component = component;
            this.repo = repo;
            this.owner = owner;
            this.visibility = visibility;
        }

        public IComponent getComponent() {
            return this.component;
        }
    }
}

