/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorInput;
import com.ibm.team.filesystem.ui.AbstractDeliveryHyperlinkHandler;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class ComponentHyperlinkHandler
extends HyperlinkHandler {
    public IStatus open2(URI uri, ContextProvider provider, IProgressMonitor monitor) {
        try {
            ComponentWrapper wrapper = this.getWrapper(uri, monitor);
            if (wrapper != null) {
                final ComponentEditorInput input = ComponentEditorInput.newForEdit(wrapper);
                WorkbenchJob job = new WorkbenchJob(Messages.ComponentHyperlinkHandler_OpeningJobName){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
                        if (page != null) {
                            ComponentEditor.open(page, input);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
                return Status.OK_STATUS;
            }
            return new Status(4, "com.ibm.team.filesystem.ide.ui", NLS.bind((String)Messages.ComponentHyperlinkHandler_OpenComponentError, (Object)uri.toString()));
        }
        catch (TeamRepositoryException e) {
            return new Status(4, "com.ibm.team.filesystem.ide.ui", NLS.bind((String)Messages.ComponentHyperlinkHandler_OpenComponentError, (Object)uri.toString()), (Throwable)e);
        }
    }

    private ComponentWrapper getWrapper(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Location location = Location.location((URI)uri);
        ITeamRepository repo = AbstractDeliveryHyperlinkHandler.resolveTeamRepository(location, (IProgressMonitor)subMonitor.newChild(1));
        if (repo == null) {
            return null;
        }
        IComponent component = (IComponent)repo.itemManager().fetchCompleteItem(location, 0, (IProgressMonitor)subMonitor.newChild(1));
        return new ComponentWrapper(repo, component);
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        if (object instanceof IComponentHandle) {
            ITeamRepository repo;
            IComponentHandle componentHandle;
            SubMonitor subMonitor;
            block4: {
                subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                componentHandle = (IComponentHandle)object;
                repo = (ITeamRepository)componentHandle.getOrigin();
                if (repo.loggedIn()) break block4;
                return null;
            }
            try {
                IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)subMonitor.newChild(1));
                Location location = Location.itemLocation((IItemHandle)component, (String)repo.getRepositoryURI());
                IURIReference ref = IReferenceFactory.INSTANCE.createReferenceFromURI(location.toAbsoluteUri(), "");
                return new URIReference(component.getName(), "", ref.createURI());
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
                monitor = subMonitor.newChild(1);
            }
        }
        return super.createHyperlink(object, monitor);
    }

    public boolean handles(URI uri) {
        try {
            Location location = Location.location((URI)uri);
            IItemType type = location.getItemType();
            return type == IComponent.ITEM_TYPE;
        }
        catch (TeamRepositoryException e) {
            return false;
        }
    }

    public boolean links(Object object) {
        if (object instanceof IComponentHandle) {
            return true;
        }
        return super.links(object);
    }
}

