/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.client.internal.calm.OslcLinkUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.AbstractDeliveryHyperlinkHandler;
import com.ibm.team.filesystem.ui.DeliveryLinkData;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ClientProviderFactory;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.links.ChangeSetLocationFactory;
import com.ibm.team.scm.common.providers.ItemProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChangeSetHyperlinkHandler
extends AbstractDeliveryHyperlinkHandler {
    @Override
    public boolean handles(URI uri) {
        try {
            Location location = Location.location((URI)uri);
            if (location.getItemType() == null) {
                URI legacyURI = OslcLinkUtil.convertToLegacyWebUrl((URI)uri);
                location = Location.location((URI)legacyURI);
            }
            return this.handles(location) && ClientURIUtils.findTeamRepository((URI)uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean handles(Location location) {
        IItemType itemType = location.getItemType();
        if (itemType != null) {
            return itemType == IChangeSet.ITEM_TYPE;
        }
        try {
            URI absoluteUri = location.toAbsoluteUri();
            return OslcLinkUtil.convertToLegacyResourceUri((URI)absoluteUri) != null;
        }
        catch (IllegalStateException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    protected void open(DeliveryLinkData data, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ChangeSetHyperlinkHandler_openChangeSetProgress, (int)10);
        ArrayList<IChangeSet> changeSets = new ArrayList<IChangeSet>();
        ArrayList<IChangeSetHandle> toRefresh = new ArrayList<IChangeSetHandle>();
        IWorkspace workspace = data.getWorkspace();
        IChangeSet changeSet = null;
        ITeamRepository repo = data.getRepository();
        for (IItem item : data.getItems()) {
            if (item == null || !(item instanceof IChangeSet)) continue;
            IChangeSet csHandle = (IChangeSet)item;
            if (changeSet == null) {
                changeSet = csHandle;
            }
            if (csHandle.isActive()) {
                toRefresh.add((IChangeSetHandle)item);
                continue;
            }
            changeSets.add(csHandle);
        }
        if (workspace != null) {
            List relatedChanges;
            IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)progress.newChild(2));
            if (data.isDeliverEvent() && (relatedChanges = workspaceConnection.changeHistory(changeSet.getComponent()).getRelatedEntries((IChangeSetHandle)changeSet, (IProgressMonitor)progress.newChild(4))).size() > changeSets.size()) {
                changeSets.clear();
                ArrayList<IChangeSetHandle> toFetch = new ArrayList<IChangeSetHandle>();
                for (Object changeHistoryEntryChange : relatedChanges) {
                    toFetch.add(((IChangeHistoryEntryChange)changeHistoryEntryChange).changeSet());
                }
                List items = repo.itemManager().fetchCompleteItems(toFetch, 0, (IProgressMonitor)progress.newChild(4));
                for (Object object : items) {
                    changeSets.add((IChangeSet)object);
                }
            }
        }
        ArrayList<IChangeSetHandle> changeSetHandles = new ArrayList<IChangeSetHandle>(changeSets.size());
        changeSetHandles.addAll(changeSets);
        if (toRefresh.size() > 0) {
            List items = repo.itemManager().fetchCompleteItems(toRefresh, 1, (IProgressMonitor)progress.newChild(4));
            changeSetHandles.addAll(items);
        }
        ChangeSetHyperlinkHandler.openChangesView((IWorkspaceHandle)workspace, changeSetHandles);
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        ChangeSetWrapper csw;
        if (object instanceof IRemoteActivity) {
            object = ((IRemoteActivity)object).getChangeSetHandle();
        }
        if ((csw = (ChangeSetWrapper)((Object)Adapters.getAdapter((Object)object, ChangeSetWrapper.class))) != null) {
            object = csw.getChangeSet();
        }
        if (object instanceof IItemReference) {
            IItemReference itemReference = (IItemReference)object;
            object = itemReference.getReferencedItem();
        }
        if (object instanceof IChangeSetHandle) {
            IChangeSetHandle set = (IChangeSetHandle)object;
            try {
                ITeamRepository origin = (ITeamRepository)set.getOrigin();
                if (origin != null) {
                    ClientProviderFactory client = new ClientProviderFactory(origin);
                    IReference reference = ChangeSetLocationFactory.createChangeSetURIReference((ItemProvider)client.getItemProvider(), (IChangeSetHandle)set, null, (boolean)false, (IProgressMonitor)monitor);
                    return new URIReference(reference.getComment(), reference.getComment(), reference.createURI());
                }
            }
            catch (NotLoggedInException e) {
                return null;
            }
            catch (ConnectionException e) {
                return null;
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)((Object)this), (String)("Error generating hyperlink for " + object.toString()), (Throwable)e);
            }
        }
        return super.createHyperlink(object, monitor);
    }

    public Object resolve(URI uri, ContextProvider provider, IProgressMonitor monitor) throws CoreException {
        try {
            URI legacyUri = OslcLinkUtil.convertToLegacyResourceUri((URI)uri);
            if (legacyUri != null) {
                uri = legacyUri;
            }
        }
        catch (URISyntaxException legacyUri) {
            // empty catch block
        }
        try {
            DeliveryLinkData data = this.parse(Location.location((URI)uri), monitor);
            if (data != null) {
                return data.getItem();
            }
            return null;
        }
        catch (TeamRepositoryException e) {
            return new CoreException(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.ChangeSetHyperlinkHandler_UnableToResolveUriError, (Object)uri, (Object[])new Object[0]), (Throwable)e));
        }
    }

    public boolean links(Object object) {
        ChangeSetWrapper csw = (ChangeSetWrapper)((Object)Adapters.getAdapter((Object)object, ChangeSetWrapper.class));
        if (csw != null) {
            return true;
        }
        if (object instanceof IItemReference) {
            IItemReference itemReference = (IItemReference)object;
            return itemReference.getReferencedItem() instanceof IChangeSetHandle;
        }
        if (object instanceof IChangeSetHandle) {
            return true;
        }
        return super.links(object);
    }

    public IItemType guessItemType(URI uri) {
        return super.guessItemType(uri);
    }
}

