/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.queries.ComponentScopedBaselinesQuery;
import com.ibm.team.filesystem.ui.views.TeamViewSorter;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.query.PagedTable;
import com.ibm.team.repository.rcp.ui.internal.utils.IRunnableWithSelection;
import com.ibm.team.repository.rcp.ui.internal.viewers.EmptySetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.layout.LayoutUtil;

public final class BaselineSelectionPart {
    private Control control;
    private IOperationRunner runner;
    private LocalResourceManager resourceManager;
    private ItemLocator<IComponent> component;
    private ItemId<IWorkspace> sourceWorkspace;
    private Button nameFilterButton;
    private Text nameFilterText;
    private Button contextFilterButton;
    private Label streamImage;
    private Text streamNameText;
    private Button browseStreamButton;
    private IWorkspace cachedContext;
    private Label filterSummaryLabel;
    private SimpleTableViewer<BaselineWrapper> tableViewer;
    private PagedTable<BaselineWrapper> pagedTable;

    public BaselineSelectionPart(Composite parent, WidgetFactoryContext context) {
        WidgetToolkit toolkit = context.getToolkit();
        Composite mainControl = context.getToolkit().createComposite(parent);
        this.runner = context.getBackgroundOperationRunner();
        Group filterGroup = new Group(mainControl, 0);
        filterGroup.setText(Messages.BaselineSelectionPart_FilterBaselinesByGroupLabel);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(3).generateLayout((Composite)filterGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)filterGroup);
        this.nameFilterButton = toolkit.createButton((Composite)filterGroup, Messages.BaselineSelectionPart_NameFilterLabel, 16);
        GridDataFactory.fillDefaults().applyTo((Control)this.nameFilterButton);
        this.nameFilterButton.setSelection(this.sourceWorkspace == null);
        this.nameFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaselineSelectionPart.this.refreshUI();
            }
        });
        this.nameFilterText = toolkit.createText((Composite)filterGroup, "");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.nameFilterText);
        final Runnable timerRunnable = new Runnable(){

            @Override
            public void run() {
                BaselineSelectionPart.this.updateFilterSummaryLabel();
                BaselineSelectionPart.this.updateQuery();
            }
        };
        int TIMER_TYPING_DELAY = 700;
        this.nameFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!BaselineSelectionPart.this.nameFilterButton.isDisposed() && BaselineSelectionPart.this.nameFilterButton.getSelection()) {
                    BaselineSelectionPart.this.nameFilterButton.getDisplay().timerExec(700, timerRunnable);
                }
            }
        });
        this.contextFilterButton = toolkit.createButton((Composite)filterGroup, Messages.BaselineSelectionPart_ContextLabel, 16);
        GridDataFactory.fillDefaults().applyTo((Control)this.contextFilterButton);
        this.nameFilterButton.setSelection(this.sourceWorkspace != null);
        this.contextFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaselineSelectionPart.this.refreshUI();
            }
        });
        this.contextFilterButton.setSelection(this.sourceWorkspace != null);
        Composite streamComposite = new Composite((Composite)filterGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(streamComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(16384, 0x1000000).applyTo((Control)streamComposite);
        this.streamImage = new Label(streamComposite, 0);
        this.streamImage.addListener(23, new Listener(){

            public void handleEvent(Event event) {
                ((GridData)((BaselineSelectionPart)BaselineSelectionPart.this).streamImage.getLayoutData()).exclude = true;
                BaselineSelectionPart.this.refreshLayout();
            }
        });
        this.streamImage.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                ((GridData)((BaselineSelectionPart)BaselineSelectionPart.this).streamImage.getLayoutData()).exclude = false;
                BaselineSelectionPart.this.refreshLayout();
            }
        });
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)filterGroup);
        this.streamImage.setImage(this.resourceManager.createImage(ImagePool.WORKSPACE));
        GridDataFactory.defaultsFor((Control)this.streamImage).applyTo((Control)this.streamImage);
        this.streamNameText = new Text(streamComposite, 4);
        this.streamNameText.setEditable(false);
        this.streamNameText.setText(Messages.BaselineSelectionPart_NoContextLabel);
        GridDataFactory.defaultsFor((Control)this.streamNameText).align(16384, 0x1000000).applyTo((Control)this.streamNameText);
        this.browseStreamButton = new Button((Composite)filterGroup, 8);
        this.browseStreamButton.setText(Messages.BaselineSelectionPart_BrowseContextButton);
        GridDataFactory.defaultsFor((Control)this.browseStreamButton).grab(false, false).align(131072, 0x1000000).applyTo((Control)this.browseStreamButton);
        this.browseStreamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BaselineSelectionPart.this.component == null) {
                    return;
                }
                AbstractPlaceWrapper selection = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(BaselineSelectionPart.this.getControl().getShell(), BaselineSelectionPart.this.component.getRepository(), null, null, WORKSPACES_OR_STREAMS.STREAMS, true, null, null, false);
                if (selection == null) {
                    return;
                }
                ItemId workspace = ItemId.forItem((IItem)selection.getWorkspace());
                BaselineSelectionPart.this.component = ItemLocator.create((ITeamRepository)selection.getRepository(), (IAuditableHandle)((IComponentHandle)BaselineSelectionPart.this.component.toHandle()));
                BaselineSelectionPart.this.setWorkspace((ItemId<IWorkspace>)workspace);
            }
        });
        this.filterSummaryLabel = toolkit.createLabel(mainControl, "", 64);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(100, -1).grab(true, false).applyTo((Control)this.filterSummaryLabel);
        this.pagedTable = new PagedTable(mainControl, context, 2816, null, null);
        this.tableViewer = this.pagedTable.getViewer();
        DialogUtil.setFocusControl(this.filterSummaryLabel, this.pagedTable.getControl());
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(false);
        table.setFont(parent.getFont());
        new LabelColumn(this.tableViewer, Messages.BaselineSelectionPart_baselinesColumn, -1).setComparator(TeamViewSorter.getBaselineComparator());
        GridDataFactory.fillDefaults().hint(600, 400).grab(true, true).span(3, 1).applyTo(this.pagedTable.getControl());
        GridLayoutFactory.fillDefaults().numColumns(3).generateLayout(mainControl);
        this.control = mainControl;
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BaselineSelectionPart.this.dispose();
            }
        });
        this.refreshUI();
    }

    public void setComponent(ItemLocator<IComponent> component) {
        if (this.component == null ? component == null : this.component.equals(component)) {
            return;
        }
        this.component = component;
        this.nameFilterButton.setSelection(this.sourceWorkspace == null);
        this.contextFilterButton.setSelection(this.sourceWorkspace != null);
        this.refreshUI();
    }

    public void setWorkspace(ItemId<IWorkspace> workspace) {
        if (this.sourceWorkspace == null ? workspace == null : this.sourceWorkspace.equals(workspace)) {
            return;
        }
        this.sourceWorkspace = workspace;
        this.nameFilterButton.setSelection(this.sourceWorkspace == null);
        this.contextFilterButton.setSelection(this.sourceWorkspace != null);
        this.refreshUI();
    }

    public Control getControl() {
        return this.control;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.tableViewer.getSelectionProvider();
    }

    public void setDoubleClickHandler(IRunnableWithSelection runnableWithSelection) {
        this.tableViewer.setDoubleClickHandler(runnableWithSelection);
    }

    public void setFocusOnTable() {
        this.pagedTable.getControl().setFocus();
    }

    private void refreshUI() {
        this.updateEnablement();
        this.updateSelectedContextLabel();
        this.updateFilterSummaryLabel();
        this.refreshLayout();
        this.updateQuery();
    }

    private void updateEnablement() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        if (this.nameFilterButton.getSelection()) {
            this.nameFilterText.setEnabled(true);
            this.streamImage.setEnabled(false);
            this.streamNameText.setEnabled(false);
            this.browseStreamButton.setEnabled(false);
        } else {
            this.nameFilterText.setEnabled(false);
            this.streamImage.setEnabled(true);
            this.streamNameText.setEnabled(true);
            this.browseStreamButton.setEnabled(true);
        }
    }

    private void updateSelectedContextLabel() {
        if (this.streamNameText == null || this.streamNameText.isDisposed()) {
            return;
        }
        if (this.component != null && this.sourceWorkspace != null) {
            this.streamImage.setVisible(true);
            if (this.cachedContext != null && this.cachedContext.getItemId().equals((Object)this.sourceWorkspace.getItemUUID())) {
                this.streamNameText.setText(this.cachedContext.getName());
                if (this.cachedContext.isStream()) {
                    this.streamImage.setImage(this.resourceManager.createImage(ImagePool.STREAM));
                } else {
                    this.streamImage.setImage(this.resourceManager.createImage(ImagePool.WORKSPACE));
                }
                LayoutUtil.resize((Control)this.streamNameText);
            } else {
                final ITeamRepository repo = this.component.getRepository();
                final Display display = Display.getCurrent();
                this.runner.enqueue(Messages.BaselineSelectionPart_computingFilterProgress, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        final IWorkspace fetchedWorkspace = (IWorkspace)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)BaselineSelectionPart.this.sourceWorkspace, (IProgressMonitor)monitor);
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!BaselineSelectionPart.this.streamNameText.isDisposed()) {
                                    BaselineSelectionPart.this.cachedContext = fetchedWorkspace;
                                    if (fetchedWorkspace.isStream()) {
                                        BaselineSelectionPart.this.streamImage.setImage(BaselineSelectionPart.this.resourceManager.createImage(ImagePool.STREAM));
                                    } else {
                                        BaselineSelectionPart.this.streamImage.setImage(BaselineSelectionPart.this.resourceManager.createImage(ImagePool.WORKSPACE));
                                    }
                                    BaselineSelectionPart.this.streamNameText.setText(fetchedWorkspace.getName());
                                    LayoutUtil.resize((Control)BaselineSelectionPart.this.streamNameText);
                                }
                            }
                        });
                    }
                });
            }
        } else {
            this.streamImage.setVisible(false);
            this.streamNameText.setText(Messages.BaselineSelectionPart_NoContextLabel);
            LayoutUtil.resize((Control)this.streamNameText);
        }
    }

    private void updateFilterSummaryLabel() {
        if (this.filterSummaryLabel.isDisposed()) {
            return;
        }
        if (this.nameFilterButton.getSelection()) {
            String namePrefix = this.nameFilterText.getText();
            if (namePrefix == null || namePrefix.trim().isEmpty() || namePrefix.trim().equals("*")) {
                this.filterSummaryLabel.setText(NLS.bind((String)Messages.BaselineSelectionPart_showAllFilterName, (Object)namePrefix));
            } else {
                this.filterSummaryLabel.setText(NLS.bind((String)Messages.BaselineSelectionPart_filterByNamePrefix, (Object)namePrefix));
            }
        } else if (this.contextFilterButton.getSelection() && this.sourceWorkspace != null) {
            if (this.cachedContext != null && this.cachedContext.getItemId().equals((Object)this.sourceWorkspace.getItemUUID())) {
                if (this.cachedContext.isStream()) {
                    this.filterSummaryLabel.setText(NLS.bind((String)Messages.BaselineSelectionPart_showingStreamBaselineFilter, (Object)this.cachedContext.getName()));
                } else {
                    this.filterSummaryLabel.setText(NLS.bind((String)Messages.BaselineSelectionPart_showingWorkspaceBaselineFilter, (Object)this.cachedContext.getName()));
                }
                LayoutUtil.resize((Control)this.filterSummaryLabel);
            } else {
                this.filterSummaryLabel.setText(Messages.BaselineSelectionPart_computingFilterLabel);
                final Display display = Display.getCurrent();
                this.runner.enqueue(Messages.BaselineSelectionPart_computingFilterProgress, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        final IWorkspace workspace = (IWorkspace)RepoFetcher.fetchCurrent((ITeamRepository)BaselineSelectionPart.this.component.getRepository(), (ItemId)BaselineSelectionPart.this.sourceWorkspace, (IProgressMonitor)monitor);
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (BaselineSelectionPart.this.filterSummaryLabel.isDisposed()) {
                                    return;
                                }
                                if (workspace.isStream()) {
                                    BaselineSelectionPart.this.filterSummaryLabel.setText(NLS.bind((String)Messages.BaselineSelectionPart_showingStreamBaselineFilter, (Object)workspace.getName()));
                                } else {
                                    BaselineSelectionPart.this.filterSummaryLabel.setText(NLS.bind((String)Messages.BaselineSelectionPart_showingWorkspaceBaselineFilter, (Object)workspace.getName()));
                                }
                                LayoutUtil.resize((Control)BaselineSelectionPart.this.filterSummaryLabel);
                            }
                        });
                    }
                });
            }
        }
        LayoutUtil.resize((Control)this.filterSummaryLabel);
    }

    private void refreshLayout() {
        Shell shell = this.getControl().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.layout(true, true);
        }
    }

    private void updateQuery() {
        if (this.component == null) {
            this.pagedTable.setInput((ISetWithListeners)EmptySetWithListeners.createInstance());
            return;
        }
        Object query = null;
        if (this.nameFilterButton.getSelection()) {
            query = BaselineSearchCriteria.create(this.component.getRepository()).setComponent((ItemId<IComponent>)this.component.getItemId()).setFullText(this.nameFilterText.getText()).setIgnoreCase(true).getQuery(this.runner, false);
        } else if (this.contextFilterButton.getSelection() && this.sourceWorkspace != null) {
            query = new ComponentScopedBaselinesQuery(this.component, Arrays.asList(this.sourceWorkspace), this.runner);
        }
        if (query != null) {
            this.pagedTable.setInput(query);
        }
    }

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
        this.cachedContext = null;
    }
}

