/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditorInput;
import com.ibm.team.filesystem.ui.AbstractDeliveryHyperlinkHandler;
import com.ibm.team.filesystem.ui.DeliveryLinkData;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentInfo;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;

public class BaselineHyperlinkHandler
extends AbstractDeliveryHyperlinkHandler {
    @Override
    public boolean handles(Location location) {
        return location.getItemType() == IBaseline.ITEM_TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void open(DeliveryLinkData data, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspace stream = data.getWorkspace();
        IBaseline baseline = (IBaseline)data.getItem();
        if (data.isDeliverEvent()) {
            Object[] indexString = (String[])data.getLocation().getQueryParms().get("com.ibm.team.scm.eventCategory.delivery.baselines.index");
            if (indexString.length == 0 || indexString[0] == null) {
                throw new TeamRepositoryException("Baseline index is missing or in the wrong format: " + Arrays.toString(indexString));
            }
            try {
                int index = Integer.parseInt(indexString[0]);
                if (index <= 0) return;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.BaselineHyperlinkHandler_OpeningBaselineProgressMessage, (int)10);
                IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)data.getRepository()).getWorkspaceConnection((IWorkspaceHandle)stream, (IProgressMonitor)progress.newChild(2));
                List componentInfos = connection.getComponentAuditTrail(baseline.getComponent(), (long)(index - 1), 1L, (IProgressMonitor)progress.newChild(8));
                IComponentInfo componentInfo = (IComponentInfo)componentInfos.get(0);
                IBaselineHandle previousBaseline = componentInfo.basis();
                if (previousBaseline != null) {
                    BaselineHyperlinkHandler.openChangesView(data.getRepository(), (IBaselineHandle)baseline, previousBaseline);
                    return;
                }
                JFaceUtils.showMessage((String)Messages.BaselineHyperlinkHandler_CannotFindBaselineMessageTitle, (String)Messages.BaselineHyperlinkHandler_CannotRunBaselineComparisonMessage, (int)1);
                return;
            }
            catch (NumberFormatException e) {
                throw new TeamRepositoryException("Baseline index is missing or in the wrong format: " + Arrays.toString(indexString));
            }
        } else {
            IComponent component = (IComponent)data.getRepository().itemManager().fetchCompleteItem((IItemHandle)baseline.getComponent(), 1, monitor);
            final BaselineWrapper wrapper = new BaselineWrapper(data.getRepository(), baseline, component);
            UIJob job = new UIJob(Messages.BaselineHyperlinkHandler_OpeningBaselinePropertiesTitle){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
                    if (page != null) {
                        BaselineEditor.open(page, BaselineEditorInput.newForEdit(wrapper));
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public URIReference createHyperlink(Object object) {
        try {
            if (object instanceof BaselineWrapper) {
                object = ((BaselineWrapper)object).getBaseline();
            }
            if ((object = Adapters.getAdapter((Object)object, IBaseline.class)) instanceof IBaselineHandle) {
                IBaselineHandle handle = (IBaselineHandle)object;
                ITeamRepository repository = (ITeamRepository)handle.getOrigin();
                ArrayList<String> properties = new ArrayList<String>(2);
                properties.add(IWorkspace.NAME_PROPERTY);
                properties.add(IWorkspace.OWNER_PROPERTY);
                IBaseline baseline = (IBaseline)repository.itemManager().fetchPartialItem((IItemHandle)handle, 0, properties, null);
                if (baseline != null) {
                    StringBuilder details = new StringBuilder();
                    details.append("Name: ");
                    details.append(baseline.getName());
                    IComponent component = (IComponent)repository.itemManager().fetchCompleteItem((IItemHandle)baseline.getComponent(), 0, null);
                    details.append(" (");
                    details.append(component.getName());
                    details.append(")");
                    Location location = Location.itemLocation((IItemHandle)baseline, (String)repository.getRepositoryURI());
                    return new URIReference(details.toString(), details.toString(), location.toAbsoluteUri());
                }
            }
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        return null;
    }

    public Object resolve(URI uri, ContextProvider provider, IProgressMonitor monitor) throws CoreException {
        try {
            DeliveryLinkData data = this.parse(Location.location((URI)uri), monitor);
            if (data != null) {
                IBaseline baseline = (IBaseline)data.getItem();
                IComponent component = (IComponent)data.getRepository().itemManager().fetchCompleteItem((IItemHandle)baseline.getComponent(), 1, monitor);
                return new BaselineWrapper(data.getRepository(), baseline, component);
            }
            return null;
        }
        catch (TeamRepositoryException e) {
            return new CoreException(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.BaselineHyperlinkHandler_UnableToResolveUriText, (Object)uri, (Object[])new Object[0]), (Throwable)e));
        }
    }

    public boolean links(Object object) {
        BaselineWrapper baseline = (BaselineWrapper)Adapters.getAdapter((Object)object, BaselineWrapper.class);
        if (baseline != null) {
            return true;
        }
        return object instanceof IBaselineHandle || Adapters.getAdapter((Object)object, IBaseline.class) != null;
    }
}

