/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractFilesystemHyperLinkHandler
extends HyperlinkHandler {
    protected IWorkspace extractWorkspace(Location location, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)this.extractItem(IWorkspace.ITEM_TYPE, location, monitor);
    }

    protected <T extends IItem> T extractItem(IItemType itemType, Location location, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository server = AbstractFilesystemHyperLinkHandler.resolveTeamRepository(location, (IProgressMonitor)progress.newChild(5));
        IItemManager itemManager = server.itemManager();
        IItem item = null;
        String uuidString = this.getQueryParam(location, itemType.getName());
        if (uuidString != null) {
            UUID id = UUID.valueOf((String)uuidString);
            try {
                IItemHandle itemHandle = itemType.createItemHandle(id, null);
                item = itemManager.fetchCompleteItem(itemHandle, 1, (IProgressMonitor)progress.newChild(95));
            }
            catch (ItemNotFoundException e) {
                item = null;
            }
            catch (Exception e) {
                item = null;
            }
        }
        return (T)item;
    }

    public static ITeamRepository resolveTeamRepository(Location loc, IProgressMonitor monitor) throws TeamRepositoryException {
        if (loc == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        if (loc.getRepoUri() == null) {
            return null;
        }
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        ITeamRepository repo = service.getTeamRepository(loc.getRepoUri(), monitor);
        return repo;
    }

    public String getQueryParam(Location location, String key) {
        Map queryParams;
        String[] values;
        if (location.hasQueryParms() && (values = (String[])(queryParams = location.getQueryParms()).get(key)) != null) {
            return values[0];
        }
        return null;
    }
}

