/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.internal.calm.OslcLinkUtil;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.ui.AbstractFilesystemHyperLinkHandler;
import com.ibm.team.filesystem.ui.DeliveryLinkData;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryView;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractDeliveryHyperlinkHandler
extends AbstractFilesystemHyperLinkHandler {
    public static void openChangesView(List<IChangeSetHandle> changeSets) {
        AbstractDeliveryHyperlinkHandler.openChangesView(null, changeSets);
    }

    public static void openChangesView(final IWorkspaceHandle workspace, final List<IChangeSetHandle> changeSets) {
        UIJob job = new UIJob(Messages.AbstractDeliveryHyperlinkHandler_OpeningChangeSummaryJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
                if (page != null) {
                    if (workspace == null) {
                        ChangeSummaryView.open(new ChangeSetInput(changeSets).getOutgoing(), changeSets);
                    } else {
                        SnapshotId sid = SnapshotId.getSnapshotId((IItemHandle)workspace);
                        ChangeSummaryView.open(new ChangeSetInput(sid, changeSets).getOutgoing(), changeSets);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static void openChangesView(final ITeamRepository repo, final IBaselineHandle baseline1, final IBaselineHandle baseline2) {
        UIJob job = new UIJob(Messages.AbstractDeliveryHyperlinkHandler_OpeningChangeExplorerJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
                if (page != null) {
                    ChangesViewConverter.compare(UIContext.createPageContext((Shell)page.getWorkbenchWindow().getShell(), (IWorkbenchPage)page), (SnapshotId)BaselineId.create((ITeamRepository)repo, (IBaselineHandle)baseline1), (SnapshotId)BaselineId.create((ITeamRepository)repo, (IBaselineHandle)baseline2));
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public boolean handles(URI uri) {
        try {
            Location location = Location.location((URI)uri);
            return this.handles(location);
        }
        catch (Exception e) {
            return false;
        }
    }

    public abstract boolean handles(Location var1);

    public boolean resolves(URI uri) {
        return this.handles(uri);
    }

    public IStatus open2(URI uri, ContextProvider context, IProgressMonitor monitor) {
        return this.open(Collections.singletonList(uri), context, monitor);
    }

    public IStatus open(List<URI> uris, ContextProvider provider, IProgressMonitor monitor) {
        try {
            ArrayList<Location> locations = new ArrayList<Location>(uris.size());
            for (URI uri : uris) {
                locations.add(Location.location((URI)uri));
            }
            return this.doOpen(locations, provider, monitor);
        }
        catch (NotLoggedInException e) {
            return Status.OK_STATUS;
        }
        catch (ConnectionException e) {
            return Status.OK_STATUS;
        }
        catch (TeamRepositoryException e) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.AbstractDeliveryHyperlinkHandler_ErrorOpeningChangeSetReferences, (Throwable)e);
        }
    }

    public IStatus doOpen(List<Location> locations, ContextProvider provider, IProgressMonitor monitor) {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            DeliveryLinkData data = this.parse(locations, (IProgressMonitor)progress.newChild(1));
            if (progress.isCanceled()) {
                return Status.OK_STATUS;
            }
            if (data == null) {
                return StatusUtil.newStatus((Object)((Object)this), (String)Messages.AbstractDeliveryHyperlinkHandler_ERROR_CHANGESET_NOTACCESSIBLE);
            }
            this.open(data, monitor);
            return Status.OK_STATUS;
        }
        catch (NotLoggedInException e) {
            return Status.OK_STATUS;
        }
        catch (ConnectionException e) {
            return Status.OK_STATUS;
        }
        catch (FileSystemStatusException e) {
            return e.getStatus();
        }
        catch (TeamRepositoryException e) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.AbstractDeliveryHyperlinkHandler_ErrorOpeningChangeSetReferences, (Throwable)e);
        }
    }

    protected abstract void open(DeliveryLinkData var1, IProgressMonitor var2) throws TeamRepositoryException;

    public DeliveryLinkData parse(Location location, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        if (!this.handles(location)) {
            return null;
        }
        ITeamRepository server = AbstractDeliveryHyperlinkHandler.resolveTeamRepository(location, monitor);
        IItemManager itemManager = server.itemManager();
        IItem item = itemManager.fetchCompleteItem(location, 0, monitor);
        if (item == null) {
            throw new FileSystemException(NLS.bind((String)Messages.AbstractDeliveryHyperlinkHandler_ErrorChangeSetNotAccessableWithLocation, (Object)location.toAbsoluteUri()));
        }
        IWorkspace workspace = this.extractWorkspace(location, monitor);
        String deliveryEvent = this.getQueryParam(location, "com.ibm.team.scm.eventCategory.delivery");
        return new DeliveryLinkData(server, location, item, workspace, deliveryEvent != null);
    }

    public DeliveryLinkData parse(List<Location> locations, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        if (!this.handles(locations.get(0))) {
            return null;
        }
        ArrayList<IItemHandle> handles = new ArrayList<IItemHandle>(locations.size());
        ArrayList<Location> newLocations = new ArrayList<Location>(locations.size());
        for (Location location : locations) {
            if (location.getItemHandle() == null) {
                IItemHandle handle;
                Location l;
                URI origUri = location.toAbsoluteUri();
                URI newURI = null;
                try {
                    newURI = OslcLinkUtil.convertToLegacyResourceUri((URI)origUri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                if (newURI == null || (l = Location.location((URI)newURI)) == null || (handle = l.getItemHandle()) == null) continue;
                newLocations.add(l);
                handles.add(handle);
                continue;
            }
            handles.add(location.getItemHandle());
            newLocations.add(location);
        }
        Location firstLocation = (Location)newLocations.get(0);
        ITeamRepository server = AbstractDeliveryHyperlinkHandler.resolveTeamRepository(firstLocation, monitor);
        IItemManager itemManager = server.itemManager();
        List items = itemManager.fetchCompleteItems(handles, 0, monitor);
        ArrayList<IItem> itemsForData = new ArrayList<IItem>();
        int i = 0;
        while (i < items.size()) {
            IItem item = (IItem)items.get(i);
            if (item != null) {
                itemsForData.add(item);
            }
            ++i;
        }
        if (itemsForData.size() == 0) {
            return null;
        }
        IWorkspace workspace = this.extractWorkspace(firstLocation, monitor);
        String deliveryEvent = this.getQueryParam(firstLocation, "com.ibm.team.scm.eventCategory.delivery");
        return new DeliveryLinkData(server, locations, items, workspace, deliveryEvent != null);
    }
}

