/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process.providers;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.IUnmodifiedInfo;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.internal.FilesystemPackage;
import com.ibm.team.filesystem.ide.ui.process.AbstractFileAdvisorDetailProvider;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.ide.ui.process.providers.AbstractLinkDetailHandler;
import com.ibm.team.filesystem.ide.ui.process.providers.ContextType;
import com.ibm.team.filesystem.ide.ui.process.providers.ITagDetailHandlerContext;
import com.ibm.team.filesystem.ide.ui.process.providers.ITagMemento;
import com.ibm.team.filesystem.ide.ui.process.providers.VersionableMemento;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.editor.PartUtil;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ScmPackage;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.xml.sax.Attributes;

public class VersionableLinkDetailHandler
extends AbstractLinkDetailHandler<VersionableMemento> {
    private static Map<String, ResourceType> eTypeMap = null;

    @Override
    public ITagMemento start(ITagDetailHandlerContext ctx, String uri, String localName, String qName, Attributes attr) {
        VersionableMemento memento = new VersionableMemento(this);
        memento.uuid = UUID.valueOf((String)attr.getValue("uuid"));
        String value = attr.getValue("state");
        if (value != null) {
            memento.state = UUID.valueOf((String)value);
        }
        memento.type = this.findType(attr);
        boolean bl = memento.useNameFromMetadata = attr.getValue("make-content") != null;
        if (memento.useNameFromMetadata) {
            ctx.markRequiringLongOp();
        }
        memento.extract(attr);
        return memento;
    }

    private synchronized ResourceType findType(Attributes attr) {
        String typeAttr = attr.getValue("type");
        if (typeAttr != null) {
            if ("file".equals(typeAttr)) {
                return ResourceType.FILE;
            }
            if ("directory".equals(typeAttr)) {
                return ResourceType.FOLDER;
            }
            if ("symlink".equals(typeAttr)) {
                return ResourceType.SYMBOLIC_LINK;
            }
        }
        if ((typeAttr = attr.getValue("etype")) != null) {
            ResourceType type;
            if (eTypeMap == null) {
                eTypeMap = new HashMap<String, ResourceType>();
                eTypeMap.put(String.valueOf(IFileItem.ITEM_TYPE.getNamespaceURI()) + " " + IFileItem.ITEM_TYPE.getName(), ResourceType.FILE);
                eTypeMap.put(String.valueOf(IFolder.ITEM_TYPE.getNamespaceURI()) + " " + IFolder.ITEM_TYPE.getName(), ResourceType.FOLDER);
                eTypeMap.put(String.valueOf(ISymbolicLink.ITEM_TYPE.getNamespaceURI()) + " " + ISymbolicLink.ITEM_TYPE.getName(), ResourceType.SYMBOLIC_LINK);
                eTypeMap.put("com.ibm.team.filesystem " + FilesystemPackage.eINSTANCE.getFileItemHandle().getName(), ResourceType.FILE);
                eTypeMap.put("com.ibm.team.scm " + ScmPackage.eINSTANCE.getFolderHandle().getName(), ResourceType.FILE);
                eTypeMap.put("com.ibm.team.filesystem " + FilesystemPackage.eINSTANCE.getSymbolicLinkHandle().getName(), ResourceType.FILE);
            }
            if ((type = eTypeMap.get(typeAttr)) != null) {
                return type;
            }
        }
        return null;
    }

    @Override
    public void end(ITagDetailHandlerContext ctx, VersionableMemento memento) {
        String versionableName = null;
        if (memento.useNameFromMetadata && ctx.getProgressMonitor() != null) {
            try {
                Collection<IShareable> shareables = this.findShareables(memento, ctx.getProgressMonitor());
                if (shareables.size() == 1) {
                    versionableName = shareables.iterator().next().getLocalPath().getName();
                }
                if (shareables.size() > 0) {
                    String candidateName = null;
                    for (IShareable shareable : shareables) {
                        if (candidateName == null) {
                            candidateName = shareable.getLocalPath().getName();
                            continue;
                        }
                        if (candidateName.equals(shareable.getLocalPath().getName())) continue;
                        candidateName = null;
                        break;
                    }
                    versionableName = candidateName;
                }
                IProgressMonitor mon = ctx.getProgressMonitor();
                if (shareables.size() == 0 && mon != null) {
                    versionableName = this.guessNameUsingMetadata(memento, mon);
                }
            }
            catch (FileSystemException e) {
                LoggingHelper.log((String)"com.ibm.team.filesystem.ide.ui", (TeamRepositoryException)((Object)e));
            }
        }
        if (versionableName == null) {
            versionableName = memento.linkText.toString();
        }
        if (memento.type == ResourceType.FILE) {
            ctx.getLinkWriter().writeHyperlink(versionableName, "", ctx.getOutputBuffer(), memento.getRunnable());
        } else {
            ctx.getOutputBuffer().append(versionableName);
        }
    }

    protected String guessNameUsingMetadata(VersionableMemento memento, IProgressMonitor mon) throws FileSystemException {
        Collection allLoaded;
        Iterator iterator;
        IContextHandle wsHandle = memento.getContextHandle();
        IComponentHandle cHandle = memento.getComponent();
        IVersionableHandle ver = memento.getHandle();
        if (wsHandle != null && cHandle != null && ver != null && (iterator = (allLoaded = SharingManager.getInstance().findUnmodifiedInfoFor(wsHandle, cHandle, ver, mon)).iterator()).hasNext()) {
            IUnmodifiedInfo info = (IUnmodifiedInfo)iterator.next();
            return info.getName();
        }
        return null;
    }

    @Override
    public void showClickResult(VersionableMemento memento, IWorkbenchWindow window, SubMonitor monitor) throws FileSystemException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        monitor.setTaskName(Messages.VersionableLinkDetailHandler_FILE_OPEN_PROGRESS_MESSAGE);
        final Shell shell = window.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        IComponentHandle cHandle = memento.getComponent();
        IFileItemHandle ver = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(memento.uuid, memento.state);
        if (memento.contextType == ContextType.WORKSPACE) {
            IWorkspaceHandle wsHandle = memento.getWorkspaceHandle();
            Collection<IShareable> shareables = this.findShareables(memento, (IProgressMonitor)monitor);
            ArrayList<IFile> files = new ArrayList<IFile>(shareables.size());
            monitor.setWorkRemaining(shareables.size() * 2);
            for (IShareable shareable : shareables) {
                IFile file = (IFile)shareable.getAdapter(IFile.class);
                if (file == null) continue;
                files.add(file);
            }
            if (files.size() == 1) {
                this.openFile(window, (IFile)files.get(0));
                return;
            }
            if (files.size() > 1) {
                this.openFiles(window, files);
                return;
            }
            if (ver.getStateId() != null) {
                ITeamRepository repo = memento.getRepository();
                final FileItemWrapper fiw = new FileItemWrapper(new StateId((IItemHandle)ver), memento.linkText.toString(), WorkspaceNamespace.create((ITeamRepository)repo, (IWorkspaceHandle)wsHandle, (IComponentHandle)cHandle));
                final IWorkbenchPage page = this.findWorkbenchPage(window);
                if (page == null) {
                    StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (String)"Could not find page");
                    return;
                }
                shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        UIContext context = UIContext.createPageContext((Shell)shell, (IWorkbenchPage)page);
                        PartUtil.openEditor(context, fiw);
                    }
                });
            } else {
                shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialogFactory.showMessage((Shell)shell, (String)Messages.VersionableLinkDetailHandler_MissingFileTitle, (int)2, (String)Messages.VersionableLinkDetailHandler_MissingFileMessage);
                    }
                });
            }
        }
    }

    protected Collection<IShareable> findShareables(VersionableMemento memento, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
        IContextHandle wsHandle = memento.getContextHandle();
        IComponentHandle cHandle = memento.getComponent();
        IVersionableHandle ver = memento.getHandle();
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        Collection shareables = cHandle == null ? sharingManager.findShareables(ver, (IProgressMonitor)monitor.newChild(1)) : (wsHandle == null ? sharingManager.findShareables(cHandle, ver, (IProgressMonitor)monitor.newChild(1)) : sharingManager.findShareables(wsHandle, cHandle, ver, (IProgressMonitor)monitor.newChild(1)));
        monitor.done();
        return shareables;
    }

    private void openFile(IWorkbenchWindow window, final IFile file) {
        final IWorkbenchPage page = this.findWorkbenchPage(window);
        if (page != null) {
            window.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    }
                    catch (PartInitException e) {
                        StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
                    }
                }
            });
        }
    }

    private void openFiles(IWorkbenchWindow window, List<IFile> files) {
        IWorkbenchPage page = this.findWorkbenchPage(window);
        if (page != null) {
            AbstractFileAdvisorDetailProvider.FileSelectionDialog dialog = new AbstractFileAdvisorDetailProvider.FileSelectionDialog(window.getShell(), files);
            dialog.setTitle(Messages.AbstractFileAdvisorDetailProvider_3);
            if (dialog.open() == 0) {
                Object[] selectedFiles = dialog.getResult();
                int i = 0;
                while (i < selectedFiles.length) {
                    this.openFile(window, (IFile)selectedFiles[i]);
                    ++i;
                }
            }
        }
    }
}

