/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process.providers;

import com.ibm.team.filesystem.common.internal.util.LoggingUtil;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.ide.ui.process.providers.HtmlTranslator;
import com.ibm.team.filesystem.ide.ui.process.providers.ParsedUnifiedDescriptionRegistry;
import com.ibm.team.filesystem.ide.ui.process.providers.TagDetailHandler;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.ide.ui.advice.AdviceElementDetailProvider;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.internal.process.AdvisorDataMarshaller;
import java.io.IOException;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class TeamAdvisorViewDetailTransformer
extends AdviceElementDetailProvider
implements TagDetailHandler.ILinkWriter {
    private static final String TAG_TAG = "tag";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_MATCH = "match";
    private static WeakHashMap<IReportInfo, TeamAdvisorViewDetailTransformer> transformerMap = null;
    private final Object cacheLock = new Object();
    private String cachedPreamble;
    private String cachedPostamble;
    private String cachedShortOpDescriptionBuffer;
    private String cachedLongOpDescriptionBuffer;

    private static synchronized WeakHashMap<IReportInfo, TeamAdvisorViewDetailTransformer> getMap() {
        if (transformerMap == null) {
            transformerMap = new WeakHashMap();
        }
        return transformerMap;
    }

    public static TeamAdvisorViewDetailTransformer newInstanceFor(IReportInfo info) {
        WeakHashMap<IReportInfo, TeamAdvisorViewDetailTransformer> map = TeamAdvisorViewDetailTransformer.getMap();
        TeamAdvisorViewDetailTransformer trans = map.get(info);
        if (trans == null) {
            trans = new TeamAdvisorViewDetailTransformer(info);
            map.put(info, trans);
        }
        return trans;
    }

    private TeamAdvisorViewDetailTransformer(Object element) {
        super(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendPreamble(int severity, StringBuffer target) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cachedPreamble == null) {
                StringBuffer preamble = new StringBuffer(100);
                this.appendBodyAndTableStart(preamble, severity);
                String problemTitle = Messages.AbstractFileAdvisorDetailProvider_1;
                preamble.append("<b><font color=\"").append(this.getTitleFontColor()).append(NLS.bind((String)"\">{0}</font></b><br>", (Object)problemTitle));
                this.cachedPreamble = preamble.toString();
            }
            target.append(this.cachedPreamble);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendPostamble(IAdvisorInfo info, StringBuffer buffer) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cachedPostamble == null) {
                String parentDescription;
                StringBuffer buf = new StringBuffer();
                IProcessReport parentReport = info.getProcessReport();
                if (parentReport instanceof IParticipantReport && (parentDescription = parentReport.getDescription()) != null && parentDescription.length() > 0) {
                    String reasonTitle = Messages.AbstractFileAdvisorDetailProvider_2;
                    buf.append("<br><br><b><font color=\"").append(this.getTitleFontColor()).append(NLS.bind((String)"\">{0}</font></b><br>", (Object)reasonTitle));
                    buf.append(this.convertToHtml(parentDescription));
                }
                this.appendExplainOperationLink(info, buf);
                this.computePostable(buf);
                this.cachedPostamble = buf.toString();
            }
            buffer.append(this.cachedPostamble);
        }
    }

    private void computePostable(StringBuffer buf) {
        buf.append("</td></tr></table></body>");
    }

    private boolean appendProblem(VersionablePermissionDeniedException exception, StringBuffer buf, IProgressMonitor progress) {
        String xml = exception.getAml();
        if (xml != null && xml.length() != 0) {
            StringBuffer procBuf = new StringBuffer(xml.length());
            HtmlTranslator translator = new HtmlTranslator(procBuf, this, SubMonitor.convert((IProgressMonitor)progress));
            this.configureTranslator(translator);
            try {
                translator.translate(xml);
            }
            catch (SAXException e) {
                StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
                return false;
            }
            catch (IOException e) {
                StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
                return false;
            }
            buf.append(procBuf);
            return true;
        }
        return false;
    }

    private void configureTranslator(HtmlTranslator translator) {
        IConfigurationElement[] configs;
        IConfigurationElement[] iConfigurationElementArray = configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.ide.ui", "advisor_tag");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IConfigurationElement child = iConfigurationElementArray[n2];
                if (TAG_TAG.equals(child.getName())) {
                    TagDetailHandler handler;
                    Object[] matches = child.getAttribute(ATTR_MATCH).split("\\s+");
                    try {
                        handler = (TagDetailHandler)child.createExecutableExtension(ATTR_CLASS);
                    }
                    catch (CoreException e) {
                        StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (String)NLS.bind((String)Messages.TeamAdvisorViewDetailTransformer_COULD_NOT_CREATE_EXTENSION, (Object)child.getAttribute(ATTR_CLASS), (Object)Arrays.toString(matches)), (Throwable)e);
                        break block5;
                    }
                    Object[] objectArray = matches;
                    int n3 = matches.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object match = objectArray[n4];
                        translator.addTagHandler((String)match, handler);
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    public boolean requiresLongOp() {
        return this.buildDescription(null);
    }

    protected String createDetailText() {
        return this.createDetailText(null);
    }

    protected String createDetailText(IProgressMonitor progress) {
        if (this.fElement instanceof IAdvisorInfo) {
            IAdvisorInfo info = (IAdvisorInfo)this.fElement;
            StringBuffer buffer = new StringBuffer();
            this.appendPreamble(info.getSeverity(), buffer);
            this.buildDescription(progress == null ? null : SubMonitor.convert((IProgressMonitor)progress));
            this.appendDescription(buffer, null);
            this.appendQuickFixes(info, buffer);
            this.appendPostamble(info, buffer);
            String shortOpText = buffer.toString();
            if (UiPlugin.TRACE_AML_MARKUP) {
                System.out.println("Full text:");
                System.out.println(LoggingUtil.indent((String)shortOpText));
            }
            return shortOpText;
        }
        if (this.fElement instanceof IReportInfo) {
            StringBuffer buffer = new StringBuffer();
            this.appendPreamble(4, buffer);
            this.buildDescription(progress == null ? null : SubMonitor.convert((IProgressMonitor)progress));
            this.appendDescription(buffer, null);
            this.computePostable(buffer);
            return buffer.toString();
        }
        return null;
    }

    private static void printMarkup(String message, String multiline) {
        System.out.println(message);
        System.out.println(LoggingUtil.indent((String)multiline));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean buildDescription(SubMonitor monitor) {
        IAdvisorInfo info;
        Object object = this.cacheLock;
        synchronized (object) {
            if (monitor == null) {
                if (this.cachedShortOpDescriptionBuffer != null) {
                    if (this.cachedLongOpDescriptionBuffer != null) return false;
                    return true;
                }
            } else if (this.cachedLongOpDescriptionBuffer != null) {
                return false;
            }
        }
        if (this.fElement instanceof IAdvisorInfo) {
            info = (IAdvisorInfo)this.fElement;
            HtmlTranslator translator = null;
            StringBuffer descBuffer = new StringBuffer();
            if (UiPlugin.TRACE_AML_MARKUP && info.getData() != null) {
                TeamAdvisorViewDetailTransformer.printMarkup("Source markup", info.getData());
            }
            Throwable exception = null;
            try {
                AdvisorDataMarshaller.AdvisorData unified = this.extractUnifiedDescription(info);
                if (unified != null && unified.text != null) {
                    descBuffer.ensureCapacity(unified.text.length());
                    translator = new HtmlTranslator(descBuffer, this, monitor);
                    this.configureTranslator(translator);
                    translator.translate(unified.text);
                }
            }
            catch (IOException e) {
                exception = e;
            }
            catch (SAXException e) {
                exception = e;
            }
            catch (AdvisorDataMarshaller.MarshallerException e) {
                exception = e;
            }
            if (exception != null) {
                exception = new TeamRepositoryException("AML parse failed for " + info.getIdentifier(), exception);
                StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)exception);
            }
            if (descBuffer.length() == 0) {
                descBuffer.append("<div style=\"white-space: pre\">" + info.getDescription() + "</div>");
            }
            String s = descBuffer.toString();
            Object object2 = this.cacheLock;
            synchronized (object2) {
                if (this.cachedShortOpDescriptionBuffer == null) {
                    this.cachedShortOpDescriptionBuffer = s;
                }
                if (this.cachedLongOpDescriptionBuffer == null && translator != null && monitor != null) {
                    this.cachedLongOpDescriptionBuffer = s;
                }
            }
            if (translator == null) return false;
            if (!translator.requiresLongOp()) return false;
            return true;
        }
        if (!(this.fElement instanceof IReportInfo)) return false;
        info = (IReportInfo)this.fElement;
        StringBuffer buffer = new StringBuffer();
        Object problemObject = info.getProblemObject();
        boolean wroteAml = false;
        if (problemObject instanceof VersionablePermissionDeniedException) {
            VersionablePermissionDeniedException vpde = (VersionablePermissionDeniedException)problemObject;
            wroteAml = this.appendProblem(vpde, buffer, null);
        }
        if (!wroteAml && problemObject instanceof Throwable) {
            Throwable t = (Throwable)problemObject;
            buffer.append(t.getMessage());
        }
        String s = buffer.toString();
        Object object3 = this.cacheLock;
        synchronized (object3) {
            if (this.cachedShortOpDescriptionBuffer == null) {
                this.cachedShortOpDescriptionBuffer = s;
            }
            if (this.cachedLongOpDescriptionBuffer != null) return false;
            if (monitor == null) return false;
            this.cachedLongOpDescriptionBuffer = s;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendDescription(StringBuffer buffer, SubMonitor monitor) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cachedLongOpDescriptionBuffer == null) {
                buffer.append(this.cachedShortOpDescriptionBuffer);
            } else {
                buffer.append(this.cachedLongOpDescriptionBuffer);
            }
        }
    }

    private AdvisorDataMarshaller.AdvisorData extractUnifiedDescription(IAdvisorInfo info) throws AdvisorDataMarshaller.MarshallerException {
        String data = info.getData();
        if (data == null) {
            return null;
        }
        return ParsedUnifiedDescriptionRegistry.getInstance().parse(info);
    }

    @Override
    public void writeHyperlink(String linkText, String tooltipText, StringBuffer buffer, Runnable hyperlinkRunnable) {
        this.appendHyperlink(linkText, tooltipText, buffer, hyperlinkRunnable);
    }
}

