/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process.providers;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.process.providers.AbstractLinkDetailHandler;
import com.ibm.team.filesystem.ide.ui.process.providers.ITagDetailHandlerContext;
import com.ibm.team.filesystem.ide.ui.process.providers.ITagMemento;
import com.ibm.team.filesystem.ide.ui.process.providers.ProcessAreaLinkMemento;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.ide.ui.EditorUtilities;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.ItemHandle;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.xml.sax.Attributes;

public class ProcessAreaLinkDetailHandler
extends AbstractLinkDetailHandler<ProcessAreaLinkMemento> {
    @Override
    public ITagMemento start(ITagDetailHandlerContext ctx, String uri, String localName, String qName, Attributes attr) {
        ProcessAreaLinkMemento memento = new ProcessAreaLinkMemento(this);
        memento.name = attr.getValue("name");
        memento.paUuid = UUID.valueOf((String)attr.getValue("process-area-uuid"));
        String type = attr.getValue("process-area-type");
        memento.type = "project".equals(type) ? ProcessAreaLinkMemento.LinkType.PROJECT_AREA : ("team".equals(type) ? ProcessAreaLinkMemento.LinkType.TEAM_AREA : ProcessAreaLinkMemento.LinkType.UNKNOWN);
        memento.extract(attr);
        return memento;
    }

    @Override
    public void showClickResult(ProcessAreaLinkMemento memento, IWorkbenchWindow window, SubMonitor monitor) throws FileSystemException {
        if (memento.type == ProcessAreaLinkMemento.LinkType.PROJECT_AREA) {
            IProjectAreaHandle paHandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(memento.paUuid, null);
            ((ItemHandle)paHandle).setOrigin((Object)memento.getRepository());
            EditorUtilities.openProjectAreaEditor((IWorkbenchPage)window.getActivePage(), (IProjectAreaHandle)paHandle, (String)"processAreaOverview");
        } else if (memento.type == ProcessAreaLinkMemento.LinkType.TEAM_AREA) {
            ITeamAreaHandle taHandle = (ITeamAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle(memento.paUuid, null);
            ((ItemHandle)taHandle).setOrigin((Object)memento.getRepository());
            EditorUtilities.openTeamAreaEditor((IWorkbenchPage)window.getActivePage(), (ITeamAreaHandle)taHandle, (String)"processAreaOverview");
        }
    }

    @Override
    public void end(ITagDetailHandlerContext ctx, ProcessAreaLinkMemento memento) {
        if (memento.type == ProcessAreaLinkMemento.LinkType.UNKNOWN) {
            ctx.getOutputBuffer().append(memento.linkText);
        } else {
            ctx.getLinkWriter().writeHyperlink(memento.linkText.toString(), "Open Process Area", ctx.getOutputBuffer(), memento.getRunnable());
        }
    }
}

