/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process.providers;

import com.ibm.team.filesystem.ide.ui.process.providers.ITagDetailHandlerContext;
import com.ibm.team.filesystem.ide.ui.process.providers.ITagMemento;
import com.ibm.team.filesystem.ide.ui.process.providers.TagDetailHandler;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class HtmlTranslator
extends DefaultHandler {
    private final StringBuffer output;
    private final Map<String, String> translation;
    private final Stack<TagFrame> tags = new Stack();
    private final SubMonitor monitor;
    private final TagDetailHandler.ILinkWriter linkWriter;
    private final Map<String, TagDetailHandler> tagHandlers = new HashMap<String, TagDetailHandler>();
    private final ITagDetailHandlerContext ctx = new ITagDetailHandlerContext(){

        @Override
        public StringBuffer getOutputBuffer() {
            return HtmlTranslator.this.output;
        }

        @Override
        public TagDetailHandler.ILinkWriter getLinkWriter() {
            return HtmlTranslator.this.linkWriter;
        }

        @Override
        public IProgressMonitor getProgressMonitor() {
            return HtmlTranslator.this.monitor;
        }

        @Override
        public void markRequiringLongOp() {
            HtmlTranslator.this.requiresLongOp = true;
        }
    };
    protected boolean requiresLongOp = false;

    public HtmlTranslator(StringBuffer output, TagDetailHandler.ILinkWriter linkWriter, SubMonitor monitor) {
        this.output = output;
        this.linkWriter = linkWriter;
        this.monitor = monitor;
        this.translation = new HashMap<String, String>(6);
        this.translation.put("description", "");
        this.translation.put("em", "em");
        this.translation.put("b", "b");
        this.translation.put("list", null);
        this.translation.put("item", "li");
        this.translation.put("paragraph", "p");
        this.translation.put("mono", "tt");
    }

    public String getOutput() {
        return this.output.toString();
    }

    void addTagHandler(String type, TagDetailHandler h) {
        if (this.tagHandlers.containsKey(type)) {
            throw new IllegalStateException();
        }
        this.tagHandlers.put(type, h);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String mapping = this.translation.get(localName);
        if (mapping != null) {
            if (mapping.length() > 0) {
                this.tags.add(new TagFrame(null, localName, mapping, null));
                this.appendTag(mapping);
            } else {
                this.tags.add(new TagFrame(null, localName, "", null));
            }
            return;
        }
        if ("description".equals(localName)) {
            this.tags.add(new TagFrame(null, localName, null, null));
            return;
        }
        if ("list".equals(localName)) {
            String value = attributes.getValue("type");
            String htmlTag = "bullets".equals(value) ? "ul" : ("numbers".equals(value) ? "ol" : "ul");
            this.tags.add(new TagFrame(null, localName, htmlTag, null));
            this.appendTag(htmlTag);
        } else if (this.tagHandlers.containsKey(localName)) {
            TagDetailHandler handler = this.tagHandlers.get(localName);
            ITagMemento memento = handler.start(this.ctx, uri, localName, qName, attributes);
            this.tags.add(new TagFrame(handler, localName, null, memento));
        } else {
            this.tags.add(new TagFrame(null, qName, null, null));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        TagFrame popped = this.tags.pop();
        if (!localName.equals(popped.inTag)) {
            throw new IllegalStateException(String.valueOf(localName) + "/" + popped.inTag);
        }
        String mapping = this.translation.get(localName);
        if (mapping != null) {
            assert (popped.outTag.equals(mapping));
            if (mapping.length() > 0) {
                this.appendTag("/", mapping);
            }
            return;
        }
        if ("description".equals(localName)) {
            assert (popped == null);
            return;
        }
        if ("list".equals(localName)) {
            assert ("ul".equals(popped.outTag) || "ol".equals(popped.outTag));
            this.appendTag("/", popped.outTag);
        } else if (this.tagHandlers.containsKey(localName)) {
            TagDetailHandler handler = this.tagHandlers.get(localName);
            handler.end(this.ctx, popped.key);
        }
    }

    private void appendTag(CharSequence ... str) {
        CharSequence s;
        int size = this.output.length() + 2;
        CharSequence[] charSequenceArray = str;
        int n = str.length;
        int n2 = 0;
        while (n2 < n) {
            s = charSequenceArray[n2];
            size += s.length();
            ++n2;
        }
        this.output.ensureCapacity(size);
        this.output.append('<');
        charSequenceArray = str;
        n = str.length;
        n2 = 0;
        while (n2 < n) {
            s = charSequenceArray[n2];
            this.output.append(s);
            ++n2;
        }
        this.output.append('>');
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        TagFrame peek = null;
        if (!this.tags.isEmpty()) {
            peek = this.tags.peek();
        }
        if (peek != null && peek.handler != null) {
            peek.handler.characters(this.ctx, peek.key, chars, start, length);
        } else {
            this.output.append(chars, start, length);
        }
        if (this.monitor != null) {
            this.monitor.worked(length);
        }
    }

    public void translate(String text) throws SAXException, IOException {
        if (this.monitor != null) {
            this.monitor.setWorkRemaining(text.length());
        }
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(this);
        reader.parse(new InputSource(new StringReader(text)));
    }

    public boolean requiresLongOp() {
        return this.requiresLongOp;
    }

    private static class TagFrame {
        public final TagDetailHandler handler;
        public final String inTag;
        public final String outTag;
        public final ITagMemento key;

        public TagFrame(TagDetailHandler handler, String in_tag, String out_tag, ITagMemento memento) {
            this.handler = handler;
            this.inTag = in_tag;
            this.outTag = out_tag;
            this.key = memento;
        }
    }
}

