/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process.providers;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorInput;
import com.ibm.team.filesystem.ide.ui.process.providers.AbstractLinkDetailHandler;
import com.ibm.team.filesystem.ide.ui.process.providers.ComponentLinkMemento;
import com.ibm.team.filesystem.ide.ui.process.providers.ITagDetailHandlerContext;
import com.ibm.team.filesystem.ide.ui.process.providers.ITagMemento;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.xml.sax.Attributes;

public class ComponentLinkDetailHandler
extends AbstractLinkDetailHandler<ComponentLinkMemento> {
    @Override
    public ITagMemento start(ITagDetailHandlerContext ctx, String uri, String localName, String qName, Attributes attributes) {
        ComponentLinkMemento memento = new ComponentLinkMemento(this);
        memento.extract(attributes);
        memento.componentId = UUID.valueOf((String)attributes.getValue("component-uuid"));
        return memento;
    }

    @Override
    public void showClickResult(ComponentLinkMemento memento, IWorkbenchWindow window, SubMonitor monitor) throws FileSystemException {
        IComponent comp;
        final IWorkbenchPage page = this.findWorkbenchPage(window);
        if (page == null) {
            return;
        }
        IComponentHandle compHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(memento.componentId, null);
        ITeamRepository repo = memento.getRepository();
        try {
            comp = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)compHandle, 0, (IProgressMonitor)monitor);
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException((Throwable)e);
        }
        final ComponentWrapper wrapper = new ComponentWrapper(repo, comp);
        Shell shell = window.getShell();
        if (shell == null) {
            return;
        }
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ComponentEditor.open(page, ComponentEditorInput.newForEdit(wrapper));
            }
        });
    }
}

