/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process.providers;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.ide.ui.process.providers.AbstractLinkDetailHandler;
import com.ibm.team.filesystem.ide.ui.process.providers.ChangeSetLinkMemento;
import com.ibm.team.filesystem.ide.ui.process.providers.ITagDetailHandlerContext;
import com.ibm.team.filesystem.ide.ui.process.providers.ITagMemento;
import com.ibm.team.filesystem.ide.ui.process.providers.Messages;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.xml.sax.Attributes;

public class ChangeSetLinkDetailHandler
extends AbstractLinkDetailHandler<ChangeSetLinkMemento> {
    @Override
    public ITagMemento start(ITagDetailHandlerContext ctx, String uri, String localName, String qName, Attributes attr) {
        ChangeSetLinkMemento memento = new ChangeSetLinkMemento(this);
        memento.extract(attr);
        String[] uuidStrings = attr.getValue("uuids").split("\\s+");
        ArrayList<UUID> uuids = new ArrayList<UUID>(uuidStrings.length);
        String[] stringArray = uuidStrings;
        int n = uuidStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String uuidString = stringArray[n2];
            uuids.add(UUID.valueOf((String)uuidString));
            ++n2;
        }
        memento.uuids = uuids;
        return memento;
    }

    @Override
    public void showClickResult(ChangeSetLinkMemento memento, IWorkbenchWindow window, SubMonitor monitor) throws FileSystemException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor);
        String message = memento.uuids.size() == 1 ? Messages.ChangeSetLinkDetailHandler_OPENING_CS_SINGULAR : Messages.ChangeSetLinkDetailHandler_OPEN_CS_PLURAL;
        monitor.setTaskName(message);
        if (!this.showInPendingChangesView(memento, window, monitor)) {
            this.showInChangeExplorer(memento, window, monitor);
        }
    }

    private boolean showInPendingChangesView(ChangeSetLinkMemento memento, final IWorkbenchWindow w, SubMonitor monitor) throws FileSystemException {
        List activities;
        IComponentSyncModel syncModel = FileSystemResourcesPlugin.getComponentSyncModel();
        IWorkspaceSyncContext wsCtx = null;
        IWorkspaceSyncContext[] iWorkspaceSyncContextArray = syncModel.getWorkspaceSyncContexts();
        int n = iWorkspaceSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceSyncContext candidate = iWorkspaceSyncContextArray[n2];
            IWorkspaceConnection local = candidate.getLocal();
            if (local.teamRepository().getId().equals((Object)memento.repoUuid) && local.getContextHandle().getItemId().equals((Object)memento.contextUuid)) {
                wsCtx = candidate;
                break;
            }
            ++n2;
        }
        if (wsCtx == null) {
            activities = ComponentSyncUtil.getOutgoingActivitiesWithinOneWorkspace((IComponentSyncModel)syncModel, memento.getChangeSets());
        } else {
            IComponentSyncContext csCtx = null;
            IComponentSyncContext[] iComponentSyncContextArray = wsCtx.getComponentSyncContexts();
            int n3 = iComponentSyncContextArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IComponentSyncContext candidate = iComponentSyncContextArray[n4];
                if (candidate.getComponent().getItemId().equals((Object)memento.component)) {
                    csCtx = candidate;
                    break;
                }
                ++n4;
            }
            if (csCtx == null) {
                return false;
            }
            activities = ComponentSyncUtil.getOutgoingActivitiesFor((IComponentSyncModel)syncModel, memento.getChangeSets(), (IWorkspaceConnection)wsCtx.getLocal());
        }
        if (activities.size() != memento.uuids.size()) {
            return false;
        }
        final IViewDescriptor desc = PlatformUI.getWorkbench().getViewRegistry().find("com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView");
        if (desc == null) {
            StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (String)"Couldn't find Pending Changes view");
            return false;
        }
        Shell shell = w.getShell();
        if (shell == null) {
            return false;
        }
        final boolean[] retVal = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewPart view = w.getActivePage().showView(desc.getId());
                    if (view instanceof LocalWorkspaceChangesView) {
                        ((LocalWorkspaceChangesView)view).getActiveChangesViewPage().setSelection((IStructuredSelection)new StructuredSelection(activities));
                        retVal[0] = true;
                    }
                }
                catch (PartInitException e) {
                    StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
                }
            }
        });
        return retVal[0];
    }

    private void showInChangeExplorer(ChangeSetLinkMemento memento, final IWorkbenchWindow w, SubMonitor monitor) throws FileSystemException {
        ITeamRepository repo = memento.getRepository();
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Opening change explorer", (int)1);
        final ArrayList<IChangeSetHandle> wrapped = new ArrayList<IChangeSetHandle>(memento.uuids.size());
        for (IChangeSetHandle csHandle : memento.getChangeSets()) {
            wrapped.add(csHandle);
        }
        final SnapshotId ss = SnapshotId.getSnapshotId((ITeamRepository)repo, (IItemHandle)memento.getContextHandle());
        Shell shell = w.getShell();
        if (shell == null) {
            return;
        }
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ChangesViewConverter.openChangeExplorer(w.getActivePage(), new ChangeSetInput(ss, wrapped));
            }
        });
    }
}

