/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process.providers;

import com.ibm.team.filesystem.ide.ui.process.providers.AbstractLinkDetailHandler;
import com.ibm.team.filesystem.ide.ui.process.providers.AbstractLinkMemento;
import com.ibm.team.filesystem.ide.ui.process.providers.ContextType;
import com.ibm.team.filesystem.ide.ui.process.providers.ITagMemento;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.xml.sax.Attributes;

public class AbstractSourceControlLinkMemento
extends AbstractLinkMemento
implements ITagMemento {
    UUID component;
    UUID contextUuid;
    ContextType contextType;

    public AbstractSourceControlLinkMemento(AbstractLinkDetailHandler toRun) {
        super(toRun);
    }

    @Override
    public void extract(Attributes attr) {
        String ctxUuidStr;
        super.extract(attr);
        String compStr = attr.getValue("component-uuid");
        if (compStr != null) {
            this.component = UUID.valueOf((String)compStr);
        }
        if ((ctxUuidStr = attr.getValue("context-uuid")) != null) {
            this.contextUuid = UUID.valueOf((String)ctxUuidStr);
            this.contextType = this.findContextType(attr.getValue("context-type"));
        }
    }

    protected ContextType findContextType(String type) {
        if ("workspace".equals(type)) {
            return ContextType.WORKSPACE;
        }
        if ("baseline".equals(type)) {
            return ContextType.BASELINE;
        }
        throw new IllegalArgumentException("Unknown context type: " + type);
    }

    protected IWorkspaceHandle getWorkspaceHandle() {
        if (this.contextUuid == null) {
            return null;
        }
        if (this.contextType != ContextType.WORKSPACE) {
            throw new ClassCastException("Can not cast type: " + (Object)((Object)this.contextType) + " to " + (Object)((Object)ContextType.WORKSPACE));
        }
        return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(this.contextUuid, null);
    }

    public IContextHandle getContextHandle() {
        if (this.contextUuid == null) {
            return null;
        }
        if (this.contextType == ContextType.WORKSPACE) {
            return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(this.contextUuid, null);
        }
        if (this.contextType == ContextType.BASELINE) {
            return (IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle(this.contextUuid, null);
        }
        throw new IllegalArgumentException("Unknown context type: " + (Object)((Object)this.contextType));
    }

    public IComponentHandle getComponent() {
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(this.component, null);
    }
}

