/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process.providers;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.process.providers.AbstractLinkDetailHandler;
import com.ibm.team.filesystem.ide.ui.process.providers.ITagMemento;
import com.ibm.team.filesystem.ide.ui.process.providers.Messages;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.xml.sax.Attributes;

public class AbstractLinkMemento
implements ITagMemento {
    protected final StringBuffer linkText = new StringBuffer();
    protected final AbstractLinkDetailHandler toRun;
    protected UUID repoUuid;

    public AbstractLinkMemento(AbstractLinkDetailHandler toRun) {
        this.toRun = toRun;
    }

    public ITeamRepository getRepository() throws FileSystemException {
        ITeamRepository repo = null;
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository candidate = iTeamRepositoryArray[n2];
            if (candidate.root() != null && this.repoUuid.equals((Object)candidate.root().getItemId())) {
                repo = candidate;
                break;
            }
            ++n2;
        }
        if (repo == null) {
            throw new FileSystemException("Could not find repo with root" + this.repoUuid);
        }
        return repo;
    }

    protected void consume(char[] chars, int start, int length) {
        this.linkText.append(chars, start, length);
    }

    protected String getToolTipText() {
        return "";
    }

    public void extract(Attributes attr) {
        this.repoUuid = UUID.valueOf((String)attr.getValue("repository"));
    }

    public Runnable getRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                Job job = new Job(Messages.AbstractLinkMemento_GENERIC_STATUS_MESSAGE){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            (this).AbstractLinkMemento.this.toRun.linkClicked(AbstractLinkMemento.this, SubMonitor.convert((IProgressMonitor)monitor));
                        }
                        catch (FileSystemException e) {
                            StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        };
    }
}

