/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.IVersionablePermissionsReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class SimpleRemotePathResolver
implements Iterable<ComponentInfoPair> {
    private final IWorkspaceConnection wsConn;
    private final List<IComponentHandle> compHandles;
    private final List<List<IVersionableHandle>> versionables;
    private final HashSet<UUID> missingComponentUuids = new HashSet();
    private boolean fetchFullVersionable;
    private boolean fetchFullComponent;
    private Map<UUID, Map<UUID, VersionableInfo>> versionableInfos;
    private Map<UUID, IComponent> fullComponents;

    public SimpleRemotePathResolver(IWorkspaceConnection wsConn, List<IComponentHandle> comps, List<List<IVersionableHandle>> versionables) {
        this.wsConn = wsConn;
        this.compHandles = comps;
        this.versionables = versionables;
    }

    public boolean isPresentInConfiguration(IComponentHandle comp) {
        if (this.versionableInfos == null) {
            throw new IllegalStateException();
        }
        return !this.missingComponentUuids.contains(comp.getItemId());
    }

    public void setFetchFullVersionable(boolean b) {
        this.fetchFullVersionable = b;
    }

    public void setFetchFullComponent(boolean b) {
        this.fetchFullComponent = b;
    }

    public void resolve(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (String)NLS.bind((String)"Resolving remote paths in {0}", (Object)this.wsConn.getName()), (int)(this.compHandles.size() * 2 + 1));
        HashMap<UUID, Map<UUID, VersionableInfo>> infos = new HashMap<UUID, Map<UUID, VersionableInfo>>();
        if (this.fetchFullComponent) {
            List full = this.wsConn.teamRepository().itemManager().fetchCompleteItems(this.compHandles, 0, (IProgressMonitor)mon.newChild(1));
            this.fullComponents = new HashMap<UUID, IComponent>();
            for (IComponent c : full) {
                this.fullComponents.put(c.getItemId(), c);
            }
        }
        int compIndex = 0;
        while (compIndex < this.compHandles.size()) {
            block5: {
                IConfiguration compConfig;
                IComponentHandle comp = this.compHandles.get(compIndex);
                List<IVersionableHandle> vers = this.versionables.get(compIndex);
                try {
                    compConfig = this.wsConn.configuration(comp);
                }
                catch (ComponentNotInWorkspaceException e) {
                    this.missingComponentUuids.add(comp.getItemId());
                    infos.put(comp.getItemId(), this.buildMissingCompInfo(comp, vers, mon.newChild(1)));
                    break block5;
                }
                infos.put(comp.getItemId(), this.buildCompInfo(compConfig, vers, mon.newChild(1)));
            }
            ++compIndex;
        }
        this.versionableInfos = infos;
    }

    private Map<UUID, VersionableInfo> buildMissingCompInfo(IComponentHandle comp, List<? extends IVersionableHandle> vers, SubMonitor newChild) {
        HashMap<UUID, VersionableInfo> compInfo = new HashMap<UUID, VersionableInfo>();
        int verIndex = 0;
        while (verIndex < vers.size()) {
            VersionableInfo info = new VersionableInfo();
            info.ancestors = null;
            info.handle = vers.get(verIndex);
            if (this.fetchFullVersionable) {
                info.resolved = null;
                info.isResolved = false;
            }
            compInfo.put(vers.get(verIndex).getItemId(), info);
            ++verIndex;
        }
        return compInfo;
    }

    private Map<UUID, VersionableInfo> buildCompInfo(IConfiguration compConfig, List<? extends IVersionableHandle> vers, SubMonitor mon) throws TeamRepositoryException {
        IVersionablePermissionsReport[] permReports;
        mon.setWorkRemaining(3);
        HashMap<UUID, VersionableInfo> compInfo = new HashMap<UUID, VersionableInfo>(vers.size());
        HashMap<UUID, IVersionableHandle> toQueryMap = new HashMap<UUID, IVersionableHandle>(vers.size());
        for (IVersionableHandle iVersionableHandle : vers) {
            VersionableInfo info = new VersionableInfo();
            info.handle = iVersionableHandle;
            compInfo.put(iVersionableHandle.getItemId(), info);
            toQueryMap.put(iVersionableHandle.getItemId(), iVersionableHandle);
        }
        IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)compConfig.teamRepository());
        IVersionablePermissionsReport[] iVersionablePermissionsReportArray = permReports = iWorkspaceManager.getPermissions(vers.toArray(new IVersionableHandle[vers.size()]), compConfig.component(), (IProgressMonitor)mon.newChild(1));
        int n = permReports.length;
        int n2 = 0;
        while (n2 < n) {
            IVersionablePermissionsReport rpt = iVersionablePermissionsReportArray[n2];
            if (rpt.isReportOfInaccessible()) {
                for (UUID invis : rpt.getItemsIds()) {
                    toQueryMap.remove(invis);
                    ((VersionableInfo)compInfo.get(invis)).isAccessible = false;
                }
            }
            ++n2;
        }
        ArrayList toQueryList = new ArrayList(toQueryMap.values());
        List ancestors = compConfig.locateAncestors(toQueryList, (IProgressMonitor)mon.newChild(1));
        List full = null;
        if (this.fetchFullVersionable) {
            full = compConfig.fetchCompleteItems(toQueryList, (IProgressMonitor)mon.newChild(1));
        }
        int verIndex = toQueryList.size() - 1;
        while (verIndex >= 0) {
            VersionableInfo info = compInfo.get(((IVersionableHandle)toQueryList.get(verIndex)).getItemId());
            info.isAccessible = true;
            info.ancestors = (IAncestorReport)ancestors.get(verIndex);
            info.handle = vers.get(verIndex);
            if (this.fetchFullVersionable) {
                info.resolved = (IVersionable)full.get(verIndex);
                info.isResolved = info.resolved != null;
            }
            compInfo.put(vers.get(verIndex).getItemId(), info);
            --verIndex;
        }
        return compInfo;
    }

    public VersionableInfo getVersionableInfoFor(UUID compId, UUID versionableId) {
        if (this.versionableInfos == null) {
            throw new IllegalStateException();
        }
        Map<UUID, VersionableInfo> compMap = this.versionableInfos.get(compId);
        if (compMap == null) {
            throw new IllegalStateException();
        }
        VersionableInfo info = compMap.get(versionableId);
        if (info == null) {
            throw new IllegalStateException();
        }
        return info;
    }

    public IComponent getComponentFor(UUID compId) {
        if (this.fullComponents == null) {
            throw new IllegalStateException();
        }
        return this.fullComponents.get(compId);
    }

    public IComponent getComponentFor(IComponentHandle h) {
        return this.getComponentFor(h.getItemId());
    }

    public Collection<IComponentHandle> getComponents() {
        return this.compHandles;
    }

    public Collection<VersionableInfo> getInfoFor(IComponentHandle comp) {
        for (Map.Entry<UUID, Map<UUID, VersionableInfo>> entry : this.versionableInfos.entrySet()) {
            if (!entry.getKey().equals((Object)comp.getItemId())) continue;
            return entry.getValue().values();
        }
        return Collections.emptyList();
    }

    @Override
    public Iterator<ComponentInfoPair> iterator() {
        ArrayList<ComponentInfoPair> toReturn = new ArrayList<ComponentInfoPair>(this.versionableInfos.size());
        for (Map.Entry<UUID, Map<UUID, VersionableInfo>> entry : this.versionableInfos.entrySet()) {
            ComponentInfoPair pair = new ComponentInfoPair();
            pair.comp = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(entry.getKey(), null);
            pair.infos = entry.getValue().values();
            toReturn.add(pair);
        }
        return toReturn.iterator();
    }

    public class ComponentInfoPair {
        public IComponentHandle comp;
        public Collection<VersionableInfo> infos;

        public boolean isPresentInConfiguration() {
            return SimpleRemotePathResolver.this.isPresentInConfiguration(this.comp);
        }
    }

    public static class VersionableInfo {
        private boolean isAccessible = false;
        private IAncestorReport ancestors;
        private IVersionable resolved;
        private IVersionableHandle handle;
        private boolean isResolved = false;

        public boolean isAccessible() {
            return this.isAccessible;
        }

        public String getParentPath() {
            if (!this.isAccessible) {
                throw new IllegalStateException();
            }
            StringBuffer buf = new StringBuffer();
            List pairs = this.ancestors.getNameItemPairs();
            int i = 1;
            while (i < this.ancestors.getNameItemPairs().size() - 1) {
                if (buf.length() > 0) {
                    buf.append('/');
                }
                buf.append(((INameItemPair)pairs.get(i)).getName());
                ++i;
            }
            return buf.toString();
        }

        public boolean isAtComponentRoot() {
            return this.ancestors.getNameItemPairs().size() == 2;
        }

        public String getName() {
            if (!this.isAccessible) {
                throw new IllegalStateException();
            }
            List pairs = this.ancestors.getNameItemPairs();
            return ((INameItemPair)pairs.get(pairs.size() - 1)).getName();
        }

        public IVersionableHandle getHandle() {
            return this.handle;
        }

        public IVersionable getResolvedVersionable() {
            if (!this.isAccessible) {
                throw new IllegalStateException();
            }
            return this.resolved;
        }

        public boolean isResolved() {
            return this.isResolved;
        }
    }
}

