/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.ide.ui.internal.util.DisplayHelper;
import com.ibm.team.filesystem.ide.ui.process.ComponentListUIJob;
import com.ibm.team.filesystem.ide.ui.process.ComponentScopeDefinitionBlock;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.internal.IScmQueryService;
import com.ibm.team.scm.common.internal.dto.ItemQueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ScmDeferredElementListSelectionDialog
extends ListDialog {
    private static ComponentDialogEntryLabelProvider labelProvider = null;
    private Job fFetchingJob;
    private boolean fFetchingDone;
    private ViewerComparator fComparator;
    private ArrayContentProvider fContentProvider;
    private Object[] fElements;
    private final ITeamRepository repository;

    static LabelProvider getLabelProvider() {
        if (labelProvider == null) {
            labelProvider = new ComponentDialogEntryLabelProvider();
        }
        return labelProvider;
    }

    public ScmDeferredElementListSelectionDialog(ITeamRepository repository, Shell parent) {
        super(parent);
        this.repository = repository;
        this.setLabelProvider((ILabelProvider)new ComponentDialogEntryLabelProvider());
        this.fContentProvider = new ArrayContentProvider();
        this.setContentProvider((IStructuredContentProvider)this.fContentProvider);
    }

    public void setFetchingJob(Job job) {
        this.fFetchingJob = job;
    }

    public void setComparator(ViewerComparator comparator) {
        this.fComparator = comparator;
    }

    protected Control createDialogArea(Composite container) {
        Control control = super.createDialogArea(container);
        TableViewer tableViewer = this.getTableViewer();
        tableViewer.setSorter((ViewerSorter)new ComponentViewSorter());
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ScmDeferredElementListSelectionDialog.this.getOkButton().setEnabled(ScmDeferredElementListSelectionDialog.this.fFetchingDone && selection.size() == 1);
            }
        });
        if (this.fComparator != null) {
            tableViewer.setComparator(this.fComparator);
        }
        if (this.fElements != null) {
            tableViewer.setInput((Object)this.fElements);
        }
        this.startComponentJob();
        return control;
    }

    private void startComponentJob() {
        this.fFetchingJob = new ComponentListUIJob(this.repository){

            @Override
            public void doneFetching(final Collection<IComponentTableEntry> toShow) {
                DisplayHelper.asyncExec(ScmDeferredElementListSelectionDialog.this.getTableViewer().getControl(), new Runnable(){

                    @Override
                    public void run() {
                        ScmDeferredElementListSelectionDialog.this.setFetchingDone();
                        ScmDeferredElementListSelectionDialog.this.setElements(toShow.toArray());
                    }
                });
            }

            @Override
            public List<IComponentHandle> getComponentsToShow(ITeamRepository repository, SubMonitor monitor) throws TeamRepositoryException {
                IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                IScmQueryService query = (IScmQueryService)((WorkspaceManager)workspaceManager).getContext().getServiceInterface(IScmQueryService.class);
                int PAGE_SIZE = 512;
                IComponentSearchCriteria criteria = IComponentSearchCriteria.FACTORY.newInstance();
                HashMap<UUID, IComponentHandle> components = new HashMap<UUID, IComponentHandle>();
                while (true) {
                    monitor.setWorkRemaining(2);
                    ItemQueryResult r = query.findComponents(criteria, 512, (IRepositoryProgressMonitorHandle)IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)monitor.newChild(1)));
                    if (r == null || r.getItemHandles().isEmpty()) break;
                    for (Object o : r.getItemHandles()) {
                        if (!(o instanceof IComponentHandle)) continue;
                        IComponentHandle comp = (IComponentHandle)o;
                        components.put(comp.getItemId(), comp);
                    }
                    if (r.getLastTimestamp() == null) break;
                    criteria = (IComponentSearchCriteria)EcoreUtil.copy((EObject)((EObject)criteria));
                    criteria.setModifiedBeforeOptional((Date)r.getLastTimestamp());
                }
                return new ArrayList<IComponentHandle>(components.values());
            }

            @Override
            public List<String> getStringsToShow() throws TeamRepositoryException {
                return Collections.emptyList();
            }
        };
        this.fFetchingJob.setUser(false);
        this.fFetchingJob.schedule();
    }

    public boolean close() {
        this.fFetchingJob.cancel();
        return super.close();
    }

    public void setFetchingDone() {
        this.fFetchingDone = true;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
        TableViewer tableViewer = this.getTableViewer();
        if (tableViewer != null) {
            tableViewer.setInput((Object)elements);
        }
    }

    public Object getFirstResult() {
        Object[] result = this.getResult();
        if (result.length > 0) {
            return result[0];
        }
        return null;
    }

    private static class ComponentDialogEntryLabelProvider
    extends LabelProvider {
        private ResourceManager fResources;

        private ComponentDialogEntryLabelProvider() {
        }

        public String getText(Object element) {
            return ((IComponentTableEntry)element).getDisplayName();
        }

        public Image getImage(Object element) {
            if (element instanceof ComponentTableEntry) {
                ComponentTableEntry cde = (ComponentTableEntry)element;
                if (cde.isPersonal) {
                    if (cde.isLoaded) {
                        return this.getPooledImage(ImagePool.SELF_COMPONENT);
                    }
                    return this.getPooledImage(ImagePool.SELF_COMPONENT_UNLOADED);
                }
                if (cde.isLoaded) {
                    return this.getPooledImage(ImagePool.COMPONENT);
                }
                return this.getPooledImage(ImagePool.COMPONENT_UNLOADED);
            }
            if (element instanceof StringTableEntry) {
                return this.getPooledImage(ImagePool.COMPONENT);
            }
            return null;
        }

        protected final Image getPooledImage(ImageDescriptor descriptor) {
            Assert.isNotNull((Object)descriptor);
            ResourceManager res = this.getResources();
            Object existingImage = res.find((DeviceResourceDescriptor)descriptor);
            if (existingImage instanceof Image) {
                return (Image)existingImage;
            }
            return JazzResources.getImageWithDefault((ResourceManager)this.getResources(), (ImageDescriptor)descriptor);
        }

        protected final ResourceManager getResources() {
            if (this.fResources == null) {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                this.fResources = new LocalResourceManager(JFaceResources.getResources((Display)display));
            }
            return this.fResources;
        }
    }

    public static class ComponentTableEntry
    implements IComponentTableEntry {
        private final IComponent comp;
        private final String ownerName;
        final boolean isLoaded;
        final boolean isPersonal;

        public ComponentTableEntry(IComponent comp, String owner, boolean isLoaded, boolean isPersonal) {
            this.comp = comp;
            this.ownerName = owner;
            this.isLoaded = isLoaded;
            this.isPersonal = isPersonal;
        }

        @Override
        public IComponentHandle getComponent() {
            return this.comp;
        }

        @Override
        public String getLegacyName() {
            return this.comp.getName();
        }

        @Override
        public String getDisplayName() {
            return NLS.bind((String)Messages.ScmDeferredElementListSelectionDialog_COMPONENT_NAME_AND_OWNER, (Object)this.comp.getName(), (Object)this.ownerName);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.comp == null ? 0 : this.comp.getItemId().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComponentTableEntry other = (ComponentTableEntry)obj;
            return !(this.comp == null ? other.comp != null : !this.comp.getItemId().equals((Object)other.comp.getItemId()));
        }
    }

    public static class ComponentViewSorter
    extends ViewerSorter {
        public int category(Object element) {
            if (element instanceof ComponentTableEntry) {
                return 5;
            }
            if (element instanceof StringTableEntry) {
                return 10;
            }
            return 20;
        }
    }

    public static interface IComponentTableEntry
    extends ComponentScopeDefinitionBlock.IComponentMatcherEntry {
        @Override
        public IComponentHandle getComponent();

        @Override
        public String getLegacyName();

        public String getDisplayName();
    }

    public static class StringTableEntry
    implements IComponentTableEntry {
        private final String legacyName;

        public StringTableEntry(String legacyName) {
            this.legacyName = legacyName;
        }

        @Override
        public IComponentHandle getComponent() {
            return null;
        }

        @Override
        public String getLegacyName() {
            return this.legacyName;
        }

        @Override
        public String getDisplayName() {
            return this.legacyName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.legacyName == null ? 0 : this.legacyName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringTableEntry other = (StringTableEntry)obj;
            return !(this.legacyName == null ? other.legacyName != null : !this.legacyName.equals(other.legacyName));
        }
    }
}

