/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.client.internal.operations.ChangePropertiesOperation;
import com.ibm.team.filesystem.common.internal.process.config.ComponentScopedAdvisorConfig;
import com.ibm.team.filesystem.common.internal.process.config.RestrictMimeTypeEncodingAdvisorConfig;
import com.ibm.team.filesystem.ide.ui.internal.util.DisplayHelper;
import com.ibm.team.filesystem.ide.ui.process.ComponentScopedAdvisorAspectEditor;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RestrictMimeTypeAndEncodingAdvisorAspectEditor
extends ComponentScopedAdvisorAspectEditor {
    private TableViewer fMimeTypeTableViewer;
    private Button fIncludeMimeTypeCheckBox;
    private TableViewer fEncodingTableViewer;
    private Button fIncludeEncodingCheckBox;

    @Override
    protected Class<? extends ComponentScopedAdvisorConfig> getConfigClass() {
        return RestrictMimeTypeEncodingAdvisorConfig.class;
    }

    private RestrictMimeTypeEncodingAdvisorConfig getMimeTypeEncodingConfig() {
        return (RestrictMimeTypeEncodingAdvisorConfig)this.getConfig();
    }

    @Override
    public boolean saveState(IMemento memento) {
        List mimeTypes = (List)this.fMimeTypeTableViewer.getInput();
        this.getMimeTypeEncodingConfig().setMimeTypes(mimeTypes);
        List encodings = (List)this.fEncodingTableViewer.getInput();
        this.getMimeTypeEncodingConfig().setEncodings(encodings);
        return super.saveState(memento);
    }

    @Override
    protected boolean validateState() {
        List mimeTypeList = (List)this.fMimeTypeTableViewer.getInput();
        List encodingList = (List)this.fEncodingTableViewer.getInput();
        if (this.getMimeTypeEncodingConfig().isIncludeMimeTypes() && mimeTypeList.isEmpty()) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_29, (String)Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_30);
            this.getMimeTypeEncodingConfig().setIncludeMimeTypes(false);
            this.fIncludeMimeTypeCheckBox.setSelection(false);
            this.fIncludeMimeTypeCheckBox.notifyListeners(13, new Event());
        }
        if (this.getMimeTypeEncodingConfig().isIncludeEncodings() && encodingList.isEmpty()) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_29, (String)Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_31);
            this.getMimeTypeEncodingConfig().setIncludeEncodings(false);
            this.fIncludeEncodingCheckBox.setSelection(false);
            this.fIncludeEncodingCheckBox.notifyListeners(13, new Event());
        }
        return true;
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        super.createControl(parent, toolkit);
        this.createMimeTypeControl(parent, toolkit, (ProcessAspectEditor)this);
        this.createEncodingControl(parent, toolkit, (ProcessAspectEditor)this);
    }

    public void createMimeTypeControl(Composite parent, FormToolkit toolkit, final ProcessAspectEditor editor) {
        Composite mimeTypeBlockComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)mimeTypeBlockComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(mimeTypeBlockComposite);
        this.fIncludeMimeTypeCheckBox = toolkit.createButton(mimeTypeBlockComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_7, 32);
        GridDataFactory.fillDefaults().align(16384, 128).grab(true, false).applyTo((Control)this.fIncludeMimeTypeCheckBox);
        Composite mimeComposite = toolkit.createComposite(mimeTypeBlockComposite);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).indent(20, 0).applyTo((Control)mimeComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(mimeComposite);
        final Button allowMimeTypeRadioButton = toolkit.createButton(mimeComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_8, 16);
        GridDataFactory.fillDefaults().align(16384, 128).grab(true, false).applyTo((Control)allowMimeTypeRadioButton);
        allowMimeTypeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.setDirty();
                RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.getMimeTypeEncodingConfig().setAllowMimeTypes(allowMimeTypeRadioButton.getSelection());
            }
        });
        final Button restrictMimeTypeRadioButton = toolkit.createButton(mimeComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_9, 16);
        GridDataFactory.fillDefaults().align(16384, 128).grab(true, false).applyTo((Control)restrictMimeTypeRadioButton);
        restrictMimeTypeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.setDirty();
                RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.getMimeTypeEncodingConfig().setAllowMimeTypes(!restrictMimeTypeRadioButton.getSelection());
            }
        });
        if (!allowMimeTypeRadioButton.getSelection() && !restrictMimeTypeRadioButton.getSelection()) {
            allowMimeTypeRadioButton.setSelection(true);
        }
        Composite mimeTypeComposite = toolkit.createComposite(mimeComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(2).applyTo(mimeTypeComposite);
        GridDataFactory.fillDefaults().align(16384, 128).indent(15, 0).grab(true, true).applyTo((Control)mimeTypeComposite);
        this.fMimeTypeTableViewer = new TableViewer(mimeTypeComposite, 2818);
        toolkit.adapt((Control)this.fMimeTypeTableViewer.getTable(), true, true);
        this.fMimeTypeTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fMimeTypeTableViewer.setInput(new ArrayList());
        this.fMimeTypeTableViewer.setComparator(new ViewerComparator());
        int k = this.fMimeTypeTableViewer.getTable().getItemHeight() * 2;
        k = this.fMimeTypeTableViewer.getTable().computeTrim((int)0, (int)0, (int)500, (int)k).height;
        GridDataFactory.fillDefaults().grab(true, true).hint(300, k).applyTo((Control)this.fMimeTypeTableViewer.getTable());
        Composite mimeTypeButtonComposite = toolkit.createComposite(mimeTypeComposite);
        GridDataFactory.fillDefaults().align(131072, 128).grab(false, true).applyTo((Control)mimeTypeButtonComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(mimeTypeButtonComposite);
        Button addMimeTypeButton = toolkit.createButton(mimeTypeButtonComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_10, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)addMimeTypeButton);
        addMimeTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.addMimeType()) {
                    editor.setDirty();
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fMimeTypeTableViewer.refresh();
                }
            }
        });
        final Button editMimeTypeButton = toolkit.createButton(mimeTypeButtonComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_11, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)editMimeTypeButton);
        editMimeTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.editMimeType()) {
                    editor.setDirty();
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fMimeTypeTableViewer.refresh();
                }
            }
        });
        final Button removeMimeTypeButton = toolkit.createButton(mimeTypeButtonComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_12, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)removeMimeTypeButton);
        removeMimeTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.removeMimeType()) {
                    editor.setDirty();
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fMimeTypeTableViewer.refresh();
                }
            }
        });
        removeMimeTypeButton.setEnabled(false);
        editMimeTypeButton.setEnabled(false);
        this.fMimeTypeTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fMimeTypeTableViewer.getSelection();
                removeMimeTypeButton.setEnabled(selection != null && !selection.isEmpty());
                editMimeTypeButton.setEnabled(selection != null && selection.size() == 1);
            }
        });
        final Control[] controls = new Control[]{this.fMimeTypeTableViewer.getTable(), allowMimeTypeRadioButton, restrictMimeTypeRadioButton, addMimeTypeButton, editMimeTypeButton, removeMimeTypeButton};
        DisplayHelper.asyncExec((Control)this.fIncludeMimeTypeCheckBox, new Runnable(){

            @Override
            public void run() {
                if (!RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fIncludeMimeTypeCheckBox.isDisposed()) {
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.setEnablementFor(controls, RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fIncludeMimeTypeCheckBox.getSelection());
                    if (RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.getMimeTypeEncodingConfig().isIncludeMimeTypes()) {
                        editMimeTypeButton.setEnabled(false);
                        removeMimeTypeButton.setEnabled(false);
                    }
                }
            }
        });
        this.fIncludeMimeTypeCheckBox.setSelection(this.getMimeTypeEncodingConfig().isIncludeMimeTypes());
        if (this.getMimeTypeEncodingConfig().isIncludeMimeTypes()) {
            allowMimeTypeRadioButton.setSelection(this.getMimeTypeEncodingConfig().isAllowMimeTypes());
            restrictMimeTypeRadioButton.setSelection(!this.getMimeTypeEncodingConfig().isAllowMimeTypes());
        }
        this.fIncludeMimeTypeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.setEnablementFor(controls, RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fIncludeMimeTypeCheckBox.getSelection());
                editor.setDirty();
                if (RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fIncludeMimeTypeCheckBox.getSelection()) {
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.getMimeTypeEncodingConfig().setIncludeMimeTypes(true);
                    if (RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fMimeTypeTableViewer.getSelection().isEmpty()) {
                        editMimeTypeButton.setEnabled(false);
                        removeMimeTypeButton.setEnabled(false);
                    }
                } else {
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.getMimeTypeEncodingConfig().setIncludeMimeTypes(false);
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fMimeTypeTableViewer.getTable().setSelection(-1);
                }
            }
        });
        this.populateMimeTypes(editor);
        this.fMimeTypeTableViewer.refresh();
    }

    private void populateMimeTypes(ProcessAspectEditor editor) {
        List mimeTypes = (List)this.fMimeTypeTableViewer.getInput();
        mimeTypes.clear();
        mimeTypes.addAll(this.getMimeTypeEncodingConfig().getMimeTypes());
        DisplayHelper.asyncExec((Control)this.fMimeTypeTableViewer.getTable(), new Runnable(){

            @Override
            public void run() {
                if (!RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fMimeTypeTableViewer.getTable().isDisposed()) {
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fMimeTypeTableViewer.refresh();
                }
            }
        });
    }

    private boolean addMimeType() {
        InputDialog addMimeTypeDialog = new InputDialog(this.fMimeTypeTableViewer.getControl().getShell(), Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_19, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_20, "", (IInputValidator)new MimeTypeSyntaxValidator());
        if (addMimeTypeDialog.open() != 0) {
            return false;
        }
        String newMimeType = addMimeTypeDialog.getValue().trim();
        List mimeTypes = (List)this.fMimeTypeTableViewer.getInput();
        for (String mimeType : mimeTypes) {
            if (!newMimeType.equalsIgnoreCase(mimeType)) continue;
            return false;
        }
        mimeTypes.add(newMimeType);
        return true;
    }

    private boolean editMimeType() {
        IStructuredSelection selection = (IStructuredSelection)this.fMimeTypeTableViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        String mimeTypeToEdit = (String)selection.getFirstElement();
        InputDialog editMimeTypeDialog = new InputDialog(this.fMimeTypeTableViewer.getControl().getShell(), Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_21, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_22, mimeTypeToEdit, (IInputValidator)new MimeTypeSyntaxValidator(mimeTypeToEdit));
        if (editMimeTypeDialog.open() != 0) {
            return false;
        }
        String editedMimeType = editMimeTypeDialog.getValue().trim();
        List mimeTypes = (List)this.fMimeTypeTableViewer.getInput();
        Iterator iterator = mimeTypes.iterator();
        while (iterator.hasNext()) {
            String existingMimeType = (String)iterator.next();
            if (existingMimeType.equalsIgnoreCase(mimeTypeToEdit)) {
                iterator.remove();
                continue;
            }
            if (!existingMimeType.equalsIgnoreCase(editedMimeType)) continue;
            iterator.remove();
        }
        mimeTypes.add(editedMimeType);
        return true;
    }

    private boolean removeMimeType() {
        List mimeTypes = (List)this.fMimeTypeTableViewer.getInput();
        IStructuredSelection selection = (IStructuredSelection)this.fMimeTypeTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = selection;
            return mimeTypes.removeAll(ss.toList());
        }
        return false;
    }

    public void createEncodingControl(Composite parent, FormToolkit toolkit, final ProcessAspectEditor editor) {
        Composite encodingBlockComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)encodingBlockComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).margins(0, 30).numColumns(1).applyTo(encodingBlockComposite);
        this.fIncludeEncodingCheckBox = toolkit.createButton(encodingBlockComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_13, 32);
        GridDataFactory.fillDefaults().align(16384, 128).grab(true, false).applyTo((Control)this.fIncludeEncodingCheckBox);
        Composite encodingComposite = toolkit.createComposite(encodingBlockComposite);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).indent(20, 0).applyTo((Control)encodingComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(encodingComposite);
        final Button allowEncodingRadioButton = toolkit.createButton(encodingComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_14, 16);
        GridDataFactory.fillDefaults().align(16384, 128).grab(true, false).applyTo((Control)allowEncodingRadioButton);
        allowEncodingRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.getMimeTypeEncodingConfig().setAllowEncodings(allowEncodingRadioButton.getSelection());
                editor.setDirty();
            }
        });
        final Button restrictEncodingRadioButton = toolkit.createButton(encodingComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_15, 16);
        GridDataFactory.fillDefaults().align(16384, 128).grab(true, false).applyTo((Control)restrictEncodingRadioButton);
        restrictEncodingRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.getMimeTypeEncodingConfig().setAllowEncodings(!restrictEncodingRadioButton.getSelection());
                editor.setDirty();
            }
        });
        if (!allowEncodingRadioButton.getSelection() && !restrictEncodingRadioButton.getSelection()) {
            allowEncodingRadioButton.setSelection(true);
        }
        Composite encodeComposite = toolkit.createComposite(encodingComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(2).applyTo(encodeComposite);
        GridDataFactory.fillDefaults().align(16384, 128).indent(15, 0).grab(true, true).applyTo((Control)encodeComposite);
        this.fEncodingTableViewer = new TableViewer(encodeComposite, 2818);
        toolkit.adapt((Control)this.fEncodingTableViewer.getTable(), true, true);
        this.fEncodingTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fEncodingTableViewer.setInput(new ArrayList());
        this.fEncodingTableViewer.setComparator(new ViewerComparator());
        int k = this.fEncodingTableViewer.getTable().getItemHeight() * 2;
        k = this.fEncodingTableViewer.getTable().computeTrim((int)0, (int)0, (int)500, (int)k).height;
        GridDataFactory.fillDefaults().grab(true, true).hint(300, k).applyTo((Control)this.fEncodingTableViewer.getTable());
        Composite encodingButtonComposite = toolkit.createComposite(encodeComposite);
        GridDataFactory.fillDefaults().align(131072, 128).grab(false, true).applyTo((Control)encodingButtonComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(encodingButtonComposite);
        Button addEncodingButton = toolkit.createButton(encodingButtonComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_16, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)addEncodingButton);
        addEncodingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.addEncoding()) {
                    editor.setDirty();
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fEncodingTableViewer.refresh();
                }
            }
        });
        final Button editEncodingButton = toolkit.createButton(encodingButtonComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_17, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)editEncodingButton);
        editEncodingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.editEncoding()) {
                    editor.setDirty();
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fEncodingTableViewer.refresh();
                }
            }
        });
        final Button removeEncodingButton = toolkit.createButton(encodingButtonComposite, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_18, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)removeEncodingButton);
        removeEncodingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.removeEncoding()) {
                    editor.setDirty();
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fEncodingTableViewer.refresh();
                }
            }
        });
        editEncodingButton.setEnabled(false);
        removeEncodingButton.setEnabled(false);
        this.fEncodingTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fEncodingTableViewer.getSelection();
                editEncodingButton.setEnabled(selection != null && selection.size() == 1);
                removeEncodingButton.setEnabled(selection != null && !selection.isEmpty());
            }
        });
        final Control[] controls = new Control[]{this.fEncodingTableViewer.getTable(), allowEncodingRadioButton, restrictEncodingRadioButton, addEncodingButton, editEncodingButton, removeEncodingButton};
        DisplayHelper.asyncExec((Control)this.fIncludeEncodingCheckBox, new Runnable(){

            @Override
            public void run() {
                if (!RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fIncludeEncodingCheckBox.isDisposed()) {
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.setEnablementFor(controls, RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fIncludeEncodingCheckBox.getSelection());
                }
            }
        });
        this.fIncludeEncodingCheckBox.setSelection(this.getMimeTypeEncodingConfig().isIncludeEncodings());
        if (this.getMimeTypeEncodingConfig().isIncludeEncodings()) {
            allowEncodingRadioButton.setSelection(this.getMimeTypeEncodingConfig().isAllowEncodings());
            restrictEncodingRadioButton.setSelection(!this.getMimeTypeEncodingConfig().isAllowEncodings());
        }
        this.fIncludeEncodingCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.setEnablementFor(controls, RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fIncludeEncodingCheckBox.getSelection());
                editor.setDirty();
                if (RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fIncludeEncodingCheckBox.getSelection()) {
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.getMimeTypeEncodingConfig().setIncludeEncodings(true);
                    if (RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fEncodingTableViewer.getSelection().isEmpty()) {
                        editEncodingButton.setEnabled(false);
                        removeEncodingButton.setEnabled(false);
                    }
                } else {
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.getMimeTypeEncodingConfig().setIncludeEncodings(false);
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fEncodingTableViewer.getTable().setSelection(-1);
                }
            }
        });
        this.populateEncodings(editor);
        this.fEncodingTableViewer.refresh();
    }

    private void populateEncodings(ProcessAspectEditor editor) {
        List encodings = (List)this.fEncodingTableViewer.getInput();
        encodings.clear();
        encodings.addAll(this.getMimeTypeEncodingConfig().getEncodings());
        DisplayHelper.asyncExec((Control)this.fEncodingTableViewer.getTable(), new Runnable(){

            @Override
            public void run() {
                if (!RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fEncodingTableViewer.getTable().isDisposed()) {
                    RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fEncodingTableViewer.refresh();
                }
            }
        });
    }

    private boolean addEncoding() {
        InputDialog addEncodingDialog = new InputDialog(this.fMimeTypeTableViewer.getControl().getShell(), Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_23, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_24, "", new IInputValidator(){

            public String isValid(String newEncoding) {
                if (newEncoding == null || newEncoding.trim().isEmpty()) {
                    return "";
                }
                Object encodingInput = RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fEncodingTableViewer.getInput();
                if (encodingInput instanceof List) {
                    for (Object o : (List)encodingInput) {
                        String existingEncoding;
                        if (!(o instanceof String) || !(existingEncoding = (String)o).equalsIgnoreCase(newEncoding)) continue;
                        return Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_EncodingAlreadyExistsMessage;
                    }
                }
                return null;
            }
        });
        if (addEncodingDialog.open() != 0) {
            return false;
        }
        String newEncoding = addEncodingDialog.getValue().trim();
        List encodings = (List)this.fEncodingTableViewer.getInput();
        for (String encoding : encodings) {
            if (!newEncoding.equalsIgnoreCase(encoding)) continue;
            return false;
        }
        encodings.add(newEncoding);
        return true;
    }

    private boolean editEncoding() {
        IStructuredSelection selection = (IStructuredSelection)this.fEncodingTableViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        final String encodingToEdit = (String)selection.getFirstElement();
        InputDialog editEncodingDialog = new InputDialog(this.fEncodingTableViewer.getControl().getShell(), Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_25, Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_26, encodingToEdit, new IInputValidator(){

            public String isValid(String newEncoding) {
                if (newEncoding == null || newEncoding.trim().isEmpty()) {
                    return "";
                }
                Object encodingInput = RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fEncodingTableViewer.getInput();
                if (encodingInput instanceof List) {
                    for (Object o : (List)encodingInput) {
                        String existingEncoding;
                        if (!(o instanceof String) || !(existingEncoding = (String)o).equalsIgnoreCase(newEncoding.trim()) || newEncoding.trim().equalsIgnoreCase(encodingToEdit)) continue;
                        return Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_EncodingAlreadyExistsMessage;
                    }
                }
                return null;
            }
        });
        if (editEncodingDialog.open() != 0) {
            return false;
        }
        String editedEncoding = editEncodingDialog.getValue().trim();
        List encodings = (List)this.fEncodingTableViewer.getInput();
        Iterator iterator = encodings.iterator();
        while (iterator.hasNext()) {
            String existingEncoding = (String)iterator.next();
            if (existingEncoding.equalsIgnoreCase(encodingToEdit)) {
                iterator.remove();
                continue;
            }
            if (!existingEncoding.equalsIgnoreCase(editedEncoding)) continue;
            iterator.remove();
        }
        encodings.add(editedEncoding);
        return true;
    }

    private boolean removeEncoding() {
        List encodings = (List)this.fEncodingTableViewer.getInput();
        IStructuredSelection selection = (IStructuredSelection)this.fEncodingTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = selection;
            return encodings.removeAll(ss.toList());
        }
        return false;
    }

    private void setEnablementFor(Control[] widgets, boolean enabled) {
        Control[] controlArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Control w = controlArray[n2];
            w.setEnabled(enabled);
            ++n2;
        }
    }

    public class MimeTypeSyntaxValidator
    implements IInputValidator {
        private String fMimeTypeBeingEdited;

        public MimeTypeSyntaxValidator() {
        }

        public MimeTypeSyntaxValidator(String typeAllowedToExist) {
            this.fMimeTypeBeingEdited = typeAllowedToExist;
        }

        public String isValid(String newMimeType) {
            if (newMimeType == null || newMimeType.trim().isEmpty()) {
                return "";
            }
            if (!ChangePropertiesOperation.validMimeType((String)newMimeType)) {
                return Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_27;
            }
            Object mimeTypeInput = RestrictMimeTypeAndEncodingAdvisorAspectEditor.this.fMimeTypeTableViewer.getInput();
            if (mimeTypeInput instanceof List) {
                for (Object o : (List)mimeTypeInput) {
                    String existingMimeType;
                    if (!(o instanceof String) || !(existingMimeType = (String)o).equalsIgnoreCase(newMimeType.trim()) || newMimeType.trim().equalsIgnoreCase(this.fMimeTypeBeingEdited)) continue;
                    return Messages.RestrictMimeTypeAndEncodingAdvisorAspectEditor_MimeTypeAlreadyExistsMessage;
                }
            }
            return null;
        }
    }
}

