/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.common.internal.process.config.ComponentScopedAdvisorConfig;
import com.ibm.team.filesystem.common.internal.process.config.RestrictFileSizeAdvisorConfig;
import com.ibm.team.filesystem.ide.ui.process.ComponentScopedAdvisorAspectEditor;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RestrictFileSizeCheckinAdvisorAspectEditor
extends ComponentScopedAdvisorAspectEditor {
    public static int calculateSizeForDigits(Text testWidget, int digits) {
        GC gc = new GC((Drawable)testWidget);
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        int width = fm.getAverageCharWidth() * digits;
        return width;
    }

    @Override
    protected boolean validateState() {
        if (this.getFileSizeConfig().fileSizeLimit <= 0) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.RestrictFileSizeCheckinAdvisorAspectEditor_VALIDATE_WARNING, (String)Messages.RestrictFileSizeCheckinAdvisorAspectEditor_INVALID_SIZE);
            return false;
        }
        return true;
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        super.createControl(parent, toolkit);
        Composite fileSizeComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(fileSizeComposite);
        Label fileSizeLimitLabel = toolkit.createLabel(fileSizeComposite, Messages.RestrictFileSizeCheckinAdvisorAspectEditor_LABEL_MAX_FILE_SIZE);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).span(1, 1).applyTo((Control)fileSizeLimitLabel);
        final Text fileSizeLimit = toolkit.createText(fileSizeComposite, "", 2308);
        int width = RestrictFileSizeCheckinAdvisorAspectEditor.calculateSizeForDigits(fileSizeLimit, 9);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).hint(width, -1).span(2, 1).applyTo((Control)fileSizeLimit);
        fileSizeLimit.addVerifyListener((VerifyListener)new PositiveIntegerVerifyListener());
        fileSizeLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = fileSizeLimit.getText();
                if (text.length() > 0 && !Integer.toString(((RestrictFileSizeCheckinAdvisorAspectEditor)RestrictFileSizeCheckinAdvisorAspectEditor.this).getFileSizeConfig().fileSizeLimit).equalsIgnoreCase(text)) {
                    ((RestrictFileSizeCheckinAdvisorAspectEditor)RestrictFileSizeCheckinAdvisorAspectEditor.this).getFileSizeConfig().fileSizeLimit = Integer.parseInt(text);
                    RestrictFileSizeCheckinAdvisorAspectEditor.this.setDirty(true);
                }
            }
        });
        fileSizeLimit.setText(String.valueOf(this.getFileSizeConfig().fileSizeLimit));
        Label labelMB = toolkit.createLabel(fileSizeComposite, Messages.RestrictFileSizeCheckinAdvisorAspectEditor_LABEL_MB, 0x1000000);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).span(1, 1).applyTo((Control)labelMB);
    }

    @Override
    protected Class<? extends ComponentScopedAdvisorConfig> getConfigClass() {
        return RestrictFileSizeAdvisorConfig.class;
    }

    private RestrictFileSizeAdvisorConfig getFileSizeConfig() {
        return (RestrictFileSizeAdvisorConfig)this.getConfig();
    }

    public static final class PositiveIntegerVerifyListener
    implements VerifyListener {
        public void verifyText(VerifyEvent e) {
            e.doit = true;
            String oldTextValue = ((Text)e.widget).getText();
            String newTextValue = String.valueOf(oldTextValue.substring(0, e.start)) + e.text + oldTextValue.substring(e.end);
            if (newTextValue.length() > 9) {
                e.doit = false;
                return;
            }
            if (!newTextValue.isEmpty()) {
                int newValue;
                try {
                    newValue = Integer.parseInt(newTextValue);
                }
                catch (NumberFormatException ex) {
                    e.doit = false;
                    return;
                }
                if (newValue <= 0) {
                    e.doit = false;
                    return;
                }
                if (newTextValue.startsWith("0")) {
                    e.doit = false;
                    return;
                }
            }
        }
    }
}

