/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.common.internal.process.config.ComponentScopedAdvisorConfig;
import com.ibm.team.filesystem.common.internal.process.config.RestrictChangeSetSizeAdvisorConfig;
import com.ibm.team.filesystem.ide.ui.process.ComponentScopedAdvisorAspectEditor;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.ide.ui.process.RestrictFileSizeCheckinAdvisorAspectEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RestrictChangeSetSizeCheckinAdvisorAspectEditor
extends ComponentScopedAdvisorAspectEditor {
    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        super.createControl(parent, toolkit);
        Composite changeSetSizeComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(changeSetSizeComposite);
        Label changeSetSizeLimitLabel = toolkit.createLabel(changeSetSizeComposite, Messages.RestrictChangeSetSinceCheckinAdvisorAspectEditor_0);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).span(1, 1).applyTo((Control)changeSetSizeLimitLabel);
        final Text changeSetSizeLimit = toolkit.createText(changeSetSizeComposite, "", 2308);
        int width = RestrictFileSizeCheckinAdvisorAspectEditor.calculateSizeForDigits(changeSetSizeLimit, 9);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).hint(width, -1).span(2, 1).applyTo((Control)changeSetSizeLimit);
        changeSetSizeLimit.addVerifyListener((VerifyListener)new RestrictFileSizeCheckinAdvisorAspectEditor.PositiveIntegerVerifyListener());
        changeSetSizeLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = changeSetSizeLimit.getText();
                if (text.length() > 0 && !Integer.toString(((RestrictChangeSetSizeCheckinAdvisorAspectEditor)RestrictChangeSetSizeCheckinAdvisorAspectEditor.this).getChangeSetSizeConfig().changeSetSizeLimit).equalsIgnoreCase(text)) {
                    ((RestrictChangeSetSizeCheckinAdvisorAspectEditor)RestrictChangeSetSizeCheckinAdvisorAspectEditor.this).getChangeSetSizeConfig().changeSetSizeLimit = Integer.parseInt(text);
                    RestrictChangeSetSizeCheckinAdvisorAspectEditor.this.setDirty(true);
                }
            }
        });
        int initialChangeSetSizeLimit = this.getChangeSetSizeConfig().changeSetSizeLimit;
        changeSetSizeLimit.setText(String.valueOf(initialChangeSetSizeLimit));
    }

    @Override
    protected boolean validateState() {
        int size = this.getChangeSetSizeConfig().changeSetSizeLimit;
        if (Integer.signum(size) <= 0) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.RestrictFileSizeCheckinAdvisorAspectEditor_VALIDATE_WARNING, (String)Messages.RestrictChangeSetSinceCheckinAdvisorAspectEditor_1);
            return false;
        }
        return true;
    }

    @Override
    protected Class<? extends ComponentScopedAdvisorConfig> getConfigClass() {
        return RestrictChangeSetSizeAdvisorConfig.class;
    }

    private RestrictChangeSetSizeAdvisorConfig getChangeSetSizeConfig() {
        return (RestrictChangeSetSizeAdvisorConfig)this.getConfig();
    }
}

