/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ide.ui.process.AbstractFileAdvisorDetailProvider;
import com.ibm.team.filesystem.ide.ui.process.AbstractSourceControlAdvisorDetailProvider;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RequiredContentDetailProvider
extends AbstractFileAdvisorDetailProvider {
    private static final int MAX_FILES_TO_SHOW = 10;
    public static final String DATA_TAG_FILE = "file";
    public static final String DATA_ATTR_FILE_ITEMID = "fileItemId";
    public static final String DATA_ATTR_FILE_NAME = "fileName";
    public static final String DATA_ATTR_COMPONENT_ITEMID = "componentItemId";
    public static final String DATA_ATTR_WORKSPACE_ITEMID = "workspaceItemId";

    public RequiredContentDetailProvider(IAdvisorInfo info) {
        super(info);
    }

    public boolean requiresLongOp() {
        return true;
    }

    @Override
    protected void appendProblem(IAdvisorInfo info, StringBuffer buffer, IProgressMonitor progress) {
        ProblemDescription desc;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        try {
            desc = RequiredContentDetailProvider.getFiles(info, (IProgressMonitor)monitor.newChild(1));
        }
        catch (ParseException e) {
            buffer.append(e.complaint);
            return;
        }
        if (desc.blHandle != null) {
            monitor.setWorkRemaining(3);
            buffer.append(Messages.RequiredContentDetailProvider_BAD_BASELINE_CONTENT);
            ITeamRepository repo = RequiredContentDetailProvider.getTeamRepository(desc.repoRoot);
            if (repo == null || desc.unresolvableFiles == null || desc.unresolvableFiles.isEmpty()) {
                return;
            }
            try {
                this.appendBaselineFiles(buffer, desc, repo, monitor);
            }
            catch (TeamRepositoryException e) {
                LoggingHelper.log((IStatus)FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.RequiredContentDetailProvider_EXCEPTION_MESSAGE, (Throwable)e));
            }
            return;
        }
        assert (desc.wsHandle != null);
        Collections.sort(desc.localFiles, new Comparator<IFile>(){

            @Override
            public int compare(IFile arg0, IFile arg1) {
                if (arg0 instanceof IFile && arg1 instanceof IFile) {
                    Collator collator = Collator.getInstance();
                    return collator.compare(arg0.getName(), arg1.getName());
                }
                return 0;
            }
        });
        int numFiles = desc.localFiles.size();
        if (numFiles > 0) {
            if (numFiles == 1) {
                buffer.append(Messages.RequiredContentDetailProvider_0);
            } else {
                buffer.append(NLS.bind((String)Messages.RequiredContentDetailProvider_1, (Object)numFiles));
            }
            int i = 0;
            while (i < desc.localFiles.size() && i < 10) {
                IFile file = desc.localFiles.get(i);
                this.appendListItemPrefix(buffer);
                this.appendFileLink(buffer, file);
                ++i;
            }
            if (numFiles > 10) {
                this.appendListItemPrefix(buffer);
                this.appendHyperlink(NLS.bind((String)Messages.RequiredContentDetailProvider_2, (Object)(numFiles - 10)), Messages.RequiredContentDetailProvider_3, buffer, new Runnable(){

                    @Override
                    public void run() {
                        RequiredContentDetailProvider.this.showAllFiles(desc.localFiles);
                    }
                });
            }
        }
    }

    private void appendBaselineFiles(StringBuffer buffer, ProblemDescription desc, ITeamRepository repo, SubMonitor monitor) throws TeamRepositoryException {
        IBaseline bl = (IBaseline)repo.itemManager().fetchCompleteItem((IItemHandle)desc.blHandle, 0, (IProgressMonitor)monitor.newChild(1));
        IBaselineConnection conn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(bl, (IProgressMonitor)monitor.newChild(1));
        ArrayList<IFileItemHandle> fileHandles = new ArrayList<IFileItemHandle>(desc.unresolvableFiles.size());
        int i = 0;
        for (String uuid : desc.unresolvableFiles) {
            if (i++ > 10) break;
            fileHandles.add((IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null));
        }
        List ancestors = conn.configuration().determineAncestorsInHistory(fileHandles, (IProgressMonitor)monitor.newChild(1));
        for (IAncestorReport report : ancestors) {
            StringBuffer nameBuf = new StringBuffer();
            for (INameItemPair segment : report.getNameItemPairs()) {
                String name = segment.getName();
                if (name == null) continue;
                nameBuf.append("/");
                nameBuf.append(name);
            }
            this.appendListItemPrefix(buffer);
            buffer.append(nameBuf);
        }
    }

    private void appendListItemPrefix(StringBuffer buffer) {
        buffer.append("<br>&nbsp;&nbsp;");
    }

    public static ProblemDescription getFiles(IAdvisorInfo info, IProgressMonitor monitor) throws ParseException {
        IWorkspaceHandle wsHandle;
        IBaselineHandle blHandle;
        UUID repoRoot;
        ArrayList<String> unresolved;
        ArrayList<IFile> resolved;
        block9: {
            String wsId;
            Element dataElement;
            block10: {
                block8: {
                    resolved = new ArrayList();
                    unresolved = null;
                    Object problemObject = info.getProblemObject();
                    if (!(problemObject instanceof List)) break block8;
                    resolved = (List)problemObject;
                    repoRoot = null;
                    blHandle = null;
                    wsHandle = null;
                    break block9;
                }
                dataElement = AbstractSourceControlAdvisorDetailProvider.getDataElement(info.getData());
                if (dataElement == null) {
                    throw new ParseException(Messages.RequiredContentDetailProvider_ERROR_INVALID_DATA_FIELD);
                }
                String repoStr = dataElement.getAttribute("repositoryRoot");
                if ("".equals(repoStr)) {
                    throw new ParseException(Messages.RequiredContentDetailProvider_ERROR_INVALID_DATA_FIELD);
                }
                repoRoot = UUID.valueOf((String)repoStr);
                wsId = dataElement.getAttribute("sourceWorkspaceId");
                if (!"".equals(wsId)) break block10;
                wsHandle = null;
                String blUuid = dataElement.getAttribute("sourceBaselineId");
                blHandle = (IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle(UUID.valueOf((String)blUuid), null);
                NodeList fileElements = dataElement.getElementsByTagName(DATA_TAG_FILE);
                unresolved = new ArrayList<String>(fileElements.getLength());
                int i = 0;
                while (i < fileElements.getLength()) {
                    String fileId = ((Element)fileElements.item(i)).getAttribute(DATA_ATTR_FILE_ITEMID);
                    unresolved.add(fileId);
                    ++i;
                }
                break block9;
            }
            blHandle = null;
            repoRoot = null;
            wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)wsId), null);
            IComponentHandle componentHandle = null;
            String compId = dataElement.getAttribute(DATA_ATTR_COMPONENT_ITEMID);
            if ("".equals(compId)) {
                throw new ParseException(Messages.RequiredContentDetailProvider_ERROR_MISSING_COMPONENT_ID);
            }
            componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)compId), null);
            if (dataElement == null) break block9;
            NodeList fileElements = dataElement.getElementsByTagName(DATA_TAG_FILE);
            int i = 0;
            while (i < fileElements.getLength()) {
                Element fileElement = (Element)fileElements.item(i);
                UUID fileItemId = UUID.valueOf((String)fileElement.getAttribute(DATA_ATTR_FILE_ITEMID));
                IFileItemHandle fileItemHandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(fileItemId, null);
                ISharingManager sharingManager = FileSystemCore.getSharingManager();
                try {
                    Collection shareables = sharingManager.findShareables((IContextHandle)wsHandle, componentHandle, (IVersionableHandle)fileItemHandle, monitor);
                    for (IShareable shareable : shareables) {
                        IFile file = (IFile)shareable.getAdapter(IFile.class);
                        if (file == null) continue;
                        resolved.add(file);
                    }
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
                ++i;
            }
        }
        return new ProblemDescription(repoRoot, blHandle, wsHandle, resolved, unresolved);
    }

    private static ITeamRepository getTeamRepository(UUID rootId) {
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo = iTeamRepositoryArray[n2];
            if (rootId.equals((Object)repo.root().getItemId())) {
                return repo;
            }
            ++n2;
        }
        return null;
    }

    protected static class ParseException
    extends Exception {
        final String complaint;

        public ParseException(String complaint) {
            this.complaint = complaint;
        }
    }

    protected static class ProblemDescription {
        final UUID repoRoot;
        final IBaselineHandle blHandle;
        final IWorkspaceHandle wsHandle;
        final List<IFile> localFiles;
        final List<String> unresolvableFiles;

        public ProblemDescription(UUID repoRoot, IBaselineHandle blHandle, IWorkspaceHandle wsHandle, List<IFile> modifiedFiles, List<String> unresolvableFiles) {
            this.repoRoot = repoRoot;
            this.blHandle = blHandle;
            this.wsHandle = wsHandle;
            this.localFiles = modifiedFiles;
            this.unresolvableFiles = unresolvableFiles;
        }
    }
}

