/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.ide.ui.internal.util.DisplayHelper;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import com.ibm.team.process.internal.ide.ui.editors.form.util.MessageBox;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RequireVsTestRunAspectEditor
extends OperationDetailsAspectEditor {
    private static final String MSTEST = "MSTest";
    private static final String NUNIT = "NUnit";
    private static final String TOOL_INFO = "toolinfo";
    private static final String TOOL_ID = "id";
    private static final String TOOL_HOME = "home";
    private static final String TEST_FILE = "testfile";
    private static final String ARGUMENTS = "arguments";
    private static final String COMPONENTS = "components";
    private static final String EMPTY = "";
    private UnitTestToolData fUnitTestTool;
    private static UnitTestToolData[] fAnalysisTools;
    private Combo fToolCombo;
    private Text fToolHomeField;
    private Text fTestFileField;
    private Text fToolArgumentsField;
    private ControlDecoration fTestSuiteDecoration;
    private MessageBox fMessageBox;
    private boolean fSettingInput;

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        fAnalysisTools = this.getAnalysisTools();
    }

    public void restoreState(IMemento memento) {
        this.fUnitTestTool = UnitTestToolData.readFrom(memento);
    }

    public boolean saveState(IMemento memento) {
        if (this.fUnitTestTool != null) {
            this.fUnitTestTool.setToolHome(this.fToolHomeField.getText());
            this.fUnitTestTool.setArguments(this.fToolArgumentsField.getText());
            this.fUnitTestTool.setTestFile(this.fTestFileField.getText());
            return this.fUnitTestTool.save(memento);
        }
        return false;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(1).applyTo(parent);
        Label heading = toolkit.createLabel(parent, Messages.RequireVsTestRunAspectEditor_0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)heading);
        heading.setFont(this.getBoldFont());
        Composite body = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(2).applyTo(body);
        Label label = toolkit.createLabel(body, Messages.RequireVsTestRunAspectEditor_1);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fToolCombo = new Combo(body, 12);
        GridDataFactory.fillDefaults().applyTo((Control)this.fToolCombo);
        this.fTestSuiteDecoration = new ControlDecoration((Control)this.fToolCombo, 16512);
        this.fToolCombo.setItems(this.getToolLabels());
        this.fToolCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequireVsTestRunAspectEditor.this.fUnitTestTool = RequireVsTestRunAspectEditor.getToolDataByIndex(RequireVsTestRunAspectEditor.this.fToolCombo.getSelectionIndex());
                RequireVsTestRunAspectEditor.this.setEditorDirty();
            }
        });
        label = toolkit.createLabel(body, Messages.RequireVsTestRunAspectEditor_2);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fToolHomeField = toolkit.createText(body, EMPTY, 2052);
        this.fToolHomeField.setToolTipText(Messages.RequireVsTestRunAspectEditor_4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fToolHomeField);
        this.fToolHomeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RequireVsTestRunAspectEditor.this.setEditorDirty();
            }
        });
        label = toolkit.createLabel(body, Messages.RequireVsTestRunAspectEditor_8);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fTestFileField = toolkit.createText(body, EMPTY, 2052);
        this.fTestFileField.setToolTipText(Messages.RequireVsTestRunAspectEditor_9);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTestFileField);
        this.fTestFileField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RequireVsTestRunAspectEditor.this.setEditorDirty();
            }
        });
        label = toolkit.createLabel(body, Messages.RequireVsTestRunAspectEditor_3);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fToolArgumentsField = toolkit.createText(body, EMPTY, 2052);
        this.fToolArgumentsField.setToolTipText(Messages.RequireVsTestRunAspectEditor_5);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fToolArgumentsField);
        this.fToolArgumentsField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RequireVsTestRunAspectEditor.this.setEditorDirty();
            }
        });
        this.fMessageBox = new MessageBox();
        Composite messageBoxControl = this.fMessageBox.createControl(parent, toolkit, (ProcessAspectEditor)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)messageBoxControl);
        DisplayHelper.asyncExec((Control)messageBoxControl, new Runnable(){

            @Override
            public void run() {
                RequireVsTestRunAspectEditor.this.updateUI();
            }
        });
    }

    public void dispose() {
    }

    public void updateUI() {
        this.fSettingInput = true;
        try {
            if (this.fUnitTestTool != null) {
                this.fToolCombo.select(RequireVsTestRunAspectEditor.getIndexForToolData(this.fUnitTestTool.getToolId()));
                this.fToolHomeField.setText(this.fUnitTestTool.getToolHome());
                this.fToolArgumentsField.setText(this.fUnitTestTool.getArguments());
                this.fTestFileField.setText(this.fUnitTestTool.getTestFile());
            }
            this.validateData();
        }
        finally {
            this.fSettingInput = false;
        }
    }

    private void setEditorDirty() {
        if (!this.fSettingInput) {
            this.setDirty();
            this.validateData();
        }
    }

    private void validateData() {
        if (this.validateTool()) {
            this.fMessageBox.clearMessage();
        }
    }

    private boolean validateTool() {
        if (this.fUnitTestTool == null) {
            this.clearValidations();
            this.setValidationMessage(true, this.fTestSuiteDecoration, true, Messages.RequireVsTestRunAspectEditor_7);
            return false;
        }
        this.clearValidations();
        return true;
    }

    private void clearValidations() {
        this.setValidationMessage(true, this.fTestSuiteDecoration, true, null);
    }

    private void setValidationMessage(boolean required, ControlDecoration decoration, boolean setErrorMessage, String msg) {
        if (msg != null) {
            if (setErrorMessage) {
                this.fMessageBox.setErrorMessage(msg);
            }
            decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        } else {
            this.clearDecoration(decoration, required);
        }
    }

    private void clearDecoration(ControlDecoration decoration, boolean required) {
        if (required) {
            decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        } else {
            decoration.hide();
            decoration.setImage(null);
            decoration.show();
        }
    }

    private static UnitTestToolData getToolDataByIndex(int index) {
        return fAnalysisTools[index];
    }

    private static UnitTestToolData getToolDataById(String id) {
        int i = 0;
        while (i < fAnalysisTools.length) {
            if (fAnalysisTools[i].getToolId().equals(id)) {
                return fAnalysisTools[i];
            }
            ++i;
        }
        return null;
    }

    private static int getIndexForToolData(String id) {
        int i = 0;
        while (i < fAnalysisTools.length) {
            if (fAnalysisTools[i].getToolId().equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String[] getToolLabels() {
        return UnitTestToolData.getToolNames(fAnalysisTools);
    }

    private UnitTestToolData[] getAnalysisTools() {
        UnitTestToolData[] tools = new UnitTestToolData[]{new UnitTestToolData(MSTEST, "com.ibm.team.scm.vsclient.mstest"), new UnitTestToolData(NUNIT, "com.ibm.team.scm.vsclient.nunit")};
        return tools;
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    private static class UnitTestToolData {
        private String fToolName;
        private String fToolId;
        private String fToolHome;
        private String fArguments;
        private String fTestFile;

        public UnitTestToolData(String toolName, String toolId) {
            this.fToolName = toolName;
            this.fToolId = toolId;
            this.fToolHome = null;
            this.fArguments = null;
        }

        public String getArguments() {
            return this.fArguments;
        }

        public void setArguments(String fArguments) {
            this.fArguments = fArguments;
        }

        public String getToolHome() {
            return this.fToolHome;
        }

        public void setToolHome(String fToolHome) {
            this.fToolHome = fToolHome;
        }

        public String getToolName() {
            return this.fToolName;
        }

        public String getToolId() {
            return this.fToolId;
        }

        public void setTestFile(String fTestFile) {
            this.fTestFile = fTestFile;
        }

        public String getTestFile() {
            return this.fTestFile;
        }

        public boolean save(IMemento memento) {
            IMemento tagMemento = memento.createChild(RequireVsTestRunAspectEditor.TOOL_INFO);
            tagMemento.putString(RequireVsTestRunAspectEditor.TOOL_ID, this.getToolId());
            tagMemento.putString(RequireVsTestRunAspectEditor.TOOL_HOME, UnitTestToolData.getValue(this.getToolHome()));
            tagMemento.putString(RequireVsTestRunAspectEditor.TEST_FILE, UnitTestToolData.getValue(this.getTestFile()));
            tagMemento.putString(RequireVsTestRunAspectEditor.ARGUMENTS, UnitTestToolData.getValue(this.getArguments()));
            tagMemento.putString(RequireVsTestRunAspectEditor.COMPONENTS, RequireVsTestRunAspectEditor.EMPTY);
            return true;
        }

        public static UnitTestToolData readFrom(IMemento memento) {
            IMemento tagMemento = memento.getChild(RequireVsTestRunAspectEditor.TOOL_INFO);
            UnitTestToolData toolData = null;
            if (tagMemento != null && (toolData = RequireVsTestRunAspectEditor.getToolDataById(tagMemento.getString(RequireVsTestRunAspectEditor.TOOL_ID))) != null) {
                toolData.setToolHome(tagMemento.getString(RequireVsTestRunAspectEditor.TOOL_HOME));
                toolData.setTestFile(tagMemento.getString(RequireVsTestRunAspectEditor.TEST_FILE));
                toolData.setArguments(tagMemento.getString(RequireVsTestRunAspectEditor.ARGUMENTS));
            }
            return toolData;
        }

        public static String[] getToolNames(UnitTestToolData[] analysisTools) {
            if (analysisTools != null && analysisTools.length > 0) {
                String[] tools = new String[analysisTools.length];
                int i = 0;
                while (i < analysisTools.length) {
                    tools[i] = analysisTools[i].getToolName();
                    ++i;
                }
                return tools;
            }
            return null;
        }

        private static String getValue(String value) {
            return value != null ? value : RequireVsTestRunAspectEditor.EMPTY;
        }
    }
}

