/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.ide.ui.internal.util.DisplayHelper;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import com.ibm.team.process.internal.ide.ui.editors.form.util.MessageBox;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RequireStaticAnalysisAspectEditor
extends OperationDetailsAspectEditor {
    private static final String TOOL_INFO = "toolinfo";
    private static final String TOOL_ID = "id";
    private static final String TOOL_NAME = "name";
    private static final String TOOL_HOME = "home";
    private static final String TOOL_CMD = "command";
    private static final String ARGUMENTS = "arguments";
    private static final String EXCLUDE_PROJECTS = "excludeprojects";
    private static final String EMPTY = "";
    private static final String FXCOP_CMD = "FxCopCmd.exe";
    private ToolData fAnalysisTool;
    private static ToolData[] fAnalysisTools;
    private Combo fToolCombo;
    private Text fToolNameField;
    private Text fToolHomeField;
    private Text fToolCmdField;
    private Text fToolArgumentsField;
    private Text fExcludeProjectsField;
    private ControlDecoration fTestSuiteDecoration;
    private ControlDecoration fToolCommandDecoration;
    private MessageBox fMessageBox;
    private boolean fSettingInput;

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        fAnalysisTools = this.getAnalysisTools();
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(1).applyTo(parent);
        Label heading = toolkit.createLabel(parent, Messages.RequireStaticAnalysisRunAspectEditor_0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)heading);
        heading.setFont(this.getBoldFont());
        Composite body = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(2).applyTo(body);
        Label label = toolkit.createLabel(body, Messages.RequireStaticAnalysisRunAspectEditor_1);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fToolCombo = new Combo(body, 12);
        GridDataFactory.fillDefaults().applyTo((Control)this.fToolCombo);
        this.fTestSuiteDecoration = new ControlDecoration((Control)this.fToolCombo, 16512);
        this.fToolCombo.setItems(this.getAnalysisToolLabels());
        label = toolkit.createLabel(body, Messages.RequireStaticAnalysisRunAspectEditor_2);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fToolNameField = toolkit.createText(body, EMPTY, 2052);
        this.fToolNameField.setToolTipText(Messages.RequireStaticAnalysisRunAspectEditor_11);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fToolNameField);
        this.fToolNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RequireStaticAnalysisAspectEditor.this.setEditorDirty();
            }
        });
        this.fToolCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequireStaticAnalysisAspectEditor.this.fAnalysisTool = RequireStaticAnalysisAspectEditor.getToolDataByIndex(RequireStaticAnalysisAspectEditor.this.fToolCombo.getSelectionIndex());
                RequireStaticAnalysisAspectEditor.this.fToolNameField.setText(RequireStaticAnalysisAspectEditor.this.fAnalysisTool.getToolName());
                this.setToolCommand();
                RequireStaticAnalysisAspectEditor.this.setEditorDirty();
            }

            private void setToolCommand() {
                boolean isCustomTool = RequireStaticAnalysisAspectEditor.this.fAnalysisTool.getToolId().equals("com.ibm.team.scm.vsclient.fxcop");
                RequireStaticAnalysisAspectEditor.this.fToolCmdField.setEditable(!isCustomTool);
                RequireStaticAnalysisAspectEditor.this.fToolCmdField.setText(RequireStaticAnalysisAspectEditor.this.fAnalysisTool.getToolCmd());
            }
        });
        label = toolkit.createLabel(body, Messages.RequireStaticAnalysisRunAspectEditor_3);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fToolHomeField = toolkit.createText(body, EMPTY, 2052);
        this.fToolHomeField.setToolTipText(Messages.RequireStaticAnalysisRunAspectEditor_12);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fToolHomeField);
        this.fToolHomeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RequireStaticAnalysisAspectEditor.this.setEditorDirty();
            }
        });
        label = toolkit.createLabel(body, Messages.RequireStaticAnalysisRunAspectEditor_10);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fToolCmdField = toolkit.createText(body, EMPTY, 2052);
        this.fToolCmdField.setToolTipText(Messages.RequireStaticAnalysisRunAspectEditor_14);
        this.fToolCommandDecoration = new ControlDecoration((Control)this.fToolCmdField, 16512);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fToolCmdField);
        this.fToolCmdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RequireStaticAnalysisAspectEditor.this.setEditorDirty();
            }
        });
        label = toolkit.createLabel(body, Messages.RequireStaticAnalysisRunAspectEditor_4);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fToolArgumentsField = toolkit.createText(body, EMPTY, 2052);
        this.fToolArgumentsField.setToolTipText(Messages.RequireStaticAnalysisRunAspectEditor_15);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fToolArgumentsField);
        this.fToolArgumentsField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RequireStaticAnalysisAspectEditor.this.setEditorDirty();
            }
        });
        label = toolkit.createLabel(body, Messages.RequireStaticAnalysisRunAspectEditor_5);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fExcludeProjectsField = toolkit.createText(body, EMPTY, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fExcludeProjectsField);
        this.fExcludeProjectsField.setToolTipText(Messages.RequireStaticAnalysisRunAspectEditor_6);
        this.fExcludeProjectsField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RequireStaticAnalysisAspectEditor.this.setEditorDirty();
            }
        });
        this.fMessageBox = new MessageBox();
        Composite messageBoxControl = this.fMessageBox.createControl(parent, toolkit, (ProcessAspectEditor)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)messageBoxControl);
        DisplayHelper.asyncExec((Control)messageBoxControl, new Runnable(){

            @Override
            public void run() {
                RequireStaticAnalysisAspectEditor.this.updateUI();
            }
        });
    }

    public void updateUI() {
        this.fSettingInput = true;
        try {
            if (this.fAnalysisTool != null) {
                this.fToolCombo.select(RequireStaticAnalysisAspectEditor.getIndexForToolData(this.fAnalysisTool.getToolId()));
                this.fToolNameField.setText(this.fAnalysisTool.getDisplayName());
                this.fToolHomeField.setText(this.fAnalysisTool.getToolHome());
                this.fToolCmdField.setText(this.fAnalysisTool.getToolCmd());
                this.fToolArgumentsField.setText(this.fAnalysisTool.getArguments());
                this.fExcludeProjectsField.setText(this.fAnalysisTool.getExcludedProjects());
            }
            this.validateData();
        }
        finally {
            this.fSettingInput = false;
        }
    }

    private void setEditorDirty() {
        if (!this.fSettingInput) {
            this.setDirty();
            this.validateData();
        }
    }

    public void restoreState(IMemento memento) {
        this.fAnalysisTool = ToolData.readFrom(memento);
    }

    public boolean saveState(IMemento memento) {
        if (this.fAnalysisTool != null) {
            this.fAnalysisTool.setDisplayName(this.fToolNameField.getText());
            this.fAnalysisTool.setToolHome(this.fToolHomeField.getText());
            this.fAnalysisTool.setToolCommand(this.fToolCmdField.getText());
            this.fAnalysisTool.setArguments(this.fToolArgumentsField.getText());
            this.fAnalysisTool.setExcludedProjects(this.fExcludeProjectsField.getText());
            return this.fAnalysisTool.save(memento);
        }
        return false;
    }

    public void dispose() {
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    private ToolData[] getAnalysisTools() {
        ToolData[] tools = new ToolData[]{new ToolData(Messages.RequireStaticAnalysisRunAspectEditor_FxCopTool, "com.ibm.team.scm.vsclient.fxcop", FXCOP_CMD), new ToolData(Messages.RequireStaticAnalysisRunAspectEditor_Generic, "com.ibm.team.scm.vsclient.generic", EMPTY)};
        return tools;
    }

    private String[] getAnalysisToolLabels() {
        return ToolData.getToolNames(fAnalysisTools);
    }

    private void validateData() {
        if (this.validateTool()) {
            this.fMessageBox.clearMessage();
        }
    }

    private boolean validateTool() {
        if (this.fAnalysisTool == null) {
            this.clearValidations();
            this.setValidationMessage(true, this.fTestSuiteDecoration, true, Messages.RequireStaticAnalysisRunAspectEditor_7);
            return false;
        }
        if (!this.isValidStringValue(this.fToolCmdField.getText())) {
            this.clearValidations();
            this.setValidationMessage(true, this.fToolCommandDecoration, true, Messages.RequireStaticAnalysisRunAspectEditor_16);
            return false;
        }
        this.clearValidations();
        return true;
    }

    private boolean isValidStringValue(String sValue) {
        return sValue != null && sValue.trim().length() >= 1;
    }

    private void clearValidations() {
        this.setValidationMessage(true, this.fTestSuiteDecoration, true, null);
        this.setValidationMessage(true, this.fToolCommandDecoration, true, null);
    }

    private void setValidationMessage(boolean required, ControlDecoration decoration, boolean setErrorMessage, String msg) {
        if (msg != null) {
            if (setErrorMessage) {
                this.fMessageBox.setErrorMessage(msg);
            }
            decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        } else {
            this.clearDecoration(decoration, required);
        }
    }

    private void clearDecoration(ControlDecoration decoration, boolean required) {
        if (required) {
            decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        } else {
            decoration.hide();
            decoration.setImage(null);
            decoration.show();
        }
    }

    private static ToolData getToolDataByIndex(int index) {
        return fAnalysisTools[index];
    }

    private static ToolData getToolDataById(String id) {
        int i = 0;
        while (i < fAnalysisTools.length) {
            if (fAnalysisTools[i].getToolId().equals(id)) {
                return fAnalysisTools[i];
            }
            ++i;
        }
        return null;
    }

    private static int getIndexForToolData(String id) {
        int i = 0;
        while (i < fAnalysisTools.length) {
            if (fAnalysisTools[i].getToolId().equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class ToolData {
        private String fToolName;
        private String fToolId;
        private String fDisplayName;
        private String fToolHome;
        private String fToolCmd;
        private String fArguments;
        private String fExcludedProjects;

        public ToolData(String toolName, String toolId, String toolCmd) {
            this.fToolName = toolName;
            this.fToolId = toolId;
            this.fToolCmd = toolCmd;
            this.fDisplayName = null;
            this.fToolHome = null;
            this.fArguments = null;
        }

        public String getArguments() {
            return this.fArguments;
        }

        public void setArguments(String fArguments) {
            this.fArguments = fArguments;
        }

        public String getToolHome() {
            return this.fToolHome;
        }

        public String getToolCmd() {
            return this.fToolCmd;
        }

        public void setToolHome(String fToolHome) {
            this.fToolHome = fToolHome;
        }

        public void setToolCommand(String fToolCmd) {
            this.fToolCmd = fToolCmd;
        }

        public String getToolName() {
            return this.fToolName;
        }

        public String getToolId() {
            return this.fToolId;
        }

        public void setDisplayName(String displayName) {
            this.fDisplayName = displayName;
        }

        public String getDisplayName() {
            if (this.fDisplayName == null || this.fDisplayName.trim().length() == 0) {
                return this.fToolName;
            }
            return this.fDisplayName;
        }

        public void setExcludedProjects(String excludedProjects) {
            this.fExcludedProjects = excludedProjects;
        }

        public String getExcludedProjects() {
            return this.fExcludedProjects;
        }

        public boolean save(IMemento memento) {
            IMemento tagMemento = memento.createChild(RequireStaticAnalysisAspectEditor.TOOL_INFO);
            tagMemento.putString(RequireStaticAnalysisAspectEditor.TOOL_ID, this.getToolId());
            tagMemento.putString(RequireStaticAnalysisAspectEditor.TOOL_NAME, ToolData.getValue(this.getDisplayName()));
            tagMemento.putString(RequireStaticAnalysisAspectEditor.TOOL_HOME, ToolData.getValue(this.getToolHome()));
            tagMemento.putString(RequireStaticAnalysisAspectEditor.TOOL_CMD, ToolData.getValue(this.getToolCmd()));
            tagMemento.putString(RequireStaticAnalysisAspectEditor.ARGUMENTS, ToolData.getValue(this.getArguments()));
            tagMemento.putString(RequireStaticAnalysisAspectEditor.EXCLUDE_PROJECTS, ToolData.getValue(this.getExcludedProjects()));
            return true;
        }

        public static ToolData readFrom(IMemento memento) {
            IMemento tagMemento = memento.getChild(RequireStaticAnalysisAspectEditor.TOOL_INFO);
            ToolData toolData = null;
            if (tagMemento != null && (toolData = RequireStaticAnalysisAspectEditor.getToolDataById(tagMemento.getString(RequireStaticAnalysisAspectEditor.TOOL_ID))) != null) {
                toolData.setDisplayName(tagMemento.getString(RequireStaticAnalysisAspectEditor.TOOL_NAME));
                toolData.setToolHome(tagMemento.getString(RequireStaticAnalysisAspectEditor.TOOL_HOME));
                toolData.setToolCommand(tagMemento.getString(RequireStaticAnalysisAspectEditor.TOOL_CMD));
                toolData.setArguments(tagMemento.getString(RequireStaticAnalysisAspectEditor.ARGUMENTS));
                toolData.setExcludedProjects(tagMemento.getString(RequireStaticAnalysisAspectEditor.EXCLUDE_PROJECTS));
            }
            return toolData;
        }

        public static String[] getToolNames(ToolData[] analysisTools) {
            if (analysisTools != null && analysisTools.length > 0) {
                String[] tools = new String[analysisTools.length];
                int i = 0;
                while (i < analysisTools.length) {
                    tools[i] = analysisTools[i].getToolName();
                    ++i;
                }
                return tools;
            }
            return null;
        }

        private static String getValue(String value) {
            return value != null ? value : RequireStaticAnalysisAspectEditor.EMPTY;
        }
    }
}

