/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.ide.ui.process.SimpleRemotePathResolver;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.labelproviders.ComponentWrapperLabelProvider;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilePicker;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerOutput;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.ScmPackage;
import com.ibm.team.scm.common.internal.process.IFauxXmlNode;
import com.ibm.team.scm.common.internal.process.MementoFauxXmlNode;
import com.ibm.team.scm.common.internal.process.ProcessConfigDeserializer;
import com.ibm.team.scm.common.internal.process.ProcessConfigSerializer;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.process.ProcessUtils;
import com.ibm.team.scm.common.process.ProtectVersionableConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ProtectVersionableAdvisorAspectEditor
extends OperationDetailsAspectEditor {
    private static final String WS_HREF = "ws";
    private static final String CHANGE_HREF = "change";
    private TreeViewer versionableListing;
    private ProtectVersionableConfig config = new ProtectVersionableConfig();
    private final VersionableDisplayModel uiModel = new VersionableDisplayModel();
    private Job pathLookupJob;
    private ITeamRepository repo;
    private LocalResourceManager resourceManager;
    private Button removeVersionableButton;
    private Button addVersionableButton;
    private Link locationLink;
    private Button allowButton;
    public static final Comparator<ComponentDisplayRecord> COMPONENT_DISPLAY_RECORD_COMPARATOR = new Comparator<ComponentDisplayRecord>(){

        @Override
        public int compare(ComponentDisplayRecord o1, ComponentDisplayRecord o2) {
            String c2;
            String c1 = o1.component.getName();
            int r = c1.compareTo(c2 = o2.component.getName());
            if (r == 0) {
                int h1 = System.identityHashCode(c1);
                int h2 = System.identityHashCode(c2);
                return h1 - h2;
            }
            return r;
        }
    };
    private static final Comparator<VersionableDisplayRecord> VERSIONABLE_DISPLAY_RECORD_COMPARATOR = new Comparator<VersionableDisplayRecord>(){

        @Override
        public int compare(VersionableDisplayRecord o1, VersionableDisplayRecord o2) {
            if (o1.isFolder && !o2.isFolder) {
                return -1;
            }
            if (!o1.isFolder && o2.isFolder) {
                return 1;
            }
            int r = o1.name.compareTo(o2.name);
            if (r == 0) {
                return System.identityHashCode(o1) - System.identityHashCode(o2);
            }
            return r;
        }
    };
    private static final Comparator<VersionableFolder> VERSIONABLE_FOLDER_COMPARATOR = new Comparator<VersionableFolder>(){

        @Override
        public int compare(VersionableFolder o1, VersionableFolder o2) {
            int r;
            if (o1.path != null && o2.path != null && (r = o1.path.compareTo(o2.path)) != 0) {
                return r;
            }
            if (o1.path == null && o2.path != null) {
                return -1;
            }
            if (o1.path != null && o2.path == null) {
                return 1;
            }
            return System.identityHashCode(o1) - System.identityHashCode(o2);
        }
    };

    protected final Image getImage(ImageDescriptor descriptor) {
        Object o = this.resourceManager.find((DeviceResourceDescriptor)descriptor);
        if (o instanceof Image) {
            return (Image)o;
        }
        return this.resourceManager.createImageWithDefault(descriptor);
    }

    public boolean saveState(IMemento memento) {
        if (this.uiModel.state == UiState.LOADING) {
            return true;
        }
        this.config = this.uiModel.dumpConfig();
        MementoFauxXmlNode node = new MementoFauxXmlNode(memento);
        ProcessConfigSerializer serializer = new ProcessConfigSerializer();
        try {
            serializer.serialize((IFauxXmlNode)node, (Object)this.config);
        }
        catch (ProcessConfigSerializer.SerializationException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.client", (Throwable)e);
            return false;
        }
        return true;
    }

    private String makePath(VersionablePath filePath) {
        StringBuffer buf = new StringBuffer();
        String[] segments = filePath.getStringSegments();
        int i = 0;
        while (i < segments.length - 1) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            buf.append(segments[i]);
            ++i;
        }
        return buf.toString();
    }

    public void restoreState(IMemento memento) {
        ProcessConfigDeserializer deserializer = new ProcessConfigDeserializer();
        try {
            this.config = (ProtectVersionableConfig)deserializer.deserialize((IFauxXmlNode)new MementoFauxXmlNode(memento), ProtectVersionableConfig.class);
        }
        catch (ProcessConfigDeserializer.DeserializationException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.client", (Throwable)e);
        }
        if (this.config == null) {
            this.config = new ProtectVersionableConfig();
        }
        if (this.config.uiHints != null && this.config.uiHints.pathResolutionLocation != null) {
            this.uiModel.workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(this.config.uiHints.pathResolutionLocation, null);
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent.getShell());
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        Composite radioComp = toolkit.createComposite(parent);
        Label label = toolkit.createLabel(radioComp, Messages.ProtectVersionableAdvisorAspectEditor_MATCH_TYPE);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        GridDataFactory radioData = GridDataFactory.fillDefaults().grab(false, false);
        this.allowButton = toolkit.createButton(radioComp, Messages.ProtectVersionableAdvisorAspectEditor_ALLOW_MESSAGE, 16);
        radioData.applyTo((Control)this.allowButton);
        Button preventButton = toolkit.createButton(radioComp, Messages.ProtectVersionableAdvisorAspectEditor_DENY_MESSAGE, 16);
        radioData.applyTo((Control)preventButton);
        SelectionAdapter dirtyListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProtectVersionableAdvisorAspectEditor.this.setDirty();
            }
        };
        this.allowButton.addSelectionListener((SelectionListener)dirtyListener);
        preventButton.addSelectionListener((SelectionListener)dirtyListener);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(3).applyTo(radioComp);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)radioComp);
        if (this.config != null && this.config.allowMatching) {
            this.allowButton.setSelection(true);
        } else {
            preventButton.setSelection(true);
        }
        this.versionableListing = new TreeViewer(parent);
        this.versionableListing.setContentProvider((IContentProvider)new ProtectVersionableContentProvider());
        this.versionableListing.setLabelProvider((IBaseLabelProvider)new ProtectVersionableLabelProvider());
        this.versionableListing.setInput((Object)this.uiModel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.versionableListing.getTree());
        Composite buttonComp = toolkit.createComposite(parent);
        GridDataFactory buttonData = GridDataFactory.fillDefaults().align(4, 128);
        this.addVersionableButton = toolkit.createButton(buttonComp, Messages.ProtectVersionableAdvisorAspectEditor_ADD_PATH_BUTTON, 8);
        this.addVersionableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProtectVersionableAdvisorAspectEditor.this.addClicked(((Control)e.widget).getShell());
            }
        });
        buttonData.applyTo((Control)this.addVersionableButton);
        this.removeVersionableButton = toolkit.createButton(buttonComp, Messages.ProtectVersionableAdvisorAspectEditor_REMOVE_PATH_BUTTON, 8);
        this.removeVersionableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProtectVersionableAdvisorAspectEditor.this.removeClicked(((Control)e.widget).getShell());
            }
        });
        this.removeVersionableButton.setEnabled(false);
        this.versionableListing.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProtectVersionableAdvisorAspectEditor.this.updateOnListingSelectionChange(event);
            }
        });
        buttonData.applyTo((Control)this.removeVersionableButton);
        GridLayoutFactory.fillDefaults().applyTo(buttonComp);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)buttonComp);
        this.updateButtonEnablement();
        this.locationLink = new Link(parent, 64);
        this.locationLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProtectVersionableAdvisorAspectEditor.WS_HREF.equals(e.text)) {
                    IWorkbenchPage page;
                    IWorkspace ws = (IWorkspace)ProtectVersionableAdvisorAspectEditor.this.locationLink.getData();
                    if (ws == null) {
                        return;
                    }
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        TeamPlacePart2.open(page, TeamPlaceEditorInput.newForEdit(AbstractPlaceWrapper.newWrapper(ws)));
                    }
                } else if (ProtectVersionableAdvisorAspectEditor.CHANGE_HREF.equals(e.text)) {
                    ProtectVersionableAdvisorAspectEditor.this.changeResolutionLocation(ProtectVersionableAdvisorAspectEditor.this.locationLink.getShell());
                }
            }
        });
        this.setPathResolutionLocation(null);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.locationLink);
        this.loadExistingPaths();
    }

    protected void setPathResolutionLocation(IWorkspace newLocation) {
        String location = newLocation == null ? "Location not resolved" : NLS.bind((String)Messages.ProtectVersionableAdvisorAspectEditor_PATH_LINK_MESSAGE, (Object)("<a href=\"ws\">" + newLocation.getName() + "</a>"));
        String changeText = NLS.bind((String)"<a href=\"change\">{0}</a>", (Object)Messages.ProtectVersionableAdvisorAspectEditor_CHANGE_LINK);
        this.locationLink.setText(NLS.bind((String)Messages.ProtectVersionableAdvisorAspectEditor_MESSAGE_AND_LINK_TEXT, (Object)location, (Object)changeText));
        this.locationLink.setData((Object)newLocation);
        this.locationLink.getParent().layout(new Control[]{this.locationLink});
    }

    protected void changeResolutionLocation(Shell parent) {
        AbstractPlaceWrapper ws = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(parent, this.repo);
        if (ws == null) {
            return;
        }
        if (ws.getWorkspace().sameItemId((IItemHandle)this.uiModel.workspaceHandle)) {
            return;
        }
        this.config = this.uiModel.dumpConfig();
        this.setDirty();
        this.uiModel.fullWorkspace = null;
        this.uiModel.workspaceHandle = ws.getWorkspace();
        if (this.config.uiHints == null) {
            this.config.uiHints = new ProtectVersionableConfig.UiHints();
        }
        this.config.uiHints.pathResolutionLocation = ws.getWorkspace().getItemId();
        this.pathLookupJob.schedule();
    }

    protected void updateOnListingSelectionChange(SelectionChangedEvent event) {
        this.updateButtonEnablement();
    }

    protected void updateButtonEnablement() {
        if (this.uiModel.state == UiState.OK) {
            this.addVersionableButton.setEnabled(true);
            this.removeVersionableButton.setEnabled(this.versionableListing.getTree().getSelectionCount() > 0);
        } else {
            this.addVersionableButton.setEnabled(false);
            this.removeVersionableButton.setEnabled(false);
        }
    }

    protected void removeClicked(Shell shell) {
        if (this.uiModel.state != UiState.OK) {
            return;
        }
        ITreeSelection selection = (ITreeSelection)this.versionableListing.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object toRemove = objectArray[n2];
            AbstractTreeRecord rec = (AbstractTreeRecord)toRemove;
            AbstractTreeRecord parent = rec.getParent();
            rec.removeSelfFromParent();
            while (true) {
                if (parent == null) {
                    this.versionableListing.refresh();
                    break;
                }
                this.versionableListing.refresh((Object)parent);
                if (parent.hasChildren()) break;
                parent.removeSelfFromParent();
                parent = parent.getParent();
            }
            ++n2;
        }
        this.setDirty();
    }

    private void loadExistingPaths() {
        final IProcessItem processItem = this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        this.repo = (ITeamRepository)processItem.getOrigin();
        this.pathLookupJob = new Job(Messages.ProtectVersionableAdvisorAspectEditor_RESOLVE_STATUS_MESSAGE){

            protected IStatus run(IProgressMonitor progress) {
                try {
                    IWorkspace loc;
                    ProtectVersionableAdvisorAspectEditor.this.uiModel.setState(UiState.LOADING);
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)5);
                    try {
                        loc = ProtectVersionableAdvisorAspectEditor.this.findResolutionLocation(ProtectVersionableAdvisorAspectEditor.this.repo, processItem, mon.newChild(1));
                    }
                    catch (TeamRepositoryException e) {
                        ProtectVersionableAdvisorAspectEditor.this.displayLookupFailure();
                        return Status.OK_STATUS;
                    }
                    if (loc == null) {
                        ProtectVersionableAdvisorAspectEditor.this.uiModel.setState(UiState.FAILED_TO_RESOLVE_WORKSPACE);
                        return Status.OK_STATUS;
                    }
                    ProtectVersionableAdvisorAspectEditor.this.resolvePaths(ProtectVersionableAdvisorAspectEditor.this.repo, loc, mon.newChild(4));
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return FileSystemStatusUtil.getStatusFor((Throwable)e);
                }
            }
        };
        this.pathLookupJob.schedule();
    }

    protected void displayLookupFailure() {
        Display display;
        try {
            display = this.versionableListing.getTree().getDisplay();
        }
        catch (SWTException e) {
            return;
        }
        if (display.isDisposed()) {
            return;
        }
        this.uiModel.setState(UiState.FAILED_TO_RESOLVE_WORKSPACE);
    }

    protected void addClicked(Shell shell) {
        if (this.uiModel.state != UiState.OK) {
            return;
        }
        final RepositoryFilesPickerOutput picked = RepositoryFilePicker.pickFiles(shell, this.repo, this.uiModel.workspaceHandle, Messages.ProtectVersionableAdvisorAspectEditor_PICKER_TEXT, Collections.EMPTY_SET, true);
        if (picked == null || picked.getItemIds().isEmpty()) {
            return;
        }
        this.setDirty();
        Job job = new Job(Messages.ProtectVersionableAdvisorAspectEditor_FINDING_DIRECTORIES_MESSAGE){

            protected IStatus run(IProgressMonitor monitor) {
                Display display;
                final Set<UUID> folderUuids = ProtectVersionableAdvisorAspectEditor.this.findFoldersIn(picked, SubMonitor.convert((IProgressMonitor)monitor));
                try {
                    display = ProtectVersionableAdvisorAspectEditor.this.versionableListing.getTree().getDisplay();
                }
                catch (SWTException e) {
                    return Status.OK_STATUS;
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProtectVersionableAdvisorAspectEditor.this.uiModel.mergeIn(picked, folderUuids);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected Set<UUID> findFoldersIn(RepositoryFilesPickerOutput picked, SubMonitor mon) {
        mon.setWorkRemaining(2);
        HashMap<UUID, ArrayList<IVersionableHandle>> compToItems = new HashMap<UUID, ArrayList<IVersionableHandle>>();
        ArrayList<IComponent> components = new ArrayList<IComponent>();
        for (SiloedItemId item : picked.getItemIds()) {
            ArrayList<IVersionableHandle> list = (ArrayList<IVersionableHandle>)compToItems.get(item.getComponentUUID());
            if (list == null) {
                list = new ArrayList<IVersionableHandle>();
                compToItems.put(item.getComponentUUID(), list);
                components.add(picked.getOwningComponent((SiloedItemId<IVersionable>)item));
            }
            list.add(item.toHandle());
        }
        HashSet<UUID> toReturn = new HashSet<UUID>();
        try {
            IWorkspaceConnection conn = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repo).getWorkspaceConnection(this.uiModel.workspaceHandle, (IProgressMonitor)mon.newChild(1));
            for (IComponent comp : components) {
                IConfiguration config = conn.configuration((IComponentHandle)comp);
                List versionables = config.fetchCompleteItems((List)compToItems.get(comp.getItemId()), (IProgressMonitor)mon.newChild(1));
                for (IVersionable ver : versionables) {
                    if (!(ver instanceof IFolderHandle)) continue;
                    toReturn.add(ver.getItemId());
                }
            }
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.client", (Throwable)e);
        }
        return toReturn;
    }

    public void dispose() {
        this.resourceManager.dispose();
    }

    private IWorkspace findResolutionLocation(ITeamRepository repo, IProcessItem item, SubMonitor mon) throws TeamRepositoryException {
        mon.setWorkRemaining(2);
        IWorkspaceHandle wsHandle = this.uiModel.workspaceHandle;
        if (wsHandle == null) {
            IProjectAreaHandle pa = ProcessUtils.findProcessAreaForProcessItem((IProcessItem)item);
            IWorkspaceSearchCriteria query = IWorkspaceSearchCriteria.FACTORY.newInstance();
            query.getFilterByOwnerOptional().add(pa);
            query.setKind(1);
            List streams = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findWorkspaces(query, 1, (IProgressMonitor)mon.newChild(1));
            if (streams.size() > 0) {
                wsHandle = (IWorkspaceHandle)streams.get(0);
            }
        }
        if (wsHandle == null) {
            return null;
        }
        return (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)wsHandle, 0, (IProgressMonitor)mon.newChild(1));
    }

    protected void resolvePaths(ITeamRepository repo, IWorkspace ws, SubMonitor monitor) throws TeamRepositoryException {
        SimpleRemotePathResolver resolved;
        monitor.setWorkRemaining(3);
        ArrayList locations = null;
        if (this.config != null && this.config.items != null) {
            locations = new ArrayList(this.config.items);
        }
        if (locations == null) {
            resolved = null;
        } else {
            ArrayList<IComponentHandle> comps = new ArrayList<IComponentHandle>();
            ArrayList<List<IVersionableHandle>> toResolve = new ArrayList<List<IVersionableHandle>>();
            IItemType versionableType = IItemType.IRegistry.INSTANCE.getItemType(ScmPackage.eINSTANCE.getVersionable().getName(), "com.ibm.team.scm");
            HashMap<UUID, Integer> componentIndexes = new HashMap<UUID, Integer>();
            for (ProtectVersionableConfig.VersionableLocation loc : locations) {
                ArrayList<IVersionableHandle> versionables;
                IComponentHandle comp;
                Integer offset = (Integer)componentIndexes.get(loc.compId);
                if (offset == null) {
                    comp = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(loc.compId, null);
                    offset = comps.size();
                    comps.add(comp);
                    componentIndexes.put(loc.compId, offset);
                    versionables = new ArrayList<IVersionableHandle>();
                    toResolve.add(versionables);
                } else {
                    comp = (IComponentHandle)comps.get(offset);
                    versionables = (ArrayList<IVersionableHandle>)toResolve.get(offset);
                }
                IVersionableHandle ver = (IVersionableHandle)versionableType.createItemHandle(loc.versionableId, null);
                versionables.add(ver);
            }
            IWorkspaceConnection conn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)ws, (IProgressMonitor)monitor.newChild(1));
            resolved = new SimpleRemotePathResolver(conn, comps, toResolve);
            resolved.setFetchFullComponent(true);
            resolved.setFetchFullVersionable(true);
            resolved.resolve((IProgressMonitor)monitor.newChild(2));
        }
        this.setDisplayedVersionables(ws, resolved);
    }

    private void setDisplayedVersionables(final IWorkspace ws, final SimpleRemotePathResolver resolved) {
        if (this.versionableListing.getTree().isDisposed()) {
            return;
        }
        Display display = this.versionableListing.getTree().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ((ProtectVersionableAdvisorAspectEditor)ProtectVersionableAdvisorAspectEditor.this).uiModel.fullWorkspace = ws;
                ((ProtectVersionableAdvisorAspectEditor)ProtectVersionableAdvisorAspectEditor.this).uiModel.workspaceHandle = ws;
                ProtectVersionableAdvisorAspectEditor.this.uiModel.setTree(resolved);
                ProtectVersionableAdvisorAspectEditor.this.versionableListing.setInput((Object)ProtectVersionableAdvisorAspectEditor.this.uiModel);
                ProtectVersionableAdvisorAspectEditor.this.setPathResolutionLocation(ws);
                ProtectVersionableAdvisorAspectEditor.this.uiModel.setState(UiState.OK);
            }
        });
    }

    protected static abstract class AbstractTreeRecord {
        protected final AbstractTreeRecord parent;

        protected AbstractTreeRecord(AbstractTreeRecord p) {
            this.parent = p;
        }

        public AbstractTreeRecord getParent() {
            return this.parent;
        }

        public abstract void removeSelfFromParent();

        public abstract boolean hasChildren();
    }

    protected class ComponentDisplayRecord
    extends AbstractTreeRecord {
        public final IComponent component;
        public final ComponentWrapper wrapper;
        public final VersionableFolder unresolved;
        public final boolean isPresent;
        public final HashMap<String, VersionableFolder> children;

        public ComponentDisplayRecord(ComponentWrapper wrapper, boolean isPresent) {
            super(null);
            this.unresolved = new VersionableFolder(this);
            this.children = new HashMap();
            this.wrapper = wrapper;
            this.component = wrapper.getComponent();
            this.isPresent = isPresent;
        }

        @Override
        public void removeSelfFromParent() {
            ((ProtectVersionableAdvisorAspectEditor)ProtectVersionableAdvisorAspectEditor.this).uiModel.components.remove(this.component.getItemId());
        }

        @Override
        public boolean hasChildren() {
            return !this.children.isEmpty();
        }
    }

    public class ProtectVersionableContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            ProtectVersionableAdvisorAspectEditor.this.versionableListing.refresh();
        }

        public Object[] getElements(Object inputElement) {
            if (((ProtectVersionableAdvisorAspectEditor)ProtectVersionableAdvisorAspectEditor.this).uiModel.state == UiState.LOADING) {
                return new String[]{Messages.ProtectVersionableAdvisorAspectEditor_LOAD_MESSAGE};
            }
            if (((ProtectVersionableAdvisorAspectEditor)ProtectVersionableAdvisorAspectEditor.this).uiModel.state == UiState.FAILED_TO_RESOLVE_WORKSPACE) {
                return new String[]{Messages.ProtectVersionableAdvisorAspectEditor_FAILED_TO_LOAD_MESSAGE};
            }
            TreeSet<ComponentDisplayRecord> ts = new TreeSet<ComponentDisplayRecord>(COMPONENT_DISPLAY_RECORD_COMPARATOR);
            ts.addAll(((ProtectVersionableAdvisorAspectEditor)ProtectVersionableAdvisorAspectEditor.this).uiModel.components.values());
            return ts.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                return new Object[0];
            }
            if (parentElement instanceof ComponentDisplayRecord) {
                ComponentDisplayRecord cdr = (ComponentDisplayRecord)parentElement;
                TreeSet<VersionableFolder> sorted = new TreeSet<VersionableFolder>(VERSIONABLE_FOLDER_COMPARATOR);
                sorted.addAll(cdr.children.values());
                if (cdr.unresolved.children.isEmpty()) {
                    return sorted.toArray();
                }
                Object[] out = new Object[sorted.size() + 1];
                sorted.toArray(out);
                out[sorted.size()] = cdr.unresolved;
                return out;
            }
            if (parentElement instanceof VersionableFolder) {
                VersionableFolder folder = (VersionableFolder)parentElement;
                TreeSet<VersionableDisplayRecord> sorted = new TreeSet<VersionableDisplayRecord>(VERSIONABLE_DISPLAY_RECORD_COMPARATOR);
                sorted.addAll(folder.children.values());
                return sorted.toArray();
            }
            throw new IllegalArgumentException("Can't find children for " + parentElement);
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return null;
            }
            if (element instanceof ComponentDisplayRecord) {
                return null;
            }
            if (element instanceof VersionableFolder) {
                return ((VersionableFolder)element).parent;
            }
            if (element instanceof VersionableDisplayRecord) {
                return ((VersionableDisplayRecord)element).parent;
            }
            throw new IllegalArgumentException("Unknown type: " + element);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof String) {
                return false;
            }
            if (element instanceof ComponentDisplayRecord) {
                return !((ComponentDisplayRecord)element).children.isEmpty() || !((ComponentDisplayRecord)element).unresolved.children.isEmpty();
            }
            if (element instanceof VersionableFolder) {
                return !((VersionableFolder)element).children.isEmpty();
            }
            if (element instanceof VersionableDisplayRecord) {
                return false;
            }
            if (element instanceof List) {
                return !((List)element).isEmpty();
            }
            throw new IllegalArgumentException("Unknown type: " + element);
        }
    }

    private class ProtectVersionableLabelProvider
    extends StyledCellLabelProvider {
        ComponentWrapperLabelProvider componentLabelProvider = new ComponentWrapperLabelProvider();
        private final TextStyle infoStyle;

        ProtectVersionableLabelProvider() {
            Font font = ProtectVersionableAdvisorAspectEditor.this.versionableListing.getTree().getFont();
            FontDescriptor fd = FontDescriptor.createFrom((Font)font);
            fd.setStyle(2);
            this.infoStyle = new TextStyle(null, JFaceResources.getColorRegistry().get("com.ibm.team.internal.filesystem.ui.ColorDefinitions.PENDING_CHANGES_DATE_COLOR"), null);
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof String) {
                String s = (String)element;
                cell.setText(s);
                this.styleAsSynthetic(cell);
                return;
            }
            if (element instanceof ComponentDisplayRecord) {
                ComponentDisplayRecord cdr = (ComponentDisplayRecord)element;
                if (cdr.isPresent) {
                    cell.setText(this.componentLabelProvider.getText((Object)cdr.wrapper));
                    cell.setImage(this.componentLabelProvider.getImage((Object)cdr.wrapper));
                } else {
                    String s = String.valueOf(cdr.component.getName()) + " (Missing) ";
                    cell.setText(s);
                    cell.setImage(ProtectVersionableAdvisorAspectEditor.this.getImage(ImagePool.COMPONENT_UNLOADED));
                }
                return;
            }
            if (element instanceof VersionableFolder) {
                VersionableFolder f = (VersionableFolder)element;
                if (f.isUnresolved) {
                    if (((ProtectVersionableAdvisorAspectEditor)ProtectVersionableAdvisorAspectEditor.this).uiModel.workspaceHandle == null) {
                        cell.setText(Messages.ProtectVersionableAdvisorAspectEditor_UNRESOLVED_PATHS);
                    } else {
                        cell.setText(NLS.bind((String)Messages.ProtectVersionableAdvisorAspectEditor_UNRESOLVED_PATHS_IN_STREAM, (Object)((ProtectVersionableAdvisorAspectEditor)ProtectVersionableAdvisorAspectEditor.this).uiModel.fullWorkspace.getName()));
                    }
                    this.styleAsSynthetic(cell);
                    cell.setImage(ProtectVersionableAdvisorAspectEditor.this.getImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER")));
                    return;
                }
                if (f.path == null) {
                    cell.setText(Messages.ProtectVersionableAdvisorAspectEditor_NAME_OF_COMPONENT_ROOT);
                    this.styleAsSynthetic(cell);
                } else {
                    cell.setText(f.path);
                }
                cell.setImage(ProtectVersionableAdvisorAspectEditor.this.getImage(UiPlugin.getFileSystemImageDescriptor(null)));
                return;
            }
            if (element instanceof VersionableDisplayRecord) {
                VersionableDisplayRecord vdr = (VersionableDisplayRecord)element;
                if (vdr.isAccessible) {
                    if (vdr.isResolved) {
                        cell.setText(vdr.name);
                        cell.setImage(ProtectVersionableAdvisorAspectEditor.this.getImage(UiPlugin.getFileSystemImageDescriptor(vdr.isFolder ? null : vdr.name)));
                    } else {
                        cell.setText(NLS.bind((String)Messages.ProtectVersionableAdvisorAspectEditor_ITEM_NOT_IN_REMOTE_WORKSPACE, (Object)vdr.handle.getItemId().getUuidValue()));
                        cell.setImage(null);
                        this.styleAsSynthetic(cell);
                    }
                } else {
                    cell.setText(NLS.bind((String)Messages.ProtectVersionableAdvisorAspectEditor_USER_NOT_PERMITTED_TO_SEE_ITEM, (Object)vdr.handle.getItemId().getUuidValue()));
                    cell.setImage(null);
                    this.styleAsSynthetic(cell);
                }
                return;
            }
            cell.setText("Unknown type: " + element);
        }

        protected void styleAsSynthetic(ViewerCell cell) {
            cell.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
            StyleRange[] range = new StyleRange[]{new StyleRange(this.infoStyle)};
            range[0].start = 0;
            range[0].length = cell.getText().length();
            cell.setStyleRanges(range);
        }

        public void dispose() {
            super.dispose();
            this.componentLabelProvider.dispose();
        }
    }

    static enum UiState {
        LOADING,
        FAILED_TO_RESOLVE_WORKSPACE,
        OK;

    }

    public class VersionableDisplayModel {
        protected UiState state;
        Map<UUID, ComponentDisplayRecord> components = new HashMap<UUID, ComponentDisplayRecord>();
        protected IWorkspaceHandle workspaceHandle;
        protected IWorkspace fullWorkspace;

        public void setTree(SimpleRemotePathResolver rpi) {
            if (ProtectVersionableAdvisorAspectEditor.this.versionableListing.getTree().isDisposed()) {
                return;
            }
            this.components.clear();
            ArrayList<Object> toRefresh = new ArrayList<Object>();
            boolean refreshRoot = false;
            for (SimpleRemotePathResolver.ComponentInfoPair pair : rpi) {
                ComponentDisplayRecord cdr = this.components.get(pair.comp.getItemId());
                if (cdr == null) {
                    cdr = new ComponentDisplayRecord(new ComponentWrapper(ProtectVersionableAdvisorAspectEditor.this.repo, rpi.getComponentFor(pair.comp)), pair.isPresentInConfiguration());
                    this.components.put(cdr.component.getItemId(), cdr);
                    refreshRoot = true;
                }
                for (SimpleRemotePathResolver.VersionableInfo info : pair.infos) {
                    VersionableDisplayRecord ver;
                    if (!info.isAccessible()) {
                        ver = new VersionableDisplayRecord(pair.comp, cdr.unresolved, info.getHandle(), false, "", false, false);
                        cdr.unresolved.children.put(info.getHandle().getItemId(), ver);
                        toRefresh.add(cdr);
                        continue;
                    }
                    if (info.isResolved()) {
                        VersionableDisplayRecord ver2;
                        String folderPath = info.isAtComponentRoot() ? null : info.getParentPath();
                        VersionableFolder folder = cdr.children.get(folderPath);
                        if (folder == null) {
                            folder = new VersionableFolder(cdr, folderPath);
                            cdr.children.put(folderPath, folder);
                            toRefresh.add(cdr);
                        }
                        if ((ver2 = folder.children.get(info.getHandle().getItemId())) != null) continue;
                        String name = info.getName();
                        boolean isFolder = info.getResolvedVersionable() instanceof IFolderHandle;
                        ver2 = new VersionableDisplayRecord(pair.comp, folder, info.getHandle(), true, name, isFolder, info.isResolved());
                        folder.children.put(info.getHandle().getItemId(), ver2);
                        toRefresh.add(folder);
                        continue;
                    }
                    ver = new VersionableDisplayRecord(pair.comp, cdr.unresolved, info.getHandle(), true, "", false, info.isResolved());
                    cdr.unresolved.children.put(info.getHandle().getItemId(), ver);
                    toRefresh.add(cdr);
                }
            }
            this.refreshMinimally(refreshRoot, toRefresh);
        }

        protected void refreshMinimally(boolean refreshRoot, List<Object> toRefresh) {
            if (refreshRoot) {
                ProtectVersionableAdvisorAspectEditor.this.versionableListing.refresh();
            } else {
                for (Object modelData : toRefresh) {
                    ProtectVersionableAdvisorAspectEditor.this.versionableListing.refresh(modelData);
                }
            }
        }

        private List<ProtectVersionableConfig.VersionableLocation> dumpItems() {
            ArrayList<ProtectVersionableConfig.VersionableLocation> toReturn = new ArrayList<ProtectVersionableConfig.VersionableLocation>();
            for (ComponentDisplayRecord cdr : this.components.values()) {
                for (VersionableFolder vf : cdr.children.values()) {
                    for (VersionableDisplayRecord vdr : vf.children.values()) {
                        toReturn.add(new ProtectVersionableConfig.VersionableLocation(vdr.component, vdr.handle));
                    }
                }
                for (VersionableDisplayRecord vdr : cdr.unresolved.children.values()) {
                    toReturn.add(new ProtectVersionableConfig.VersionableLocation(vdr.component, vdr.handle));
                }
            }
            return toReturn;
        }

        public ProtectVersionableConfig dumpConfig() {
            ProtectVersionableConfig config = new ProtectVersionableConfig();
            config.maxBadVersionables = ((ProtectVersionableAdvisorAspectEditor)ProtectVersionableAdvisorAspectEditor.this).config.maxBadVersionables;
            config.items = this.state == UiState.OK ? this.dumpItems() : ((ProtectVersionableAdvisorAspectEditor)ProtectVersionableAdvisorAspectEditor.this).config.items;
            config.allowMatching = ProtectVersionableAdvisorAspectEditor.this.allowButton.getSelection();
            config.uiHints = new ProtectVersionableConfig.UiHints();
            if (this.workspaceHandle != null) {
                config.uiHints.pathResolutionLocation = this.workspaceHandle.getItemId();
            }
            return config;
        }

        public void mergeIn(RepositoryFilesPickerOutput picked, Set<UUID> folderUuids) {
            ArrayList<Object> toRefresh = new ArrayList<Object>();
            boolean refreshAll = false;
            for (SiloedItemId item : picked.getItemIds()) {
                VersionableDisplayRecord vdr;
                VersionablePath filePath;
                String path;
                VersionableFolder vf;
                ComponentDisplayRecord cdr = this.components.get(item.getComponentUUID());
                if (cdr == null) {
                    IComponent comp = picked.getOwningComponent((SiloedItemId<IVersionable>)item);
                    cdr = new ComponentDisplayRecord(new ComponentWrapper(ProtectVersionableAdvisorAspectEditor.this.repo, comp), true);
                    this.components.put(item.getComponentUUID(), cdr);
                    refreshAll = true;
                }
                if ((vf = cdr.children.get(path = (filePath = picked.getFilePath((SiloedItemId<IVersionable>)item)).segmentCount() == 1 ? null : ProtectVersionableAdvisorAspectEditor.this.makePath(filePath))) == null) {
                    vf = new VersionableFolder(cdr, path);
                    cdr.children.put(path, vf);
                    toRefresh.add(cdr);
                }
                if ((vdr = vf.children.get(item.getItemId().getItemUUID())) != null) continue;
                VersionablePath vPath = picked.getFilePath((SiloedItemId<IVersionable>)item);
                vdr = new VersionableDisplayRecord((IComponentHandle)picked.getOwningComponent((SiloedItemId<IVersionable>)item), vf, item.toHandle(), true, vPath.getFileName(), folderUuids.contains(item.getItemUUID()), true);
                vf.children.put(item.getItemUUID(), vdr);
                toRefresh.add(vf);
            }
            this.refreshMinimally(refreshAll, toRefresh);
        }

        public void setState(final UiState state) {
            Display display = ProtectVersionableAdvisorAspectEditor.this.versionableListing.getTree().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    VersionableDisplayModel.this.state = state;
                    ProtectVersionableAdvisorAspectEditor.this.versionableListing.setInput((Object)this);
                    ProtectVersionableAdvisorAspectEditor.this.updateButtonEnablement();
                }
            });
        }
    }

    protected static class VersionableDisplayRecord
    extends AbstractTreeRecord {
        public final IComponentHandle component;
        public final IVersionableHandle handle;
        public final boolean isAccessible;
        public final String name;
        public final boolean isFolder;
        public final boolean isResolved;

        public VersionableDisplayRecord(IComponentHandle comp, AbstractTreeRecord parent, IVersionableHandle h, boolean isAccessible, String name, boolean isFolder, boolean isResolved) {
            super(parent);
            this.component = comp;
            this.handle = h;
            this.isAccessible = isAccessible;
            this.name = name;
            this.isFolder = isFolder;
            this.isResolved = isResolved;
        }

        @Override
        public void removeSelfFromParent() {
            VersionableFolder parent = (VersionableFolder)this.getParent();
            parent.children.remove(this.handle.getItemId());
        }

        @Override
        public boolean hasChildren() {
            return false;
        }
    }

    protected static class VersionableFolder
    extends AbstractTreeRecord {
        public final String path;
        public final boolean isUnresolved;
        public final HashMap<UUID, VersionableDisplayRecord> children = new HashMap();

        public VersionableFolder(ComponentDisplayRecord parent, String path) {
            super(parent);
            this.path = path;
            this.isUnresolved = false;
        }

        public VersionableFolder(ComponentDisplayRecord parent) {
            super(parent);
            this.path = null;
            this.isUnresolved = true;
        }

        @Override
        public void removeSelfFromParent() {
            ComponentDisplayRecord cdr = (ComponentDisplayRecord)this.getParent();
            if (this.isUnresolved) {
                this.children.clear();
            } else {
                cdr.children.remove(this.path);
            }
        }

        @Override
        public boolean hasChildren() {
            return !this.children.isEmpty();
        }
    }
}

