/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.IRole2;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.TeamAreaHierarchyException;
import com.ibm.team.process.internal.ide.ui.editors.form.AbstractProcessAspect;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProcessAreaUtil {
    public static String[] toPath(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (processArea instanceof ITeamArea) {
            ITeamArea teamArea = (ITeamArea)processArea;
            IItemManager manager = ((ITeamRepository)teamArea.getOrigin()).itemManager();
            IProjectAreaHandle projectAreaHandle = teamArea.getProjectArea();
            IProjectArea projectArea = (IProjectArea)manager.fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)progress.newChild(10));
            ArrayList<ITeamArea> teamAreaHandles = new ArrayList<ITeamArea>();
            try {
                ITeamArea element = teamArea;
                while ((element = projectArea.getTeamAreaHierarchy().getParent((ITeamAreaHandle)element)) != null) {
                    teamAreaHandles.add(element);
                }
            }
            catch (TeamAreaHierarchyException e) {
                return null;
            }
            List teamAreas = manager.fetchCompleteItems(teamAreaHandles, 0, (IProgressMonitor)progress.newChild(90));
            String[] result = new String[1 + teamAreas.size() + 1];
            result[0] = projectArea.getName();
            result[result.length - 1] = teamArea.getName();
            int i = result.length - 2;
            for (ITeamArea parentTeamArea : teamAreas) {
                result[i] = parentTeamArea.getName();
                --i;
            }
            return result;
        }
        if (processArea instanceof IProjectArea) {
            IProjectArea projectArea = (IProjectArea)processArea;
            return new String[]{projectArea.getName()};
        }
        return null;
    }

    public static IProcessArea fromPath(IProjectArea projectArea, String[] processAreaPath, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)processAreaPath.length);
        if (processAreaPath.length == 0 || !processAreaPath[0].equals(projectArea.getName())) {
            return null;
        }
        if (processAreaPath.length == 1) {
            return projectArea;
        }
        IItemManager manager = ((ITeamRepository)projectArea.getOrigin()).itemManager();
        Set teamAreaHandles = projectArea.getTeamAreaHierarchy().getRoots();
        List teamAreas = manager.fetchCompleteItems(new ArrayList(teamAreaHandles), 0, (IProgressMonitor)progress.newChild(1));
        ITeamArea teamArea = null;
        int level = 1;
        while (true) {
            if ((teamArea = ProcessAreaUtil.findTeamArea(processAreaPath[level], teamAreas)) == null) {
                return null;
            }
            if (level == processAreaPath.length) break;
            try {
                teamAreaHandles = projectArea.getTeamAreaHierarchy().getChildren((ITeamAreaHandle)teamArea);
            }
            catch (TeamAreaHierarchyException e) {
                return null;
            }
            teamAreas = manager.fetchCompleteItems(new ArrayList(teamAreaHandles), 0, (IProgressMonitor)progress.newChild(1));
            ++level;
        }
        return teamArea;
    }

    private static ITeamArea findTeamArea(String teamAreaName, List<ITeamArea> teamAreas) {
        for (ITeamArea teamArea : teamAreas) {
            if (!teamAreaName.equals(teamArea.getName())) continue;
            return teamArea;
        }
        return null;
    }

    public static String toString(String[] path) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < path.length) {
            result.append(path[i]);
            if (i < path.length - 1) {
                result.append('/');
            }
            ++i;
        }
        return result.toString();
    }

    public static String[] fromString(String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i] = st.nextToken();
            ++i;
        }
        return result;
    }

    public static String getRoleLabel(IRole role) {
        if (role instanceof IRole2) {
            return ((IRole2)role).getRoleLabel();
        }
        return role.getId();
    }

    public static Collection<IRole> getRoles(AbstractProcessAspect aspect, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ITeamRepository repo = (ITeamRepository)processArea.getOrigin();
        IProcessItemService service = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
        IClientProcess clientProcess = service.getClientProcess(processArea, (IProgressMonitor)progress.newChild(1));
        return Arrays.asList(clientProcess.getRoles(processArea, (IProgressMonitor)progress.newChild(1)));
    }
}

