/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.common.internal.process.ProcessAreaEntry;
import com.ibm.team.filesystem.ide.ui.process.ComponentPermissionsDefinitionBlock;
import com.ibm.team.filesystem.ide.ui.process.PermissionsPicker;
import com.ibm.team.filesystem.ide.ui.process.ProcessAreaPath;
import com.ibm.team.filesystem.ide.ui.process.ProcessAreaUtil;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.ide.ui.editors.form.AbstractProcessAspect;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PermissionsPickerModel {
    public static Node getProcessHierarchy(AbstractProcessAspect aspect, IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List teamAreaHandles = projectArea.getTeamAreas();
        IItemManager manager = ((ITeamRepository)projectArea.getOrigin()).itemManager();
        List teamAreas = manager.fetchCompleteItems(teamAreaHandles, 0, (IProgressMonitor)progress.newChild(50));
        HashMap<UUID, ITeamArea> uuid2teamArea = new HashMap<UUID, ITeamArea>();
        for (ITeamArea teamArea : teamAreas) {
            uuid2teamArea.put(teamArea.getItemId(), teamArea);
        }
        progress.setWorkRemaining(teamAreas.size() + 1);
        Node result = new Node((IProcessArea)projectArea, ProcessAreaUtil.getRoles(aspect, (IProcessArea)projectArea, (IProgressMonitor)progress.newChild(1)), null);
        for (ITeamAreaHandle teamAreaHandle : projectArea.getTeamAreaHierarchy().getRoots()) {
            PermissionsPickerModel.addChild(aspect, teamAreaHandle, projectArea, result, uuid2teamArea, progress);
        }
        return result;
    }

    public static void applyPreselection(Node node, ComponentPermissionsDefinitionBlock.PersistedPermissions settings) {
        Set<String> roleIds = null;
        for (ProcessAreaEntry entry : settings.getProcessAreaToRoles().keySet()) {
            if (entry.getProcessAreaId() != null && entry.getProcessAreaId().equals(node.element.getItemId().getUuidValue())) {
                roleIds = settings.getProcessAreaToRoles().get(entry);
                break;
            }
            if (entry.getProcessAreaId() != null || !entry.getProcessAreaPath().equals(node.getProcessAreaPath().toString())) continue;
            roleIds = settings.getProcessAreaToRoles().get(entry);
            break;
        }
        if (roleIds != null) {
            for (IRole role : node.roles) {
                if (!roleIds.contains(role.getId())) continue;
                node.selectedRoles.add(role);
            }
        }
        for (Node child : node.children) {
            PermissionsPickerModel.applyPreselection(child, settings);
        }
    }

    private static void addChild(AbstractProcessAspect aspect, ITeamAreaHandle childHandle, IProjectArea projectArea, Node parent, HashMap<UUID, ITeamArea> uuid2teamArea, SubMonitor progress) throws TeamRepositoryException {
        ITeamArea teamArea = uuid2teamArea.get(childHandle.getItemId());
        if (teamArea == null) {
            return;
        }
        Node child = new Node((IProcessArea)teamArea, ProcessAreaUtil.getRoles(aspect, (IProcessArea)teamArea, (IProgressMonitor)progress.newChild(1)), parent);
        if (!child.element.isArchived()) {
            parent.children.add(child);
            for (ITeamAreaHandle teamAreaHandle : projectArea.getTeamAreaHierarchy().getChildren((ITeamAreaHandle)teamArea)) {
                PermissionsPickerModel.addChild(aspect, teamAreaHandle, projectArea, child, uuid2teamArea, progress);
            }
        }
    }

    public static void clearSelectedRoles(Node node) {
        node.selectedRoles.clear();
        for (Node child : node.children) {
            PermissionsPickerModel.clearSelectedRoles(child);
        }
    }

    public static void setRolesAndPaths(Node node, PermissionsPicker.Permissions result) {
        IProcessArea processArea = node.element;
        Collection<IRole> roles = node.selectedRoles;
        if (!roles.isEmpty()) {
            ProcessAreaPath path = node.getProcessAreaPath();
            result.setRolesAndPath(processArea, roles, path);
        }
        for (Node child : node.children) {
            PermissionsPickerModel.setRolesAndPaths(child, result);
        }
    }

    public static class Node {
        IProcessArea element;
        Collection<IRole> roles;
        Collection<IRole> selectedRoles;
        Set<Node> children = new HashSet<Node>();
        Node parent;

        public Node(IProcessArea element, Collection<IRole> roles, Node parent) {
            this.element = element;
            this.roles = roles;
            this.selectedRoles = new HashSet<IRole>();
            this.parent = parent;
        }

        public ProcessAreaPath getProcessAreaPath() {
            ArrayList<IProcessArea> path = new ArrayList<IProcessArea>();
            Node node = this;
            do {
                path.add(node.element);
            } while ((node = node.parent) != null);
            Collections.reverse(path);
            return new ProcessAreaPath(path);
        }
    }
}

