/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.common.internal.process.ComponentIdNamePair;
import com.ibm.team.filesystem.common.internal.process.ProcessAreaEntry;
import com.ibm.team.filesystem.ide.ui.internal.util.TableUtil;
import com.ibm.team.filesystem.ide.ui.process.ComponentPermissionsDefinitionBlock;
import com.ibm.team.filesystem.ide.ui.process.PermissionsPickerModel;
import com.ibm.team.filesystem.ide.ui.process.ProcessAreaPath;
import com.ibm.team.filesystem.ide.ui.process.ProcessAreaUtil;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.internal.ide.ui.editors.form.AbstractProcessAspect;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PermissionsPicker
extends TitleAreaDialog {
    Display display;
    Group componentOwnerGroup;
    Button componentOwnerButton;
    Group roleAssigmentsGroup;
    CheckboxTableViewer roleViewer;
    Group teamAreaGroup;
    TreeViewer teamAreaViewer;
    volatile PermissionsPickerModel.Node processHierarchy;
    JobRunner jobRunner = new JobRunner(false);
    ITeamRepository repo;
    AbstractProcessAspect aspect;
    IProcessItem processItem;
    IProjectArea projectArea;
    StandardLabelProvider slp;
    ComponentPermissionsDefinitionBlock.PersistedPermissions initialSelection;
    IWorkspace stream;
    List<ComponentIdNamePair> componentIdNamePairs;
    List<IWorkspace> sourceWorkspaces;
    Group sourceWorkspacesGroup;
    private TableViewer sourceWorkspacesViewer;
    private ViewerComparator sourceWorkspacesComparator;
    private LabelProvider sourceWorkspacesLabelProvider;
    private IStructuredContentProvider sourceWorkspacesContentProvider;
    private Button removeSourceWorkspacesButton;
    private ResourceManager fResources;
    Permissions result = new Permissions();
    volatile boolean initialized = false;

    public PermissionsPicker(Shell shell, ITeamRepository repo, AbstractProcessAspect aspect, IProcessItem processItem, IWorkspace stream, List<ComponentIdNamePair> componentIdNamePairs) {
        super(shell);
        this.display = shell.getDisplay();
        this.repo = repo;
        this.aspect = aspect;
        this.processItem = processItem;
        this.stream = stream;
        this.componentIdNamePairs = componentIdNamePairs;
        this.sourceWorkspaces = new ArrayList<IWorkspace>();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PermissionsPicker_0);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(Messages.PermissionsPicker_1);
        String message = this.componentIdNamePairs.size() == 1 ? NLS.bind((String)Messages.PermissionsPicker_2, (Object)this.componentIdNamePairs.get(0).getComponentName(), (Object)this.stream.getName()) : NLS.bind((String)Messages.PermissionsPicker_14, (Object)this.componentIdNamePairs.size(), (Object)this.stream.getName());
        this.setMessage(message);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite clientPane = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)clientPane);
        this.componentOwnerGroup = new Group(clientPane, 0);
        this.componentOwnerGroup.setText(Messages.PermissionsPicker_3);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.componentOwnerGroup);
        Label componentOwnerLabel = new Label((Composite)this.componentOwnerGroup, 0);
        componentOwnerLabel.setText(Messages.PermissionsPicker_8);
        GridDataFactory.fillDefaults().applyTo((Control)componentOwnerLabel);
        this.componentOwnerButton = new Button((Composite)this.componentOwnerGroup, 32);
        this.componentOwnerButton.setText(Messages.PermissionsPicker_3);
        GridDataFactory.fillDefaults().applyTo((Control)this.componentOwnerButton);
        this.createRoleAssignmentSection(clientPane);
        this.createSourceWorkspacesSection(clientPane);
        PermissionsPicker.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo(clientPane);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo((Composite)this.componentOwnerGroup);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo((Composite)this.roleAssigmentsGroup);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo((Composite)this.sourceWorkspacesGroup);
        this.jobRunner.enqueue(Messages.PermissionsPicker_7, (Operation)new RepositoryOperation(this.repo){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (PermissionsPicker.this.processItem instanceof ITeamArea) {
                    ITeamArea teamArea = (ITeamArea)PermissionsPicker.this.processItem;
                    IProjectAreaHandle handle = teamArea.getProjectArea();
                    PermissionsPicker.this.projectArea = (IProjectArea)PermissionsPicker.this.repo.itemManager().fetchCompleteItem((IItemHandle)handle, 1, (IProgressMonitor)progress.newChild(10));
                } else if (PermissionsPicker.this.processItem instanceof IProjectArea) {
                    PermissionsPicker.this.projectArea = (IProjectArea)PermissionsPicker.this.processItem;
                }
                progress.setWorkRemaining(100);
                PermissionsPicker.this.processHierarchy = PermissionsPickerModel.getProcessHierarchy(PermissionsPicker.this.aspect, PermissionsPicker.this.projectArea, (IProgressMonitor)progress.newChild(50));
                ArrayList<IItemHandle> workspaceHandles = new ArrayList<IItemHandle>(PermissionsPicker.this.initialSelection.uuid2sourceWorkspaceName.size());
                for (String workspaceItemId : PermissionsPicker.this.initialSelection.uuid2sourceWorkspaceName.keySet()) {
                    workspaceHandles.add(IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceItemId), null));
                }
                List workspaces = PermissionsPicker.this.repo.itemManager().fetchCompleteItems(workspaceHandles, 1, (IProgressMonitor)progress.newChild(50));
                for (IWorkspace workspace : workspaces) {
                    if (workspace == null) continue;
                    PermissionsPicker.this.sourceWorkspaces.add(workspace);
                }
                PermissionsPicker.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PermissionsPicker.this.initViewers();
                    }
                });
            }
        });
        return composite;
    }

    private void createRoleAssignmentSection(Composite clientPane) {
        this.roleAssigmentsGroup = new Group(clientPane, 0);
        this.roleAssigmentsGroup.setText(Messages.PermissionsPicker_4);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.roleAssigmentsGroup);
        Label roleLabel = new Label((Composite)this.roleAssigmentsGroup, 0);
        roleLabel.setText(Messages.PermissionsPicker_9);
        GridDataFactory.fillDefaults().span(1, 2).applyTo((Control)roleLabel);
        Label selectProcessAreaLabel = new Label((Composite)this.roleAssigmentsGroup, 0);
        selectProcessAreaLabel.setText(Messages.PermissionsPicker_12);
        GridDataFactory.fillDefaults().applyTo((Control)selectProcessAreaLabel);
        this.teamAreaViewer = new TreeViewer((Composite)this.roleAssigmentsGroup, 2048);
        this.initPendingNode(this.teamAreaViewer);
        GridDataFactory.fillDefaults().hint(-1, this.convertVerticalDLUsToPixels(40)).grab(true, true).applyTo((Control)this.teamAreaViewer.getTree());
        Label selectRoleLabel = new Label((Composite)this.roleAssigmentsGroup, 0);
        selectRoleLabel.setText(Messages.PermissionsPicker_11);
        GridDataFactory.fillDefaults().applyTo((Control)selectRoleLabel);
        this.roleViewer = CheckboxTableViewer.newCheckList((Composite)this.roleAssigmentsGroup, (int)2048);
        this.roleViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        LabelProvider roleLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                IRole role = (IRole)element;
                return ProcessAreaUtil.getRoleLabel(role);
            }
        };
        this.roleViewer.setSorter(new ViewerSorter());
        this.roleViewer.setLabelProvider((IBaseLabelProvider)roleLabelProvider);
        this.roleViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)PermissionsPicker.this.teamAreaViewer.getSelection();
                PermissionsPickerModel.Node selectedProcessArea = (PermissionsPickerModel.Node)ss.getFirstElement();
                Object[] checkedElements = PermissionsPicker.this.roleViewer.getCheckedElements();
                ArrayList<IRole> roles = new ArrayList<IRole>();
                Object[] objectArray = checkedElements;
                int n = checkedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object checkedElement = objectArray[n2];
                    roles.add((IRole)checkedElement);
                    ++n2;
                }
                selectedProcessArea.selectedRoles = roles;
                PermissionsPicker.this.teamAreaViewer.refresh((Object)selectedProcessArea);
            }
        });
        GridDataFactory.fillDefaults().hint(-1, this.convertVerticalDLUsToPixels(40)).grab(true, true).grab(true, true).applyTo((Control)this.roleViewer.getTable());
    }

    private void createSourceWorkspacesSection(Composite clientPane) {
        this.sourceWorkspacesGroup = new Group(clientPane, 0);
        this.sourceWorkspacesGroup.setText(Messages.PermissionsPicker_SOURCE_WORKSPACES_HEADER);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.sourceWorkspacesGroup);
        Label sourceWorkspaceLabel = new Label((Composite)this.sourceWorkspacesGroup, 0);
        sourceWorkspaceLabel.setText(Messages.PermissionsPicker_SOURCE_WORKSPACES_LABEL);
        GridDataFactory.fillDefaults().applyTo((Control)sourceWorkspaceLabel);
        Composite composite = new Composite((Composite)this.sourceWorkspacesGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Table table = new Table(composite, 2818);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    PermissionsPicker.this.doRemoveSourceWorkspace();
                }
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 200, true));
        table.setLayout((Layout)tableLayout);
        new TableColumn(table, 0);
        this.sourceWorkspacesComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                return ((IWorkspace)o1).getName().compareToIgnoreCase(((IWorkspace)o2).getName());
            }
        };
        this.sourceWorkspacesLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                IWorkspace workspace = (IWorkspace)element;
                return workspace.getName();
            }

            public Image getImage(Object element) {
                IWorkspace workspace = (IWorkspace)element;
                ImageDescriptor imageDesc = workspace.isStream() ? ImagePool.STREAM : ImagePool.WORKSPACE;
                return this.getImage(imageDesc);
            }

            private Image getImage(ImageDescriptor imageDescriptor) {
                Object o = PermissionsPicker.this.fResources.get((DeviceResourceDescriptor)imageDescriptor);
                if (o instanceof Image) {
                    return (Image)o;
                }
                return null;
            }
        };
        this.sourceWorkspacesContentProvider = new IStructuredContentProvider(){

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object element) {
                if (element instanceof ArrayList) {
                    ArrayList workspaces = (ArrayList)element;
                    return workspaces.toArray(new Object[workspaces.size()]);
                }
                return new Object[0];
            }
        };
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PermissionsPicker.this.removeSourceWorkspacesButton.setEnabled(PermissionsPicker.this.sourceWorkspaces.size() > 0);
            }
        };
        this.sourceWorkspacesViewer = new TableViewer(table);
        this.sourceWorkspacesViewer.setLabelProvider((IBaseLabelProvider)this.sourceWorkspacesLabelProvider);
        this.sourceWorkspacesViewer.setContentProvider((IContentProvider)this.sourceWorkspacesContentProvider);
        this.sourceWorkspacesViewer.setComparator(this.sourceWorkspacesComparator);
        this.sourceWorkspacesViewer.addSelectionChangedListener(listener);
        this.sourceWorkspacesViewer.setInput(this.sourceWorkspaces);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 3).hint(-1, -1).applyTo((Control)table);
        this.createPushButton(composite, Messages.PermissionsPicker_SOURCE_WORKSPACES_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PermissionsPicker.this.doAddSourceWorkspace();
            }
        });
        this.removeSourceWorkspacesButton = this.createPushButton(composite, Messages.PermissionsPicker_SOURCE_WORKSPACES_REMOVE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PermissionsPicker.this.doRemoveSourceWorkspace();
            }
        });
        this.removeSourceWorkspacesButton.setEnabled(this.sourceWorkspaces.size() > 0);
    }

    private Button createPushButton(Composite parent, String text, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.addSelectionListener(listener);
        int minX = Math.max(button.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
        GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)button);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, Messages.PermissionsPicker_6, false);
        Button button = this.getButton(1024);
        button.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                PermissionsPicker.this.componentOwnerButton.setSelection(false);
                PermissionsPickerModel.clearSelectedRoles(PermissionsPicker.this.processHierarchy);
                PermissionsPicker.this.roleViewer.setAllChecked(false);
                PermissionsPicker.this.teamAreaViewer.refresh();
                PermissionsPicker.this.roleViewer.refresh();
                PermissionsPicker.this.sourceWorkspaces.clear();
                PermissionsPicker.this.sourceWorkspacesViewer.refresh();
            }
        });
        button.setEnabled(false);
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        this.result.componentOwner = this.componentOwnerButton.getSelection();
        PermissionsPickerModel.setRolesAndPaths(this.processHierarchy, this.result);
        this.result.setSourceWorkspaces(this.sourceWorkspaces);
        super.okPressed();
    }

    void updateUIRoles() {
        PermissionsPickerModel.Node selectedProcessArea = (PermissionsPickerModel.Node)((IStructuredSelection)this.teamAreaViewer.getSelection()).getFirstElement();
        if (selectedProcessArea == null) {
            this.roleViewer.setInput(null);
            return;
        }
        this.roleViewer.setInput((Object)selectedProcessArea.roles.toArray());
        this.roleViewer.setCheckedElements(selectedProcessArea.selectedRoles.toArray());
    }

    void initPendingNode(TreeViewer teamAreaViewer) {
        teamAreaViewer.setContentProvider((IContentProvider)new DefaultTreeContentProvider());
        teamAreaViewer.setInput((Object)new Object[]{Messages.PermissionsPicker_16});
    }

    void initViewers() {
        this.teamAreaViewer.setInput(null);
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object element) {
                if (element == PermissionsPicker.this) {
                    return new Object[]{PermissionsPicker.this.processHierarchy};
                }
                PermissionsPickerModel.Node node = (PermissionsPickerModel.Node)element;
                return node.children.toArray();
            }

            public boolean hasChildren(Object element) {
                if (element == PermissionsPicker.this) {
                    return true;
                }
                PermissionsPickerModel.Node node = (PermissionsPickerModel.Node)element;
                return !node.children.isEmpty();
            }

            public Object getParent(Object element) {
                if (element == PermissionsPicker.this) {
                    return null;
                }
                PermissionsPickerModel.Node node = (PermissionsPickerModel.Node)element;
                return node.parent != null ? node.parent : this;
            }

            public Object[] getChildren(Object arg0) {
                return this.getElements(arg0);
            }
        };
        this.teamAreaViewer.setContentProvider((IContentProvider)contentProvider);
        this.slp = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                PermissionsPickerModel.Node node = (PermissionsPickerModel.Node)element;
                if (node.element instanceof IProjectArea) {
                    return ((IProjectArea)node.element).getName();
                }
                return PermissionsPicker.this.slp.getText((Object)node.element);
            }

            public Image getImage(Object element) {
                PermissionsPickerModel.Node node = (PermissionsPickerModel.Node)element;
                return PermissionsPicker.this.slp.getImage((Object)node.element);
            }
        };
        LabelDecorator labelDecorator = new LabelDecorator(){

            public String decorateText(String text, Object element) {
                PermissionsPickerModel.Node node = (PermissionsPickerModel.Node)element;
                Collection<IRole> roles = node.selectedRoles;
                if (roles != null && !roles.isEmpty()) {
                    ArrayList<String> roleLabels = new ArrayList<String>();
                    for (IRole role : roles) {
                        roleLabels.add(ProcessAreaUtil.getRoleLabel(role));
                    }
                    String decoration = TableUtil.group(roleLabels, ", ", true);
                    text = String.valueOf(text) + NLS.bind((String)Messages.PermissionsPicker_13, (Object)decoration);
                }
                return text;
            }

            public String decorateText(String text, Object element, IDecorationContext arg2) {
                return this.decorateText(text, element);
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public boolean prepareDecoration(Object arg0, String arg1, IDecorationContext arg2) {
                return true;
            }

            public Image decorateImage(Image arg0, Object arg1) {
                return null;
            }

            public Image decorateImage(Image arg0, Object arg1, IDecorationContext arg2) {
                return null;
            }

            public void dispose() {
            }

            public void removeListener(ILabelProviderListener arg0) {
            }
        };
        this.teamAreaViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelDecorator));
        this.teamAreaViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PermissionsPicker.this.updateUIRoles();
            }
        });
        this.teamAreaViewer.setInput((Object)this);
        this.teamAreaViewer.expandAll();
        this.componentOwnerButton.setSelection(this.initialSelection.componentOwner);
        this.teamAreaViewer.setSelection((ISelection)new StructuredSelection((Object)this.processHierarchy));
        this.teamAreaViewer.setSorter(new ViewerSorter());
        PermissionsPickerModel.applyPreselection(this.processHierarchy, this.initialSelection);
        this.teamAreaViewer.refresh();
        this.sourceWorkspacesViewer.refresh();
        this.initialized = true;
        this.getButton(1024).setEnabled(true);
        this.getButton(0).setEnabled(true);
    }

    public Permissions getSelectedPermissions() {
        return this.result;
    }

    public void setInitialSelection(Collection<ComponentPermissionsDefinitionBlock.PersistedPermissions> permissions) {
        this.initialSelection = new ComponentPermissionsDefinitionBlock.PersistedPermissions();
        for (ComponentPermissionsDefinitionBlock.PersistedPermissions initialPermissions : permissions) {
            if (initialPermissions.componentOwner) {
                this.initialSelection.componentOwner = true;
            }
            for (ProcessAreaEntry entry : initialPermissions.processAreaToRoles.keySet()) {
                Set<String> roleIds = this.initialSelection.processAreaToRoles.get(entry);
                if (roleIds == null) {
                    roleIds = new HashSet<String>();
                    this.initialSelection.processAreaToRoles.put(entry, roleIds);
                }
                roleIds.addAll((Collection<String>)initialPermissions.processAreaToRoles.get(entry));
            }
            this.initialSelection.uuid2sourceWorkspaceName.putAll(initialPermissions.uuid2sourceWorkspaceName);
        }
    }

    private void doAddSourceWorkspace() {
        AbstractPlaceWrapper[] pwList = WorkspaceAndStreamSelectionDialog.getWorkspacesOrStreams(this.getShell(), this.repo, null);
        if (pwList == null || pwList.length == 0) {
            return;
        }
        AbstractPlaceWrapper[] abstractPlaceWrapperArray = pwList;
        int n = pwList.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPlaceWrapper pw = abstractPlaceWrapperArray[n2];
            boolean found = false;
            IWorkspace selectedWorkspace = pw.getWorkspace();
            for (IWorkspace sourceWorkspace : this.sourceWorkspaces) {
                if (!selectedWorkspace.sameItemId((IItemHandle)sourceWorkspace)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.sourceWorkspaces.add(selectedWorkspace);
            }
            ++n2;
        }
        this.sourceWorkspacesViewer.refresh();
    }

    private void doRemoveSourceWorkspace() {
        ArrayList<IWorkspace> selectedWorkspaces = new ArrayList<IWorkspace>();
        ISelection selection = this.sourceWorkspacesViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!(element instanceof IWorkspace)) continue;
                selectedWorkspaces.add((IWorkspace)element);
            }
        }
        if (selectedWorkspaces.isEmpty()) {
            return;
        }
        block1: for (IWorkspace selectedWorkspace : selectedWorkspaces) {
            for (IWorkspace sourceWorkspace : this.sourceWorkspaces) {
                if (!selectedWorkspace.sameItemId((IItemHandle)sourceWorkspace)) continue;
                this.sourceWorkspaces.remove(sourceWorkspace);
                continue block1;
            }
        }
        Table table = this.sourceWorkspacesViewer.getTable();
        int[] selectionIndices = table.getSelectionIndices();
        if (selectionIndices.length > 0) {
            int newIndex = table.getItemCount() - selectionIndices.length - 1;
            int i = 0;
            while (i < selectionIndices.length) {
                if (selectionIndices[i] < newIndex) {
                    newIndex = selectionIndices[i];
                }
                ++i;
            }
            this.sourceWorkspacesViewer.refresh();
            if (newIndex > -1 && newIndex <= table.getItemCount()) {
                Object data = table.getItem(newIndex).getData();
                StructuredSelection newSelection = new StructuredSelection(data);
                this.sourceWorkspacesViewer.setSelection((ISelection)newSelection);
            }
        }
    }

    public static Permissions pickPermissions(Shell shell, ITeamRepository repo, AbstractProcessAspect aspect, IProcessItem processItem, IWorkspace stream, List<ComponentIdNamePair> componentIdNamePairs, Collection<ComponentPermissionsDefinitionBlock.PersistedPermissions> permissions) {
        PermissionsPicker picker = new PermissionsPicker(shell, repo, aspect, processItem, stream, componentIdNamePairs);
        if (permissions != null) {
            picker.setInitialSelection(permissions);
        }
        return picker.open() == 0 ? picker.getSelectedPermissions() : null;
    }

    class DefaultTreeContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        DefaultTreeContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    public static class Permissions {
        public boolean componentOwner = false;
        public HashMap<UUID, IProcessArea> uuid2processAreas = new HashMap();
        public HashMap<UUID, Collection<IRole>> uuid2roles = new HashMap();
        public HashMap<UUID, ProcessAreaPath> uuid2path = new HashMap();
        public HashMap<UUID, IWorkspace> uuid2sourceWorkspaces = new HashMap();

        public void setRolesAndPath(IProcessArea processArea, Collection<IRole> roles, ProcessAreaPath path) {
            this.uuid2processAreas.put(processArea.getItemId(), processArea);
            this.uuid2roles.put(processArea.getItemId(), roles);
            this.uuid2path.put(processArea.getItemId(), path);
        }

        public void setSourceWorkspaces(Collection<IWorkspace> workspaces) {
            for (IWorkspace workspace : workspaces) {
                this.uuid2sourceWorkspaces.put(workspace.getItemId(), workspace);
            }
        }

        public Collection<IRole> getRoles(IProcessArea processArea) {
            return this.uuid2roles.get(processArea.getItemId());
        }

        public Collection<IProcessArea> getProcessAreas() {
            return this.uuid2processAreas.values();
        }

        public ProcessAreaPath getProcessAreaPath(IProcessArea processArea) {
            return this.uuid2path.get(processArea.getItemId());
        }

        public Collection<IWorkspace> getSourceWorkspaces() {
            return this.uuid2sourceWorkspaces.values();
        }
    }
}

