/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.internal.filesystem.ui.wizards.join.NewWorkspaceSeedData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.AbstractConfigurationDataAspectEditor;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.internal.common.NLS;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NewWorkspaceConfigurationDataAspectEditor
extends AbstractConfigurationDataAspectEditor {
    private final String processAspectId;
    private String namePattern;
    private int selectedReadScope;
    private Text nameField;
    private Combo readScopeField;
    private String[] scopeList = new String[]{Messages.NewWorkspaceConfigurationDataAspectEditor_0, Messages.NewWorkspaceConfigurationDataAspectEditor_1, Messages.NewWorkspaceConfigurationDataAspectEditor_3};
    private String[] scopeValues = new String[]{"private", "public", "project"};

    public NewWorkspaceConfigurationDataAspectEditor(String processAspectId) {
        this.processAspectId = processAspectId;
    }

    protected boolean saveState(IMemento memento) {
        String readScope;
        memento.putString("id", this.processAspectId);
        String namespace = this.getAspect().getSchemaNamespaceURI();
        if (namespace != null) {
            memento.putString("xmlns", namespace);
        }
        IMemento child = memento.createChild("newWorkspaceConfigurationData");
        if (this.namePattern != null && this.namePattern.length() > 0) {
            child.putString("namePattern", this.namePattern);
        }
        if ((readScope = this.getReadScopeForIndex(this.selectedReadScope)) != null) {
            child.putString("readScope", readScope);
        }
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Label descriptionLabel = toolkit.createLabel(parent, NLS.bind((String)Messages.NewWorkspaceConfigurationDataAspectEditor_6, (Object)"${stream-name}", (Object)"${user-id}"), 64);
        GridDataFactory.defaultsFor((Control)descriptionLabel).span(2, 1).applyTo((Control)descriptionLabel);
        Label namelabel = toolkit.createLabel(parent, Messages.NewWorkspaceConfigurationDataAspectEditor_4, 0);
        namelabel.setLayoutData((Object)new GridData());
        this.nameField = toolkit.createText(parent, null, 2052);
        this.nameField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!NewWorkspaceConfigurationDataAspectEditor.this.nameField.getText().equals(NewWorkspaceConfigurationDataAspectEditor.this.namePattern)) {
                    NewWorkspaceConfigurationDataAspectEditor.this.namePattern = NewWorkspaceConfigurationDataAspectEditor.this.nameField.getText();
                    NewWorkspaceConfigurationDataAspectEditor.this.setDirty();
                }
            }
        });
        Label readScopeLabel = toolkit.createLabel(parent, Messages.NewWorkspaceConfigurationDataAspectEditor_5, 0);
        readScopeLabel.setLayoutData((Object)new GridData());
        this.readScopeField = new Combo(parent, 8);
        this.readScopeField.setLayoutData((Object)new GridData(4, 4, true, false));
        toolkit.adapt((Composite)this.readScopeField);
        this.readScopeField.setItems(this.scopeList);
        this.readScopeField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (NewWorkspaceConfigurationDataAspectEditor.this.readScopeField.getSelectionIndex() != NewWorkspaceConfigurationDataAspectEditor.this.selectedReadScope) {
                    NewWorkspaceConfigurationDataAspectEditor.this.selectedReadScope = NewWorkspaceConfigurationDataAspectEditor.this.readScopeField.getSelectionIndex();
                    NewWorkspaceConfigurationDataAspectEditor.this.setDirty();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        this.updateWidgets();
    }

    public boolean needsApplyAndRevertButtons() {
        return true;
    }

    public void dispose() {
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.init();
    }

    public void revert() {
        this.init();
        this.updateWidgets();
        this.setDirty(false);
    }

    private void init() {
        List childElements;
        ModelElement root = this.getAspect().getConfigurationElement();
        this.selectedReadScope = 0;
        if (root != null && (childElements = root.getChildElements()).size() == 1) {
            IProcessConfigurationElement element = (IProcessConfigurationElement)childElements.get(0);
            this.namePattern = element.getAttribute("namePattern");
            String readScopeValue = element.getAttribute("readScope");
            this.selectedReadScope = this.getReadScopeValueIndex(readScopeValue);
        }
        if (this.namePattern == null || this.namePattern.length() == 0) {
            this.namePattern = NewWorkspaceSeedData.getDefaultWorkspaceName("${stream-name}");
        }
    }

    private int getReadScopeValueIndex(String readScopeValue) {
        if (readScopeValue != null) {
            int i = 0;
            while (i < this.scopeValues.length) {
                String value = this.scopeValues[i];
                if (readScopeValue.equals(value)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    private String getReadScopeForIndex(int index) {
        if (index < 0 || index >= this.scopeValues.length) {
            return null;
        }
        return this.scopeValues[index];
    }

    private void updateWidgets() {
        this.nameField.setText(this.namePattern);
        this.readScopeField.select(this.selectedReadScope);
    }
}

