/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MessageBox {
    private FormToolkit fToolkit;
    private Composite fContainer;
    private Label fImage;
    private Label fMessage;
    private ProcessAspectEditor fEditor;

    public Composite createControl(Composite parent, FormToolkit toolkit, ProcessAspectEditor editor) {
        this.fToolkit = toolkit;
        this.fEditor = editor;
        this.fContainer = this.fToolkit.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        this.fContainer.setLayout((Layout)layout);
        return this.fContainer;
    }

    public void clearMessage() {
        if (this.fImage != null && !this.fImage.isDisposed()) {
            this.fImage.dispose();
            this.fImage = null;
        }
        if (this.fMessage != null && !this.fMessage.isDisposed()) {
            this.fMessage.dispose();
            this.fMessage = null;
        }
        this.fContainer.getParent().layout(true);
    }

    public void setErrorMessage(String message) {
        this.setMessage(1, message);
    }

    public void setWarningMessage(String message) {
        this.setMessage(8, message);
    }

    public void setInformationMessage(String message) {
        this.setMessage(2, message);
    }

    private void setMessage(int systemImage, String message) {
        boolean forceLayout = false;
        if (this.fImage == null) {
            this.fImage = this.fToolkit.createLabel(this.fContainer, "");
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, true).applyTo((Control)this.fImage);
            forceLayout = true;
        }
        this.fImage.setImage(this.fImage.getDisplay().getSystemImage(systemImage));
        if (this.fMessage == null) {
            this.fMessage = this.fToolkit.createLabel(this.fContainer, message, 64);
            int w = LayoutConstants.getSpacing().x * 40;
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).hint(w, -1).applyTo((Control)this.fMessage);
            forceLayout = true;
        } else {
            this.fMessage.setText(message);
        }
        this.forceLayout(forceLayout);
    }

    private void forceLayout(boolean forceLayout) {
        if (forceLayout && this.fEditor != null) {
            this.fEditor.getSite().reflow();
        }
        this.fContainer.getParent().layout(true);
    }
}

