/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.common.internal.process.serialization.RequiredContentAdvisorData;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.ide.ui.process.providers.ParsedUnifiedDescriptionRegistry;
import com.ibm.team.process.client.IAdvisorProblemResolutionDelegate;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.process.AdvisorDataMarshaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class InsertRequiredTextResolutionDelegate
implements IAdvisorProblemResolutionDelegate {
    private static final String TAG_INSERT_TEXT = "insertText";

    public boolean run(IAdvisorInfo info, IProgressMonitor progress) {
        List<IFile> fileList;
        AdvisorDataMarshaller.AdvisorData unified;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.InsertRequiredTextResolutionDelegate_STATUS_MESSAGE, (int)2);
        try {
            unified = ParsedUnifiedDescriptionRegistry.getInstance().parse(info);
        }
        catch (AdvisorDataMarshaller.MarshallerException e) {
            LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Unexpected exception", (Throwable)e));
            this.complain(true, Messages.InsertRequiredTextResolutionDelegate_EXCEPTION_RESOLVING_PATHS, Messages.InsertRequiredTextResolutionDelegate_EXCEPTION_RESOLVING_PATHS_DESC);
            return false;
        }
        if (unified == null) {
            return false;
        }
        if (((RequiredContentAdvisorData)unified.data).ctx instanceof IBaselineHandle) {
            this.complain(false, Messages.InsertRequiredTextResolutionDelegate_ERROR_DIALOG_TITLE, Messages.InsertRequiredTextResolutionDelegate_CANNOT_MODIFY_BASELINE);
            return false;
        }
        if (((RequiredContentAdvisorData)unified.data).insertText == null || ((RequiredContentAdvisorData)unified.data).insertText.length() == 0) {
            this.complain(false, Messages.InsertRequiredTextResolutionDelegate_0, NLS.bind((String)Messages.InsertRequiredTextResolutionDelegate_1, (Object)TAG_INSERT_TEXT));
            return false;
        }
        try {
            fileList = this.findFileList(unified, monitor.newChild(1));
        }
        catch (FileSystemException e) {
            LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Exception while resolving files", (Throwable)e));
            this.complain(true, Messages.InsertRequiredTextResolutionDelegate_EXCEPTION_RESOLVING_PATHS, Messages.InsertRequiredTextResolutionDelegate_EXCEPTION_RESOLVING_PATHS_DESC);
            return false;
        }
        return this.insertText(fileList, ((RequiredContentAdvisorData)unified.data).insertText, (IProgressMonitor)monitor.newChild(1));
    }

    private void complain(final boolean isError, final String title, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    if (isError) {
                        MessageDialog.openError((Shell)window.getShell(), (String)title, (String)message);
                    } else {
                        MessageDialog.openInformation((Shell)window.getShell(), (String)title, (String)message);
                    }
                }
            }
        });
    }

    private List<IFile> findFileList(AdvisorDataMarshaller.AdvisorData<RequiredContentAdvisorData> unified, SubMonitor monitor) throws FileSystemException {
        if (((RequiredContentAdvisorData)unified.data).iFiles != null) {
            return ((RequiredContentAdvisorData)unified.data).iFiles;
        }
        monitor.beginTask(Messages.InsertRequiredTextResolutionDelegate_STATUS_MESSAGE_PATH_LOOKUP, ((RequiredContentAdvisorData)unified.data).files.size());
        HashSet<IFile> files = new HashSet<IFile>();
        Iterator i = ((RequiredContentAdvisorData)unified.data).files.iterator();
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        while (i.hasNext()) {
            Collection shareables = sharingManager.findShareables(((RequiredContentAdvisorData)unified.data).ctx, ((RequiredContentAdvisorData)unified.data).comp, (IVersionableHandle)((RequiredContentAdvisorData.RequiredContentAdvisorDataFile)i.next()).handle, (IProgressMonitor)monitor.newChild(1));
            for (IShareable shareable : shareables) {
                IFile file = (IFile)shareable.getAdapter(IFile.class);
                if (file == null) continue;
                files.add(file);
            }
        }
        ((RequiredContentAdvisorData)unified.data).iFiles = new ArrayList(files);
        return ((RequiredContentAdvisorData)unified.data).iFiles;
    }

    protected boolean insertText(final List<IFile> files, final String insertText, final IProgressMonitor monitor) {
        final boolean[] result = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                for (IFile file : files) {
                    IDocument document;
                    IEditorPart part = InsertRequiredTextResolutionDelegate.this.openEditor(file);
                    if (!(part instanceof ITextEditor)) continue;
                    boolean wasDirty = part.isDirty();
                    IDocumentProvider documentProvider = ((ITextEditor)part).getDocumentProvider();
                    if (documentProvider == null || (document = documentProvider.getDocument((Object)part.getEditorInput())) == null) continue;
                    String text = document.get();
                    StringBuffer buffer = new StringBuffer(InsertRequiredTextResolutionDelegate.this.convertLineDelimiters(insertText, text));
                    buffer.append(text);
                    document.set(buffer.toString());
                    if (!wasDirty) {
                        part.doSave(monitor);
                    }
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    protected String convertLineDelimiters(String text, String baseText) {
        String targetDelimiter = this.getDelimiter(baseText);
        if (targetDelimiter != null) {
            StringBuffer buffer = new StringBuffer();
            if (targetDelimiter == "\r\n") {
                int i = 0;
                while (i < text.length()) {
                    char ch = text.charAt(i);
                    if (ch == '\n') {
                        if (i <= 0 || text.charAt(i - 1) != '\r') {
                            buffer.append(targetDelimiter);
                        }
                    } else if (ch == '\r') {
                        buffer.append(targetDelimiter);
                    } else {
                        buffer.append(ch);
                    }
                    ++i;
                }
                text = buffer.toString();
            } else if (targetDelimiter == "\n") {
                int i = 0;
                while (i < text.length()) {
                    char ch = text.charAt(i);
                    if (ch != '\n' || i <= 0 || text.charAt(i - 1) != '\r') {
                        if (ch == '\r') {
                            buffer.append(targetDelimiter);
                        } else {
                            buffer.append(ch);
                        }
                    }
                    ++i;
                }
                text = buffer.toString();
            } else if (targetDelimiter == "\r") {
                int i = 0;
                while (i < text.length()) {
                    char ch = text.charAt(i);
                    if (ch == '\n') {
                        if (i <= 0 || text.charAt(i - 1) != '\r') {
                            buffer.append(targetDelimiter);
                        }
                    } else {
                        buffer.append(ch);
                    }
                    ++i;
                }
                text = buffer.toString();
            }
        }
        return text;
    }

    private String getDelimiter(String baseText) {
        int i = 0;
        while (i < baseText.length()) {
            char ch = baseText.charAt(i);
            if (ch == '\n') {
                return "\n";
            }
            if (ch == '\r') {
                if (baseText.length() >= i && baseText.charAt(i + 1) == '\n') {
                    return "\r\n";
                }
                return "\r";
            }
            ++i;
        }
        return null;
    }

    public boolean mayBeApplicable(IAdvisorInfo info) {
        if (info.getProblemObject() instanceof AdvisorDataMarshaller.AdvisorData && ((AdvisorDataMarshaller.AdvisorData)info.getProblemObject()).data instanceof RequiredContentAdvisorData) {
            return true;
        }
        String data = info.getData();
        if (data == null || "".equals(data)) {
            return false;
        }
        try {
            if (ParsedUnifiedDescriptionRegistry.getInstance().parse(info) != null) {
                return true;
            }
        }
        catch (AdvisorDataMarshaller.MarshallerException marshallerException) {
            // empty catch block
        }
        return false;
    }

    public IEditorPart openEditor(IFile file) {
        IWorkbenchPage page;
        IEditorPart part = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                part = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
            }
            catch (PartInitException e) {
                StatusUtil.log((Object)this, (Throwable)e);
            }
        }
        return part;
    }
}

