/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.common.internal.process.DisallowIncomingChangeErrorDescription;
import com.ibm.team.filesystem.ide.ui.process.AbstractSourceControlAdvisorDetailProvider;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class DisallowIncomingChangeSetDetailProvider
extends AbstractSourceControlAdvisorDetailProvider {
    public DisallowIncomingChangeSetDetailProvider(Object element) {
        super(element);
    }

    @Override
    protected void appendProblem(IAdvisorInfo info, StringBuffer buffer, IProgressMonitor monitor) {
        DisallowIncomingChangeErrorDescription error;
        try {
            error = DisallowIncomingChangeErrorDescription.deserialize((String)info.getData());
        }
        catch (DisallowIncomingChangeErrorDescription.ParseException e) {
            buffer.append("Unable to parse error description: " + e.toString());
            return;
        }
        String streamWs = error.isSourceAStream != false ? Messages.DisallowIncomingChangeSetDetailProvider_STREAM_TEXT : Messages.DisallowIncomingChangeSetDetailProvider_WORKSPACE_TEXT;
        switch (error.components.size()) {
            case 0: {
                buffer.append(String.valueOf(info.getDescription()) + NLS.bind((String)Messages.DisallowIncomingChangeSetDetailProvider_MISSING_COMPONENTS, (Object)(String.valueOf(streamWs) + " \"" + DisallowIncomingChangeSetDetailProvider.escape(error.sourceName) + "\"")));
                return;
            }
            case 1: {
                String targetStreamWs = ((DisallowIncomingChangeErrorDescription.DisallowedComponent)error.components.get((int)0)).isTargetAStream != false ? Messages.DisallowIncomingChangeSetDetailProvider_STREAM_TEXT : Messages.DisallowIncomingChangeSetDetailProvider_WORKSPACE_TEXT;
                buffer.append(NLS.bind((String)Messages.DisallowIncomingChangeSetDetailProvider_STREAM_HAS_CHANGES_IN_COMPONENT, (Object[])new Object[]{String.valueOf(streamWs) + " \"" + DisallowIncomingChangeSetDetailProvider.escape(error.sourceName) + "\"", DisallowIncomingChangeSetDetailProvider.escape(((DisallowIncomingChangeErrorDescription.DisallowedComponent)error.components.get((int)0)).name), String.valueOf(targetStreamWs) + " \"" + DisallowIncomingChangeSetDetailProvider.escape(((DisallowIncomingChangeErrorDescription.DisallowedComponent)error.components.get((int)0)).targetName) + "\""}));
                return;
            }
        }
        String targetStreamWs = ((DisallowIncomingChangeErrorDescription.DisallowedComponent)error.components.get((int)0)).isTargetAStream != false ? Messages.DisallowIncomingChangeSetDetailProvider_STREAM_TEXT : Messages.DisallowIncomingChangeSetDetailProvider_WORKSPACE_TEXT;
        buffer.append(NLS.bind((String)Messages.DisallowIncomingChangeSetDetailProvider_STREAM_HAS_CHANGES_IN_COMPONENT_LIST, (Object)(String.valueOf(streamWs) + " \"" + DisallowIncomingChangeSetDetailProvider.escape(error.sourceName) + "\""), (Object)(String.valueOf(targetStreamWs) + " \"" + DisallowIncomingChangeSetDetailProvider.escape(((DisallowIncomingChangeErrorDescription.DisallowedComponent)error.components.get((int)0)).targetName) + "\"")));
        buffer.append("<ul>");
        for (DisallowIncomingChangeErrorDescription.DisallowedComponent comp : error.components) {
            buffer.append("<li>");
            buffer.append(DisallowIncomingChangeSetDetailProvider.escape(comp.name));
            buffer.append("</li>");
        }
        buffer.append("</ul>");
    }

    private static String escape(String s) {
        return XMLString.createFromPlainText((String)s).getXMLText();
    }
}

