/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.ide.ui.internal.util.DisplayHelper;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.ide.ui.process.providers.StringOrComponentWrapperLabelProvider;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import com.ibm.team.process.internal.ide.ui.editors.util.DeferredElementListSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DisallowIncomingChangeAdvisorAspectEditor
extends OperationDetailsAspectEditor {
    private TableViewer fComponentList;
    private DeferredElementListSelectionDialog fDialog;
    private ComponentBlockState initialState;
    private volatile boolean matchAll;

    public TableViewer createControl(Composite parent, FormToolkit toolkit, final ProcessAspectEditor editor) {
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(parent);
        toolkit.createLabel(parent, Messages.ComponentScopeDefinitionBlock_1);
        final Button matchAllButton = toolkit.createButton(parent, Messages.DisallowIncomingChangeAdvisorAspectEditor_MATCH_ALL_COMPONENTS_BUTTON_TEXT, 16);
        GridDataFactory.fillDefaults().align(16384, 128).grab(true, false).applyTo((Control)matchAllButton);
        matchAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                editor.setDirty();
                DisallowIncomingChangeAdvisorAspectEditor.this.matchAll = matchAllButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                editor.setDirty();
                DisallowIncomingChangeAdvisorAspectEditor.this.matchAll = matchAllButton.getSelection();
            }
        });
        final Button matchSpecificButton = toolkit.createButton(parent, Messages.DisallowIncomingChangeAdvisorAspectEditor_MATCH_SPECIFIC_COMPONENTS_BUTTON_TEXT, 16);
        GridDataFactory.fillDefaults().align(16384, 128).grab(true, false).applyTo((Control)matchSpecificButton);
        Composite componentComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(2).applyTo(componentComposite);
        GridDataFactory.fillDefaults().align(16384, 128).indent(30, 0).grab(true, true).applyTo((Control)componentComposite);
        this.fComponentList = new TableViewer(componentComposite, 2818);
        toolkit.adapt((Control)this.fComponentList.getTable(), true, true);
        this.fComponentList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fComponentList.setLabelProvider((IBaseLabelProvider)new StringOrComponentWrapperLabelProvider());
        this.fComponentList.setInput(new ArrayList());
        this.fComponentList.setComparator(new ViewerComparator());
        int h = this.fComponentList.getTable().getItemHeight() * 2;
        h = this.fComponentList.getTable().computeTrim((int)0, (int)0, (int)500, (int)h).height;
        GridDataFactory.fillDefaults().grab(true, true).hint(300, h).applyTo((Control)this.fComponentList.getTable());
        Composite buttonComposite = toolkit.createComposite(componentComposite);
        GridDataFactory.fillDefaults().align(131072, 128).grab(false, true).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(buttonComposite);
        Button addComponentButton = toolkit.createButton(buttonComposite, Messages.ComponentScopeDefinitionBlock_2, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)addComponentButton);
        addComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DisallowIncomingChangeAdvisorAspectEditor.this.addComponents(editor, (List)DisallowIncomingChangeAdvisorAspectEditor.this.fComponentList.getInput())) {
                    editor.setDirty();
                    DisallowIncomingChangeAdvisorAspectEditor.this.fComponentList.refresh();
                }
            }
        });
        final Button removeComponentButton = toolkit.createButton(buttonComposite, Messages.ComponentScopeDefinitionBlock_3, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)removeComponentButton);
        removeComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DisallowIncomingChangeAdvisorAspectEditor.this.removeComponents(editor, (List)DisallowIncomingChangeAdvisorAspectEditor.this.fComponentList.getInput())) {
                    editor.setDirty();
                    DisallowIncomingChangeAdvisorAspectEditor.this.fComponentList.refresh();
                }
            }
        });
        removeComponentButton.setEnabled(false);
        this.fComponentList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                removeComponentButton.setEnabled(selection != null && !selection.isEmpty());
            }
        });
        final Control[] controls = new Control[]{this.fComponentList.getTable(), removeComponentButton, addComponentButton};
        Display display = parent.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DisallowIncomingChangeAdvisorAspectEditor.this.setEnablementFor(controls, matchSpecificButton.getSelection());
            }
        });
        matchAllButton.setSelection(this.initialState.matchAll);
        matchSpecificButton.setSelection(!this.initialState.matchAll);
        matchSpecificButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DisallowIncomingChangeAdvisorAspectEditor.this.setEnablementFor(controls, matchSpecificButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DisallowIncomingChangeAdvisorAspectEditor.this.setEnablementFor(controls, matchSpecificButton.getSelection());
            }
        });
        Job populateCompsJob = new Job(Messages.ComponentScopeDefinitionBlock_4){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DisallowIncomingChangeAdvisorAspectEditor.this.populateComps(editor);
                }
                catch (TeamRepositoryException e) {
                    throw new RuntimeException(e);
                }
                return Status.OK_STATUS;
            }
        };
        ((ArrayList)this.fComponentList.getInput()).add(Messages.DisallowIncomingChangeAdvisorAspectEditor_LOADING_COMPONENTS);
        this.fComponentList.refresh();
        populateCompsJob.setSystem(false);
        populateCompsJob.schedule();
        return this.fComponentList;
    }

    private void setEnablementFor(Control[] widgets, boolean enabled) {
        Control[] controlArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Control w = controlArray[n2];
            w.setEnabled(enabled);
            ++n2;
        }
    }

    private void populateComps(ProcessAspectEditor editor) throws TeamRepositoryException {
        ProcessAspect aspect = editor.getAspect();
        IProcessItem underlyingProcessItem = aspect.getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        ITeamRepository repo = (ITeamRepository)underlyingProcessItem.getOrigin();
        ArrayList<IComponentHandle> compHandles = new ArrayList<IComponentHandle>(this.initialState.comps.values());
        List full = repo.itemManager().fetchCompleteItems(compHandles, 0, null);
        List comps = (List)this.fComponentList.getInput();
        comps.clear();
        for (IComponent comp : full) {
            if (comp == null) continue;
            comps.add(new ComponentWrapper(repo, comp));
        }
        Display display = this.fComponentList.getTable().getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DisallowIncomingChangeAdvisorAspectEditor.this.fComponentList.getTable().isDisposed()) {
                    return;
                }
                DisallowIncomingChangeAdvisorAspectEditor.this.fComponentList.refresh();
            }
        });
    }

    private boolean addComponents(ProcessAspectEditor editor, List<ComponentWrapper> componentNameModel) {
        ProcessAspect aspect = editor.getAspect();
        IProcessItem underlyingProcessItem = aspect.getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        final ITeamRepository repository = (ITeamRepository)underlyingProcessItem.getOrigin();
        Job fetchComponentNames = new Job(Messages.ComponentScopeDefinitionBlock_4){

            protected IStatus run(IProgressMonitor monitor) {
                List<Object> components;
                try {
                    components = this.queryComponents(repository, SubMonitor.convert((IProgressMonitor)monitor));
                }
                catch (TeamRepositoryException x) {
                    StatusUtil.log((Object)((Object)this), (Throwable)x);
                    components = Collections.singletonList(Messages.ComponentScopeDefinitionBlock_5);
                }
                final List<Object> toPassIn = components;
                DisplayHelper.asyncExec(DisallowIncomingChangeAdvisorAspectEditor.this.fComponentList.getControl(), new Runnable(){

                    @Override
                    public void run() {
                        DisallowIncomingChangeAdvisorAspectEditor.this.fDialog.setFetchingDone();
                        DisallowIncomingChangeAdvisorAspectEditor.this.fDialog.setElements(toPassIn.toArray());
                    }
                });
                return Status.OK_STATUS;
            }

            private List<ComponentWrapper> queryComponents(ITeamRepository repo, SubMonitor monitor) throws TeamRepositoryException {
                IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                List comps = workspaceManager.findComponents(IComponentSearchCriteria.FACTORY.newInstance(), Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
                List complete = repo.itemManager().fetchCompleteItems(comps, 0, (IProgressMonitor)monitor.newChild(1));
                comps = null;
                ArrayList<ComponentWrapper> wrapped = new ArrayList<ComponentWrapper>(complete.size());
                for (IComponent comp : complete) {
                    wrapped.add(new ComponentWrapper(repo, comp));
                }
                return wrapped;
            }
        };
        this.fDialog = new DeferredElementListSelectionDialog(fetchComponentNames, this.fComponentList.getControl().getShell(), (ILabelProvider)new StringOrComponentWrapperLabelProvider());
        this.fDialog.setElements((Object[])new String[]{Messages.ComponentScopeDefinitionBlock_6});
        this.fDialog.setTitle(Messages.ComponentScopeDefinitionBlock_7);
        this.fDialog.setMessage(Messages.ComponentScopeDefinitionBlock_8);
        this.fDialog.setComparator(new ViewerComparator());
        fetchComponentNames.setUser(false);
        fetchComponentNames.schedule();
        if (this.fDialog.open() != 0) {
            fetchComponentNames.cancel();
            return false;
        }
        fetchComponentNames.cancel();
        boolean added = false;
        Object[] result = this.fDialog.getResult();
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                if (result[i] instanceof ComponentWrapper) {
                    ComponentWrapper comp = (ComponentWrapper)((Object)result[i]);
                    componentNameModel.add(comp);
                    added = true;
                }
                ++i;
            }
        }
        return added;
    }

    private boolean removeComponents(ProcessAspectEditor editor, List componentNameModel) {
        ISelection selection = this.fComponentList.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return componentNameModel.removeAll(ss.toList());
        }
        return false;
    }

    public boolean saveState(IMemento memento) {
        List comps = (List)this.fComponentList.getInput();
        IMemento componentsRoot = memento.createChild("components");
        componentsRoot.putBoolean("match-all", this.matchAll);
        for (ComponentWrapper comp : comps) {
            IMemento perComp = componentsRoot.createChild("component");
            perComp.putString("uuid", comp.getComponent().getItemId().getUuidValue());
        }
        return true;
    }

    public void restoreState(IMemento memento) {
        this.initialState = new ComponentBlockState();
        this.initialState.matchAll = true;
        this.initialState.comps = new Hashtable();
        IMemento componentsRoot = memento.getChild("components");
        if (componentsRoot == null) {
            return;
        }
        this.initialState.matchAll = Boolean.valueOf(componentsRoot.getString("match-all"));
        IMemento[] iMementoArray = componentsRoot.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            String uuidStr = child.getString("uuid");
            try {
                UUID uuid = UUID.valueOf((String)uuidStr);
                IComponentHandle handle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(uuid, null);
                this.initialState.comps.put(uuid, handle);
            }
            catch (IllegalArgumentException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
            ++n2;
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Label heading = toolkit.createLabel(parent, Messages.GenericComponentScopeAspectEditor_0);
        heading.setFont(this.getBoldFont());
        this.createControl(parent, toolkit, (ProcessAspectEditor)this);
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    public void dispose() {
    }

    private static class ComponentBlockState {
        boolean matchAll;
        Hashtable<UUID, IComponentHandle> comps;

        private ComponentBlockState() {
        }
    }
}

