/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.ide.ui.advice.AdviceElementDetailProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.process.DeliverOperationData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DeliverProcessDetailProvider
extends AdviceElementDetailProvider {
    public static final String ADD_A_DESCRIPTION = Messages.DeliverProcessDetailProvider_0;

    public DeliverProcessDetailProvider(IOperationReport report) {
        super((Object)report);
    }

    protected String createDetailText() {
        IOperationReport report = (IOperationReport)this.fElement;
        AdvisableOperation operation = report.getOperation();
        if (operation == null) {
            return null;
        }
        Object data = operation.getOperationData();
        StringBuffer buffer = new StringBuffer();
        this.appendBodyAndTableStart(buffer, (IProcessReport)report);
        this.appendReportState((IProcessReport)report, buffer);
        this.appendDeliveryDetails(data, buffer);
        this.appendExplainOperationLink(report, buffer);
        buffer.append("</td></tr></table></body>");
        return buffer.toString();
    }

    private void appendDeliveryDetails(Object data, StringBuffer buffer) {
        IWorkspaceConnection sourceWorkspace = this.getSourceWorkspace(data);
        IWorkspaceConnection destWorkspace = this.getDestWorkspace(data);
        if (sourceWorkspace != null && destWorkspace != null) {
            String detailsTitle = Messages.DeliverProcessDetailProvider_6;
            buffer.append("<br><br><b><font color=\"").append(this.getTitleFontColor()).append(NLS.bind((String)"\">{0}</font></b><br>", (Object)detailsTitle));
            List activities = this.getActivities(data);
            if (activities.size() > 0) {
                buffer.append(NLS.bind((String)Messages.DeliverProcessDetailProvider_7, (Object)sourceWorkspace.getName(), (Object)destWorkspace.getName()));
                for (IRemoteActivity activity : activities) {
                    buffer.append("<br>&nbsp;&nbsp;&nbsp;");
                    this.appendActivityLink(activity, buffer);
                }
            } else {
                buffer.append(NLS.bind((String)Messages.DeliverProcessDetailProvider_8, (Object)sourceWorkspace.getName(), (Object)destWorkspace.getName()));
            }
        }
    }

    private void appendActivityLink(final IRemoteActivity activity, StringBuffer buffer) {
        this.appendHyperlink(this.convertToHtml(LocalWorkspaceChangesViewLabelProvider.getLabel(activity)), Messages.DeliverProcessDetailProvider_9, buffer, new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    window.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                LocalWorkspaceChangesView view = (LocalWorkspaceChangesView)page.showView("com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView");
                                view.getFullChangesViewPage().show(activity);
                            }
                            catch (PartInitException e) {
                                StatusUtil.log((Object)this, (Throwable)e);
                            }
                        }
                    });
                }
            }
        });
    }

    private IWorkspaceConnection getSourceWorkspace(Object data) {
        if (data instanceof DeliverOperationData) {
            return this.getWorkspaceConnection(((DeliverOperationData)data).getSourceWorkspace());
        }
        return null;
    }

    private IWorkspaceConnection getDestWorkspace(Object data) {
        if (data instanceof DeliverOperationData) {
            return this.getWorkspaceConnection(((DeliverOperationData)data).getDestWorkspace());
        }
        return null;
    }

    private IWorkspaceConnection getWorkspaceConnection(IWorkspace workspace) {
        ITeamRepository repo = (ITeamRepository)workspace.getOrigin();
        List connections = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).knownWorkspaceConnections();
        for (IWorkspaceConnection connection : connections) {
            if (!workspace.sameItemId((IItemHandle)connection.getResolvedWorkspace())) continue;
            return connection;
        }
        return null;
    }

    private List getActivities(Object object) {
        ArrayList<IRemoteActivity> activities = new ArrayList<IRemoteActivity>();
        if (object instanceof DeliverOperationData) {
            IWorkspaceSyncContext workspaceContext;
            DeliverOperationData data = (DeliverOperationData)object;
            IWorkspaceConnection source = this.getSourceWorkspace(data);
            List changeSetHandles = data.getChangeSetHandles();
            if (source != null && (workspaceContext = FileSystemResourcesPlugin.getComponentSyncModel().getWorkspaceSyncContext(source)) != null) {
                IComponentSyncContext[] contexts = workspaceContext.getComponentSyncContexts();
                int i = 0;
                while (i < contexts.length) {
                    IComponentSyncContext context = contexts[i];
                    List outgoingActivities = context.getOutgoingActivitySource().getActivities();
                    for (IRemoteActivity activity : outgoingActivities) {
                        if (!(activity instanceof IOutgoingRemoteActivity)) continue;
                        IChangeSetHandle activityChangeSet = activity.getChangeSetHandle();
                        for (IChangeSetHandle handle : changeSetHandles) {
                            if (!handle.sameItemId((IItemHandle)activityChangeSet)) continue;
                            activities.add(activity);
                        }
                    }
                    ++i;
                }
            }
        }
        return activities;
    }
}

