/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.client.IAdvisorProblemResolutionDelegate;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.process.DeliverOperationData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class DeliverOperationProblemResolution
implements IAdvisorProblemResolutionDelegate {
    public boolean run(IAdvisorInfo info, IProgressMonitor monitor) {
        final OpData data = this.getOperationData((IReportInfo)info);
        final boolean[] result = new boolean[1];
        if (data == null) {
            JFaceUtils.showMessage((String)Messages.DeliverOperationProblemResolution_InternalErrorMessageTitle, (String)Messages.DeliverOperationProblemResolution_CannotFindDeliverOperationDataMessage, (int)4);
        } else {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            List changeSetHandles = data.opData.getChangeSetHandles();
            final ArrayList changeSets = new ArrayList(changeSetHandles.size());
            if (changeSetHandles.size() > 0) {
                IChangeSetHandle firstChange = (IChangeSetHandle)changeSetHandles.get(0);
                ITeamRepository repo = (ITeamRepository)firstChange.getOrigin();
                try {
                    changeSets.addAll(repo.itemManager().fetchCompleteItems(changeSetHandles, 0, (IProgressMonitor)progress.newChild(7)));
                    final IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)data.opData.getSourceWorkspace(), (IProgressMonitor)progress.newChild(3));
                    IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
                    if (page != null) {
                        final Shell shell = page.getWorkbenchWindow().getShell();
                        shell.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                result[0] = DeliverOperationProblemResolution.this.execute(shell, data.opData, changeSets, connection);
                            }
                        });
                    }
                }
                catch (TeamRepositoryException e) {
                    JFaceUtils.showMessage((String)Messages.DeliverOperationProblemResolution_ErrorMessageTitle, (String)Messages.DeliverOperationProblemResolution_ErrorFetchingChangesFromRepoMessage, (int)4);
                }
            }
        }
        return result[0];
    }

    protected abstract boolean execute(Shell var1, DeliverOperationData var2, List var3, IWorkspaceConnection var4);

    private OpData getOperationData(IReportInfo info) {
        IProcessReport report = info.getProcessReport();
        do {
            OpData data;
            if ((data = this.findOperationData(report)) == null) continue;
            return data;
        } while ((report = report.getParentReport()) != null);
        return null;
    }

    private OpData findOperationData(IProcessReport report) {
        OpData data;
        IOperationReport[] reports = report.getOperationReports();
        if (report instanceof IOperationReport && (data = this.extractFromReport((IOperationReport)report)) != null) {
            return data;
        }
        int i = 0;
        while (i < reports.length) {
            IOperationReport operationReport = reports[i];
            OpData data2 = this.extractFromReport(operationReport);
            if (data2 != null) {
                return data2;
            }
            ++i;
        }
        return null;
    }

    private OpData extractFromReport(IOperationReport report) {
        AdvisableOperation operation;
        Object data;
        if (report.getOperationId().equals("com.ibm.team.scm.client.deliver") && (data = (operation = report.getOperation()).getOperationData()) instanceof DeliverOperationData) {
            return new OpData((DeliverOperationData)data, operation.getProcessArea().getProjectArea());
        }
        return null;
    }

    class OpData {
        public DeliverOperationData opData;
        public IProjectAreaHandle area;

        public OpData(DeliverOperationData data, IProjectAreaHandle area) {
            this.opData = data;
            this.area = area;
        }
    }
}

