/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.ide.ui.internal.util.DisplayHelper;
import com.ibm.team.filesystem.ide.ui.process.ComponentListUIJob;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.ide.ui.process.ScmDeferredElementListSelectionDialog;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComponentScopeDefinitionBlock {
    private static final String TAG_COMPONENTS = "components";
    private static final String TAG_COMPONENT = "component";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_UUID = "uuid";
    private List<IComponentMatcherEntry> matchers = new LinkedList<IComponentMatcherEntry>();
    private TableViewer fComponentList;
    private ScmDeferredElementListSelectionDialog fDialog;
    private Button addComponentButton;
    private Button removeComponentButton;
    private volatile boolean populatingUi = false;

    public void readComponents(IMemento memento) {
        IMemento[] component;
        ArrayList<IComponentMatcherEntry> matchers = new ArrayList<IComponentMatcherEntry>();
        IMemento componentsMemento = memento.getChild(TAG_COMPONENTS);
        if (componentsMemento != null && (component = componentsMemento.getChildren(TAG_COMPONENT)) != null) {
            int i = 0;
            while (i < component.length) {
                block7: {
                    IMemento componentMemento = component[i];
                    String uuidString = componentMemento.getString(ATTR_UUID);
                    String componentName = componentMemento.getString(ATTR_NAME);
                    if (ComponentScopeDefinitionBlock.isNotNull(uuidString)) {
                        UUID uuid;
                        try {
                            uuid = UUID.valueOf((String)uuidString);
                        }
                        catch (IllegalArgumentException e) {
                            LoggingHelper.log((IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
                            break block7;
                        }
                        IComponentHandle comp = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(uuid, null);
                        matchers.add(new ComponentMatcherEntry(comp, componentName));
                    } else if (ComponentScopeDefinitionBlock.isNotNull(componentName)) {
                        matchers.add(new LegacyMatcherEntry(componentName));
                    }
                }
                ++i;
            }
        }
        this.matchers = matchers;
    }

    public boolean saveComponents(IMemento memento) {
        if (this.fComponentList != null) {
            this.matchers = (List)this.fComponentList.getInput();
        }
        if (this.matchers == null || this.matchers.isEmpty()) {
            return true;
        }
        IMemento components = memento.createChild(TAG_COMPONENTS);
        for (IComponentMatcherEntry matcher : this.matchers) {
            IMemento child = components.createChild(TAG_COMPONENT);
            if (matcher.getLegacyName() != null) {
                child.putString(ATTR_NAME, matcher.getLegacyName());
            }
            if (matcher.getComponent() == null) continue;
            child.putString(ATTR_UUID, matcher.getComponent().getItemId().getUuidValue());
        }
        return true;
    }

    private static boolean isNotNull(String string) {
        return string != null && string.trim().length() > 0;
    }

    public TableViewer createControl(Composite parent, FormToolkit toolkit, final ProcessAspectEditor editor) {
        Label label = toolkit.createLabel(parent, Messages.ComponentScopeDefinitionBlock_1);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)label);
        this.fComponentList = new TableViewer(parent, 2818);
        this.fComponentList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fComponentList.setLabelProvider((IBaseLabelProvider)ScmDeferredElementListSelectionDialog.getLabelProvider());
        this.fComponentList.setSorter((ViewerSorter)new ScmDeferredElementListSelectionDialog.ComponentViewSorter());
        int h = this.fComponentList.getTable().getItemHeight() * 2;
        h = this.fComponentList.getTable().computeTrim((int)0, (int)0, (int)500, (int)h).height;
        GridDataFactory.fillDefaults().grab(true, true).hint(200, h).applyTo((Control)this.fComponentList.getTable());
        Composite buttonComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().align(131072, 128).grab(false, true).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(buttonComposite);
        this.addComponentButton = toolkit.createButton(buttonComposite, Messages.ComponentScopeDefinitionBlock_2, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)this.addComponentButton);
        this.addComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentScopeDefinitionBlock.this.addComponents(editor, (Collection)ComponentScopeDefinitionBlock.this.fComponentList.getInput())) {
                    editor.setDirty();
                    ComponentScopeDefinitionBlock.this.fComponentList.refresh();
                }
            }
        });
        this.removeComponentButton = toolkit.createButton(buttonComposite, Messages.ComponentScopeDefinitionBlock_3, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)this.removeComponentButton);
        this.removeComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentScopeDefinitionBlock.this.removeComponents(editor, (List)ComponentScopeDefinitionBlock.this.fComponentList.getInput())) {
                    editor.setDirty();
                    ComponentScopeDefinitionBlock.this.fComponentList.refresh();
                }
            }
        });
        this.removeComponentButton.setEnabled(false);
        this.fComponentList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ComponentScopeDefinitionBlock.this.populatingUi) {
                    return;
                }
                ISelection selection = event.getSelection();
                ComponentScopeDefinitionBlock.this.removeComponentButton.setEnabled(selection != null && !selection.isEmpty());
            }
        });
        return this.fComponentList;
    }

    private boolean addComponents(ProcessAspectEditor editor, Collection<ScmDeferredElementListSelectionDialog.IComponentTableEntry> componentNameModel) {
        ProcessAspect aspect = editor.getAspect();
        IProcessItem underlyingProcessItem = aspect.getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        ITeamRepository repository = (ITeamRepository)underlyingProcessItem.getOrigin();
        this.fDialog = new ScmDeferredElementListSelectionDialog(repository, this.fComponentList.getControl().getShell());
        this.fDialog.setElements(new ScmDeferredElementListSelectionDialog.IComponentTableEntry[]{new ScmDeferredElementListSelectionDialog.StringTableEntry(Messages.ComponentScopeDefinitionBlock_LOADING_COMPONENTS_MESSAGE)});
        this.fDialog.setTitle(Messages.ComponentScopeDefinitionBlock_7);
        this.fDialog.setMessage(Messages.ComponentScopeDefinitionBlock_8);
        if (this.fDialog.open() != 0) {
            return false;
        }
        boolean added = false;
        Object[] result = this.fDialog.getResult();
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                ScmDeferredElementListSelectionDialog.IComponentTableEntry entry = (ScmDeferredElementListSelectionDialog.IComponentTableEntry)result[i];
                if (!componentNameModel.contains(entry)) {
                    componentNameModel.add(entry);
                    added = true;
                }
                ++i;
            }
        }
        return added;
    }

    protected HashSet<UUID> determineLoadedComponents(SubMonitor monitor) throws FileSystemException {
        Collection sandboxes = SharingManager.getInstance().getRegisteredSandboxes();
        monitor.setWorkRemaining(sandboxes.size());
        HashSet<UUID> toReturn = new HashSet<UUID>();
        for (ISandbox sandbox : sandboxes) {
            Collection configs = sandbox.allLoadedConfigurations((IProgressMonitor)monitor.newChild(1));
            for (LoadedConfigurationDescriptor config : configs) {
                toReturn.add(config.componentHandle.getItemId());
            }
        }
        return toReturn;
    }

    private boolean removeComponents(ProcessAspectEditor editor, List<ScmDeferredElementListSelectionDialog.IComponentTableEntry> componentNameModel) {
        ISelection selection = this.fComponentList.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return componentNameModel.removeAll(ss.toList());
        }
        return false;
    }

    public void populateUi(ITeamRepository repository) {
        if (this.matchers.isEmpty()) {
            this.populatingUi = false;
            this.addComponentButton.setEnabled(true);
            this.fComponentList.setInput(new ArrayList());
            return;
        }
        this.populatingUi = true;
        this.addComponentButton.setEnabled(false);
        this.removeComponentButton.setEnabled(false);
        ArrayList<ScmDeferredElementListSelectionDialog.StringTableEntry> list = new ArrayList<ScmDeferredElementListSelectionDialog.StringTableEntry>();
        list.add(new ScmDeferredElementListSelectionDialog.StringTableEntry(Messages.ComponentScopeDefinitionBlock_LOADING_COMPONENTS_MESSAGE));
        this.fComponentList.setInput(list);
        ComponentListUIJob job = new ComponentListUIJob(repository){

            @Override
            public void doneFetching(final Collection<ScmDeferredElementListSelectionDialog.IComponentTableEntry> items) {
                DisplayHelper.asyncExec(ComponentScopeDefinitionBlock.this.fComponentList.getControl(), new Runnable(){

                    @Override
                    public void run() {
                        ComponentScopeDefinitionBlock.this.populatingUi = false;
                        ComponentScopeDefinitionBlock.this.fComponentList.setInput((Object)items);
                        ComponentScopeDefinitionBlock.this.addComponentButton.setEnabled(true);
                        if (!ComponentScopeDefinitionBlock.this.fComponentList.getSelection().isEmpty()) {
                            ComponentScopeDefinitionBlock.this.removeComponentButton.setEnabled(true);
                        }
                    }
                });
            }

            @Override
            public List<IComponentHandle> getComponentsToShow(ITeamRepository repo, SubMonitor progress) throws TeamRepositoryException {
                HashMap<UUID, IComponentHandle> components = new HashMap<UUID, IComponentHandle>(ComponentScopeDefinitionBlock.this.matchers.size());
                for (IComponentMatcherEntry entry : ComponentScopeDefinitionBlock.this.matchers) {
                    IComponentHandle comp = entry.getComponent();
                    if (comp == null) continue;
                    components.put(comp.getItemId(), comp);
                }
                return new ArrayList<IComponentHandle>(components.values());
            }

            @Override
            public List<String> getStringsToShow() throws TeamRepositoryException {
                ArrayList<String> toReturn = new ArrayList<String>(ComponentScopeDefinitionBlock.this.matchers.size());
                for (IComponentMatcherEntry entry : ComponentScopeDefinitionBlock.this.matchers) {
                    String name = entry.getLegacyName();
                    if (entry.getComponent() != null || name == null) continue;
                    toReturn.add(name);
                }
                return toReturn;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    public static class ComponentMatcherEntry
    implements IComponentMatcherEntry {
        private final IComponentHandle component;
        private final String legacyName;

        public ComponentMatcherEntry(IComponentHandle component, String name) {
            this.component = component;
            this.legacyName = name;
        }

        @Override
        public IComponentHandle getComponent() {
            return this.component;
        }

        @Override
        public String getLegacyName() {
            return this.legacyName;
        }
    }

    public static interface IComponentMatcherEntry {
        public IComponentHandle getComponent();

        public String getLegacyName();
    }

    public static class LegacyMatcherEntry
    implements IComponentMatcherEntry {
        private final String legacyName;

        public LegacyMatcherEntry(String name) {
            this.legacyName = name;
        }

        @Override
        public IComponentHandle getComponent() {
            return null;
        }

        @Override
        public String getLegacyName() {
            return this.legacyName;
        }
    }
}

