/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.internal.process.ComponentIdNamePair;
import com.ibm.team.filesystem.common.internal.process.ProcessAreaEntry;
import com.ibm.team.filesystem.common.internal.util.StringUtils;
import com.ibm.team.filesystem.ide.ui.internal.util.TableUtil;
import com.ibm.team.filesystem.ide.ui.process.MessageBox;
import com.ibm.team.filesystem.ide.ui.process.PermissionsPicker;
import com.ibm.team.filesystem.ide.ui.process.ProcessAreaPath;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialogOptions;
import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceWrapper;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import com.ibm.team.process.internal.ide.ui.editors.form.AbstractProcessAspect;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComponentPermissionsDefinitionBlock {
    private static final String TAG_COMPONENTS = "components";
    private static final String TAG_PERMISSIONS = "permissions";
    private static final String TAG_COMPONENT = "component";
    private static final String ATTR_NAME = "name";
    private static final String TAG_STREAM = "stream";
    private static final String TAG_ROLEASSIGNMENT = "roleAssignment";
    private static final String TAG_ROLE = "role";
    private static final String TAG_COMPONENTOWNER = "componentOwner";
    private static final String ATTR_ID = "id";
    private static final String ATTR_PROCESSAREA = "processarea";
    private static final String ATTR_PROCESSAREA_ID = "processAreaId";
    private static final String TAG_SOURCEWORKSPACE = "sourceWorkspace";
    private static final String ATTR_ITEMID = "itemId";
    ProcessAspectEditor editor;
    Model model;
    Shell shell;
    private Composite streamComposite;
    private StandardControlLabelProvider streamHyperlink;
    Button editPermissionsButton;
    IProcessItem processItem;
    ITeamRepository repo;
    boolean settingInput;
    JobRunner jobRunner = new JobRunner(false);
    MessageBox messageBox;
    Display display;
    Composite body;
    boolean noStreamsFound;
    private TableViewer permissionsTable;

    public ComponentPermissionsDefinitionBlock(IProcessItem processItem) {
        this.processItem = processItem;
        this.repo = (ITeamRepository)processItem.getOrigin();
        this.model = new Model();
        this.model.repo = this.repo;
        this.model.processItem = processItem;
    }

    private static boolean isNotNull(String string) {
        return string != null && string.trim().length() > 0;
    }

    private void setDefaultStreamByName(final Display display, final String defaultSelectionHint) {
        this.jobRunner.enqueue(Messages.StreamCombo_1, (Operation)new RepositoryOperation(this.repo){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                IItem workspace;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                List itemHandles = ComponentPermissionsDefinitionBlock.this.model.listStreamsMatchingName(ComponentPermissionsDefinitionBlock.this.processItem, defaultSelectionHint, progress.newChild(80));
                final IWorkspace stream = itemHandles == null || itemHandles.size() < 1 ? null : ((workspace = ComponentPermissionsDefinitionBlock.this.repo.itemManager().fetchCompleteItem((IItemHandle)itemHandles.get(0), 1, (IProgressMonitor)progress.newChild(20))) instanceof IWorkspace ? (IWorkspace)workspace : null);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ComponentPermissionsDefinitionBlock.this.streamComposite.isDisposed()) {
                            return;
                        }
                        if (stream != null) {
                            ComponentPermissionsDefinitionBlock.this.selectedStream(stream);
                        } else {
                            (this).ComponentPermissionsDefinitionBlock.this.noStreamsFound = true;
                            ComponentPermissionsDefinitionBlock.this.validateData();
                        }
                    }
                });
            }
        });
    }

    public void createControls(Composite parent, FormToolkit toolkit, final ProcessAspectEditor editor) {
        this.editor = editor;
        this.shell = parent.getShell();
        this.display = parent.getDisplay();
        Label heading = toolkit.createLabel(parent, Messages.StreamComponentsPermissionAspectEditor_0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)heading);
        heading.setFont(this.getBoldFont());
        this.body = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.body);
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(2).applyTo(this.body);
        this.streamComposite = toolkit.createComposite(this.body);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.streamComposite);
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(3).applyTo(this.streamComposite);
        Label streamLabel = toolkit.createLabel(this.streamComposite, Messages.StreamComponentsPermissionAspectEditor_1);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)streamLabel);
        this.streamHyperlink = FileSystemEditorToolkit.createDecoratedImageHyperlink(this.streamComposite, toolkit, null, "");
        GridDataFactory.fillDefaults().minSize(100, 0).align(16384, 0x1000000).grab(true, true).applyTo(this.streamHyperlink.getControl());
        Button browseButton = toolkit.createButton(this.streamComposite, Messages.StreamComponentsPermissionAspectEditor_BrowseButtonText, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceAndStreamSelectionDialogOptions options = new WorkspaceAndStreamSelectionDialogOptions().setAllowMultiSelect(false).setShowWorkspaces(WORKSPACES_OR_STREAMS.STREAMS).setShowWorkspacesRadio(false).setForceRepo(true).setOwnerHandler((IAuditableHandle)ComponentPermissionsDefinitionBlock.this.processItem).setFilter(new IFilter(){

                    public boolean select(Object o) {
                        if (o instanceof TeamPlaceWrapper) {
                            TeamPlaceWrapper wrapper = (TeamPlaceWrapper)((Object)o);
                            return wrapper.getWorkspace().getOwner().sameItemId((IItemHandle)(this).ComponentPermissionsDefinitionBlock.this.processItem);
                        }
                        return false;
                    }
                });
                AbstractPlaceWrapper newStream = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(ComponentPermissionsDefinitionBlock.this.shell, ComponentPermissionsDefinitionBlock.this.repo, options);
                if (newStream != null && !newStream.getWorkspace().getItemId().equals(ComponentPermissionsDefinitionBlock.this.model.stream == null ? null : ComponentPermissionsDefinitionBlock.this.model.stream.getItemId())) {
                    if (ComponentPermissionsDefinitionBlock.this.model.componentIdNamePairsWithPermissions != null && ComponentPermissionsDefinitionBlock.this.model.hasPermissions()) {
                        boolean force = JFaceUtils.showMessageBlocking((String)Messages.StreamComponentsPermissionAspectEditor_SelectStreamWarningTitle, (String)Messages.StreamComponentsPermissionAspectEditor_SelectStreamWarningDescription, (String[])new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, (int)4);
                        if (!force) {
                            return;
                        }
                        editor.setDirty();
                    }
                    ComponentPermissionsDefinitionBlock.this.selectedStream(newStream.getWorkspace());
                }
            }
        });
        this.setDefaultStreamByName(parent.getDisplay(), this.model.streamName);
        this.permissionsTable = new TableViewer(this.body, 68354);
        TableColumn tc = new TableColumn(this.permissionsTable.getTable(), 0);
        tc.setText(Messages.ComponentAuthorizedUsersScopeDefinitionBlock_0);
        tc = new TableColumn(this.permissionsTable.getTable(), 0);
        tc.setText(Messages.ComponentAuthorizedUsersScopeDefinitionBlock_1);
        tc = new TableColumn(this.permissionsTable.getTable(), 0);
        tc.setText(Messages.ComponentAuthorizedUsersScopeDefinitionBlock_SOURCE_WORKSPACES);
        this.permissionsTable.getTable().setHeaderVisible(true);
        this.permissionsTable.getTable().setLinesVisible(true);
        TableUtil.multiLines(this.permissionsTable.getTable());
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object element) {
                Model model = (Model)element;
                Object[] result = new Object[model.componentIdNamePairsWithPermissions.size()];
                int i = 0;
                for (Map.Entry<ComponentIdNamePair, PersistedPermissions> componentPermissionEntry : model.componentIdNamePairsWithPermissions.entrySet()) {
                    result[i] = new Object[]{componentPermissionEntry.getKey(), componentPermissionEntry.getValue()};
                    ++i;
                }
                return result;
            }
        };
        this.permissionsTable.setContentProvider((IContentProvider)contentProvider);
        this.permissionsTable.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.permissionsTable.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Object[] s1 = (Object[])e1;
                Object[] s2 = (Object[])e2;
                String componentName1 = ((ComponentIdNamePair)s1[0]).getComponentName();
                String componentName2 = ((ComponentIdNamePair)s2[0]).getComponentName();
                return componentName1.compareTo(componentName2);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.permissionsTable.getTable());
        Composite buttonComposite = toolkit.createComposite(this.body);
        GridDataFactory.fillDefaults().align(131072, 128).grab(false, false).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).applyTo(buttonComposite);
        this.editPermissionsButton = toolkit.createButton(buttonComposite, Messages.ComponentAuthorizedUsersScopeDefinitionBlock_2, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)this.editPermissionsButton);
        this.editPermissionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentPermissionsDefinitionBlock.this.editPermission(ComponentPermissionsDefinitionBlock.this.getSelectedComponentIdNamePairList())) {
                    editor.setDirty();
                    ComponentPermissionsDefinitionBlock.this.permissionsTable.refresh();
                    TableUtil.resetColumnSizeHint(ComponentPermissionsDefinitionBlock.this.permissionsTable.getTable());
                }
                ComponentPermissionsDefinitionBlock.this.validateData();
            }
        });
        this.permissionsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComponentPermissionsDefinitionBlock.this.validateData();
            }
        });
        this.messageBox = new MessageBox();
        Composite messageBoxControl = this.messageBox.createControl(parent, toolkit, editor);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)messageBoxControl);
        this.updateUI();
    }

    private void selectedStream(final IWorkspace stream) {
        if (stream != null) {
            this.streamHyperlink.setElement((Object)AbstractPlaceWrapper.newWrapper(stream));
            this.streamComposite.layout();
            this.jobRunner.enqueue(Messages.StreamComponentsPermissionAspectEditor_5, (Operation)new RepositoryOperation(this.repo){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    this.fetchComponents(stream, ComponentPermissionsDefinitionBlock.this.repo, monitor);
                }

                private void fetchComponents(IWorkspace stream2, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                    progress.setWorkRemaining(2);
                    boolean sameStream = ComponentPermissionsDefinitionBlock.this.isSameStream(stream2, ComponentPermissionsDefinitionBlock.this.model);
                    ComponentPermissionsDefinitionBlock.this.model.stream = stream2;
                    ComponentPermissionsDefinitionBlock.this.model.streamName = stream2.getName();
                    ComponentPermissionsDefinitionBlock.this.model.streamUUID = stream2.getItemId().getUuidValue();
                    List<IComponent> components = ComponentPermissionsDefinitionBlock.getComponentsFromStreamInRepo(repo, stream2, (IProgressMonitor)progress.newChild(50));
                    HashSet<ComponentIdNamePair> componentIdNamePairSet = new HashSet<ComponentIdNamePair>();
                    ComponentPermissionsDefinitionBlock.this.model.duplicateComponentIdNamePairSet.clear();
                    if (ComponentPermissionsDefinitionBlock.listNotEmpty(components)) {
                        for (IComponent comp : components) {
                            if (componentIdNamePairSet.add(new ComponentIdNamePair(comp.getItemId().getUuidValue(), comp.getName()))) continue;
                            ComponentPermissionsDefinitionBlock.this.model.duplicateComponentIdNamePairSet.add(new ComponentIdNamePair(comp.getItemId().getUuidValue(), comp.getName()));
                        }
                    }
                    Map<Object, PersistedPermissions> oldPermissions = sameStream ? new HashMap<ComponentIdNamePair, PersistedPermissions>(ComponentPermissionsDefinitionBlock.this.model.componentIdNamePairsWithPermissions) : Collections.EMPTY_MAP;
                    ComponentPermissionsDefinitionBlock.this.model.componentIdNamePairsWithPermissions.clear();
                    if (ComponentPermissionsDefinitionBlock.listNotEmpty(componentIdNamePairSet)) {
                        for (ComponentIdNamePair componentIdNamePair : componentIdNamePairSet) {
                            ComponentPermissionsDefinitionBlock.this.model.componentIdNamePairsWithPermissions.put(componentIdNamePair, (PersistedPermissions)oldPermissions.get(componentIdNamePair));
                        }
                    }
                    ComponentPermissionsDefinitionBlock.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ComponentPermissionsDefinitionBlock.this.updateUI();
                        }
                    });
                }
            });
        }
    }

    private boolean isSameStream(IWorkspace stream, Model model) {
        boolean result = !StringUtils.isEmpty((String)model.streamUUID) ? stream.getItemId().getUuidValue().equals(model.streamUUID) : stream.getName().equals(model.streamName);
        return result;
    }

    private void validateData() {
        ArrayList<ComponentIdNamePair> selectedDuplicateComponentIdNamePairList = new ArrayList<ComponentIdNamePair>();
        for (ComponentIdNamePair componentIdNamePair : this.getSelectedComponentIdNamePairList()) {
            if (!this.model.duplicateComponentIdNamePairSet.contains(componentIdNamePair)) continue;
            selectedDuplicateComponentIdNamePairList.add(componentIdNamePair);
        }
        this.permissionsTable.getTable().setEnabled(!this.noStreamsFound && this.model.componentIdNamePairsWithPermissions.size() > 0);
        boolean buttonEnable = this.permissionsTable.getTable().isEnabled() && this.permissionsTable.getTable().getSelectionCount() > 0 && selectedDuplicateComponentIdNamePairList.isEmpty();
        this.editPermissionsButton.setEnabled(buttonEnable);
        this.messageBox.clearMessage();
        if (this.noStreamsFound) {
            this.messageBox.setWarningMessage(NLS.bind((String)Messages.ComponentAuthorizedUsersScopeDefinitionBlock_12, (Object)this.processItem.getName()));
        } else if (this.model.streamName == null) {
            this.messageBox.setInformationMessage(Messages.StreamComponentsPermissionAspectEditor_6);
        } else if (this.model.streamName != null && this.model.componentIdNamePairsWithPermissions.isEmpty()) {
            this.messageBox.setWarningMessage(Messages.StreamComponentsPermissionAspectEditor_7);
        } else if (!selectedDuplicateComponentIdNamePairList.isEmpty()) {
            this.messageBox.setWarningMessage(NLS.bind((String)Messages.StreamComponentsPermissionAspectEditor_9, (Object)((ComponentIdNamePair)selectedDuplicateComponentIdNamePairList.get(0)).getComponentName()));
        }
    }

    private List<ComponentIdNamePair> getSelectedComponentIdNamePairList() {
        ArrayList<ComponentIdNamePair> selected = new ArrayList<ComponentIdNamePair>();
        Object[] objectArray = ((IStructuredSelection)this.permissionsTable.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object row = objectArray[n2];
            selected.add((ComponentIdNamePair)((Object[])row)[0]);
            ++n2;
        }
        return selected;
    }

    public void updateUI() {
        if (this.streamComposite.isDisposed()) {
            return;
        }
        this.validateData();
        this.body.layout();
        this.permissionsTable.setInput((Object)this.model);
    }

    private boolean editPermission(List<ComponentIdNamePair> componentIdNamePairList) {
        IProcessItem processItem = this.editor.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        AbstractProcessAspect aspect = (AbstractProcessAspect)this.editor.getAspect();
        ArrayList<PersistedPermissions> currentPermissions = new ArrayList<PersistedPermissions>();
        for (ComponentIdNamePair componentIdNamePair : componentIdNamePairList) {
            PersistedPermissions permissions = this.model.componentIdNamePairsWithPermissions.get(componentIdNamePair);
            if (permissions == null) continue;
            currentPermissions.add(permissions);
        }
        PermissionsPicker.Permissions newPermissions = PermissionsPicker.pickPermissions(this.shell, this.repo, aspect, processItem, this.model.stream, componentIdNamePairList, currentPermissions);
        if (newPermissions != null) {
            for (ComponentIdNamePair componentIdNamePair : componentIdNamePairList) {
                this.model.editPermission(componentIdNamePair, newPermissions.componentOwner);
                this.model.clearPermissionProcessAreas(componentIdNamePair);
                this.model.clearPermissionSourceWorkspaces(componentIdNamePair);
                for (IProcessArea processArea : newPermissions.getProcessAreas()) {
                    ProcessAreaPath path = newPermissions.getProcessAreaPath(processArea);
                    Collection<IRole> roles = newPermissions.getRoles(processArea);
                    this.model.editPermissionProcessArea(componentIdNamePair, processArea.getItemId(), path, roles);
                }
                this.model.editPermissionSourceWorkspaces(componentIdNamePair, newPermissions.getSourceWorkspaces());
            }
            return true;
        }
        return false;
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    public Model getModel() {
        return this.model;
    }

    public static List<IComponent> getComponentsFromStreamInRepo(ITeamRepository repo, IWorkspace stream, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List handles = null;
        List components = Collections.emptyList();
        try {
            IWorkspaceConnection wc = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)stream, (IProgressMonitor)progress.newChild(50));
            if (wc != null && ComponentPermissionsDefinitionBlock.listNotEmpty(handles = wc.getComponents())) {
                components = repo.itemManager().fetchCompleteItems(handles, 1, (IProgressMonitor)progress.newChild(50));
                Iterator iter = components.iterator();
                while (iter.hasNext()) {
                    IComponent element = (IComponent)iter.next();
                    if (element != null) continue;
                    iter.remove();
                }
            }
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log(ComponentPermissionsDefinitionBlock.class, (Throwable)e);
        }
        return components;
    }

    public static List<ComponentIdNamePair> getComponentsIdNamePairFromStreamInRepo(ITeamRepository repo, IWorkspace stream, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<ComponentIdNamePair> componentsIdNamePairList = new ArrayList<ComponentIdNamePair>();
        List<IComponent> componentsInStream = ComponentPermissionsDefinitionBlock.getComponentsFromStreamInRepo(repo, stream, (IProgressMonitor)progress.newChild(100));
        if (ComponentPermissionsDefinitionBlock.listNotEmpty(componentsInStream)) {
            for (IComponent component : componentsInStream) {
                componentsIdNamePairList.add(new ComponentIdNamePair(component.getItemId().getUuidValue(), component.getName()));
            }
        }
        return componentsIdNamePairList;
    }

    private static ComponentIdNamePair getComponentIdNamePair(List<ComponentIdNamePair> componentsIdNamePairList, String componentUUID, String componentName) {
        ComponentIdNamePair result = null;
        for (ComponentIdNamePair componentIdNamePair : componentsIdNamePairList) {
            if (!StringUtils.isEmpty((String)componentUUID) && componentUUID.equals(componentIdNamePair.getComponentUUIDStr())) {
                result = componentIdNamePair;
                break;
            }
            if (StringUtils.isEmpty((String)componentName) || !componentName.equals(componentIdNamePair.getComponentName())) continue;
            result = componentIdNamePair;
            break;
        }
        return result;
    }

    private static boolean listNotEmpty(Collection<?> list) {
        return list != null && !list.isEmpty();
    }

    public static boolean isComponentIdNamePairNull(ComponentIdNamePair componentIdNamePair) {
        return componentIdNamePair == null;
    }

    public static class Model {
        Set<ComponentIdNamePair> duplicateComponentIdNamePairSet = new HashSet<ComponentIdNamePair>();
        IWorkspace stream = null;
        String streamName = null;
        String streamUUID = null;
        Map<ComponentIdNamePair, PersistedPermissions> componentIdNamePairsWithPermissions = new HashMap<ComponentIdNamePair, PersistedPermissions>();
        List<ComponentIdNamePair> componentIdNamePairList = new ArrayList<ComponentIdNamePair>();
        ITeamRepository repo;
        IProcessItem processItem;

        public void readFrom(IMemento memento) {
            this.componentIdNamePairsWithPermissions.clear();
            final IMemento streamMemento = memento.getChild(ComponentPermissionsDefinitionBlock.TAG_STREAM);
            if (streamMemento != null) {
                this.streamUUID = streamMemento.getString(ComponentPermissionsDefinitionBlock.ATTR_ITEMID);
                this.streamName = streamMemento.getString(ComponentPermissionsDefinitionBlock.ATTR_NAME);
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            if (!StringUtils.isEmpty((String)streamUUID)) {
                                IWorkspaceHandle streamHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)streamUUID), null);
                                try {
                                    stream = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)streamHandle, 1, monitor);
                                    if (stream != null) {
                                        streamName = stream.getName();
                                        streamMemento.putString(ComponentPermissionsDefinitionBlock.ATTR_NAME, streamName);
                                    }
                                }
                                catch (TeamRepositoryException e) {
                                    StatusUtil.log((Object)this, (Throwable)e);
                                }
                            } else if (!StringUtils.isEmpty((String)streamName)) {
                                try {
                                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                    List streamHandles = this.listStreamsMatchingName(processItem, streamName, progress.newChild(50));
                                    if (ComponentPermissionsDefinitionBlock.listNotEmpty(streamHandles)) {
                                        stream = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)streamHandles.get(0), 1, (IProgressMonitor)progress.newChild(50));
                                        if (stream != null) {
                                            streamUUID = stream.getItemId().getUuidValue();
                                            streamMemento.putString(ComponentPermissionsDefinitionBlock.ATTR_ITEMID, streamUUID);
                                        }
                                    } else {
                                        stream = null;
                                    }
                                }
                                catch (TeamRepositoryException e) {
                                    StatusUtil.log((Object)this, (Throwable)e);
                                }
                                catch (OperationFailedException e) {
                                    StatusUtil.log((Object)this, (Throwable)e);
                                }
                            }
                        }
                    });
                }
                catch (InvocationTargetException ite) {
                    StatusUtil.log((Object)this, (Throwable)ite);
                }
                catch (InterruptedException ie) {
                    StatusUtil.log((Object)this, (Throwable)ie);
                }
                if (this.stream != null) {
                    this.readComponentsWithPermissions(streamMemento);
                }
            }
        }

        public boolean saveTo(IMemento memento) {
            IMemento child = memento.createChild(ComponentPermissionsDefinitionBlock.TAG_STREAM);
            if (!StringUtils.isEmpty((String)this.streamUUID)) {
                child.putString(ComponentPermissionsDefinitionBlock.ATTR_ITEMID, this.streamUUID);
            }
            child.putString(ComponentPermissionsDefinitionBlock.ATTR_NAME, this.streamName);
            return this.saveComponentsWithPermissions(child);
        }

        public void readComponentsWithPermissions(IMemento memento) {
            IMemento componentsMemento = memento.getChild(ComponentPermissionsDefinitionBlock.TAG_COMPONENTS);
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        componentIdNamePairList = ComponentPermissionsDefinitionBlock.getComponentsIdNamePairFromStreamInRepo(repo, stream, monitor);
                    }
                });
            }
            catch (InvocationTargetException ite) {
                StatusUtil.log((Object)this, (Throwable)ite);
            }
            catch (InterruptedException ie) {
                StatusUtil.log((Object)this, (Throwable)ie);
            }
            if (componentsMemento != null && this.componentIdNamePairList != null && this.componentIdNamePairList.size() > 0) {
                IMemento[] iMementoArray = componentsMemento.getChildren(ComponentPermissionsDefinitionBlock.TAG_COMPONENT);
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String componentName;
                    IMemento componentMemento = iMementoArray[n2];
                    String componentUUIDStr = componentMemento.getString(ComponentPermissionsDefinitionBlock.ATTR_ITEMID);
                    ComponentIdNamePair componentIdNamePair = ComponentPermissionsDefinitionBlock.getComponentIdNamePair(this.componentIdNamePairList, componentUUIDStr, componentName = componentMemento.getString(ComponentPermissionsDefinitionBlock.ATTR_NAME));
                    if (!ComponentPermissionsDefinitionBlock.isComponentIdNamePairNull(componentIdNamePair)) {
                        componentMemento.putString(ComponentPermissionsDefinitionBlock.ATTR_NAME, componentIdNamePair.getComponentName());
                        componentMemento.putString(ComponentPermissionsDefinitionBlock.ATTR_ITEMID, componentIdNamePair.getComponentUUIDStr());
                    }
                    IMemento permissionsMemento = componentMemento.getChild(ComponentPermissionsDefinitionBlock.TAG_PERMISSIONS);
                    if (!ComponentPermissionsDefinitionBlock.isComponentIdNamePairNull(componentIdNamePair) && permissionsMemento != null) {
                        PersistedPermissions permissions = new PersistedPermissions();
                        permissions.readFrom(componentMemento);
                        this.componentIdNamePairsWithPermissions.put(componentIdNamePair, permissions);
                    }
                    ++n2;
                }
            }
        }

        public boolean saveComponentsWithPermissions(IMemento memento) {
            if (this.componentIdNamePairsWithPermissions != null && !this.componentIdNamePairsWithPermissions.isEmpty()) {
                IMemento components = null;
                for (Map.Entry<ComponentIdNamePair, PersistedPermissions> componentIdNamePairEntry : this.componentIdNamePairsWithPermissions.entrySet()) {
                    ComponentIdNamePair componentIdNamePair = componentIdNamePairEntry.getKey();
                    PersistedPermissions permissions = componentIdNamePairEntry.getValue();
                    if (ComponentPermissionsDefinitionBlock.isComponentIdNamePairNull(componentIdNamePair) || permissions == null) continue;
                    if (components == null) {
                        components = memento.createChild(ComponentPermissionsDefinitionBlock.TAG_COMPONENTS);
                    }
                    IMemento child = components.createChild(ComponentPermissionsDefinitionBlock.TAG_COMPONENT);
                    child.putString(ComponentPermissionsDefinitionBlock.ATTR_ITEMID, componentIdNamePair.getComponentUUIDStr());
                    child.putString(ComponentPermissionsDefinitionBlock.ATTR_NAME, componentIdNamePair.getComponentName());
                    permissions.saveTo(child);
                }
            }
            return true;
        }

        public boolean hasPermissions() {
            for (PersistedPermissions permissions : this.componentIdNamePairsWithPermissions.values()) {
                if (permissions == null) continue;
                return true;
            }
            return false;
        }

        public void clearPermissionProcessAreas(ComponentIdNamePair componentIdNamePair) {
            PersistedPermissions permissions = this.componentIdNamePairsWithPermissions.get(componentIdNamePair);
            if (permissions != null) {
                permissions.processAreaToRoles.clear();
            }
        }

        public void clearPermissionSourceWorkspaces(ComponentIdNamePair componentIdNamePair) {
            PersistedPermissions permissions = this.componentIdNamePairsWithPermissions.get(componentIdNamePair);
            if (permissions != null) {
                permissions.uuid2sourceWorkspaceName.clear();
            }
        }

        public void editPermissionProcessArea(ComponentIdNamePair componentIdNamePair, UUID itemId, ProcessAreaPath path, Collection<IRole> roles) {
            Set<String> roleIds;
            PersistedPermissions permissions = this.componentIdNamePairsWithPermissions.get(componentIdNamePair);
            if (permissions == null) {
                permissions = new PersistedPermissions();
                this.componentIdNamePairsWithPermissions.put(componentIdNamePair, permissions);
            }
            ProcessAreaEntry entryToUpdate = null;
            for (ProcessAreaEntry entry : permissions.getProcessAreaToRoles().keySet()) {
                if ((entry.getProcessAreaId() == null || !entry.getProcessAreaId().equals(itemId.getUuidValue())) && (entry.getProcessAreaId() != null || !entry.getProcessAreaPath().equals(path.pathLabel))) continue;
                entryToUpdate = entry;
                break;
            }
            if (entryToUpdate == null) {
                entryToUpdate = new ProcessAreaEntry(itemId.getUuidValue(), path.pathLabel);
            }
            if ((roleIds = permissions.processAreaToRoles.get(entryToUpdate)) == null) {
                roleIds = new HashSet<String>();
                permissions.processAreaToRoles.put(entryToUpdate, roleIds);
            }
            roleIds.clear();
            for (IRole role : roles) {
                roleIds.add(role.getId());
            }
        }

        public void editPermissionSourceWorkspaces(ComponentIdNamePair componentIdNamePair, Collection<IWorkspace> workspaces) {
            PersistedPermissions permissions = this.componentIdNamePairsWithPermissions.get(componentIdNamePair);
            if (permissions == null) {
                permissions = new PersistedPermissions();
                this.componentIdNamePairsWithPermissions.put(componentIdNamePair, permissions);
            }
            permissions.uuid2sourceWorkspaceName.clear();
            for (IWorkspace workspace : workspaces) {
                permissions.uuid2sourceWorkspaceName.put(workspace.getItemId().getUuidValue(), workspace.getName());
            }
        }

        public void editPermission(ComponentIdNamePair componentIdNamePair, boolean componentOwner) {
            PersistedPermissions permissions = this.componentIdNamePairsWithPermissions.get(componentIdNamePair);
            if (permissions == null) {
                permissions = new PersistedPermissions();
                this.componentIdNamePairsWithPermissions.put(componentIdNamePair, permissions);
            }
            permissions.componentOwner = componentOwner;
        }

        private List<IWorkspaceHandle> listStreamsMatchingName(IProcessItem processItem, String streamNameHint, SubMonitor progress) throws TeamRepositoryException, FileSystemException, OperationFailedException {
            IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance();
            criteria.getFilterByOwnerOptional().add(processItem);
            criteria.setExactName(streamNameHint);
            criteria.setKind(1);
            List itemHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repo).findWorkspaces(criteria, 1, (IProgressMonitor)progress);
            return itemHandles;
        }
    }

    public static class PersistedPermissions {
        boolean componentOwner;
        Map<ProcessAreaEntry, Set<String>> processAreaToRoles = new HashMap<ProcessAreaEntry, Set<String>>();
        Map<String, String> uuid2sourceWorkspaceName = new HashMap<String, String>();

        public Map<ProcessAreaEntry, Set<String>> getProcessAreaToRoles() {
            return this.processAreaToRoles;
        }

        public void setComponentOwner(boolean componentOwner) {
            this.componentOwner = componentOwner;
        }

        public boolean getComponentOwner() {
            return this.componentOwner;
        }

        public void readFrom(IMemento memento) {
            this.processAreaToRoles.clear();
            this.componentOwner = false;
            IMemento child = memento.getChild(ComponentPermissionsDefinitionBlock.TAG_PERMISSIONS);
            if (child == null) {
                return;
            }
            IMemento[] iMementoArray = child.getChildren(ComponentPermissionsDefinitionBlock.TAG_ROLEASSIGNMENT);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento roleAssignment = iMementoArray[n2];
                String processAreaPath = roleAssignment.getString(ComponentPermissionsDefinitionBlock.ATTR_PROCESSAREA);
                String processAreaId = roleAssignment.getString(ComponentPermissionsDefinitionBlock.ATTR_PROCESSAREA_ID);
                ProcessAreaEntry entry = new ProcessAreaEntry(processAreaId, processAreaPath);
                Set<String> roleIds = this.processAreaToRoles.get(entry);
                if (roleIds == null) {
                    roleIds = new HashSet<String>();
                    this.processAreaToRoles.put(entry, roleIds);
                }
                IMemento[] iMementoArray2 = roleAssignment.getChildren(ComponentPermissionsDefinitionBlock.TAG_ROLE);
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento role = iMementoArray2[n4];
                    String roleId = role.getString(ComponentPermissionsDefinitionBlock.ATTR_ID);
                    roleIds.add(roleId);
                    ++n4;
                }
                ++n2;
            }
            iMementoArray = child.getChildren(ComponentPermissionsDefinitionBlock.TAG_SOURCEWORKSPACE);
            n = iMementoArray.length;
            n2 = 0;
            while (n2 < n) {
                IMemento sourceWorkspace = iMementoArray[n2];
                String workspaceItemId = sourceWorkspace.getString(ComponentPermissionsDefinitionBlock.ATTR_ITEMID);
                String workspaceName = sourceWorkspace.getString(ComponentPermissionsDefinitionBlock.ATTR_NAME);
                this.uuid2sourceWorkspaceName.put(workspaceItemId, workspaceName);
                ++n2;
            }
            this.componentOwner = child.getChild(ComponentPermissionsDefinitionBlock.TAG_COMPONENTOWNER) != null;
        }

        public void saveTo(IMemento memento) {
            IMemento permissionsMemento = memento.createChild(ComponentPermissionsDefinitionBlock.TAG_PERMISSIONS);
            for (ProcessAreaEntry processAreaEntry : this.processAreaToRoles.keySet()) {
                IMemento roleAssignmentMemento = permissionsMemento.createChild(ComponentPermissionsDefinitionBlock.TAG_ROLEASSIGNMENT);
                roleAssignmentMemento.putString(ComponentPermissionsDefinitionBlock.ATTR_PROCESSAREA_ID, processAreaEntry.getProcessAreaId());
                roleAssignmentMemento.putString(ComponentPermissionsDefinitionBlock.ATTR_PROCESSAREA, processAreaEntry.getProcessAreaPath());
                for (String roleId : this.processAreaToRoles.get(processAreaEntry)) {
                    roleAssignmentMemento.createChild(ComponentPermissionsDefinitionBlock.TAG_ROLE).putString(ComponentPermissionsDefinitionBlock.ATTR_ID, roleId);
                }
            }
            if (this.componentOwner) {
                permissionsMemento.createChild(ComponentPermissionsDefinitionBlock.TAG_COMPONENTOWNER);
            }
            for (Map.Entry entry : this.uuid2sourceWorkspaceName.entrySet()) {
                IMemento sourceWorkspacesMemento = permissionsMemento.createChild(ComponentPermissionsDefinitionBlock.TAG_SOURCEWORKSPACE);
                sourceWorkspacesMemento.putString(ComponentPermissionsDefinitionBlock.ATTR_ITEMID, (String)entry.getKey());
                sourceWorkspacesMemento.putString(ComponentPermissionsDefinitionBlock.ATTR_NAME, (String)entry.getValue());
            }
        }

        public String toPermissionsString() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.componentOwner) {
                result.add(Messages.ComponentAuthorizedUsersScopeDefinitionBlock_6);
            }
            if (!this.processAreaToRoles.isEmpty()) {
                for (ProcessAreaEntry entry : this.processAreaToRoles.keySet()) {
                    result.add(NLS.bind((String)Messages.ComponentAuthorizedUsersScopeDefinitionBlock_11, (Object)entry.getProcessAreaPath(), (Object)TableUtil.group((Collection<String>)this.processAreaToRoles.get(entry), ", ", true)));
                }
            }
            return TableUtil.group(result, "\n", false);
        }

        public String toSourceWorkspacesString() {
            if (this.uuid2sourceWorkspaceName.isEmpty()) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            for (Map.Entry<String, String> workspace : this.uuid2sourceWorkspaceName.entrySet()) {
                result.add(workspace.getValue() != null ? workspace.getValue() : workspace.getKey());
            }
            return TableUtil.group(result, "\n", true);
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public String getColumnText(Object row, int columnIndex) {
            Object[] elements = (Object[])row;
            ComponentIdNamePair componentNameIdPair = (ComponentIdNamePair)elements[0];
            PersistedPermissions permissions = (PersistedPermissions)elements[1];
            String cellValue = "";
            if (columnIndex == 0) {
                cellValue = componentNameIdPair.getComponentName();
            } else if (columnIndex == 1) {
                String description = permissions != null ? permissions.toPermissionsString() : null;
                cellValue = ComponentPermissionsDefinitionBlock.isNotNull(description) ? description : Messages.ComponentAuthorizedUsersScopeDefinitionBlock_7;
            } else if (columnIndex == 2) {
                String description = permissions != null ? permissions.toSourceWorkspacesString() : null;
                cellValue = ComponentPermissionsDefinitionBlock.isNotNull(description) ? description : Messages.ComponentAuthorizedUsersScopeDefinitionBlock_ANY;
            }
            return cellValue;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

