/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.common.internal.process.ComponentMatchBlock;
import com.ibm.team.filesystem.ide.ui.internal.util.DisplayHelper;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.ide.ui.process.providers.StringOrComponentWrapperLabelProvider;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import com.ibm.team.process.internal.ide.ui.editors.util.DeferredElementListSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComponentMatchBlockPart {
    private final ProcessAspectEditor editor;
    private volatile boolean matchAll;
    private TableViewer componentList;
    private DeferredElementListSelectionDialog componentDialog;
    private Button matchSpecificButton;
    private Button removeComponentButton;
    private Button addComponentButton;
    private final boolean showOnlyProjectAreaComponents;
    private String matchSpecificComponentsLabelText;
    private String matchAllComponentsLabelText;

    public ComponentMatchBlockPart(ProcessAspectEditor editor) {
        this(editor, false);
    }

    public ComponentMatchBlockPart(ProcessAspectEditor editor, boolean showOnlyProjectAreaComponents) {
        this.editor = editor;
        this.showOnlyProjectAreaComponents = showOnlyProjectAreaComponents;
        if (showOnlyProjectAreaComponents) {
            this.matchAllComponentsLabelText = Messages.ComponentMatchBlockPart_0;
            this.matchSpecificComponentsLabelText = Messages.ComponentMatchBlockPart_1;
        } else {
            this.matchAllComponentsLabelText = Messages.DisallowIncomingChangeAdvisorAspectEditor_MATCH_ALL_COMPONENTS_BUTTON_TEXT;
            this.matchSpecificComponentsLabelText = Messages.DisallowIncomingChangeAdvisorAspectEditor_MATCH_SPECIFIC_COMPONENTS_BUTTON_TEXT;
        }
    }

    public void createControl(ComponentMatchBlock input, Composite parent, FormToolkit toolkit) {
        this.matchAll = input.matchAll;
        GridDataFactory dataFactory = GridDataFactory.fillDefaults().grab(true, false);
        Label label = toolkit.createLabel(parent, Messages.ComponentScopeDefinitionBlock_1);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        dataFactory.applyTo((Control)label);
        final Button matchAllButton = toolkit.createButton(parent, this.matchAllComponentsLabelText, 16);
        dataFactory.applyTo((Control)matchAllButton);
        matchAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentMatchBlockPart.this.editor.setDirty();
                ComponentMatchBlockPart.this.matchAll = matchAllButton.getSelection();
            }
        });
        this.matchSpecificButton = toolkit.createButton(parent, this.matchSpecificComponentsLabelText, 16);
        dataFactory.applyTo((Control)this.matchSpecificButton);
        Composite componentComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(2).applyTo(componentComposite);
        dataFactory.copy().grab(true, true).applyTo((Control)componentComposite);
        Table table = toolkit.createTable(componentComposite, 2818);
        this.componentList = new TableViewer(table);
        this.componentList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.componentList.setLabelProvider((IBaseLabelProvider)new StringOrComponentWrapperLabelProvider());
        this.componentList.setInput(new ArrayList());
        this.componentList.setComparator(new ViewerComparator());
        GridDataFactory.fillDefaults().grab(true, true).indent(30, 0).applyTo((Control)table);
        Composite buttonComposite = toolkit.createComposite(componentComposite);
        GridDataFactory.fillDefaults().align(131072, 128).grab(false, true).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(buttonComposite);
        this.addComponentButton = toolkit.createButton(buttonComposite, Messages.ComponentScopeDefinitionBlock_2, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)this.addComponentButton);
        this.addComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentMatchBlockPart.this.addComponents(ComponentMatchBlockPart.this.editor, (List)ComponentMatchBlockPart.this.componentList.getInput())) {
                    ComponentMatchBlockPart.this.editor.setDirty();
                    ComponentMatchBlockPart.this.componentList.refresh();
                }
            }
        });
        this.removeComponentButton = toolkit.createButton(buttonComposite, Messages.ComponentScopeDefinitionBlock_3, 0x800000);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)this.removeComponentButton);
        this.removeComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentMatchBlockPart.this.removeComponents(ComponentMatchBlockPart.this.editor, (List)ComponentMatchBlockPart.this.componentList.getInput())) {
                    ComponentMatchBlockPart.this.editor.setDirty();
                    ComponentMatchBlockPart.this.componentList.refresh();
                }
            }
        });
        this.removeComponentButton.setEnabled(false);
        this.componentList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                ComponentMatchBlockPart.this.removeComponentButton.setEnabled(selection != null && !selection.isEmpty());
            }
        });
        Display display = parent.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ComponentMatchBlockPart.this.matchSpecificButton.isDisposed()) {
                    ComponentMatchBlockPart.this.updateEnablement();
                }
            }
        });
        matchAllButton.setSelection(input.matchAll);
        this.matchSpecificButton.setSelection(!input.matchAll);
        this.matchSpecificButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentMatchBlockPart.this.updateEnablement();
            }
        });
        GridLayoutFactory.fillDefaults().spacing(5, 3).numColumns(1).applyTo(parent);
        final ArrayList comps = new ArrayList(input.components);
        Job populateCompsJob = new Job(Messages.ComponentScopeDefinitionBlock_4){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ComponentMatchBlockPart.this.populateComps(comps, ComponentMatchBlockPart.this.editor);
                }
                catch (TeamRepositoryException e) {
                    throw new RuntimeException(e);
                }
                return Status.OK_STATUS;
            }
        };
        ((ArrayList)this.componentList.getInput()).add(Messages.DisallowIncomingChangeAdvisorAspectEditor_LOADING_COMPONENTS);
        this.componentList.refresh();
        populateCompsJob.setSystem(false);
        populateCompsJob.schedule();
    }

    private void updateEnablement() {
        boolean listEnabled = this.matchSpecificButton.getSelection();
        this.componentList.getTable().setEnabled(listEnabled);
        this.addComponentButton.setEnabled(listEnabled);
        this.removeComponentButton.setEnabled(listEnabled && this.componentList.getTable().getSelectionCount() > 0);
    }

    private boolean addComponents(ProcessAspectEditor editor, List<ComponentWrapper> componentNameModel) {
        ProcessAspect aspect = editor.getAspect();
        final IProcessItem underlyingProcessItem = aspect.getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        final ITeamRepository repository = (ITeamRepository)underlyingProcessItem.getOrigin();
        final Set<UUID> componentsToIgnore = this.getIdsOfComponentsInViewer();
        Job fetchComponentNames = new Job(Messages.ComponentScopeDefinitionBlock_4){

            protected IStatus run(IProgressMonitor monitor) {
                List<Object> components;
                try {
                    components = this.queryComponents(repository, underlyingProcessItem, componentsToIgnore, SubMonitor.convert((IProgressMonitor)monitor));
                }
                catch (TeamRepositoryException x) {
                    StatusUtil.log((Object)((Object)this), (Throwable)x);
                    components = Collections.singletonList(Messages.ComponentScopeDefinitionBlock_5);
                }
                final List<String> toPassIn = components;
                DisplayHelper.asyncExec((Control)ComponentMatchBlockPart.this.componentDialog.getShell(), new Runnable(){

                    @Override
                    public void run() {
                        ComponentMatchBlockPart.this.componentDialog.setFetchingDone();
                        ComponentMatchBlockPart.this.componentDialog.setElements(toPassIn.toArray());
                    }
                });
                return Status.OK_STATUS;
            }

            private List<ComponentWrapper> queryAllComponents(ITeamRepository repo, SubMonitor monitor) throws TeamRepositoryException {
                IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                List comps = workspaceManager.findComponents(IComponentSearchCriteria.FACTORY.newInstance(), Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
                List complete = repo.itemManager().fetchCompleteItems(comps, 0, (IProgressMonitor)monitor.newChild(1));
                comps = null;
                ArrayList<ComponentWrapper> wrapped = new ArrayList<ComponentWrapper>(complete.size());
                for (IComponent comp : complete) {
                    wrapped.add(new ComponentWrapper(repo, comp));
                }
                return wrapped;
            }

            private List<ComponentWrapper> queryComponents(ITeamRepository repo, IProcessItem underlyingProcessItem2, Set<UUID> componentsToIgnore2, SubMonitor monitor) throws TeamRepositoryException {
                if (!ComponentMatchBlockPart.this.showOnlyProjectAreaComponents) {
                    return this.queryAllComponents(repository, monitor);
                }
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ArrayList<ComponentWrapper> wrappersToReturn = new ArrayList<ComponentWrapper>();
                IProjectArea projectArea = null;
                if (underlyingProcessItem2 instanceof ITeamArea) {
                    ITeamArea teamArea = (ITeamArea)underlyingProcessItem2;
                    IProjectAreaHandle handle = teamArea.getProjectArea();
                    projectArea = (IProjectArea)repo.itemManager().fetchCompleteItem((IItemHandle)handle, 1, (IProgressMonitor)progress.newChild(10));
                } else if (underlyingProcessItem2 instanceof IProjectArea) {
                    projectArea = (IProjectArea)underlyingProcessItem2;
                }
                if (projectArea == null) {
                    return wrappersToReturn;
                }
                IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                IComponentSearchCriteria criteria = IComponentSearchCriteria.FACTORY.newInstance();
                criteria.getFilterByOwnerOptional().add(projectArea);
                List teamAreas = projectArea.getTeamAreaHierarchy().getTeamAreas();
                criteria.getFilterByOwnerOptional().addAll(teamAreas);
                List comps = workspaceManager.findComponents(criteria, Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(40));
                List fetchedComponents = repo.itemManager().fetchCompleteItems(comps, 0, (IProgressMonitor)progress.newChild(40));
                for (Object item : fetchedComponents) {
                    IComponent component;
                    if (!(item instanceof IComponent) || componentsToIgnore2.contains((component = (IComponent)item).getItemId())) continue;
                    wrappersToReturn.add(new ComponentWrapper(repo, component));
                }
                return wrappersToReturn;
            }
        };
        this.componentDialog = new DeferredElementListSelectionDialog(fetchComponentNames, this.componentList.getControl().getShell(), new StringOrComponentWrapperLabelProvider()){

            protected int getTableStyle() {
                return 2818;
            }

            protected void updateButtons() {
                IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
                this.getOkButton().setEnabled(this.isFetchingDone() && selection.size() > 0 && !(selection.getFirstElement() instanceof String));
            }
        };
        this.componentDialog.setElements((Object[])new String[]{Messages.ComponentScopeDefinitionBlock_6});
        this.componentDialog.setTitle(Messages.ComponentScopeDefinitionBlock_7);
        this.componentDialog.setMessage(Messages.ComponentScopeDefinitionBlock_8);
        this.componentDialog.setComparator(new ViewerComparator());
        fetchComponentNames.setUser(false);
        fetchComponentNames.schedule();
        if (this.componentDialog.open() != 0) {
            fetchComponentNames.cancel();
            return false;
        }
        fetchComponentNames.cancel();
        boolean added = false;
        Object[] result = this.componentDialog.getResult();
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                if (result[i] instanceof ComponentWrapper) {
                    ComponentWrapper comp = (ComponentWrapper)((Object)result[i]);
                    componentNameModel.add(comp);
                    added = true;
                }
                ++i;
            }
        }
        return added;
    }

    private Set<UUID> getIdsOfComponentsInViewer() {
        ArrayList componentsInTableViewer = (ArrayList)this.componentList.getInput();
        HashSet<UUID> componentsToIgnore = new HashSet<UUID>(componentsInTableViewer.size());
        for (ComponentWrapper wrapper : componentsInTableViewer) {
            componentsToIgnore.add(wrapper.getComponent().getItemId());
        }
        return componentsToIgnore;
    }

    private boolean removeComponents(ProcessAspectEditor editor, List<ComponentWrapper> componentNameModel) {
        ISelection selection = this.componentList.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return componentNameModel.removeAll(ss.toList());
        }
        return false;
    }

    private void populateComps(Collection<ComponentMatchBlock.ComponentMatchRule> cmrs, ProcessAspectEditor editor) throws TeamRepositoryException {
        ProcessAspect aspect = editor.getAspect();
        IProcessItem underlyingProcessItem = aspect.getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        ITeamRepository repo = (ITeamRepository)underlyingProcessItem.getOrigin();
        ArrayList<IComponentHandle> compHandles = new ArrayList<IComponentHandle>(cmrs.size());
        for (ComponentMatchBlock.ComponentMatchRule rule : cmrs) {
            IComponentHandle handle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(rule.uuid, null);
            compHandles.add(handle);
        }
        List full = repo.itemManager().fetchCompleteItems(compHandles, 0, null);
        List comps = (List)this.componentList.getInput();
        comps.clear();
        for (IComponent comp : full) {
            if (comp == null) continue;
            comps.add(new ComponentWrapper(repo, comp));
        }
        Display display = this.componentList.getTable().getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ComponentMatchBlockPart.this.componentList.getTable().isDisposed()) {
                    return;
                }
                ComponentMatchBlockPart.this.componentList.refresh();
            }
        });
    }

    public ComponentMatchBlock getResult() {
        List comps = (List)this.componentList.getInput();
        ComponentMatchBlock block = new ComponentMatchBlock();
        block.matchAll = this.matchAll;
        block.components = new ArrayList(comps.size());
        for (ComponentWrapper comp : comps) {
            block.components.add(new ComponentMatchBlock.ComponentMatchRule(comp.getComponent().getItemId()));
        }
        return block;
    }
}

