/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.ide.ui.process.ScmDeferredElementListSelectionDialog;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public abstract class ComponentListUIJob
extends Job {
    private final ITeamRepository repository;
    final Collection<ScmDeferredElementListSelectionDialog.IComponentTableEntry> toShow = new ArrayList<ScmDeferredElementListSelectionDialog.IComponentTableEntry>();

    public ComponentListUIJob(ITeamRepository repository) {
        super(Messages.ComponentListUIJob_JOB_NAME);
        this.repository = repository;
    }

    protected IStatus run(IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.ComponentListUIJob_COMPONENT_QUERY, (int)5);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository);
        try {
            Set<Object> loadedComponentUuids;
            List owners;
            List<IComponentHandle> allComponentHandles = this.getComponentsToShow(this.repository, monitor.newChild(1));
            List allComponents = this.repository.itemManager().fetchCompleteItems(allComponentHandles, 0, (IProgressMonitor)monitor.newChild(1));
            if (allComponentHandles.isEmpty()) {
                owners = Collections.emptyList();
            } else {
                monitor.subTask(Messages.ComponentListUIJob_FINDING_OWNERS);
                List ownerHandles = workspaceManager.findOwnersForComponents(allComponents, (IProgressMonitor)monitor.newChild(1));
                owners = this.repository.itemManager().fetchCompleteItems(ownerHandles, 0, (IProgressMonitor)monitor.newChild(1));
            }
            monitor.subTask(Messages.ComponentListUIJob_FINDING_LOADED);
            try {
                loadedComponentUuids = this.determineLoadedComponents(monitor.newChild(1));
            }
            catch (FileSystemException e) {
                LoggingHelper.log((IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
                loadedComponentUuids = Collections.emptySet();
            }
            this.toShow.clear();
            int i = 0;
            while (i < allComponents.size()) {
                String ownerName;
                IComponent comp = (IComponent)allComponents.get(i);
                IAuditable owner = (IAuditable)owners.get(i);
                boolean isPersonal = false;
                if (owner instanceof IContributor) {
                    ownerName = ((IContributor)owner).getName();
                    isPersonal = true;
                } else {
                    ownerName = owner instanceof IProcessArea ? ((IProcessArea)owner).getName() : Messages.ComponentListUIJob_UNKNOWN_OWNER;
                }
                ScmDeferredElementListSelectionDialog.ComponentTableEntry cde = new ScmDeferredElementListSelectionDialog.ComponentTableEntry(comp, ownerName, loadedComponentUuids.contains(comp.getItemId()), isPersonal);
                this.toShow.add(cde);
                ++i;
            }
            for (String s : this.getStringsToShow()) {
                this.toShow.add(new ScmDeferredElementListSelectionDialog.StringTableEntry(s));
            }
        }
        catch (TeamRepositoryException x) {
            StatusUtil.log((Object)((Object)this), (Throwable)x);
            this.toShow.clear();
            this.toShow.add(new ScmDeferredElementListSelectionDialog.StringTableEntry(Messages.ComponentScopeDefinitionBlock_5));
        }
        this.doneFetching(this.toShow);
        return Status.OK_STATUS;
    }

    public abstract List<IComponentHandle> getComponentsToShow(ITeamRepository var1, SubMonitor var2) throws TeamRepositoryException;

    public abstract List<String> getStringsToShow() throws TeamRepositoryException;

    public abstract void doneFetching(Collection<ScmDeferredElementListSelectionDialog.IComponentTableEntry> var1);

    protected HashSet<UUID> determineLoadedComponents(SubMonitor monitor) throws FileSystemException {
        Collection sandboxes = SharingManager.getInstance().getRegisteredSandboxes();
        monitor.setWorkRemaining(sandboxes.size());
        HashSet<UUID> toReturn = new HashSet<UUID>();
        for (ISandbox sandbox : sandboxes) {
            Collection configs = sandbox.allLoadedConfigurations((IProgressMonitor)monitor.newChild(1));
            for (LoadedConfigurationDescriptor config : configs) {
                toReturn.add(config.componentHandle.getItemId());
            }
        }
        return toReturn;
    }
}

