/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.process.DisallowIncomingChangeErrorDescription;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.WorkspaceUpdateUtil;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.process.client.IAdvisorProblemResolutionDelegate;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AcceptAllProblemResolution
implements IAdvisorProblemResolutionDelegate {
    public boolean run(IAdvisorInfo info, IProgressMonitor progress) {
        UIContext[] context;
        Display display;
        block7: {
            DisallowIncomingChangeErrorDescription error;
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
            try {
                error = DisallowIncomingChangeErrorDescription.deserialize((String)info.getData());
            }
            catch (DisallowIncomingChangeErrorDescription.ParseException e) {
                throw new RuntimeException(e);
            }
            display = Display.getDefault();
            context = new UIContext[1];
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = display.getActiveShell();
                    if (shell == null) {
                        Shell[] shells = display.getShells();
                        if (shells.length > 0) {
                            shell = shells[0];
                        } else {
                            throw new RuntimeException("need a shell");
                        }
                    }
                    context[0] = UIContext.createShellContext((Shell)shell);
                }
            });
            WarnWorkspaceUpdate dilemmaHandler = new WarnWorkspaceUpdate(context[0], Messages.AcceptAllProblemResolution_DIALOG_TITLE_1){

                @Override
                public int componentsToBeAddedOrRemoved(Collection<ConfigurationFacade> added, Collection<ConfigurationFacade> removed) {
                    this.context.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)context.getShell(), (String)Messages.AcceptAllProblemResolution_ADDED_OR_REMOVED_COMPONENT_TITLE, (String)Messages.AcceptAllProblemResolution_ADDED_OR_REMOVED_COMPONENT_MESSAGE);
                        }
                    });
                    return 1;
                }

                @Override
                public int componentReplacementCandidates(Collection<ConfigurationFacade> replaceConfigurations) {
                    this.context.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)context.getShell(), (String)Messages.AcceptAllProblemResolution_REPLACED_COMPONENT_TITLE, (String)Messages.AcceptAllProblemResolution_REPLACED_COMPONENT_MESSAGE);
                        }
                    });
                    return 1;
                }
            };
            Collection<IComponentSyncContext> changedComponents = this.getChangedComponents(error);
            if (changedComponents == null) break block7;
            if (!changedComponents.isEmpty()) {
                WorkspaceUpdateUtil.accept(changedComponents, (WorkspaceUpdateDilemmaHandler)dilemmaHandler, (boolean)false, (boolean)false, (IProgressMonitor)monitor.newChild(1));
            }
            return true;
        }
        try {
            this.displayMsg(display, context[0]);
            return false;
        }
        catch (FileSystemStatusException fse) {
            this.displayMsg(display, context[0]);
            return false;
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private void displayMsg(Display display, final UIContext context) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = context.getShell();
                if (shell.isDisposed()) {
                    return;
                }
                MessageDialog.openError((Shell)shell, (String)Messages.AcceptAllProblemResolution_ERROR_TITLE, (String)Messages.AcceptAllProblemResolution_ERROR_MESSAGE);
            }
        });
    }

    private Collection<IComponentSyncContext> getChangedComponents(DisallowIncomingChangeErrorDescription error) throws TeamRepositoryException {
        IComponentSyncModel syncModel = FileSystemResourcesPlugin.getComponentSyncModel();
        Hashtable<UUID, DisallowIncomingChangeErrorDescription.DisallowedComponent> componentIds = new Hashtable<UUID, DisallowIncomingChangeErrorDescription.DisallowedComponent>();
        for (DisallowIncomingChangeErrorDescription.DisallowedComponent badComp : error.components) {
            componentIds.put(badComp.uuid, badComp);
        }
        ArrayList<IComponentSyncContext> changedContexts = new ArrayList<IComponentSyncContext>();
        IComponentSyncContext[] iComponentSyncContextArray = syncModel.getComponentSyncContexts();
        int n = iComponentSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisallowIncomingChangeErrorDescription.DisallowedComponent dc;
            IComponentSyncContext ctx = iComponentSyncContextArray[n2];
            ComponentSyncInfo info = ctx.getComponentSyncInfo();
            if (error.sourceUuid.equals((Object)info.getLocalWorkspaceConnection().getContextHandle().getItemId()) && (dc = (DisallowIncomingChangeErrorDescription.DisallowedComponent)componentIds.get(info.getComponent().getItemId())) != null && info.getRemoteIncoming() != null && dc.targetUuid.equals((Object)info.getRemoteIncoming().connectionHandle.getItemId())) {
                componentIds.remove(info.getComponent().getItemId());
                changedContexts.add(ctx);
            }
            ++n2;
        }
        if (!componentIds.isEmpty()) {
            return null;
        }
        return changedContexts;
    }

    public boolean mayBeApplicable(IAdvisorInfo info) {
        return "com.ibm.team.process.definitions.server.disallowIncomingChanges".equals(info.getIdentifier());
    }
}

