/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.ide.ui.advice.AdviceElementDetailProvider;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.internal.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractSourceControlAdvisorDetailProvider
extends AdviceElementDetailProvider {
    public static Element getDataElement(String data) {
        if (data != null) {
            try {
                DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
                Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(data.getBytes()));
                return doc.getDocumentElement();
            }
            catch (SAXException e) {
                StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
            }
            catch (IOException e) {
                StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
            }
        }
        return null;
    }

    public AbstractSourceControlAdvisorDetailProvider(Object element) {
        super(element);
    }

    protected String getShortOpDetailText() {
        return Messages.AbstractSourceControlAdvisorDetailProvider_LOCAL_PROCESSING_MESSAGE;
    }

    protected String createDetailText() {
        if (this.requiresLongOp()) {
            StringBuffer buf = new StringBuffer();
            IAdvisorInfo info = (IAdvisorInfo)this.fElement;
            this.appendBodyAndTableStart(buf, info.getSeverity());
            buf.append(this.getShortOpDetailText());
            buf.append("</td></tr></table></body>");
            return buf.toString();
        }
        return this.createDetailText((IProgressMonitor)new NullProgressMonitor());
    }

    protected String createDetailText(IProgressMonitor monitor) {
        String parentDescription;
        IAdvisorInfo info = (IAdvisorInfo)this.fElement;
        StringBuffer buffer = new StringBuffer();
        this.appendBodyAndTableStart(buffer, info.getSeverity());
        String problemTitle = Messages.AbstractFileAdvisorDetailProvider_1;
        buffer.append("<b><font color=\"").append(this.getTitleFontColor()).append(NLS.bind((String)"\">{0}</font></b><br>", (Object)problemTitle));
        this.appendProblem(info, buffer, monitor);
        IProcessReport parentReport = info.getProcessReport();
        if (parentReport instanceof IParticipantReport && (parentDescription = parentReport.getDescription()) != null && parentDescription.length() > 0) {
            String reasonTitle = Messages.AbstractFileAdvisorDetailProvider_2;
            buffer.append("<br><br><b><font color=\"").append(this.getTitleFontColor()).append(NLS.bind((String)"\">{0}</font></b><br>", (Object)reasonTitle));
            buffer.append(this.convertToHtml(parentDescription));
        }
        this.appendQuickFixes(info, buffer);
        this.appendExplainOperationLink(info, buffer);
        buffer.append("</td></tr></table></body>");
        return buffer.toString();
    }

    protected abstract void appendProblem(IAdvisorInfo var1, StringBuffer var2, IProgressMonitor var3);
}

