/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.process;

import com.ibm.team.filesystem.ide.ui.process.AbstractSourceControlAdvisorDetailProvider;
import com.ibm.team.filesystem.ide.ui.process.Messages;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class AbstractFileAdvisorDetailProvider
extends AbstractSourceControlAdvisorDetailProvider {
    public AbstractFileAdvisorDetailProvider(IAdvisorInfo info) {
        super(info);
    }

    protected void appendFileLink(StringBuffer buffer, final IFile file) {
        this.appendHyperlink(file.getName(), file.getFullPath().toString(), buffer, new Runnable(){

            @Override
            public void run() {
                AbstractFileAdvisorDetailProvider.this.openFile(file);
            }
        });
    }

    protected void showAllFiles(List<IFile> files) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            FileSelectionDialog dialog = new FileSelectionDialog(window.getShell(), files);
            dialog.setTitle(Messages.AbstractFileAdvisorDetailProvider_3);
            if (dialog.open() == 0) {
                Object[] selectedFiles = dialog.getResult();
                int i = 0;
                while (i < selectedFiles.length) {
                    this.openFile((IFile)selectedFiles[i]);
                    ++i;
                }
            }
        }
    }

    public void openFile(String filePath) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(filePath));
        if (resource != null && resource instanceof IFile) {
            this.openFile((IFile)resource);
        }
    }

    public void openFile(final IFile file) {
        IWorkbenchPage page;
        IWorkbenchWindow[] workbenchWindows;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null && (workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
            window = workbenchWindows[0];
        }
        if (window != null && (page = window.getActivePage()) != null) {
            window.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    }
                    catch (PartInitException e) {
                        StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
                    }
                }
            });
        }
    }

    public static class FileSelectionDialog
    extends ListSelectionDialog {
        public FileSelectionDialog(Shell shell, List files) {
            super(shell, (Object)files, new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof List) {
                        return ((List)inputElement).toArray();
                    }
                    return new Object[0];
                }
            }, (ILabelProvider)new WorkbenchLabelProvider(), Messages.AbstractFileAdvisorDetailProvider_0);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }
    }
}

