/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.platformignores;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.IIgnoreInfo;
import org.eclipse.team.core.Team;

public class UpdatePlatformIgnoreOperation {
    private static UpdatePlatformIgnoreOperation instance = new UpdatePlatformIgnoreOperation();
    private LinkedList<IgnoresAndHandler> toRun = new LinkedList();
    Job job;

    public static UpdatePlatformIgnoreOperation getInstance() {
        return instance;
    }

    public IStatus execute(IIgnoreInfo[] newMatchers, IUpdatePlatformIgnoreDilemmaHandler handler, IProgressMonitor progress) {
        try {
            return this.doExecute(newMatchers, handler, progress);
        }
        catch (FileSystemException e) {
            return FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)"Exception running ignore operation", (Throwable)e);
        }
    }

    private int runDilemmaHandler(IIgnoreInfo[] oldPatterns, IIgnoreInfo[] newPatterns, IUpdatePlatformIgnoreDilemmaHandler handler, SubMonitor monitor) {
        int choice = handler.changesAcceptable(oldPatterns, newPatterns, monitor.newChild(1));
        if (choice == 1) {
            this.undoNewIgnores(oldPatterns, newPatterns);
            return choice;
        }
        if (choice != 0) {
            StatusUtil.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Unexpected return code from dilemma handler"));
        }
        return choice;
    }

    /*
     * Exception decompiling
     */
    private IStatus doExecute(IIgnoreInfo[] newPatterns, IUpdatePlatformIgnoreDilemmaHandler handler, IProgressMonitor progress) throws FileSystemException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void undoNewIgnores(IIgnoreInfo[] oldPatterns, IIgnoreInfo[] newPatterns) {
        TreeSet<String> oldEnabled = new TreeSet<String>();
        IIgnoreInfo[] iIgnoreInfoArray = oldPatterns;
        int n = oldPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            IIgnoreInfo oldPattern = iIgnoreInfoArray[n2];
            if (oldPattern.getEnabled()) {
                oldEnabled.add(oldPattern.getPattern());
            }
            ++n2;
        }
        ArrayList<String> patterns = new ArrayList<String>(newPatterns.length);
        boolean[] enablement = new boolean[newPatterns.length];
        int i = 0;
        IIgnoreInfo[] iIgnoreInfoArray2 = newPatterns;
        int n3 = newPatterns.length;
        int n4 = 0;
        while (n4 < n3) {
            IIgnoreInfo newPattern = iIgnoreInfoArray2[n4];
            patterns.add(newPattern.getPattern());
            enablement[i++] = oldEnabled.remove(newPattern.getPattern());
            ++n4;
        }
        boolean[] newEnablement = new boolean[enablement.length + oldEnabled.size()];
        System.arraycopy(enablement, 0, newEnablement, 0, enablement.length);
        enablement = newEnablement;
        for (String pattern : oldEnabled) {
            patterns.add(pattern);
            enablement[i++] = true;
        }
        Team.setAllIgnores((String[])patterns.toArray(new String[patterns.size()]), (boolean[])enablement);
    }

    private IStatus refreshFilesystem(IIgnoreInfo[] newPatterns, IIgnoreInfo[] oldPatterns, SubMonitor monitor) {
        IShare[] shares;
        monitor.setWorkRemaining(100);
        try {
            shares = SharingManager.getInstance().allShares((IProgressMonitor)monitor.newChild(5));
        }
        catch (FileSystemException e2) {
            return new Status(4, "com.ibm.team.filesystem.ide.ui", "Problem determining ignored resources");
        }
        monitor.setWorkRemaining(shares.length);
        IShare[] iShareArray = shares;
        int n = shares.length;
        int n2 = 0;
        while (n2 < n) {
            IShare share = iShareArray[n2];
            monitor.setTaskName(NLS.bind((String)Messages.UpdatePlatformIgnoreOperation_RefreshingUnignoredChangesProgressName, (Object)share.getPath().segment(0)));
            this.refresh(share, monitor.newChild(1));
            ++n2;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private void refresh(IShare share, SubMonitor monitor) {
        try {
            ((LocalChangeManager)SharingManager.getInstance().getLocalChangeManager()).refreshChanges(share.getShareable(), (IProgressMonitor)monitor);
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(IIgnoreInfo[] newIgnores, IUpdatePlatformIgnoreDilemmaHandler handler) {
        LinkedList<IgnoresAndHandler> linkedList = this.toRun;
        synchronized (linkedList) {
            this.toRun.add(new IgnoresAndHandler(newIgnores, handler));
        }
        this.getJob().schedule();
    }

    public synchronized Job getJob() {
        if (this.job == null) {
            this.job = new Job(Messages.UpdatePlatformIgnoreOperation_UpdatePlatformIgnoresJobName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    while (true) {
                        IgnoresAndHandler iah;
                        try {
                            LinkedList linkedList = UpdatePlatformIgnoreOperation.this.toRun;
                            synchronized (linkedList) {
                                iah = (IgnoresAndHandler)UpdatePlatformIgnoreOperation.this.toRun.remove();
                            }
                        }
                        catch (NoSuchElementException e) {
                            return Status.OK_STATUS;
                        }
                        UpdatePlatformIgnoreOperation.this.execute(iah.ignores, iah.handler, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                    }
                }
            };
        }
        return this.job;
    }

    public static interface IUpdatePlatformIgnoreDilemmaHandler {
        public static final int OK = 0;
        public static final int UNDO = 1;

        public int changesAcceptable(IIgnoreInfo[] var1, IIgnoreInfo[] var2, SubMonitor var3);
    }

    private static class IgnoresAndHandler {
        IIgnoreInfo[] ignores;
        IUpdatePlatformIgnoreDilemmaHandler handler;

        IgnoresAndHandler(IIgnoreInfo[] ignores, IUpdatePlatformIgnoreDilemmaHandler handler) {
            this.ignores = ignores;
            this.handler = handler;
        }
    }
}

