/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.platformignores;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.ide.ui.platformignores.PlatformIgnoreChangeCollector;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.Layouts;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.team.core.IIgnoreInfo;

public class PlatformIgnoreChangeDialog
extends TrayDialog {
    private Table matchBox;
    private LocalResourceManager resourceManager;
    long ignoredResourceCount = 0L;
    long sharedResourceCount = 0L;
    private CLabel statusMessageLabel;
    private Label progressLabel;
    private final IIgnoreInfo[] newMatchers;
    private final IIgnoreInfo[] oldMatchers;
    boolean changed = false;
    LinkedList<UpdateRecord> updates = new LinkedList();
    Runnable updateRunner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (PlatformIgnoreChangeDialog.this.matchBox.isDisposed()) {
                return;
            }
            while (true) {
                UpdateRecord rec;
                try {
                    LinkedList<UpdateRecord> linkedList = PlatformIgnoreChangeDialog.this.updates;
                    synchronized (linkedList) {
                        rec = PlatformIgnoreChangeDialog.this.updates.remove();
                    }
                }
                catch (NoSuchElementException e) {
                    break;
                }
                TableItem tableItem = new TableItem(PlatformIgnoreChangeDialog.this.matchBox, 0);
                String path = rec.shareable.getLocalPath().toString();
                tableItem.setText(NLS.bind((String)Messages.PlatformIgnoreChangeDialog_UpdatePathIgnoredOrSharedTableText, (Object)path, (Object)(rec.ignoreStatus ? Messages.PlatformIgnoreChangeDialog_WillBeIgnoredText : Messages.PlatformIgnoreChangeDialog_WillBeSharedText)));
                ImageDescriptor image = null;
                try {
                    ResourceType type = rec.shareable.getResourceType((IProgressMonitor)TempHelper.MONITOR);
                    image = type == ResourceType.FOLDER ? UiPlugin.getFileSystemImageDescriptor(null) : (type == ResourceType.SYMBOLIC_LINK ? ImagePool.SYMBOLIC_LINK : UiPlugin.getFileSystemImageDescriptor(path));
                }
                catch (FileSystemException e) {
                    TempHelper.throwEx((TeamRepositoryException)e);
                }
                tableItem.setImage(PlatformIgnoreChangeDialog.this.getImage(image));
                if (rec.ignoreStatus) {
                    ++PlatformIgnoreChangeDialog.this.ignoredResourceCount;
                    continue;
                }
                ++PlatformIgnoreChangeDialog.this.sharedResourceCount;
            }
            PlatformIgnoreChangeDialog.this.updateStatus();
        }
    };
    private final PlatformIgnoreChangeCollector collector;
    boolean done = false;

    public PlatformIgnoreChangeDialog(IIgnoreInfo[] oldMatchers, IIgnoreInfo[] newMatchers, PlatformIgnoreChangeCollector collector) {
        super(Display.getDefault().getShells()[0]);
        this.newMatchers = newMatchers;
        this.oldMatchers = oldMatchers;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)Display.getDefault().getShells()[0]);
        this.collector = collector;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PlatformIgnoreChangeDialog_VerifyIgnoreListChange_ShellTitle);
    }

    protected String getExplanation() {
        return Messages.PlatformIgnoreChangeDialog_ExplanationLabel;
    }

    private List<IgnoreDifference> findIgnoreDifferences() {
        TreeSet<String> oldPatterns = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        IIgnoreInfo[] iIgnoreInfoArray = this.oldMatchers;
        int n = this.oldMatchers.length;
        int n2 = 0;
        while (n2 < n) {
            IIgnoreInfo info = iIgnoreInfoArray[n2];
            if (info.getEnabled()) {
                oldPatterns.add(info.getPattern());
            }
            ++n2;
        }
        TreeSet<String> newPatterns = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        IIgnoreInfo[] iIgnoreInfoArray2 = this.newMatchers;
        int n3 = this.newMatchers.length;
        n = 0;
        while (n < n3) {
            IIgnoreInfo info = iIgnoreInfoArray2[n];
            if (info.getEnabled()) {
                newPatterns.add(info.getPattern());
            }
            ++n;
        }
        ArrayList<IgnoreDifference> diff = new ArrayList<IgnoreDifference>(Math.max(this.newMatchers.length, this.oldMatchers.length));
        IIgnoreInfo[] iIgnoreInfoArray3 = this.newMatchers;
        int n4 = this.newMatchers.length;
        n3 = 0;
        while (n3 < n4) {
            IIgnoreInfo info = iIgnoreInfoArray3[n3];
            if (info.getEnabled() && !oldPatterns.remove(info.getPattern())) {
                diff.add(new IgnoreDifference(0, info));
            }
            ++n3;
        }
        for (final String removed : oldPatterns) {
            diff.add(new IgnoreDifference(1, new IIgnoreInfo(){

                public boolean getEnabled() {
                    return true;
                }

                public String getPattern() {
                    return removed;
                }
            }));
        }
        return diff;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayoutFactory layoutFactory = GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins());
        Composite top = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)top);
        Label label = new Label(top, 64);
        label.setText(this.getExplanation());
        GridDataFactory.fillDefaults().grab(true, false).hint(400, -1).applyTo((Control)label);
        label = new Label(top, 64);
        label.setText(Messages.PlatformIgnoreChangeDialog_2);
        GridDataFactory.fillDefaults().grab(true, false).hint(400, -1).applyTo((Control)label);
        List<IgnoreDifference> differences = this.findIgnoreDifferences();
        Table ruleBox = new Table(top, 2048);
        int itemHeight = this.guessItemHeightFor((Control)ruleBox);
        GridDataFactory.fillDefaults().hint(-1, itemHeight * (differences.size() + 1)).grab(true, true).applyTo((Control)ruleBox);
        for (IgnoreDifference diff : differences) {
            TableItem tableItem = new TableItem(ruleBox, 0);
            if (diff.changeType == 0) {
                tableItem.setText(NLS.bind((String)Messages.PlatformIgnoreChangeDialog_0, (Object)diff.info.getPattern()));
                continue;
            }
            if (diff.changeType == 1) {
                tableItem.setText(NLS.bind((String)Messages.PlatformIgnoreChangeDialog_1, (Object)diff.info.getPattern()));
                continue;
            }
            tableItem.setText(String.valueOf(diff.info.getPattern()) + " (unknown change: " + diff.changeType + ")");
        }
        label = new Label(top, 64);
        label.setText(Messages.PlatformIgnoreChangeDialog_3);
        GridDataFactory.fillDefaults().grab(true, false).hint(400, -1).applyTo((Control)label);
        this.matchBox = new Table(top, 2048);
        int itemHeight2 = this.guessItemHeightFor((Control)this.matchBox);
        GridDataFactory.fillDefaults().hint(-1, itemHeight2 * 6).grab(true, true).applyTo((Control)this.matchBox);
        this.statusMessageLabel = new CLabel(top, 0);
        this.progressLabel = new Label(top, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)this.statusMessageLabel);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)this.progressLabel);
        this.updateStatus();
        Dialog.applyDialogFont((Control)parent);
        layoutFactory.applyTo(top);
        return top;
    }

    private void updateStatus() {
        this.statusMessageLabel.setText(NLS.bind((String)Messages.PlatformIgnoreChangeDialog_ResourcesIgnoredSharedStatusText, (Object)this.ignoredResourceCount, (Object)this.sharedResourceCount));
        Layouts.changed((Control)this.statusMessageLabel);
    }

    private int guessItemHeightFor(Control control) {
        FontData[] data = control.getFont().getFontData();
        int maxHeight = -1;
        FontData[] fontDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData datum = fontDataArray[n2];
            maxHeight = Math.max(datum.getHeight(), maxHeight);
            ++n2;
        }
        return maxHeight;
    }

    protected void unignored(IShareable shareable) {
        this.update(shareable, false);
    }

    protected void ignored(IShareable shareable) {
        this.update(shareable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changesIgnoreList() {
        LinkedList<UpdateRecord> linkedList = this.updates;
        synchronized (linkedList) {
            return this.changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(IShareable shareable, boolean isIgnored) {
        PlatformIgnoreChangeCollector platformIgnoreChangeCollector = this.collector;
        synchronized (platformIgnoreChangeCollector) {
            if (this.done) {
                return;
            }
        }
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null) {
            return;
        }
        LinkedList<UpdateRecord> linkedList = this.updates;
        synchronized (linkedList) {
            this.changed = true;
            this.updates.add(new UpdateRecord(shareable, isIgnored));
        }
        display.asyncExec(this.updateRunner);
    }

    protected final Image getImage(ImageDescriptor descriptor) {
        Object o = this.resourceManager.find((DeviceResourceDescriptor)descriptor);
        if (o instanceof Image) {
            return (Image)o;
        }
        return this.resourceManager.createImageWithDefault(descriptor);
    }

    void setProgress(final String message) {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PlatformIgnoreChangeDialog.this.progressLabel.isDisposed()) {
                    PlatformIgnoreChangeDialog.this.progressLabel.setText(message);
                    Layouts.changed((Control)PlatformIgnoreChangeDialog.this.progressLabel);
                }
            }
        });
    }

    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        PlatformIgnoreChangeCollector platformIgnoreChangeCollector = this.collector;
        synchronized (platformIgnoreChangeCollector) {
            this.done = true;
            this.collector.notifyAll();
        }
        return super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForClose() {
        PlatformIgnoreChangeCollector platformIgnoreChangeCollector = this.collector;
        synchronized (platformIgnoreChangeCollector) {
            while (!this.done) {
                try {
                    this.collector.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    private static class IgnoreDifference {
        protected static final int ADDED = 0;
        protected static final int REMOVED = 1;
        final int changeType;
        final IIgnoreInfo info;

        IgnoreDifference(int changeType, IIgnoreInfo info) {
            this.changeType = changeType;
            this.info = info;
        }
    }

    private static class UpdateRecord {
        IShareable shareable;
        boolean ignoreStatus;

        UpdateRecord(IShareable shareable, boolean ignoreStatus) {
            this.shareable = shareable;
            this.ignoreStatus = ignoreStatus;
        }
    }
}

