/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.platformignores;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IFileStorageVisitor;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.ide.ui.platformignores.EclipseIgnoreProvider;
import com.ibm.team.filesystem.ide.ui.platformignores.PlatformIgnoreChangeDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.IIgnoreInfo;

public class PlatformIgnoreChangeCollector {
    IIgnoreManager manager = null;
    EclipseIgnoreProvider eip = null;
    private PlatformIgnoreChangeDialog dialog = null;
    final IIgnoreInfo[] newMatchers;
    final IIgnoreInfo[] oldMatchers;
    DialogFactory dialogFactory;

    public PlatformIgnoreChangeCollector(IIgnoreInfo[] oldMatchers, IIgnoreInfo[] newMatchers) {
        this.oldMatchers = oldMatchers;
        this.newMatchers = newMatchers;
    }

    public void setDialogFactory(DialogFactory f) {
        this.dialogFactory = f;
    }

    public IStatus run(IProgressMonitor progress) {
        IShare[] allShares;
        if (this.dialogFactory == null) {
            throw new IllegalStateException();
        }
        SubMonitor progressMonitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        this.init((IProgressMonitor)progressMonitor.newChild(5));
        final IIgnoreManager oldManager = SharingManager.getInstance().getIgnoreManager();
        try {
            allShares = SharingManager.getInstance().allShares((IProgressMonitor)progressMonitor.newChild(5));
        }
        catch (FileSystemException e) {
            return FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)"Couldn't get share list", (Throwable)e);
        }
        CancellationMonitor dialogMonitor = new CancellationMonitor((IProgressMonitor)progressMonitor);
        int i = 0;
        progressMonitor.setWorkRemaining(allShares.length);
        IShare[] iShareArray = allShares;
        int n = allShares.length;
        int n2 = 0;
        while (n2 < n) {
            IShare share = iShareArray[n2];
            if (this.isDone()) {
                return Status.OK_STATUS;
            }
            try {
                String progressMessage = NLS.bind((String)Messages.PlatformIgnoreChangeCollector_ScanningProjectsProgressName, (Object[])new Object[]{share.getPath().toString(), ++i, allShares.length});
                if (this.dialog != null) {
                    this.dialog.setProgress(progressMessage);
                }
                progressMonitor.subTask(progressMessage);
                progressMonitor.worked(1);
                ((Shareable)share.getShareable()).getFileStorage().accept(new IFileStorageVisitor(){

                    public boolean visit(IFileStorage storage, IProgressMonitor progress) {
                        if (progress != null && progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (storage.getIDEPath().segmentCount() < 2) {
                            return true;
                        }
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
                        Shareable shareable = storage.getShareable();
                        boolean ignoredByOld = oldManager.shouldBeIgnored((IShareable)shareable, (IProgressMonitor)monitor.newChild(1));
                        boolean ignoredByNew = PlatformIgnoreChangeCollector.this.manager.shouldBeIgnored((IShareable)shareable, (IProgressMonitor)monitor.newChild(1));
                        if (ignoredByOld && !ignoredByNew) {
                            PlatformIgnoreChangeCollector.this.ensureDialogExists((IProgressMonitor)monitor.newChild(1));
                            PlatformIgnoreChangeCollector.this.dialog.unignored((IShareable)shareable);
                            return true;
                        }
                        if (!ignoredByOld && ignoredByNew) {
                            PlatformIgnoreChangeCollector.this.ensureDialogExists((IProgressMonitor)monitor.newChild(1));
                            PlatformIgnoreChangeCollector.this.dialog.ignored((IShareable)shareable);
                            return false;
                        }
                        return !ignoredByNew;
                    }
                }, Integer.MAX_VALUE, (IProgressMonitor)dialogMonitor);
            }
            catch (FileSystemException e) {
                return FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)"Couldn't walk shares", (Throwable)e);
            }
            ++n2;
        }
        if (this.dialog != null) {
            this.dialog.setProgress("");
            this.dialog.waitForClose();
            assert (this.dialog.isDone());
        }
        return Status.OK_STATUS;
    }

    private boolean isDone() {
        return this.dialog != null && this.dialog.isDone();
    }

    private void ensureDialogExists(IProgressMonitor monitor) {
        if (this.isDone()) {
            return;
        }
        if (this.dialog == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformIgnoreChangeCollector.this.dialog = PlatformIgnoreChangeCollector.this.dialogFactory.createDialog(PlatformIgnoreChangeCollector.this.oldMatchers, PlatformIgnoreChangeCollector.this.newMatchers, PlatformIgnoreChangeCollector.this);
                    PlatformIgnoreChangeCollector.this.dialog.setBlockOnOpen(false);
                    PlatformIgnoreChangeCollector.this.dialog.open();
                }
            });
        }
    }

    public int getReturnCode() {
        if (this.dialog != null) {
            return this.dialog.getReturnCode() == 0 ? 0 : 1;
        }
        return 0;
    }

    private synchronized void init(IProgressMonitor monitor) {
        Assert.isTrue((this.manager == null ? 1 : 0) != 0);
        Assert.isTrue((this.eip == null ? 1 : 0) != 0);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.manager = SharingManager.getInstance().getIgnoreManager().createCopy((IProgressMonitor)progress.newChild(50));
        this.eip = (EclipseIgnoreProvider)this.manager.getIgnoreProvider("team_ignores", (IProgressMonitor)progress.newChild(50));
        this.eip.setPatterns(this.newMatchers);
    }

    public static interface DialogFactory {
        public PlatformIgnoreChangeDialog createDialog(IIgnoreInfo[] var1, IIgnoreInfo[] var2, PlatformIgnoreChangeCollector var3);
    }
}

