/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.platformignores;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.ide.ui.platformignores.PlatformIgnoreChangeCollector;
import com.ibm.team.filesystem.ide.ui.platformignores.PlatformIgnoreChangeDialog;
import com.ibm.team.filesystem.ide.ui.platformignores.StartupPlatformIgnoreChangeDialog;
import com.ibm.team.filesystem.ide.ui.platformignores.UpdatePlatformIgnoreOperation;
import com.ibm.team.filesystem.ui.UiPlugin;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.IIgnoreInfo;
import org.eclipse.team.core.Team;

public class EclipseIgnoreStartupSynchronizer {
    private static String PREF_PATTERN_SEPARATOR = "\n";
    private static EclipseIgnoreStartupSynchronizer instance;
    private UpdatePlatformIgnoreOperation.IUpdatePlatformIgnoreDilemmaHandler updatePlatformIgnoreDilemmaHandler = new UpdatePlatformIgnoreOperation.IUpdatePlatformIgnoreDilemmaHandler(){

        @Override
        public int changesAcceptable(IIgnoreInfo[] oldPatterns, IIgnoreInfo[] newPatterns, SubMonitor newChild) {
            PlatformIgnoreChangeCollector collector = new PlatformIgnoreChangeCollector(oldPatterns, newPatterns);
            collector.setDialogFactory(new PlatformIgnoreChangeCollector.DialogFactory(){

                @Override
                public PlatformIgnoreChangeDialog createDialog(IIgnoreInfo[] oldMatchers, IIgnoreInfo[] newMatchers, PlatformIgnoreChangeCollector collector) {
                    return new StartupPlatformIgnoreChangeDialog(oldMatchers, newMatchers, collector);
                }
            });
            collector.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)newChild));
            return collector.getReturnCode();
        }
    };

    public static synchronized EclipseIgnoreStartupSynchronizer getInstance() {
        if (instance == null) {
            instance = new EclipseIgnoreStartupSynchronizer();
        }
        return instance;
    }

    synchronized IIgnoreInfo[] initialize(IProgressMonitor progress) {
        IIgnoreInfo[] current = Team.getAllIgnores();
        ISharingManager sm = FileSystemCore.getSharingManager();
        int numSandboxes = sm.getRegisteredSandboxes().size();
        try {
            if (numSandboxes == 0 || numSandboxes == 1 && sm.allShares(progress).length == 0) {
                this.storeCurrentIgnores(current);
                return current;
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        String serialized = UiPlugin.getDefault().getPreferenceStore().getString("previous_ignore_patterns");
        if ("".equals(serialized)) {
            this.storeCurrentIgnores(current);
            return current;
        }
        SortedSet<String> previousStrings = this.deserializeInfos(serialized);
        int enabledCount = 0;
        IIgnoreInfo[] iIgnoreInfoArray = current;
        int n = current.length;
        int n2 = 0;
        while (n2 < n) {
            IIgnoreInfo info = iIgnoreInfoArray[n2];
            if (info.getEnabled()) {
                ++enabledCount;
                if (!previousStrings.contains(info.getPattern())) {
                    return this.handleOutOfSync(current, previousStrings);
                }
            }
            ++n2;
        }
        if (previousStrings.size() != enabledCount) {
            return this.handleOutOfSync(current, previousStrings);
        }
        return current;
    }

    private IIgnoreInfo[] handleOutOfSync(IIgnoreInfo[] current, SortedSet<String> previousStrings) {
        IIgnoreInfo[] previousInfos = this.stringsToInfos(previousStrings);
        UpdatePlatformIgnoreOperation.getInstance().schedule(current, this.updatePlatformIgnoreDilemmaHandler);
        return previousInfos;
    }

    private IIgnoreInfo[] stringsToInfos(SortedSet<String> strings) {
        IIgnoreInfo[] infos = new IIgnoreInfo[strings.size()];
        int i = 0;
        for (final String pattern : strings) {
            infos[i++] = new IIgnoreInfo(){

                public boolean getEnabled() {
                    return true;
                }

                public String getPattern() {
                    return pattern;
                }
            };
        }
        return infos;
    }

    private static SortedSet<String> infoToSortedStrings(IIgnoreInfo[] infos) {
        TreeSet<String> list = new TreeSet<String>(new CaseSensitiveComparator());
        IIgnoreInfo[] iIgnoreInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IIgnoreInfo info = iIgnoreInfoArray[n2];
            if (info.getEnabled()) {
                list.add(info.getPattern());
            }
            ++n2;
        }
        return list;
    }

    private String serializeInfos(IIgnoreInfo[] infos) {
        SortedSet<String> list = EclipseIgnoreStartupSynchronizer.infoToSortedStrings(infos);
        StringBuffer serialized = new StringBuffer();
        for (String pattern : list) {
            serialized.append(pattern);
            serialized.append(PREF_PATTERN_SEPARATOR);
        }
        return serialized.toString();
    }

    private SortedSet<String> deserializeInfos(String s) {
        TreeSet<String> set = new TreeSet<String>();
        StringTokenizer strtok = new StringTokenizer(s, PREF_PATTERN_SEPARATOR);
        while (strtok.hasMoreTokens()) {
            String pattern = strtok.nextToken();
            set.add(pattern);
        }
        return set;
    }

    synchronized void storeCurrentIgnores(IIgnoreInfo[] infos) {
        UiPlugin.getDefault().getPreferenceStore().setValue("previous_ignore_patterns", this.serializeInfos(infos));
    }

    private static class CaseSensitiveComparator
    implements Comparator<String> {
        private CaseSensitiveComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }
}

