/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.platformignores;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreProvider;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.ide.ui.platformignores.EclipseIgnoreEvent;
import com.ibm.team.filesystem.ide.ui.platformignores.EclipseIgnoreRule;
import com.ibm.team.filesystem.ide.ui.platformignores.EclipseIgnoreStartupSynchronizer;
import com.ibm.team.filesystem.ide.ui.platformignores.StringMatcher;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.IIgnoreInfo;

public class EclipseIgnoreProvider
extends IgnoreProvider
implements IIgnoreProvider.IIgnoreTester {
    private static final boolean IGNORE_CASE = true;
    public static final String ECLIPSE_PROVIDER = "team_ignores";
    public static final String EVENT_PLATFORM_CHANGE = "platform_change";
    private Object cacheLock = new Object();
    final String JOB_NAME = Messages.EclipseIgnoreProvider_IgnoreEventsjobName;
    Job dispatchJob = new Job(this.JOB_NAME){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor progress) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)EclipseIgnoreProvider.this.JOB_NAME, (int)100);
            int done = 0;
            while (true) {
                EventRecord rec;
                int size = 0;
                try {
                    LinkedList<EventRecord> linkedList = EclipseIgnoreProvider.this.pendingEvents;
                    synchronized (linkedList) {
                        size = EclipseIgnoreProvider.this.pendingEvents.size();
                        rec = EclipseIgnoreProvider.this.pendingEvents.remove();
                    }
                }
                catch (NoSuchElementException e) {
                    monitor.done();
                    return Status.OK_STATUS;
                }
                monitor.setTaskName(NLS.bind((String)Messages.EclipseIgnoreProvider_dispatchingProgressName, (Object[])new Object[]{rec.share.getPath().segment(0), ++done, done + size}));
                monitor.setWorkRemaining(size);
                EclipseIgnoreProvider.this.queueEvent(new EclipseIgnoreEvent(EclipseIgnoreProvider.this.getIgnoreManager(), rec.share, rec.oldPatterns, rec.newPatterns, rec.rules));
            }
        }
    };
    private StringMatcher[] instMatchers = null;
    private IIgnoreInfo[] infos;
    private List<IIgnoreProvider.IIgnoreRule> instRules = null;
    boolean shouldInvalidateCache = true;
    protected final LinkedList<EventRecord> pendingEvents = new LinkedList();

    public static EclipseIgnoreProvider getInstance(IProgressMonitor progress) {
        return (EclipseIgnoreProvider)SharingManager.getInstance().getIgnoreManager().getIgnoreProvider(ECLIPSE_PROVIDER, progress);
    }

    public EclipseIgnoreProvider() {
        this.dispatchJob.setSystem(true);
    }

    public synchronized IIgnoreInfo[] getInfos(IProgressMonitor progress) {
        this.initializePatterns(progress);
        return this.infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setPatterns(IIgnoreInfo[] patterns) {
        this.instRules = null;
        this.infos = patterns;
        StringMatcher[] accumulator = new StringMatcher[patterns.length];
        int i = 0;
        IIgnoreInfo[] iIgnoreInfoArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            IIgnoreInfo info = iIgnoreInfoArray[n2];
            if (info.getEnabled()) {
                StringMatcher matcher = new StringMatcher(info.getPattern(), true, false);
                accumulator[i++] = matcher;
            }
            ++n2;
        }
        this.instMatchers = new StringMatcher[i];
        System.arraycopy(accumulator, 0, this.instMatchers, 0, i);
        Object object = this.cacheLock;
        synchronized (object) {
            this.shouldInvalidateCache = true;
        }
    }

    private synchronized void initializePatterns(IProgressMonitor progress) {
        if (this.instMatchers == null) {
            this.setPatterns(EclipseIgnoreStartupSynchronizer.getInstance().initialize(progress));
        }
    }

    private synchronized StringMatcher[] getPatterns(IProgressMonitor progress) {
        this.initializePatterns(progress);
        return this.instMatchers;
    }

    public synchronized List<IIgnoreProvider.IIgnoreRule> getRules(IProgressMonitor progress) {
        if (this.instRules == null) {
            StringMatcher[] patterns = this.getPatterns(progress);
            this.instRules = new ArrayList<IIgnoreProvider.IIgnoreRule>(patterns.length);
            StringMatcher[] stringMatcherArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                StringMatcher pattern = stringMatcherArray[n2];
                this.instRules.add((IIgnoreProvider.IIgnoreRule)new EclipseIgnoreRule((IIgnoreProvider)this, pattern));
                ++n2;
            }
        }
        return this.instRules;
    }

    public void addIgnoreRule(IIgnoreProvider.IIgnoreRule rule, IProgressMonitor monitor) throws FileSystemException {
        throw new IllegalStateException(Messages.EclipseIgnoreProvider_ExceptionAddIgnoreRules);
    }

    public void addIgnoreRules(Collection<? extends IIgnoreProvider.IIgnoreRule> rules, IProgressMonitor monitor) throws FileSystemException {
        throw new IllegalStateException(Messages.EclipseIgnoreProvider_ExceptionAddIgnoreRules2);
    }

    public IIgnoreProvider.IIgnoreTester getTester(IShareable shareable) {
        return this;
    }

    public void removeIgnoreRule(IIgnoreProvider.IIgnoreRule externalRule, IProgressMonitor progress) throws FileSystemException {
        throw new IllegalStateException(Messages.EclipseIgnoreProvider_ExceptionRemoveIgnoreRules);
    }

    private static boolean canBeIgnored(IRelativeLocation path) {
        return path.segmentCount() >= 2;
    }

    public List findIgnoreReasons(IShareable shareable, IRelativeLocation path, IProgressMonitor progress) {
        List<IIgnoreProvider.IIgnoreRule> rules = this.getRules(progress);
        LinkedList<IIgnoreProvider.IIgnoreRule> matches = new LinkedList<IIgnoreProvider.IIgnoreRule>();
        for (IIgnoreProvider.IIgnoreRule rule : rules) {
            if (!((EclipseIgnoreRule)rule).matcherMatches(path)) continue;
            matches.add(rule);
        }
        return matches;
    }

    public boolean shouldBeIgnored(IShareable toIgnore, IRelativeLocation path, IProgressMonitor progress) {
        if (EclipseIgnoreProvider.canBeIgnored(path)) {
            StringMatcher[] matchers = this.getPatterns(progress);
            String lastSegment = path.getName();
            String fullPath = null;
            StringMatcher[] stringMatcherArray = matchers;
            int n = matchers.length;
            int n2 = 0;
            while (n2 < n) {
                StringMatcher matcher = stringMatcherArray[n2];
                if (matcher.isPathPattern()) {
                    if (fullPath == null) {
                        fullPath = path.toString();
                    }
                    if (matcher.match(fullPath)) {
                        return true;
                    }
                }
                if (matcher.match(lastSegment)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldInvalidateCache(IShareable shareable, IProgressMonitor monitor) {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.shouldInvalidateCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheInvalidated(IShareable shareable) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.shouldInvalidateCache = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void ignoresChanged(IIgnoreInfo[] newPatterns, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        IIgnoreInfo[] oldPatterns = this.infos;
        this.setPatterns(newPatterns);
        EclipseIgnoreStartupSynchronizer.getInstance().storeCurrentIgnores(newPatterns);
        LinkedList<EventRecord> linkedList = this.cacheLock;
        synchronized (linkedList) {
            this.shouldInvalidateCache = true;
        }
        try {
            linkedList = this.pendingEvents;
            synchronized (linkedList) {
                IShare[] shares = SharingManager.getInstance().allShares((IProgressMonitor)monitor.newChild(1));
                List<IIgnoreProvider.IIgnoreRule> rules = this.getRules((IProgressMonitor)monitor.newChild(1));
                IShare[] iShareArray = shares;
                int n = shares.length;
                int n2 = 0;
                while (n2 < n) {
                    IShare share = iShareArray[n2];
                    this.pendingEvents.add(new EventRecord(share, oldPatterns, newPatterns, rules));
                    ++n2;
                }
                if (this.pendingEvents.size() > 0) {
                    this.dispatchJob.schedule();
                }
            }
        }
        catch (FileSystemException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (String)Messages.EclipseIgnoreProvider_ExceptionAllSharesLogName, (Throwable)e);
        }
    }

    public synchronized boolean sameAsInstalled(IIgnoreInfo[] newIgnores, IProgressMonitor monitor) {
        Comparator comparator = null;
        comparator = String.CASE_INSENSITIVE_ORDER;
        TreeSet<String> newPatterns = new TreeSet<String>(comparator);
        IIgnoreInfo[] iIgnoreInfoArray = newIgnores;
        int n = newIgnores.length;
        int n2 = 0;
        while (n2 < n) {
            IIgnoreInfo info = iIgnoreInfoArray[n2];
            if (info.getEnabled()) {
                newPatterns.add(info.getPattern());
            }
            ++n2;
        }
        TreeSet<String> installedPatterns = new TreeSet<String>(comparator);
        IIgnoreInfo[] iIgnoreInfoArray2 = this.getInfos(monitor);
        int n3 = iIgnoreInfoArray2.length;
        n = 0;
        while (n < n3) {
            IIgnoreInfo info = iIgnoreInfoArray2[n];
            if (info.getEnabled()) {
                installedPatterns.add(info.getPattern());
            }
            ++n;
        }
        return installedPatterns.equals(newPatterns);
    }

    protected IgnoreProvider createCopyInternal(Collection<IIgnoreManager.ICopyParameter> params, IIgnoreManager ignoreManager, IProgressMonitor progress) {
        EclipseIgnoreProvider copy = new EclipseIgnoreProvider();
        copy.instMatchers = this.getPatterns(progress);
        return copy;
    }

    public void setIgnoreManager(IIgnoreManager ignoreManager, EventSource eventQueue, IProgressMonitor progress) {
        IShare[] shares;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        super.setIgnoreManager(ignoreManager, eventQueue, (IProgressMonitor)monitor.newChild(60));
        try {
            shares = SharingManager.getInstance().allShares((IProgressMonitor)monitor.newChild(30));
        }
        catch (FileSystemException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.client", (Throwable)e);
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(10), (int)shares.length);
        IShare[] iShareArray = shares;
        int n = shares.length;
        int n2 = 0;
        while (n2 < n) {
            IShare share = iShareArray[n2];
            LocalChangeTracker tracker = LocalChangeManager.getInstance().getTracker(share, (IProgressMonitor)subMonitor.newChild(1));
            if (tracker != null) {
                tracker.metadataChanged();
            }
            ++n2;
        }
    }

    public void flushInAbsenceOfEvents(Collection<IShareable> roots, IProgressMonitor newChild) {
    }

    private static class EventRecord {
        IShare share;
        IIgnoreInfo[] oldPatterns;
        IIgnoreInfo[] newPatterns;
        List<IIgnoreProvider.IIgnoreRule> rules;

        EventRecord(IShare share, IIgnoreInfo[] oldPatterns, IIgnoreInfo[] newPatterns, List<IIgnoreProvider.IIgnoreRule> rules) {
            this.share = share;
            this.oldPatterns = oldPatterns;
            this.newPatterns = newPatterns;
            this.rules = rules;
        }
    }
}

