/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class SharesOnDisk {
    private Map<ILocation, Map<UUID, Map<UUID, ShareWrapper>>> sharesMap = new HashMap<ILocation, Map<UUID, Map<UUID, ShareWrapper>>>();

    public void initialize(IConnection connection, IProgressMonitor monitor) {
        IShare[] shares;
        try {
            shares = SharingManager.getInstance().allShares(monitor);
        }
        catch (FileSystemException e) {
            StatusUtil.log((Object)this, (Throwable)e);
            return;
        }
        IShare[] iShareArray = shares;
        int n = shares.length;
        int n2 = 0;
        while (n2 < n) {
            IShare share = iShareArray[n2];
            ISandbox sandbox = share.getSandbox();
            Map<UUID, Map<UUID, ShareWrapper>> sandboxMap = this.sharesMap.get(sandbox.getRoot());
            if (sandboxMap == null) {
                sandboxMap = new HashMap<UUID, Map<UUID, ShareWrapper>>();
                this.sharesMap.put(sandbox.getRoot(), sandboxMap);
            }
            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
            if (connection == null || sharingDescriptor.isAssociatedWithConnection(connection)) {
                UUID componentUUID = sharingDescriptor.getComponent().getItemId();
                Map<UUID, ShareWrapper> uuids = sandboxMap.get(componentUUID);
                if (uuids == null) {
                    uuids = new HashMap<UUID, ShareWrapper>();
                    sandboxMap.put(componentUUID, uuids);
                }
                uuids.put(sharingDescriptor.getRootVersionable().getItemId(), new ShareWrapper(share));
            }
            ++n2;
        }
    }

    public Set<UUID> getSharedUUIDs(ILocation sandboxPath, UUID componentId) {
        Map<UUID, ShareWrapper> set;
        Map<UUID, Map<UUID, ShareWrapper>> map = this.sharesMap.get(sandboxPath);
        if (map != null && (set = map.get(componentId)) != null) {
            return set.keySet();
        }
        return Collections.emptySet();
    }

    public void updateAfterEvaluation(ILocation sandboxPath, ILoadOperation loadOperation) {
        Collection loadOverlaps = loadOperation.getLoadOverlaps();
        for (ILoadOverlap overlap : loadOverlaps) {
            Collection shares = overlap.getOverlappingShares();
            Map overlappingItems = overlap.getOverlappingItems();
            for (Map.Entry entry : overlappingItems.entrySet()) {
                IVersionableHandle handle = (IVersionableHandle)entry.getKey();
                IShare share = this.getShareForHandle(handle, shares);
                if (share == null) continue;
                this.setSharePath(sandboxPath, overlap.getComponent(), share, (String[])entry.getValue());
            }
        }
    }

    private void setSharePath(ILocation sandboxPath, IComponentHandle component, IShare share, String[] path) {
        ShareWrapper s;
        Map<UUID, ShareWrapper> set;
        Map<UUID, Map<UUID, ShareWrapper>> map = this.sharesMap.get(sandboxPath);
        if (map != null && (set = map.get(component.getItemId())) != null && (s = set.get(share.getSharingDescriptor().getRootVersionable().getItemId())) != null) {
            s.setPath(path);
        }
    }

    private IShare getShareForHandle(IVersionableHandle handle, Collection<IShare> shares) {
        for (IShare share : shares) {
            if (!share.getSharingDescriptor().getRootVersionable().getItemId().equals((Object)handle.getItemId())) continue;
            return share;
        }
        return null;
    }

    public Collection<NamedSiloedItem> findDescendantsFor(ILocation sandboxPath, NamedSiloedItem namedSiloedItem) {
        Map<UUID, ShareWrapper> shares;
        HashSet<NamedSiloedItem> result = new HashSet<NamedSiloedItem>();
        Map<UUID, Map<UUID, ShareWrapper>> map = this.sharesMap.get(sandboxPath);
        if (map != null && (shares = map.get(namedSiloedItem.getComponentUUID())) != null) {
            for (ShareWrapper share : shares.values()) {
                if (!share.isDescendant(namedSiloedItem)) continue;
                result.add(new NamedSiloedItem(namedSiloedItem.getComponentName(), namedSiloedItem.getComponentUUID(), share.getRootFolderId(), share.getFQName()));
            }
        }
        return result;
    }

    public Collection<ShareWrapper> getShares(ILocation sandboxPath, UUID componentId) {
        Map<UUID, ShareWrapper> set;
        Map<UUID, Map<UUID, ShareWrapper>> map = this.sharesMap.get(sandboxPath);
        if (map != null && (set = map.get(componentId)) != null) {
            return set.values();
        }
        return Collections.emptySet();
    }

    public class ShareWrapper {
        private final IShare share;
        private String[] path;

        public ShareWrapper(IShare share) {
            this.share = share;
        }

        public IShare getShare() {
            return this.share;
        }

        public String[] getPath() {
            return this.path;
        }

        public void setPath(String[] path) {
            this.path = path;
        }

        public UUID getRootFolderId() {
            return this.share.getSharingDescriptor().getRootVersionable().getItemId();
        }

        public String getFQName() {
            if (this.path == null) {
                return null;
            }
            return PathUtils.getString((String[])this.path);
        }

        public boolean isDescendant(NamedSiloedItem namedSiloedItem) {
            if (this.path == null) {
                return false;
            }
            return PathUtils.isParentFolder((String)namedSiloedItem.getFQName(), (String)this.getFQName());
        }

        public String getComponentName() {
            return this.share.getSharingDescriptor().getComponentName();
        }
    }
}

