/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.ide.ui.internal.wizards.load.AncestorReportWrapper;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.SelectItemsToLoadPart;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.dto.IAncestorReport;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class SelectProjectsToLoadPart
extends SelectItemsToLoadPart {
    public SelectProjectsToLoadPart(Composite parent, LoadWizardInput loadOperation, IRunnableContext runnableContext) {
        super(parent, loadOperation, runnableContext, false);
    }

    @Override
    protected SimpleTreeViewer createViewer(Composite composite) {
        SimpleTreeViewer viewer = super.createViewer(composite);
        viewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(final SelectionEvent e) {
                if (e.detail == 32) {
                    BusyIndicator.showWhile((Display)e.display, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreeItem item = (TreeItem)e.item;
                            Object data = item.getData();
                            if (data instanceof WorkspaceComponentWrapper) {
                                WorkspaceComponentWrapper component = (WorkspaceComponentWrapper)data;
                                SelectProjectsToLoadPart.this.updateSelectedProjects(component, item.getChecked());
                            } else if (data instanceof AncestorReportWrapper) {
                                AncestorReportWrapper report = (AncestorReportWrapper)data;
                                TreeItem parent = item.getParentItem();
                                Object cd = parent.getData();
                                SelectProjectsToLoadPart.this.updateSelectedProjects((WorkspaceComponentWrapper)cd, report.getReport(), item.getChecked());
                            }
                        }
                    });
                }
            }
        });
        return viewer;
    }

    void updateSelectedProjects(WorkspaceComponentWrapper component, IAncestorReport report, boolean selected) {
        NamedSiloedItem item = new NamedSiloedItem(component.getComponent(), report);
        if (selected) {
            this.getLoadOperation().getSelectedFolders().add(item, false);
        } else {
            this.getLoadOperation().getSelectedFolders().remove(item, false);
        }
    }

    void updateSelectedProjects(WorkspaceComponentWrapper component, boolean selected) {
        LoadWizardInput loadOp = this.getLoadOperation();
        if (selected) {
            Set<IAncestorReport> outerDotProjects = loadOp.getOuterDotProjects(component);
            HashSet<NamedSiloedItem> items = new HashSet<NamedSiloedItem>(outerDotProjects.size());
            for (IAncestorReport ancestorReport : outerDotProjects) {
                items.add(new NamedSiloedItem(component.getComponent(), ancestorReport));
            }
            loadOp.getSelectedFolders().addAll(items, false);
        } else {
            Set<NamedSiloedItem> items = loadOp.getSelectedFolders().getFoldersFor(component.getComponent());
            loadOp.getSelectedFolders().removeAll(items);
        }
    }

    @Override
    protected SelectItemsToLoadPart.FoldersToLoadTreeProvider createContentProvider() {
        return new SelectItemsToLoadPart.FoldersToLoadTreeProvider(this.getLoadOperation(), new JobRunner(false), true);
    }

    @Override
    protected void recursiveRemoveChecksForItems(TreeItem parentItem, NamedSiloedItem parentNamedSiloedItem, IComponent component, Collection<NamedSiloedItem> removals) {
    }
}

