/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.wizards.load;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.AncestorReportWrapper;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadOperationInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.ProblemReport;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.queries.FolderChildrenQuery;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.ComponentShortLabelProvider;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesComponentNode;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.FilteredSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.MixedTypeComparator;
import com.ibm.team.repository.rcp.ui.internal.viewers.MixedTypeLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SelectItemsToLoadPart {
    private Composite composite;
    private Button selectAllButton;
    private LoadLabelProvider labelProvider;
    private LoadWizardInput loadOp;
    private IRunnableContext runnableContext;
    private ISetListener<NamedSiloedItem> folderListener;
    private boolean enabled = false;
    private WritableSetWithListeners<WorkspaceComponentWrapper> componentSet = new WritableSetWithListeners();
    private SimpleTreeViewer viewer;
    private TreePath revealedPath;
    private FoldersToLoadTreeProvider contentProvider;
    private boolean showFiles = false;

    public SelectItemsToLoadPart(Composite parent, LoadWizardInput loadOperation, IRunnableContext runnableContext, boolean showFiles) {
        this.showFiles = showFiles;
        this.loadOp = loadOperation;
        this.runnableContext = runnableContext;
        this.composite = new Composite(parent, 0);
        this.viewer = this.createViewer(this.composite);
        this.createButtons(this.composite);
        Dialog.applyDialogFont((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(this.composite);
        this.configureToExpandInitialSelection();
        this.configureCheckBoxUpdating();
        this.viewer.setInput((Object)this.loadOp);
    }

    private void configureCheckBoxUpdating() {
        ISetListener<Object> initialListener = new ISetListener<Object>(){

            public void changed(final SetDiff<Object> diff) {
                if (SelectItemsToLoadPart.this.getTree().isDisposed()) {
                    return;
                }
                BusyIndicator.showWhile((Display)SelectItemsToLoadPart.this.getTree().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        HashMap<UUID, Set<NamedSiloedItem>> itemsToCheck = new HashMap<UUID, Set<NamedSiloedItem>>();
                        HashMap<UUID, Set<NamedSiloedItem>> itemsToGray = new HashMap<UUID, Set<NamedSiloedItem>>();
                        for (Object o : diff.getAdditions()) {
                            if (o instanceof NamedSiloedItem) {
                                Set<NamedSiloedItem> set;
                                UUID componentUUID;
                                NamedSiloedItem item = (NamedSiloedItem)((Object)o);
                                LoadWizardInput.SelectedFoldersSet selectedFolders = SelectItemsToLoadPart.this.loadOp.getSelectedFolders();
                                item.setPath(item.getFQName());
                                if (selectedFolders.contains(item)) {
                                    componentUUID = item.getComponentUUID();
                                    set = (HashSet<NamedSiloedItem>)itemsToCheck.get(componentUUID);
                                    if (set == null) {
                                        set = new HashSet<NamedSiloedItem>();
                                        itemsToCheck.put(componentUUID, set);
                                    }
                                    set.add(item);
                                    continue;
                                }
                                if (!selectedFolders.containsChildOf(item)) continue;
                                componentUUID = item.getComponentUUID();
                                set = (Set)itemsToGray.get(componentUUID);
                                if (set == null) {
                                    set = new HashSet();
                                    itemsToGray.put(componentUUID, set);
                                }
                                set.add(item);
                                continue;
                            }
                            if (!(o instanceof AncestorReportWrapper)) continue;
                            AncestorReportWrapper report = (AncestorReportWrapper)o;
                            Object componentObject = SelectItemsToLoadPart.this.viewer.getParent((Object)report);
                            if (!(componentObject instanceof WorkspaceComponentWrapper)) continue;
                            WorkspaceComponentWrapper componentWrapper = (WorkspaceComponentWrapper)componentObject;
                            NamedSiloedItem namedSiloedItem = report.toNamedSiloedItem();
                            if (!SelectItemsToLoadPart.this.loadOp.getSelectedFolders().contains(namedSiloedItem)) continue;
                            UUID componentUUID = componentWrapper.getComponent().getItemId();
                            HashSet<NamedSiloedItem> set = (HashSet<NamedSiloedItem>)itemsToCheck.get(componentUUID);
                            if (set == null) {
                                set = new HashSet<NamedSiloedItem>();
                                itemsToCheck.put(componentUUID, set);
                            }
                            set.add(namedSiloedItem);
                        }
                        SelectItemsToLoadPart.this.ensureItemsChecked(itemsToCheck, itemsToGray);
                    }
                });
            }
        };
        this.viewer.getKnownElements().addListener((ISetListener)initialListener);
        this.folderListener = new ISetListener<NamedSiloedItem>(){

            public void changed(SetDiff<NamedSiloedItem> diff) {
                if (SelectItemsToLoadPart.this.enabled) {
                    SelectItemsToLoadPart.this.updateTreeSelection(diff);
                }
            }
        };
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SelectItemsToLoadPart.this.folderListener != null) {
                    SelectItemsToLoadPart.this.loadOp.getSelectedFolders().removeListener(SelectItemsToLoadPart.this.folderListener);
                }
            }
        });
        this.loadOp.getSelectedFolders().addListener(this.folderListener);
        this.loadOp.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("com.ibm.team.filesystem.ide.ui.ErrorMessageProperty")) {
                    try {
                        SelectItemsToLoadPart.this.handleProblemReportChange((IProgressMonitor)TempHelper.MONITOR);
                    }
                    catch (FileSystemException e) {
                        TempHelper.throwEx((TeamRepositoryException)((Object)e));
                    }
                }
            }
        });
    }

    private void configureToExpandInitialSelection() {
        this.viewer.expandMatching((IFilter)new ExpansionFilter(this.loadOp.getSelectedFolders().toCollection()));
    }

    private void createButtons(Composite composite) {
        Composite buttons = new Composite(composite, 0);
        this.addExtraButtons(buttons);
        this.selectAllButton = new Button(buttons, 8);
        this.selectAllButton.setText(this.getSelectAllButtonText());
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectItemsToLoadPart.this.loadOp.selectAll();
            }
        });
        Button deselectAllButton = new Button(buttons, 8);
        deselectAllButton.setText(Messages.SelectFromRepoPart_16);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectItemsToLoadPart.this.loadOp.getSelectedFolders().clear();
            }
        });
        Dialog.applyDialogFont((Control)buttons);
        GridLayoutFactory.fillDefaults().generateLayout(buttons);
    }

    protected String getSelectAllButtonText() {
        return Messages.SelectFromRepoPart_15;
    }

    protected void addExtraButtons(Composite composite) {
    }

    private LoadLabelProvider createLabelProvider(SimpleTreeViewer viewer) {
        ComponentShortLabelProvider componentLabelProvider = new ComponentShortLabelProvider((ISetWithListeners)FilteredSetWithListeners.createTypeFilter((ISetWithListeners)viewer.getKnownElements(), ComponentWrapper.class), (IOperationRunner)new JobRunner(false));
        MixedTypeLabelProvider mixedTypeLabelProvider = new MixedTypeLabelProvider();
        mixedTypeLabelProvider.put(ContributorPlaceComponentWrapper.class, (IViewerLabelProvider)componentLabelProvider);
        mixedTypeLabelProvider.put(AncestorReportWrapper.class, (IViewerLabelProvider)new BaseLabelProvider(){
            private Image projectImage = this.getImage(ImagePool.PROJECT);

            public void updateLabel(ViewerLabel label, Object element) {
                AncestorReportWrapper report = (AncestorReportWrapper)element;
                if (report.isComponentRoot()) {
                    label.setText(NLS.bind((String)Messages.SelectItemsToLoadPart_0, (Object)report.getComponent().getName()));
                } else {
                    label.setText(report.getPath());
                }
                label.setImage(this.projectImage);
            }
        });
        mixedTypeLabelProvider.put(NamedSiloedItem.class, (IViewerLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                NamedSiloedItem item = (NamedSiloedItem)((Object)element);
                if (item.isFolder()) {
                    label.setImage(this.getImage(UiPlugin.getFileSystemImageDescriptor(null)));
                } else {
                    label.setImage(this.getImage(UiPlugin.getFileSystemImageDescriptor(item.getName())));
                }
                label.setText(item.getName());
            }
        });
        return new LoadLabelProvider((BaseLabelProvider)mixedTypeLabelProvider, this.loadOp);
    }

    private Comparator createSorter() {
        return new MixedTypeComparator().put(NamedSiloedItem.class, (Comparator)new Comparator<NamedSiloedItem>(){

            @Override
            public int compare(NamedSiloedItem o1, NamedSiloedItem o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        }).put(AncestorReportWrapper.class, (Comparator)new Comparator<AncestorReportWrapper>(){

            @Override
            public int compare(AncestorReportWrapper o1, AncestorReportWrapper o2) {
                return o1.getPath().compareToIgnoreCase(o2.getPath());
            }
        }).put(WorkspaceComponentWrapper.class, (Comparator)new Comparator<WorkspaceComponentWrapper>(){

            @Override
            public int compare(WorkspaceComponentWrapper o1, WorkspaceComponentWrapper o2) {
                return o1.getComponent().getName().compareToIgnoreCase(o2.getComponent().getName());
            }
        });
    }

    protected void updateTreeSelection(SetDiff<NamedSiloedItem> diff) {
        if (diff == null) {
            this.addChecksForItems(this.loadOp.getSelectedFolders().toCollection(), false);
        } else {
            this.removeChecksForItems(diff.getRemovals());
            this.addChecksForItems(diff.getAdditions(), false);
        }
    }

    private void removeChecksForItems(Collection<NamedSiloedItem> removals) {
        TreeItem[] items;
        if (removals.isEmpty()) {
            return;
        }
        Map<UUID, Collection<NamedSiloedItem>> byComponent = this.groupByComponent(removals);
        TreeItem[] treeItemArray = items = this.getTree().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem componentItem = treeItemArray[n2];
            IComponent component = SelectItemsToLoadPart.getComponent(componentItem);
            Collection<NamedSiloedItem> componentChildren = byComponent.get(component.getItemId());
            if (componentChildren != null) {
                this.removeChecksForItems(componentItem, component, componentChildren);
            }
            ++n2;
        }
    }

    private void removeChecksForItems(TreeItem parentItem, IComponent component, Collection<NamedSiloedItem> removals) {
        TreeItem[] items = parentItem.getItems();
        boolean allGone = true;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            NamedSiloedItem namedSiloedItem = this.toNamedSiloedItem(treeItem, component);
            if (namedSiloedItem != null) {
                if (removals.contains((Object)namedSiloedItem)) {
                    treeItem.setChecked(false);
                    treeItem.setGrayed(false);
                } else {
                    this.recursiveRemoveChecksForItems(treeItem, namedSiloedItem, component, removals);
                }
            }
            if (treeItem.getChecked()) {
                allGone = false;
            }
            ++n2;
        }
        if (allGone) {
            parentItem.setChecked(false);
            parentItem.setGrayed(false);
        }
    }

    protected void recursiveRemoveChecksForItems(TreeItem parentItem, NamedSiloedItem parentNamedSiloedItem, IComponent component, Collection<NamedSiloedItem> removals) {
        HashSet<NamedSiloedItem> children = new HashSet<NamedSiloedItem>();
        for (NamedSiloedItem child : removals) {
            if (!child.isChildOf(parentNamedSiloedItem.getFQName())) continue;
            children.add(child);
        }
        if (!children.isEmpty()) {
            this.removeChecksForItems(parentItem, component, children);
        }
    }

    private Map<UUID, Collection<NamedSiloedItem>> groupByComponent(Collection<NamedSiloedItem> items) {
        HashMap<UUID, Collection<NamedSiloedItem>> result = new HashMap<UUID, Collection<NamedSiloedItem>>();
        for (NamedSiloedItem namedSiloedItem : items) {
            UUID componentId = namedSiloedItem.getComponentUUID();
            HashSet<NamedSiloedItem> componentItems = (HashSet<NamedSiloedItem>)result.get(componentId);
            if (componentItems == null) {
                componentItems = new HashSet<NamedSiloedItem>();
                result.put(componentId, componentItems);
            }
            componentItems.add(namedSiloedItem);
        }
        return result;
    }

    void ensureItemsChecked(Map<UUID, Set<NamedSiloedItem>> itemsToCheck, Map<UUID, Set<NamedSiloedItem>> itemsToGray) {
        TreeItem[] componentItems;
        HashSet<UUID> componentIds = new HashSet<UUID>();
        componentIds.addAll(itemsToCheck.keySet());
        componentIds.addAll(itemsToGray.keySet());
        TreeItem[] treeItemArray = componentItems = this.getTree().getItems();
        int n = componentItems.length;
        int n2 = 0;
        while (n2 < n) {
            WorkspaceComponentWrapper wrapper;
            UUID itemId;
            TreeItem componentItem = treeItemArray[n2];
            Object data = componentItem.getData();
            if (data instanceof WorkspaceComponentWrapper && componentIds.contains(itemId = (wrapper = (WorkspaceComponentWrapper)data).getComponent().getItemId())) {
                this.ensureItemsChecked(componentItem, wrapper.getComponent(), "", itemsToCheck.get(itemId), itemsToGray.get(itemId));
            }
            ++n2;
        }
    }

    private void ensureItemsChecked(TreeItem parentItem, IComponent component, String itemPath, Set<NamedSiloedItem> itemsToCheck, Set<NamedSiloedItem> itemsToGray) {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = parentItem.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem childItem = treeItemArray[n2];
            Object data = childItem.getData();
            if (data instanceof AncestorReportWrapper) {
                AncestorReportWrapper reportWrapper = (AncestorReportWrapper)data;
                if (itemsToCheck != null && itemsToCheck.contains((Object)reportWrapper.toNamedSiloedItem()) && !childItem.getChecked()) {
                    childItem.setChecked(true);
                }
            }
            if (data instanceof NamedSiloedItem) {
                NamedSiloedItem namedSiloedItem = (NamedSiloedItem)((Object)data);
                String folderPath = PathUtils.appendPath((String)itemPath, (String)namedSiloedItem.getName());
                HashSet<NamedSiloedItem> childItemsToCheck = new HashSet<NamedSiloedItem>();
                HashSet<NamedSiloedItem> childItemsToGray = new HashSet<NamedSiloedItem>();
                if (itemsToCheck != null) {
                    if (itemsToCheck.contains((Object)namedSiloedItem)) {
                        if (!childItem.getChecked()) {
                            childItem.setChecked(true);
                        }
                        if (childItem.getGrayed()) {
                            childItem.setGrayed(false);
                        }
                    } else {
                        for (NamedSiloedItem nsi : itemsToCheck) {
                            if (!nsi.isChildOf(folderPath)) continue;
                            childItemsToCheck.add(nsi);
                        }
                    }
                }
                if (itemsToGray != null) {
                    if (itemsToGray.contains((Object)namedSiloedItem)) {
                        if (!childItem.getChecked()) {
                            childItem.setChecked(true);
                        }
                        if (!childItem.getGrayed()) {
                            childItem.setGrayed(true);
                        }
                    } else {
                        for (NamedSiloedItem nsi : itemsToGray) {
                            if (!nsi.isChildOf(folderPath)) continue;
                            childItemsToGray.add(nsi);
                        }
                    }
                }
                if (!childItemsToCheck.isEmpty() || !childItemsToGray.isEmpty()) {
                    this.ensureItemsChecked(childItem, component, folderPath, childItemsToCheck, childItemsToGray);
                }
            }
            ++n2;
        }
    }

    private void addChecksForItems(Collection<NamedSiloedItem> additions, boolean isParentOfSelection) {
        TreeItem[] items;
        Map<UUID, Collection<NamedSiloedItem>> byComponent = this.groupByComponent(additions);
        TreeItem[] treeItemArray = items = this.getTree().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem componentItem = treeItemArray[n2];
            IComponent component = SelectItemsToLoadPart.getComponent(componentItem);
            Collection<NamedSiloedItem> componentChildren = byComponent.get(component.getItemId());
            if (componentChildren != null) {
                this.addChecksForItems(componentItem, component, componentChildren);
            }
            ++n2;
        }
    }

    private void addChecksForItems(TreeItem parentItem, IComponent component, Collection<NamedSiloedItem> additions) {
        TreeItem[] items = parentItem.getItems();
        if (this.isUnexpanded(parentItem, items)) {
            Set<NamedSiloedItem> selected;
            Object data = parentItem.getData();
            if (data instanceof WorkspaceComponentWrapper) {
                WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)data;
                selected = this.loadOp.getSelectedFolders().getFoldersFor(wrapper.getComponent());
                parentItem.setChecked(!selected.isEmpty());
                if (selected.size() == 1 && selected.iterator().next().getName().equals("")) {
                    parentItem.setGrayed(false);
                } else {
                    parentItem.setGrayed(!selected.isEmpty());
                }
            }
            if (data instanceof NamedSiloedItem) {
                NamedSiloedItem item = (NamedSiloedItem)((Object)data);
                selected = this.loadOp.getSelectedFolders().getFoldersFor(component);
                boolean checked = false;
                for (NamedSiloedItem namedSiloedItem : selected) {
                    if (!namedSiloedItem.isChildOf(item.getFQName())) continue;
                    checked = true;
                    break;
                }
                parentItem.setChecked(checked);
                parentItem.setGrayed(checked);
            }
            return;
        }
        boolean childChecked = false;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            NamedSiloedItem namedSiloedItem = this.toNamedSiloedItem(treeItem, component);
            if (namedSiloedItem != null) {
                if (additions.contains((Object)namedSiloedItem)) {
                    treeItem.setChecked(true);
                    treeItem.setGrayed(false);
                } else {
                    HashSet<NamedSiloedItem> children = new HashSet<NamedSiloedItem>();
                    for (NamedSiloedItem child : additions) {
                        if (!child.isChildOf(namedSiloedItem.getFQName())) continue;
                        children.add(child);
                    }
                    if (!children.isEmpty()) {
                        this.addChecksForItems(treeItem, component, children);
                    }
                }
            }
            if (treeItem.getChecked()) {
                childChecked = true;
            }
            ++n2;
        }
        if (childChecked) {
            parentItem.setChecked(true);
            parentItem.setGrayed(true);
        }
    }

    private boolean isUnexpanded(TreeItem parentItem, TreeItem[] items) {
        return items.length == 1 && items[0].getData() == null;
    }

    private NamedSiloedItem toNamedSiloedItem(TreeItem item, IComponent component) {
        Object folderData = item.getData();
        if (folderData instanceof NamedSiloedItem) {
            return (NamedSiloedItem)((Object)folderData);
        }
        if (folderData instanceof AncestorReportWrapper) {
            AncestorReportWrapper report = (AncestorReportWrapper)folderData;
            return report.toNamedSiloedItem();
        }
        return null;
    }

    protected SimpleTreeViewer createViewer(Composite composite) {
        Tree tree = new Tree(composite, 2848);
        GridDataFactory.fillDefaults().grab(true, true).hint(150, 250).applyTo((Control)composite);
        this.contentProvider = this.createContentProvider();
        SimpleTreeViewer viewer = new SimpleTreeViewer(tree, (ITreeProvider)this.contentProvider);
        viewer.setSorter(this.createSorter());
        this.labelProvider = this.createLabelProvider(viewer);
        viewer.setLabelProvider((IViewerLabelProvider)this.labelProvider);
        return viewer;
    }

    protected FoldersToLoadTreeProvider createContentProvider() {
        return new FoldersToLoadTreeProvider(this.loadOp, new JobRunner(false), false);
    }

    public LoadWizardInput getLoadOperation() {
        return this.loadOp;
    }

    protected final Tree getTree() {
        return this.viewer.getTree();
    }

    protected static IComponent getComponent(TreeItem item) {
        Object data = item.getData();
        if (data instanceof RepositoryFilesComponentNode) {
            RepositoryFilesComponentNode node = (RepositoryFilesComponentNode)data;
            AbstractWrapper wrapper = (AbstractWrapper)((Object)node.getWrapper());
            return WorkspaceUtil.getComponent(wrapper);
        }
        if (data instanceof AbstractWrapper) {
            AbstractWrapper wrapper = (AbstractWrapper)((Object)item.getData());
            return WorkspaceUtil.getComponent(wrapper);
        }
        return null;
    }

    void handleProblemReportChange(IProgressMonitor monitor) throws FileSystemException {
        ProblemReport problems = this.loadOp.getProblems();
        HashMap<NamedSiloedItem, String> collisionLabels = new HashMap<NamedSiloedItem, String>();
        HashMap<NamedSiloedItem, String> overlapLabels = new HashMap<NamedSiloedItem, String>();
        problems.generateErrorLabels(collisionLabels, overlapLabels);
        this.labelProvider.updateLabels(collisionLabels, overlapLabels, monitor);
        TreePath treePath = this.getFirstVisibleOverlap(problems);
        if (!(treePath == null || this.revealedPath != null && treePath.equals((Object)this.revealedPath))) {
            this.revealedPath = treePath;
            this.viewer.selectAndReveal((ITreeSelection)new TreeSelection(this.revealedPath));
        }
    }

    private TreePath getFirstVisibleOverlap(ProblemReport problems) {
        for (Map.Entry<NamedSiloedItem, Set<NamedSiloedItem>> entry : problems.getOverlapMap().entrySet()) {
            TreePath treePath;
            Object element;
            List paths;
            if (entry.getValue().size() <= 1 || (paths = this.viewer.getPathsToElement(element = this.getElement(entry.getKey()))).isEmpty() || (treePath = (TreePath)paths.get(0)).getSegmentCount() <= 1) continue;
            return treePath;
        }
        return null;
    }

    protected Object getElement(NamedSiloedItem item) {
        return item;
    }

    public Control getControl() {
        return this.composite;
    }

    public static String toString(String[] segments) {
        if (segments.length == 0) {
            return "";
        }
        String path = PathUtils.getString((String[])segments);
        return SelectItemsToLoadPart.singleQuotePath(path);
    }

    public static String singleQuotePath(String path) {
        if (path.length() == 0) {
            return "''";
        }
        return "'" + (path.charAt(0) == '/' ? path.substring(1) : path) + "'";
    }

    protected String findFolder(IComponentHandle componentHandle, IFolderHandle folder) {
        return null;
    }

    public boolean isSomethingChecked() {
        return SelectItemsToLoadPart.isSomethingChecked(this.getTree().getItems());
    }

    private static boolean isSomethingChecked(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getChecked() || item.getGrayed()) {
                return true;
            }
            if (SelectItemsToLoadPart.isSomethingChecked(item.getItems())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IRunnableContext getRunnableContext() {
        return this.runnableContext;
    }

    protected Shell getShell() {
        return this.composite.getShell();
    }

    protected NamedSiloedItem getItemUUID(Object element) {
        if (element instanceof NamedSiloedItem) {
            return (NamedSiloedItem)((Object)element);
        }
        if (element instanceof AncestorReportWrapper) {
            AncestorReportWrapper report = (AncestorReportWrapper)element;
            AbstractWrapper wrapper = (AbstractWrapper)((Object)this.viewer.getParent((Object)report));
            IComponent component = WorkspaceUtil.getComponent(wrapper);
            return new NamedSiloedItem(report.getItemId(), component.getItemId());
        }
        return null;
    }

    public void initialize() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.componentSet.addAll(this.loadOp.getComponentWrappers());
        this.updateTreeSelection(null);
    }

    private final class ExpansionFilter
    implements IFilter {
        private final Collection<NamedSiloedItem> initialSelection;

        public ExpansionFilter(Collection<NamedSiloedItem> initialSelection) {
            this.initialSelection = initialSelection;
        }

        public boolean select(Object toTest) {
            if (toTest instanceof WorkspaceComponentWrapper) {
                return true;
            }
            if (toTest instanceof NamedSiloedItem) {
                NamedSiloedItem namedSiloedItem = (NamedSiloedItem)((Object)toTest);
                UUID componentId = namedSiloedItem.getComponentUUID();
                String folderPath = namedSiloedItem.getFQName();
                for (NamedSiloedItem item : this.initialSelection) {
                    String itemPath;
                    if (!item.getComponentUUID().equals((Object)componentId) || !PathUtils.isParentFolder((String)folderPath, (String)(itemPath = item.getFQName())) || PathUtils.isPathsEquals((String)folderPath, (String)itemPath)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    protected final class FoldersToLoadTreeProvider
    implements ITreeProvider {
        private final JobRunner runner;
        private final LoadWizardInput loadOp;
        private final boolean showProjects;

        public FoldersToLoadTreeProvider(LoadWizardInput loadOp, JobRunner jobRunner, boolean showProjects) {
            this.loadOp = loadOp;
            this.runner = jobRunner;
            this.showProjects = showProjects;
        }

        public ISetWithListeners getChildren(Object element) {
            if (element instanceof LoadWizardInput) {
                return SelectItemsToLoadPart.this.componentSet;
            }
            if (element instanceof WorkspaceComponentWrapper) {
                WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)element;
                if (this.showProjects) {
                    WritableSetWithListeners set = new WritableSetWithListeners();
                    Collection<IAncestorReport> projects = this.loadOp.getProjects(wrapper);
                    for (IAncestorReport ancestorReport : projects) {
                        set.add((Object)new AncestorReportWrapper(ancestorReport, wrapper.getComponent()));
                    }
                    return set;
                }
                if (!SelectItemsToLoadPart.this.showFiles) {
                    Map<String, IFolderHandle> folders = this.loadOp.getFolders(wrapper);
                    WritableSetWithListeners set = new WritableSetWithListeners();
                    for (Map.Entry<String, IFolderHandle> folderEntry : folders.entrySet()) {
                        set.add((Object)new NamedSiloedItem(wrapper.getComponent().getName(), wrapper.getComponent().getItemId(), folderEntry.getValue().getItemId(), folderEntry.getKey()));
                    }
                    return set;
                }
                Map<String, IVersionableHandle> versionables = this.loadOp.getVersionables(wrapper);
                WritableSetWithListeners set = new WritableSetWithListeners();
                for (Map.Entry<String, IVersionableHandle> entry : versionables.entrySet()) {
                    set.add((Object)new NamedSiloedItem(entry.getValue().getItemType(), wrapper.getComponent().getName(), wrapper.getComponent().getItemId(), entry.getValue().getItemId(), entry.getKey()));
                }
                return set;
            }
            if (element instanceof NamedSiloedItem) {
                NamedSiloedItem folder = (NamedSiloedItem)((Object)element);
                if (folder.getItemType() != IFolder.ITEM_TYPE) {
                    return null;
                }
                WorkspaceNamespace wsNamespace = WorkspaceNamespace.create((IWorkspaceConnection)SelectItemsToLoadPart.this.getLoadOperation().getWorkspaceConnection(), (IComponentHandle)folder.getComponentHandle());
                FolderChildrenQuery folderChildrenQuery = new FolderChildrenQuery((ItemNamespace)wsNamespace, folder.getItemId(), folder.getName(), folder.getFQName(), (IOperationRunner)this.runner){

                    @Override
                    protected Object createWrapper(ItemNamespace namespace, StateId state, String itemName, IComponentHandle component) {
                        return this.createWrapper(namespace, state, itemName, component, null);
                    }

                    @Override
                    protected Object createWrapper(ItemNamespace namespace, StateId state, String itemName, IComponentHandle component, String scope) {
                        String componentName = SelectItemsToLoadPart.this.getLoadOperation().getComponentName(component.getItemId());
                        return new NamedSiloedItem(state.getItemType(), componentName, component.getItemId(), state.getItemUUID(), itemName);
                    }
                };
                folderChildrenQuery.setFoldersOnly(!SelectItemsToLoadPart.this.showFiles);
                return folderChildrenQuery;
            }
            return null;
        }
    }

    private final class LoadLabelProvider
    extends BaseLabelProvider {
        private BaseLabelProvider labelProvider;
        private Map<NamedSiloedItem, String> overlapIds = new HashMap<NamedSiloedItem, String>();
        private Map<NamedSiloedItem, String> collisionIds = new HashMap<NamedSiloedItem, String>();
        private Set<NamedSiloedItem> multipleLocations = new HashSet<NamedSiloedItem>();
        private Color errorColor;
        private LoadOperationInput loadOp;

        public LoadLabelProvider(BaseLabelProvider labelProvider, LoadOperationInput loadOp) {
            this.labelProvider = labelProvider;
            this.loadOp = loadOp;
            this.errorColor = this.getDisplay().getSystemColor(4);
        }

        public void updateLabel(ViewerLabel label, Object element) {
            this.labelProvider.updateLabel(label, element);
            NamedSiloedItem itemUUID = SelectItemsToLoadPart.this.getItemUUID(element);
            if (itemUUID != null) {
                String overlapText = this.overlapIds.get((Object)itemUUID);
                if (overlapText != null) {
                    String text = TextProcessor.process((String)NLS.bind((String)Messages.SelectFromRepoPart_12, (Object)label.getText(), (Object)overlapText), (String)"()");
                    label.setText(text);
                    label.setForeground(this.errorColor);
                } else {
                    String collisionText = this.collisionIds.get((Object)itemUUID);
                    if (collisionText != null) {
                        label.setText(TextProcessor.process((String)NLS.bind((String)collisionText, (Object)label.getText()), (String)"()"));
                        if (this.multipleLocations.contains((Object)itemUUID)) {
                            label.setForeground(this.errorColor);
                        }
                    }
                }
            }
        }

        public void updateLabels(Map<NamedSiloedItem, String> collisions, Map<NamedSiloedItem, String> overlaps, IProgressMonitor monitor) throws FileSystemException {
            this.overlapIds.clear();
            this.collisionIds.clear();
            this.multipleLocations.clear();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.loadOp.getCollisions().size());
            for (ICollision iCollision : this.loadOp.getCollisions()) {
                String string = null;
                Collection locations = iCollision.getLocations();
                if (iCollision.collidedWithExistingContent()) {
                    IShare share = iCollision.getShareable().getShare((IProgressMonitor)progress.newChild(1));
                    if (share == null || share.getSharingDescriptor() == null) {
                        string = Messages.SelectFromRepoPart_2;
                    } else {
                        ISharingDescriptor descriptor = share.getSharingDescriptor();
                        boolean alreadyLoaded = false;
                        for (ILoadLocation location : locations) {
                            if (!descriptor.getConnectionHandle().sameItemId((IItemHandle)location.getConnection().getContextHandle()) || !descriptor.getComponent().sameItemId((IItemHandle)location.getComponent())) continue;
                            string = Messages.SelectFromRepoPart_4;
                            alreadyLoaded = true;
                            break;
                        }
                        if (!alreadyLoaded) {
                            string = Messages.SelectFromRepoPart_5;
                        }
                    }
                }
                for (ILoadLocation loadLocation : locations) {
                    NamedSiloedItem collidingUUID = new NamedSiloedItem(loadLocation.getRootToLoad().getItemId(), loadLocation.getComponent().getItemId());
                    this.collisionIds.put(collidingUUID, string);
                }
            }
            for (Map.Entry entry : collisions.entrySet()) {
                this.multipleLocationMessage((String)entry.getValue(), (NamedSiloedItem)((Object)entry.getKey()));
            }
            for (Map.Entry entry : overlaps.entrySet()) {
                this.overlapIds.put((NamedSiloedItem)((Object)entry.getKey()), (String)entry.getValue());
            }
            super.fireAllElementsChangedEvent();
        }

        private void multipleLocationMessage(String locations, NamedSiloedItem collidingUUID) {
            String string = this.collisionIds.get((Object)collidingUUID);
            if (string == null) {
                string = "{0}";
            }
            String collisionText = NLS.bind((String)Messages.SelectFromRepoPart_11, (Object)string, (Object)locations);
            this.collisionIds.put(collidingUUID, collisionText);
            this.multipleLocations.add(collidingUUID);
        }

        public void dispose() {
            this.labelProvider.dispose();
            super.dispose();
        }
    }
}

